/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.sync;

import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class ReaderTokenizer
implements Enumeration {
    private Reader reader = null;
    private String delimiters = null;
    private boolean retDelims;
    private final char[] buffer;
    private int bufferLength = 0;
    private int tokenSize = 0;
    private int currentPosition = 0;
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private StringTokenizer st = null;

    public ReaderTokenizer(Reader reader, String delim, boolean returnDelims) {
        this(reader, delim, returnDelims, 4096);
    }

    public ReaderTokenizer(Reader reader, String delim, boolean returnDelims, int bufferSize) {
        this.reader = reader;
        this.delimiters = delim;
        this.retDelims = returnDelims;
        this.buffer = new char[bufferSize];
    }

    public ReaderTokenizer(Reader reader, String delim) {
        this(reader, delim, false);
    }

    public ReaderTokenizer(Reader reader) {
        this(reader, " \t\n\r\f", false);
    }

    public boolean hasMoreTokens() {
        try {
            if (this.isBufferEnded()) {
                this.bufferLength = this.reader.read(this.buffer);
                if (this.bufferLength == -1) {
                    if (this.st == null) {
                        return false;
                    }
                    return this.st.hasMoreTokens();
                }
                String str = new String(this.buffer, 0, this.bufferLength);
                if (this.st != null && this.st.hasMoreTokens()) {
                    String lastStr = this.st.nextToken();
                    this.st = new StringTokenizer(lastStr + str, this.delimiters, this.retDelims);
                } else {
                    this.st = new StringTokenizer(str, this.delimiters, this.retDelims);
                }
                this.tokenSize = this.st.countTokens();
                if (this.tokenSize == 1) {
                    throw new RuntimeException("Buffer over flow inside Reader Tokenizer. Please enlarge the buffer size!");
                }
                this.currentPosition = 0;
            }
            ++this.currentPosition;
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean isBufferEnded() {
        return this.currentPosition >= this.tokenSize - 1;
    }

    public String nextToken() {
        return this.st.nextToken();
    }

    public String nextToken(String delim) {
        return this.st.nextToken(delim);
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() {
        return this.nextToken();
    }
}

