/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.sync;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.services.BufferedUTF8Writer;
import com.sap.ip.me.api.sync.SyncException;
import com.sap.ip.me.api.user.User;
import com.sap.ip.me.core.ConversationId;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.sync.ContainerFactory;
import com.sap.ip.me.sync.DCPackagingConfiguration;
import com.sap.ip.me.sync.OutboundContainerFormatter;
import com.sap.ip.me.sync.SyncFileManager;
import com.sap.ip.me.sync.SyncHeader;
import com.sap.ip.me.sync.SyncInboundContainer;
import com.sap.ip.me.sync.SyncOutboundContainer;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

final class PackageManager {
    private final User user;
    private final SyncFileManager filemanager;
    private final String[] containerfiles;
    private final Hashtable idToContainerMapping;
    private final boolean packagingActivated;
    private final int maxPackageSize;
    Hashtable convids = new Hashtable();
    private Trace trace = Trace.getInstance("MI/Sync");
    private int currentItemCounter = 1;
    private int currentHeaderCounter = 1;
    private int itemCounter = -1;
    private boolean morePackages;
    private Hashtable acknowledgesIdToFileMapping = new Hashtable(64);
    private Hashtable containerIds = new Hashtable();

    PackageManager(User currentUser, SyncFileManager filemanager) throws SyncException {
        this.user = currentUser;
        this.filemanager = filemanager;
        DCPackagingConfiguration dcconfig = new DCPackagingConfiguration(false);
        this.packagingActivated = dcconfig.isActivated();
        this.maxPackageSize = !this.packagingActivated ? Integer.MAX_VALUE : (int)dcconfig.getMaximumPackageSize();
        this.containerfiles = filemanager.getAllOutboundContainerFileNames(this.user);
        this.idToContainerMapping = new Hashtable(2 * (this.containerfiles.length + 1));
        File outboundfile = null;
        SyncOutboundContainer outboundcontainer = null;
        boolean wafregistryAlreadyAdded = false;
        boolean addToMapping = true;
        int i = 0;
        while (i < this.containerfiles.length) {
            outboundfile = new File(this.containerfiles[i]);
            outboundcontainer = new SyncOutboundContainer(outboundfile);
            SyncHeader header = outboundcontainer.getHeader();
            addToMapping = true;
            if ("WAF_REGISTRY".equals(header.getMethod()) && !header.isAcknowledge() && !header.isAcknowledgeReceived()) {
                if (wafregistryAlreadyAdded) {
                    addToMapping = false;
                    outboundfile.delete();
                    this.containerfiles[i] = null;
                    this.trace.log(70, "Removed duplicated WAF_REGISTRY container out of the outbound queue");
                } else {
                    wafregistryAlreadyAdded = true;
                }
            }
            if (addToMapping) {
                String id = header.getContainerId();
                this.idToContainerMapping.put(id, new Integer(i));
                int index = header.getMsgIndex();
                if (index > 0) {
                    this.updateGeneratedContainerId(outboundcontainer.getConversationId(), id, index);
                }
            }
            ++i;
        }
        this.morePackages = this.containerfiles.length > 0;
    }

    synchronized File getPackage(Hashtable alreadySentContainers) throws SyncException {
        File packageFile;
        boolean oldDeleted = (packageFile = this.filemanager.getOutboundPackageFile(this.user)).delete();
        this.trace.log(90, "PackageManager: old package file {0} {1} ", (Object)packageFile, (Object)(oldDeleted ? "was successfully deleted" : "could not be deleted"));
        this.trace.log(90, "PackageManager: create package with maximum {0} items", (Object)String.valueOf(this.maxPackageSize));
        this.itemCounter = this.maxPackageSize - this.initializeConvIdsTable();
        this.currentItemCounter = 1;
        this.currentHeaderCounter = 1;
        BufferedUTF8Writer writer = null;
        try {
            writer = new BufferedUTF8Writer(packageFile, false);
            String[] containerFileNames = this.filemanager.getAllOutboundAcknowledgeReceivedFileNames(this.user);
            int countBefore = this.itemCounter;
            this.fillPackage(containerFileNames, alreadySentContainers, writer, false, true);
            this.trace.log(90, "PackageManager: filled package with {0} acknowledge received container(s)", (Object)String.valueOf(countBefore - this.itemCounter));
            containerFileNames = this.filemanager.getAllOutboundAcknowledgeFileNames(this.user);
            countBefore = this.itemCounter;
            this.fillPackage(containerFileNames, alreadySentContainers, writer, true, false);
            this.trace.log(90, "PackageManager: filled package with {0} acknowledge container(s)", (Object)String.valueOf(countBefore - this.itemCounter));
            countBefore = this.itemCounter;
            this.morePackages = this.fillPackage(this.containerfiles, alreadySentContainers, writer, false, false);
            this.trace.log(90, "PackageManager: filled package with {0} container items or headers", (Object)String.valueOf(countBefore - this.itemCounter));
            countBefore = this.fillPackageWithNotifyContainers(writer);
            this.trace.log(90, "PackageManager: filled package with {0} notify container(s)", (Object)String.valueOf(countBefore));
            writer.flush();
            writer.close();
            return packageFile;
        }
        catch (Exception ex) {
            if (ex instanceof SyncException) {
                throw (SyncException)ex;
            }
            this.trace.logException("Sync package can not be written", (Throwable)ex, true);
            throw new SyncException("Sync package can not be written");
        }
    }

    boolean hasMorePackages() {
        return this.morePackages;
    }

    private void writeContainer(SyncOutboundContainer container, BufferedUTF8Writer writer) throws IOException {
        OutboundContainerFormatter formatter = new OutboundContainerFormatter(container, this.currentHeaderCounter, this.currentItemCounter, writer);
        formatter.write();
        writer.flush();
        ++this.currentHeaderCounter;
        this.currentItemCounter += container.getItemCount();
    }

    Hashtable getLastGeneratedContainerIds() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        Enumeration enumeration = this.containerIds.elements();
        ContainerIdsElement element = null;
        while (enumeration.hasMoreElements()) {
            element = (ContainerIdsElement)enumeration.nextElement();
            result.put(element.getConversationId(), element.getContainerId());
        }
        return result;
    }

    private int initializeConvIdsTable() {
        ConversationIdHandler convIdHandler = ConversationIdHandler.getInstance();
        ConversationId[] convIdsToBeProcessed = convIdHandler.getAllConversationIdsForUser(this.user);
        this.convids = new Hashtable();
        int i = 0;
        while (i < convIdsToBeProcessed.length) {
            this.convids.put(convIdsToBeProcessed[i].getServerCommunicationId(), convIdsToBeProcessed[i].getServerCommunicationId());
            ++i;
        }
        return convIdsToBeProcessed.length;
    }

    private void removeConversationId(ConversationId convid) {
        if (convid != null && this.convids.containsKey(convid.getServerCommunicationId())) {
            this.convids.remove(convid.getServerCommunicationId());
            ++this.itemCounter;
        }
    }

    private int fillPackageWithNotifyContainers(BufferedUTF8Writer writer) throws SyncException, IOException {
        Enumeration enumeration = this.convids.elements();
        ConversationIdHandler convIdHandler = ConversationIdHandler.getInstance();
        int addeditems = 0;
        while (enumeration.hasMoreElements()) {
            String convid = (String)enumeration.nextElement();
            SyncOutboundContainer notifycontainer = new SyncOutboundContainer(convIdHandler.getConversationId(convid), "", "N");
            this.writeContainer(notifycontainer, writer);
            ++addeditems;
        }
        return addeditems;
    }

    private boolean fillPackage(String[] containerfilenames, Hashtable alreadySentContainers, BufferedUTF8Writer writer, boolean updateAcknowledgeMappingTable, boolean deleteFileAfterAdd) throws SyncException, IOException {
        boolean moreItemsToBeSent;
        SyncOutboundContainer currentOutboundContainer;
        int currentIndex = 0;
        boolean subContainerAdded = false;
        while (this.itemCounter > 0 && currentIndex < containerfilenames.length) {
            int containerItems;
            if (containerfilenames[currentIndex] == null) {
                ++currentIndex;
                continue;
            }
            File file = new File(containerfilenames[currentIndex]);
            currentOutboundContainer = new SyncOutboundContainer(file);
            if (updateAcknowledgeMappingTable) {
                this.acknowledgesIdToFileMapping.put(currentOutboundContainer.getContainerId(), file);
            }
            ++currentIndex;
            Integer nextItemIndexToBeSent = (Integer)alreadySentContainers.get(currentOutboundContainer.getContainerId());
            if (currentOutboundContainer.getItemCount() == 0) {
                if (nextItemIndexToBeSent != null) continue;
                this.writeContainer(currentOutboundContainer, writer);
                this.removeConversationId(currentOutboundContainer.getConversationId());
                --this.itemCounter;
                alreadySentContainers.put(currentOutboundContainer.getContainerId(), new Integer(0));
                if (!deleteFileAfterAdd) continue;
                file.delete();
                continue;
            }
            int firstNotAcknowledgedItemIndex = this.getFirstNotAcknowledgedItemIndex(currentOutboundContainer);
            int from = Math.max(firstNotAcknowledgedItemIndex, nextItemIndexToBeSent == null ? 0 : nextItemIndexToBeSent);
            if (from >= (containerItems = currentOutboundContainer.getItemCount())) continue;
            if (!(containerItems + 1 <= this.itemCounter && from == 0 || "WAF_REGISTRY".equals(currentOutboundContainer.getHeader().getMethod()))) {
                int to = currentOutboundContainer.getItemCount() - 1;
                if (to - from + 2 > this.itemCounter) {
                    to = from + this.itemCounter - 2;
                }
                if (to < from) {
                    this.itemCounter = -1;
                    continue;
                }
                currentOutboundContainer = currentOutboundContainer.getSubContainer(this.filemanager.getNextSubContainerCount(currentOutboundContainer.getContainerId(), this.user), from, to);
                this.writeContainer(currentOutboundContainer, writer);
                this.removeConversationId(currentOutboundContainer.getConversationId());
                this.itemCounter = this.itemCounter - 1 - (to - from + 1);
                alreadySentContainers.put(currentOutboundContainer.getContainerId(), new Integer(to + 1));
                if (to + 1 < containerItems) {
                    subContainerAdded = true;
                }
                if (!deleteFileAfterAdd) continue;
                file.delete();
                continue;
            }
            this.writeContainer(currentOutboundContainer, writer);
            this.removeConversationId(currentOutboundContainer.getConversationId());
            this.itemCounter = this.itemCounter - 1 - currentOutboundContainer.getItemCount();
            alreadySentContainers.put(currentOutboundContainer.getContainerId(), new Integer(currentOutboundContainer.getItemCount()));
            if (!deleteFileAfterAdd) continue;
            file.delete();
        }
        boolean bl = moreItemsToBeSent = currentIndex != containerfilenames.length || subContainerAdded;
        if (currentIndex < containerfilenames.length && updateAcknowledgeMappingTable) {
            while (currentIndex < containerfilenames.length) {
                File file = new File(containerfilenames[currentIndex]);
                currentOutboundContainer = new SyncOutboundContainer(file);
                this.acknowledgesIdToFileMapping.put(currentOutboundContainer.getContainerId(), file);
                ++currentIndex;
            }
        }
        return moreItemsToBeSent;
    }

    void acknowledgeContainer(SyncInboundContainer container) {
        SyncHeader header = container.getSyncHeader();
        String parentContainerId = header.getAncestorContainerId();
        if (parentContainerId != null && parentContainerId.length() > 0) {
            Integer index;
            if (header.isAcknowledgeReceived()) {
                File f = (File)this.acknowledgesIdToFileMapping.get(parentContainerId);
                if (f != null) {
                    f.delete();
                }
            } else if (header.isAcknowledge() && (index = (Integer)this.idToContainerMapping.get(parentContainerId)) != null && this.containerfiles[index] != null) {
                File containerFile = new File(this.containerfiles[index]);
                if (header.getSubContainerId().length() > 0) {
                    int from = header.getItemFrom();
                    int to = header.getItemTo();
                    try {
                        SyncOutboundContainer outcontainer = new SyncOutboundContainer(containerFile);
                        int i = from;
                        while (i <= to) {
                            outcontainer.getItemAt(i).setAlreadyAcknowledged(true);
                            ++i;
                        }
                        outcontainer.writeContainerToFile(containerFile);
                    }
                    catch (Exception e) {
                        Trace.getInstance("MI/Sync").logException(50, "Exception while acknowledge processing", e, true);
                    }
                } else {
                    File f = new File(this.containerfiles[index]);
                    f.delete();
                    this.containerfiles[index.intValue()] = null;
                }
            }
        }
        if (!container.isAcknowledgeReceived()) {
            if (container.isAcknowledge()) {
                try {
                    ContainerFactory.createAcknowledgeContainer(container, this.user, "C");
                }
                catch (SyncException e) {
                    Trace.getInstance("MI/Sync").logException(50, "Acknowledge receipt container could not be created", e, true);
                }
            } else if (!header.isNotify()) {
                try {
                    ContainerFactory.createAcknowledgeContainer(container, this.user, "A");
                }
                catch (SyncException e) {
                    Trace.getInstance("MI/Sync").logException(50, "Acknowledge container could not be created", e, true);
                }
            }
        }
    }

    private int getFirstNotAcknowledgedItemIndex(SyncOutboundContainer container) {
        int maxcount = container.getItemCount();
        int result = 0;
        while (result < maxcount) {
            if (!container.getItemAt(result).isAlreadyAcknowledged()) break;
            ++result;
        }
        return result;
    }

    private void updateGeneratedContainerId(ConversationId conversationId, String containerId, int msgIndex) {
        if (conversationId != null && containerId != null && containerId.length() > 0 && msgIndex >= 0) {
            ContainerIdsElement element = (ContainerIdsElement)this.containerIds.get(conversationId);
            if (element == null) {
                this.containerIds.put(conversationId, new ContainerIdsElement(conversationId.getId(), containerId, msgIndex));
            } else {
                element.updateMaximum(containerId, msgIndex);
            }
        }
    }

    private static class ContainerIdsElement {
        String conversationid;
        String containerid;
        int msgIndex;

        ContainerIdsElement(String convsationid, String containerid, int msgIndex) {
            this.conversationid = convsationid;
            this.containerid = containerid;
            this.msgIndex = msgIndex;
        }

        String getConversationId() {
            return this.conversationid;
        }

        String getContainerId() {
            return this.containerid;
        }

        int getMsgIndex() {
            return this.msgIndex;
        }

        void updateMaximum(String containerId, int msgIndex) {
            if (msgIndex > this.msgIndex) {
                this.msgIndex = msgIndex;
                this.containerid = containerId;
            }
        }
    }
}

