/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.sync;

import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.services.BufferedUTF8Reader;
import com.sap.ip.me.api.sync.SyncException;
import java.io.File;
import java.io.IOException;

public class OutboundTokenizer {
    private char[] charBuffer = new char[42];
    private BufferedUTF8Reader reader;
    private StringBuffer fileBuffer = new StringBuffer();
    private boolean eofReached = false;
    private static final char[] headerPrefix = new char[]{'I', 'N', 'H'};
    private String containerBegin;
    private StringBuffer nextOutboundContainer = new StringBuffer();
    private boolean firstContainerStartIndexFound = false;

    public OutboundTokenizer(File file) throws IOException {
        this.reader = new BufferedUTF8Reader(file);
        this.containerBegin = "INH-H[";
        this.nextOutboundContainer = this.parseNextOutboundContainer(this.reader, this.fileBuffer);
    }

    public StringBuffer next() throws SyncException {
        if (!this.hasNext()) {
            throw new SyncException("No more containers in the outbound file");
        }
        StringBuffer oldNext = this.nextOutboundContainer;
        try {
            this.nextOutboundContainer = new StringBuffer();
            if (!this.eofReached) {
                this.nextOutboundContainer = this.parseNextOutboundContainer(this.reader, this.fileBuffer);
            }
            return oldNext;
        }
        catch (IOException e) {
            AppLog.getInstance("MI/Sync").logException(50, "Next outbound container can not be parsed", e, true);
            throw new SyncException("Next outbound container can not be parsed");
        }
    }

    private StringBuffer parseNextOutboundContainer(BufferedUTF8Reader reader, StringBuffer targetBuffer) throws IOException {
        int headerBeginIndex = -1;
        boolean endFound = false;
        while (!endFound && !this.eofReached) {
            this.eofReached = this.readNextCharacters(reader, this.charBuffer, targetBuffer);
            int searchStart = targetBuffer.length() - this.charBuffer.length - this.containerBegin.length() - 1;
            if (searchStart <= 0) {
                searchStart = this.firstContainerStartIndexFound ? this.containerBegin.length() : 0;
            }
            if ((headerBeginIndex = this.getIndexOfString(searchStart, targetBuffer.length(), targetBuffer, this.containerBegin)) == -1) continue;
            if (this.firstContainerStartIndexFound) {
                endFound = true;
                continue;
            }
            this.firstContainerStartIndexFound = true;
        }
        if (!this.eofReached) {
            this.nextOutboundContainer.setLength(0);
            int i = 0;
            while (i < headerBeginIndex) {
                this.nextOutboundContainer.append(targetBuffer.charAt(i));
                ++i;
            }
            int i2 = headerBeginIndex;
            int j = 0;
            while (i2 < targetBuffer.length()) {
                targetBuffer.setCharAt(j, targetBuffer.charAt(i2));
                ++j;
                ++i2;
            }
            targetBuffer.setLength(targetBuffer.length() - headerBeginIndex);
            endFound = false;
        } else {
            this.nextOutboundContainer = targetBuffer;
        }
        return this.nextOutboundContainer;
    }

    private boolean readNextCharacters(BufferedUTF8Reader reader, char[] chars, StringBuffer targetBuffer) throws IOException {
        boolean endOfFile = false;
        int length = this.fillBuffer(reader, chars);
        if (length == -1) {
            return true;
        }
        if (length < chars.length) {
            if (length > 0 && chars[length - 1] != '&') {
                targetBuffer.append(chars, 0, length - 1);
            } else {
                targetBuffer.append(chars, 0, length);
            }
            endOfFile = true;
        } else {
            targetBuffer.append(chars, 0, length);
        }
        return endOfFile;
    }

    private int getIndexOfString(int startIndex, int length, StringBuffer source, String str) {
        int indexOfStringBegin = -1;
        int i = startIndex;
        while (i < length - this.containerBegin.length()) {
            if (source.charAt(i) == headerPrefix[0] && source.charAt(i + 1) == headerPrefix[1] && source.charAt(i + 2) == headerPrefix[2]) {
                StringBuffer headerBuffer = new StringBuffer();
                int j = 0;
                while (j < this.containerBegin.length()) {
                    headerBuffer.append(source.charAt(i + j));
                    ++j;
                }
                if (headerBuffer.toString().equals(str)) {
                    indexOfStringBegin = i;
                    break;
                }
            }
            ++i;
        }
        return indexOfStringBegin;
    }

    public boolean hasNext() {
        return this.nextOutboundContainer.length() != 0 || !this.firstContainerStartIndexFound && !this.eofReached;
    }

    public void close() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                AppLog.getInstance("MI/Sync").log(60, "OutboundTokenizer close failed");
            }
        }
    }

    String getContainerID(StringBuffer containerBuf) {
        char[] id = new char[20];
        int index = 0;
        while (index < containerBuf.length() && containerBuf.charAt(index) != '=') {
            ++index;
        }
        containerBuf.getChars(index + 1, 21 + index, id, 0);
        return new String(id);
    }

    /*
     * WARNING - void declaration
     */
    private int fillBuffer(BufferedUTF8Reader reader, char[] chars) throws IOException {
        int singleChar;
        int counter = 0;
        while ((singleChar = reader.read()) != -1) {
            void var4_4;
            chars[counter] = (char)var4_4;
            if (++counter == 42) break;
        }
        return counter;
    }
}

