/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.sync;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.services.BufferedUTF8Writer;
import com.sap.ip.me.api.sync.SyncException;
import com.sap.ip.me.api.user.User;
import com.sap.ip.me.sync.OutboundContainerFormatter;
import com.sap.ip.me.sync.SyncContainer;
import com.sap.ip.me.sync.SyncOutboundContainer;
import java.io.File;
import java.io.IOException;

public class OutboundFileManager {
    private static final String ACKNOWLEDGE_FILE_NAME = "acknowledges.sync";
    private static final String PACKAGE_FILE_NAME = "packages" + File.separator + "package.sync";
    private static final String PENDING_ACKNOWLEDGES = "pendingAcks";
    private static final String NOTIFY_FILE_NAME = "notify.sync";

    OutboundFileManager() {
    }

    void writeContainerToOutboundFile(SyncOutboundContainer outboundContainer, User user, int headerindex, int itemindex) throws IOException {
        if (!outboundContainer.getHeader().isAcknowledge()) {
            this.writeToOutboundFile(outboundContainer, headerindex, itemindex, new File(this.getOutboundFileName(user)), true);
        } else {
            this.writeToOutboundFile(outboundContainer, headerindex, itemindex, new File(this.getAcknowledgeFileName(user)), true);
        }
    }

    int writeContainerToWriter(SyncContainer container, int headerIndex, int itemIndex, BufferedUTF8Writer writer) throws SyncException {
        int itemsInFile = itemIndex;
        try {
            OutboundContainerFormatter formatter = new OutboundContainerFormatter(container, headerIndex, itemIndex, writer);
            formatter.write();
            writer.flush();
        }
        catch (IOException e) {
            AppLog.getInstance("MI/Sync").logException("Container can not be written to the outbound file", (Throwable)e, true);
            throw new SyncException("Container can not be written to the outbound file");
        }
        return itemsInFile += container.getItemCount();
    }

    public synchronized File renameOutboundFile(User user) throws IOException {
        File currentOutboundFile = new File(this.getOutboundFileName(user));
        File newOutboundFile = new File(this.getProcessedOutboundFileName(user));
        if (!newOutboundFile.exists()) {
            currentOutboundFile.renameTo(newOutboundFile);
        }
        return newOutboundFile;
    }

    public synchronized void removeFile(File file) {
        File fileToDelete = new File(file.getAbsolutePath());
        if (fileToDelete.exists()) {
            fileToDelete.delete();
        } else {
            Trace.getInstance("MI/Sync").log(90, "File {0} could not be deleted because it does not exist", (Object)file.getAbsolutePath());
        }
    }

    public File getPendingSyncOutboundFile(User user) {
        File pendingOutboundFile = new File(this.getProcessedOutboundFileName(user));
        if (pendingOutboundFile.exists()) {
            return pendingOutboundFile;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void writeToOutboundFile(SyncContainer container, int headerindex, int itemindex, File outboundFile, boolean append) throws IOException {
        BufferedUTF8Writer writer = null;
        try {
            writer = new BufferedUTF8Writer(outboundFile, append);
            OutboundContainerFormatter formatter = new OutboundContainerFormatter(container, headerindex, itemindex, writer);
            formatter.write();
            Object var9_8 = null;
            if (writer == null) return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (writer == null) throw throwable;
            writer.flush();
            writer.close();
            throw throwable;
        }
        writer.flush();
        writer.close();
    }

    private String getOutboundFileName(User user) {
        String fileName = Configuration.getInstance().getProperty("MobileEngine.Sync.OutboundFile");
        return this.getSyncFileName(user, fileName);
    }

    String getAcknowledgeFileName(User user) {
        return this.getSyncFileName(user, ACKNOWLEDGE_FILE_NAME);
    }

    String getPackageFileName(User user) {
        return this.getSyncFileName(user, PACKAGE_FILE_NAME);
    }

    String getPendingAcknowledgesDirectory(User user) {
        return this.getSyncFileName(user, PENDING_ACKNOWLEDGES);
    }

    String getProcessedOutboundFileName(User user) {
        String fileName = Configuration.getInstance().getProperty("MobileEngine.Sync.CurrentlyProcessedOutboundFile");
        return this.getSyncFileName(user, fileName);
    }

    String getNotifyFileName(User user) {
        return this.getSyncFileName(user, NOTIFY_FILE_NAME);
    }

    public String getInboundFileName(User user) {
        String fileName = Configuration.getInstance().getProperty("MobileEngine.Sync.InboundFile");
        return this.getSyncFileName(user, fileName);
    }

    private String getSyncFileName(User user, String fileName) {
        String syncSubDirectory = Configuration.getInstance().getProperty("MobileEngine.Sync.Directory");
        String userLogonName = user.getUniqueName();
        StringBuffer pathBuffer = new StringBuffer();
        pathBuffer.append(Configuration.getInstance().getProperty("MobileEngine.InstallationPath"));
        pathBuffer.append(File.separator);
        if (!"".equals(syncSubDirectory)) {
            pathBuffer.append(syncSubDirectory);
            pathBuffer.append(File.separator);
        }
        if (!"".equals(userLogonName)) {
            pathBuffer.append(userLogonName);
            pathBuffer.append(File.separator);
        }
        pathBuffer.append(fileName);
        String path = pathBuffer.toString();
        File directory = new File(new File(path).getParent());
        if (!directory.exists()) {
            directory.mkdirs();
        }
        return path;
    }
}

