/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.sync;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.core.SyncSettings;
import com.sap.ip.me.sync.SyncContainer;
import com.sap.ip.me.sync.SyncContainerItem;
import com.sap.ip.me.sync.SyncHeader;
import com.sap.ip.me.sync.SyncOutboundContainer;
import java.io.IOException;
import java.io.Writer;

public class OutboundContainerFormatter {
    private static final boolean NEWPROTOCOL_USED = Configuration.getInstance().getBoolean("MobileEngine.Sync.NewProtocol", false);
    private SyncContainer container;
    private int headerindex;
    private int itemindex;
    Writer writer;
    private static final String ABAPSeparator = ";";
    static final String HEADER_BEGIN = "INH-H[";
    static final String ITEM_BEGIN = "INB-B[";
    static final char END_CHAR = '&';
    static final int STATIC_AV_HEADER_OUTPUTFORMAT_SIZE = 170;
    private static final char ABAP_SEPARATOR = ';';
    private StringBuffer containerBuffer;

    OutboundContainerFormatter(SyncContainer container, int headerindex, int itemindex, Writer writer) {
        this.container = container;
        this.headerindex = headerindex;
        this.itemindex = itemindex;
        this.writer = writer;
    }

    void write() throws IOException {
        this.writeHeader();
        this.writeBodies();
    }

    public void writeBodies() throws IOException {
        int itemslength = this.container.getItemCount();
        String containerid = this.container.getHeader().getContainerId();
        int i = 0;
        while (i < itemslength) {
            SyncContainerItem currentItem = this.container.getItemAt(i);
            this.writer.write(ITEM_BEGIN);
            if (this.itemindex == -1) {
                this.writer.write("1");
            } else {
                this.writer.write(String.valueOf(this.itemindex++));
            }
            this.writer.write("]=");
            this.writer.write(containerid);
            this.writer.write(ABAPSeparator);
            this.writer.write(currentItem.getFieldName());
            this.writer.write(ABAPSeparator);
            this.writer.write(currentItem.getLineNumber());
            this.writer.write(ABAPSeparator);
            String fieldValue1 = currentItem.getFieldValue().replace('\n', ' ');
            String fieldValue2 = fieldValue1.replace('\r', ' ');
            this.writer.write(fieldValue2);
            this.writer.write("&");
            ++i;
        }
    }

    private void writeHeader() throws IOException {
        this.writer.write(HEADER_BEGIN);
        this.writer.write(String.valueOf(this.headerindex));
        this.writer.write("]=");
        SyncHeader header = this.container.getHeader();
        this.writer.write(header.getContainerId());
        this.writer.write(59);
        this.writer.write(header.getOwner());
        this.writer.write(59);
        this.writer.write(header.getType());
        this.writer.write(59);
        this.writer.write(header.getMethod());
        this.writer.write(59);
        if (SyncSettings.isNewProtocolActive()) {
            this.writer.write(header.getConversationId());
        } else {
            String deviceId = ConversationIdHandler.getDeviceId();
            if (deviceId == null) {
                deviceId = "";
            }
            this.writer.write(deviceId);
        }
        this.writer.write(59);
        this.writer.write(header.getAncestorContainerId());
        this.writer.write(59);
        int msgindex = header.getMsgIndex();
        if (msgindex <= 0) {
            this.writer.write("");
        } else {
            this.writer.write(String.valueOf(this.getFormatedNumber(header.getMsgIndex(), 10)));
        }
        this.writer.write(59);
        this.writer.write(header.getMsgType());
        this.writer.write(59);
        this.writer.write(header.getServerId());
        this.writer.write(59);
        this.writer.write(header.getBodyType());
        this.writer.write(59);
        this.writer.write(String.valueOf(header.getBodyLength()));
        this.writer.write(59);
        this.writer.write(header.getSubContainerId());
        this.writer.write(59);
        this.writer.write(String.valueOf(header.getSubContainerMax()));
        if (NEWPROTOCOL_USED) {
            this.writer.write(59);
            if (header.getSubContainerId().length() > 0) {
                this.writer.write(String.valueOf(header.getItemFrom()));
            }
            this.writer.write(59);
            if (header.getSubContainerId().length() > 0) {
                this.writer.write(String.valueOf(header.getItemTo()));
            }
        }
        this.writer.write(38);
    }

    private String getFormatedNumber(int n, int len) {
        StringBuffer result = new StringBuffer(len);
        String value = Integer.toString(n);
        if (value.length() > len) {
            return value.substring(value.length() - len);
        }
        int zeros = len - value.length();
        int i = 0;
        while (i < zeros) {
            result.append("0");
            ++i;
        }
        result.append(value);
        return result.toString();
    }

    private OutboundContainerFormatter(StringBuffer buffer) {
        this.containerBuffer = buffer;
    }

    static SyncOutboundContainer parseOutboundContainer(StringBuffer buffer) {
        OutboundContainerFormatter parser = new OutboundContainerFormatter(buffer);
        return parser.parse();
    }

    private SyncOutboundContainer parse() {
        SyncOutboundContainer result = new SyncOutboundContainer(this.parseHeader());
        this.parseItems(result);
        return result;
    }

    private SyncHeader parseHeader() {
        int i = 0;
        String id = null;
        while (i < this.containerBuffer.length()) {
            if (this.containerBuffer.charAt(i) == '=') {
                char[] charBuf = new char[20];
                this.containerBuffer.getChars(i + 1, i + 21, charBuf, 0);
                id = new String(charBuf);
                i += 22;
                break;
            }
            ++i;
        }
        SyncHeader result = new SyncHeader(id);
        result.setOwner(this.getNextAttribute(i, false));
        i = i + result.getOwner().length() + 1;
        result.setType(this.getNextAttribute(i, false));
        i = i + result.getType().length() + 1;
        result.setMethod(this.getNextAttribute(i, false));
        i = i + result.getMethod().length() + 1;
        result.setConversationId(this.getNextAttribute(i, false));
        i = i + result.getConversationId().length() + 1;
        result.setAncestorContainerId(this.getNextAttribute(i, false));
        i = i + result.getAncestorContainerId().length() + 1;
        String msgindex = this.getNextAttribute(i, false);
        result.setMsgIndex(msgindex);
        i = i + msgindex.length() + 1;
        result.setMsgType(this.getNextAttribute(i, false));
        i = i + result.getMsgType().length() + 1;
        result.setServerId(this.getNextAttribute(i, false));
        i = i + result.getServerId().length() + 1;
        result.setBodyType(this.getNextAttribute(i, false));
        i = i + result.getBodyType().length() + 1;
        String bodyL = this.getNextAttribute(i, false);
        result.setBodyLength(Integer.parseInt(bodyL));
        i = i + bodyL.length() + 1;
        result.setSubContainerId(this.getNextAttribute(i, false));
        i = i + result.getSubContainerId().length() + 1;
        String subContainerM = this.getNextAttribute(i, false);
        result.setSubContainerMax(Integer.parseInt(subContainerM));
        i = i + subContainerM.length() + 1;
        if (NEWPROTOCOL_USED) {
            String from = this.getNextAttribute(i, false);
            result.setItemFrom(Integer.parseInt(from));
            i = i + from.length() + 1;
            String to = this.getNextAttribute(i, false);
            result.setSubContainerMax(Integer.parseInt(to));
        }
        return result;
    }

    private String getNextAttribute(int begin, boolean untilElementEnd) {
        int i = begin;
        while (i < this.containerBuffer.length()) {
            if (!(untilElementEnd || this.containerBuffer.charAt(i) != ';' && this.containerBuffer.charAt(i) != '&')) {
                char[] charBuf = new char[i - begin];
                this.containerBuffer.getChars(begin, i, charBuf, 0);
                return new String(charBuf);
            }
            if (untilElementEnd && this.containerBuffer.charAt(i) == '&') {
                int prefixend = i + 1;
                StringBuffer temp = new StringBuffer(10);
                while (prefixend < this.containerBuffer.length() && this.containerBuffer.charAt(prefixend) != '[') {
                    temp.append(this.containerBuffer.charAt(prefixend));
                    ++prefixend;
                }
                temp.append('[');
                String prefix = temp.toString();
                if (prefix.length() > 1 && (prefix.equals(HEADER_BEGIN) || prefix.equals(ITEM_BEGIN)) || prefix.length() <= 1) {
                    char[] charBuf = new char[i - begin];
                    this.containerBuffer.getChars(begin, i, charBuf, 0);
                    return new String(charBuf);
                }
            }
            ++i;
        }
        return "";
    }

    /*
     * Unable to fully structure code
     */
    private void parseItems(SyncOutboundContainer container) {
        index = 0;
        while (index < this.containerBuffer.length() && this.containerBuffer.charAt(index) != '&') {
            ++index;
        }
        ++index;
        itemNumber = 1;
        fieldname = null;
        linenumber = null;
        value = null;
        ** GOTO lbl21
        {
            ++index;
            do {
                if (index < this.containerBuffer.length() && this.containerBuffer.charAt(index) != '=') continue block1;
                fieldname = this.getNextAttribute(index += 22, false);
                index = index + fieldname.length() + 1;
                linenumber = this.getNextAttribute(index, false);
                index = index + linenumber.length() + 1;
                value = this.getNextAttribute(index, true);
                index = index + value.length() + 2;
                container.addItem(new SyncContainerItem(itemNumber, fieldname, linenumber, value));
lbl21:
                // 2 sources

            } while (index < this.containerBuffer.length());
        }
    }
}

