/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.sync;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.core.SyncSettings;
import com.sap.ip.me.sync.SyncLogImpl;
import java.util.Enumeration;
import java.util.Vector;

public class OldSyncLog {
    public static final String STATE_OK = "OK";
    public static final String STATE_FAILED = "FAILED";
    public static final String STATE_ON = "ON";
    public static final String STATE_OFF = "OFF";
    public static final String STATE_UNKNOWN = "?";
    public static final String STATE_STARTED = "START";
    public static final String STATE_DONE = "DONE";
    public static final String STATE_NOT_AUTHORIZED = "NOT_AUTHORIZED";
    private static OldSyncLog instance = new OldSyncLog();
    private String stageStartSync = "?";
    private String syncUrl = " ";
    private String stageConnected = "?";
    private String syncFailureMessage = " ";
    private String stageCheckInbound = "?";
    private String stageInboundProcStart = "?";
    private String stageInboundProcDone = "?";
    private String frameworkUpdateRequired = "?";
    private String frameworkUpdateURL = "";
    private String stageInstall = "?";
    private String stageUninstall = "?";
    private Vector instApps = new Vector();
    private Vector downloadApps = new Vector();
    private Vector uninstApps = new Vector();
    private Vector failedToInstApps = new Vector();
    private Trace trace = Trace.getInstance("MI/Sync");

    public static OldSyncLog getInstance() {
        return instance;
    }

    public void reset() {
        this.stageStartSync = STATE_UNKNOWN;
        this.stageConnected = STATE_UNKNOWN;
        this.syncUrl = " ";
        this.stageInboundProcStart = STATE_UNKNOWN;
        this.stageInboundProcDone = STATE_UNKNOWN;
        this.stageInstall = STATE_UNKNOWN;
        this.stageUninstall = STATE_UNKNOWN;
        this.frameworkUpdateRequired = STATE_UNKNOWN;
        this.frameworkUpdateURL = "";
        this.instApps.removeAllElements();
        this.downloadApps.removeAllElements();
        this.uninstApps.removeAllElements();
        this.failedToInstApps.removeAllElements();
    }

    public void setReasonForSyncFailure(String s) {
        this.syncFailureMessage = s;
    }

    public String getReasonForSyncFailure() {
        return this.syncFailureMessage;
    }

    public void setSyncUrl(String s) {
        this.syncUrl = s;
    }

    public String getSyncUrl() {
        return this.syncUrl;
    }

    public void addInboundProc(String method) {
        SyncLogImpl.getSyncLogImplInstance().addprocessedMethod(method);
        this.trace.log(80, "SyncInboundProcessing started for method {0}", (Object)method);
    }

    public String[] getInboundProcs() {
        return SyncLogImpl.getSyncLogImplInstance().getProcessedMethods();
    }

    public void addInstApp(String s) {
        this.instApps.addElement(s);
    }

    public String[] getInstApps() {
        Object[] s = new String[this.instApps.size()];
        this.instApps.copyInto(s);
        return s;
    }

    public void downloadApp(String s) {
        this.downloadApps.addElement(s);
    }

    public String[] getDownloadApps() {
        Object[] s = new String[this.downloadApps.size()];
        this.downloadApps.copyInto(s);
        return s;
    }

    public void addUninstApp(String s) {
        boolean contained = false;
        Enumeration enumeration = this.instApps.elements();
        String nextApp = null;
        while (enumeration.hasMoreElements()) {
            nextApp = (String)enumeration.nextElement();
            if (!nextApp.substring(0, nextApp.indexOf(":")).equalsIgnoreCase(s.substring(0, s.indexOf(":")))) continue;
            contained = true;
            break;
        }
        if (contained) {
            this.instApps.removeElement(nextApp);
            this.failedToInstApps.addElement(s);
        } else {
            this.uninstApps.addElement(s);
        }
    }

    public String[] getUninstApps() {
        Object[] s = new String[this.uninstApps.size()];
        this.uninstApps.copyInto(s);
        return s;
    }

    public String[] getFailedToInstApps() {
        Object[] s = new String[this.failedToInstApps.size()];
        this.failedToInstApps.copyInto(s);
        return s;
    }

    public void addMessage(String s) {
        SyncLogImpl.getSyncLogImplInstance().addFailureMessage(s);
    }

    public String[] getMessages() {
        String[] errors = SyncLogImpl.getSyncLogImplInstance().getFailureMessages();
        String[] messages = SyncLogImpl.getSyncLogImplInstance().getInfoMessages();
        String[] newArray = new String[errors.length + messages.length];
        int i = 0;
        while (i < errors.length) {
            newArray[i] = errors[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < messages.length) {
            newArray[i2 + errors.length] = messages[i2];
            ++i2;
        }
        return newArray;
    }

    public boolean hasToBeDisplayed() {
        return this.stageConnected.equalsIgnoreCase(STATE_FAILED) || this.instApps.size() > 0 || this.uninstApps.size() > 0 || !this.stageInboundProcDone.equalsIgnoreCase(STATE_DONE) || !this.stageCheckInbound.equalsIgnoreCase(STATE_OK) || this.frameworkUpdateRequired.equalsIgnoreCase(STATE_ON) || !SyncLogImpl.getSyncLogImplInstance().isReady();
    }

    public void started() {
        this.trace.log(80, "Synchronisation started");
        this.stageStartSync = STATE_STARTED;
        this.setSyncUrl(SyncSettings.getSyncGateway());
    }

    public void failed(Exception e) {
        this.stageConnected = STATE_FAILED;
        this.setReasonForSyncFailure(e.getMessage());
        this.addMessage(e.getMessage());
        AppLog.getInstance("MI/Sync").log(50, "Synchronisation failed: {0}", (Object)e.getMessage());
    }

    public void failed(String reason) {
        this.stageCheckInbound = STATE_FAILED;
        this.setReasonForSyncFailure(reason);
        this.addMessage(reason);
        AppLog.getInstance("MI/Sync").log(50, "Sync failed: {0}", (Object)reason);
    }

    public void ok() {
        this.stageCheckInbound = STATE_OK;
        this.trace.log(80, "Synchronisation: valid response received from server ");
    }

    public void notAuthorized() {
        this.stageCheckInbound = STATE_NOT_AUTHORIZED;
        AppLog.getInstance("MI/Sync").log(50, "Synchronisation: not authorized to sync with server ");
    }

    public void acknowledgeFailed(Exception e) {
        this.addMessage("Unable to send SyncAcknowledge now:" + e.getMessage());
        this.addMessage("Incoming data might be proccessed a second time at next sync");
        AppLog.getInstance("MI/Sync").logException(60, "Synchronisation: Unable to send SyncAcknowledge now (Incoming data might be proccessed a second time at next sync)", e, false);
    }

    public void inboundStarted() {
        this.stageInboundProcStart = STATE_STARTED;
        this.trace.log(80, "Synchronisation: Start processing inbound data");
    }

    public void inboundProcessingDone() {
        this.stageInboundProcDone = STATE_DONE;
        this.trace.log(80, "Synchronisation: Processing of inbound data finished");
    }

    public void processingMethodFailed(String inboundContainerMethod, Exception e) {
        this.addMessage("Exception while proccessing method " + inboundContainerMethod + " : " + e.toString() + " : " + e.getMessage());
        AppLog.getInstance("MI/Sync").logException(60, "Exception while proccessing method " + inboundContainerMethod, e, true);
    }

    public void unregisteredMethod(String inboundContainerMethod) {
        this.addMessage("received container for unregistered method " + inboundContainerMethod);
        this.trace.log(80, "Synchronisation: received container for unregistered method {0}", (Object)inboundContainerMethod);
    }

    public String getStageCheckInbound() {
        return this.stageCheckInbound;
    }

    public void setStageCheckInbound() {
        this.stageCheckInbound = STATE_OK;
    }

    public void setInstallationFailed() {
        this.stageInstall = STATE_FAILED;
    }

    public String getStageProxy() {
        boolean withProxy = Configuration.getInstance().getBoolean("MobileEngine.Sync.Proxyused", false);
        return withProxy ? STATE_ON : STATE_OFF;
    }

    public void setStageConnectedOk() {
        this.stageConnected = STATE_OK;
    }

    public void setStageConnectedFailed() {
        this.stageConnected = STATE_FAILED;
    }

    public String getStageConnected() {
        return this.stageConnected;
    }

    public String getStageStartSync() {
        return this.stageStartSync;
    }

    public void setStageStartSyncStarted() {
        this.stageStartSync = STATE_STARTED;
    }

    public String getStageInboundProcStart() {
        return this.stageInboundProcStart;
    }

    public String getStageInboundProcDone() {
        return this.stageInboundProcDone;
    }

    public String getStageInstall() {
        return this.stageInstall;
    }

    public String getStageUnnstall() {
        return this.stageUninstall;
    }

    public String getFrameworkUpdateRequired() {
        return this.frameworkUpdateRequired;
    }

    public String getFrameworkUpdateURL() {
        return this.frameworkUpdateURL;
    }
}

