/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.sync;

import com.sap.ip.me.api.conf.VisibilityType;
import com.sap.ip.me.api.logging.AbstractLogging;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.sync.InboundContainer;
import com.sap.ip.me.api.sync.InboundProcessor;
import com.sap.ip.me.api.sync.InboundProcessorRegistry;
import com.sap.ip.me.api.sync.OutboundContainer;
import com.sap.ip.me.api.sync.OutboundContainerFactory;
import com.sap.ip.me.api.sync.SyncEvent;
import com.sap.ip.me.api.sync.SyncEventListener;
import com.sap.ip.me.api.sync.SyncException;
import com.sap.ip.me.api.user.User;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.core.UserManagerImpl;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class LogSender
implements SyncEventListener,
Serializable {
    protected static final int MAX_LINE_LENGTH = 255;
    private transient Hashtable severityLevelList = null;

    public static boolean sendLogToBackend(AbstractLogging log) {
        String deviceid = ConversationIdHandler.getDeviceId();
        if (deviceid.length() == 0) {
            return false;
        }
        LogSender ls = new LogSender();
        LogSenderInboundProcessor.registerItself();
        Vector ent = log.read();
        if (ent == null) {
            return false;
        }
        String currentLogLine = null;
        int logLineLen = 0;
        Hashtable severityLevelList = ls.getSeverityLevelList();
        try {
            OutboundContainer container = null;
            container = OutboundContainerFactory.getInstance().createOutboundContainer(VisibilityType.SEPARATED, "CENTRAL_TRACING", "R");
            container.setInitialItemCount(ent.size() * 5);
            User user = UserManagerImpl.getUserManagerImplInstance().getCurrentLogonUser();
            container.addItem("PASSPORT", "");
            container.addItem("DEPLID", deviceid);
            container.addItem("USERNAME", user.getUniqueID());
            container.addItem("TIMEZONE", "");
            String timeStamp = null;
            boolean msgStart = false;
            int maxsize = ent.size();
            int i = 0;
            while (i < maxsize) {
                currentLogLine = (String)ent.elementAt(i);
                logLineLen = (currentLogLine = ls.replaceBodyOrHeaderMarkers(currentLogLine)).length();
                if (logLineLen > 27) {
                    if (currentLogLine.startsWith("[", 0) && currentLogLine.startsWith("] ", 22) && currentLogLine.startsWith(" [", 25) && severityLevelList.containsKey(currentLogLine.substring(24, 25))) {
                        msgStart = true;
                        int traceCount = container.getNextLineNumberForFieldname("TRACE");
                        container.getNextLineNumberForFieldname("MSGCNT");
                        container.addItem("MSGCNT", Integer.toString(traceCount));
                        container.addItem("MSGTYP", currentLogLine.substring(24, 25));
                        int compEnd = currentLogLine.indexOf("]", 26);
                        container.addItem("COMPONENT", currentLogLine.substring(27, compEnd));
                        timeStamp = currentLogLine.substring(1, 9);
                        timeStamp = timeStamp + currentLogLine.substring(10, 12);
                        timeStamp = timeStamp + currentLogLine.substring(13, 15);
                        timeStamp = timeStamp + currentLogLine.substring(16, 18);
                        timeStamp = timeStamp + ".";
                        timeStamp = timeStamp + currentLogLine.substring(19, 22);
                        container.addItem("TIMESTAMP", timeStamp);
                        String lineSubString = currentLogLine.substring(compEnd + 2);
                        int lineSubStringLen = lineSubString.length();
                        while (lineSubStringLen > 0) {
                            container.getNextLineNumberForFieldname("TRACE");
                            if (lineSubStringLen > 255) {
                                container.addItem("TRACE", lineSubString);
                                lineSubString = lineSubString.substring(255);
                                lineSubStringLen = lineSubString.length();
                                continue;
                            }
                            container.addItem("TRACE", lineSubString);
                            lineSubStringLen = 0;
                        }
                    } else if (msgStart) {
                        while (logLineLen > 0) {
                            if (logLineLen > 255) {
                                container.getNextLineNumberForFieldname("TRACE");
                                container.addItem("TRACE", currentLogLine.substring(0, 255));
                                currentLogLine = currentLogLine.substring(255);
                                logLineLen = currentLogLine.length();
                                continue;
                            }
                            container.getNextLineNumberForFieldname("TRACE");
                            container.addItem("TRACE", currentLogLine);
                            logLineLen = 0;
                        }
                    }
                } else if (msgStart) {
                    container.getNextLineNumberForFieldname("TRACE");
                    container.addItem("TRACE", currentLogLine);
                }
                ++i;
            }
            container.close();
            return true;
        }
        catch (SyncException s) {
            AppLog.getInstance("MI/Sync").logException(50, s);
        }
        catch (NumberFormatException ex) {
            AppLog.getInstance("MI/Sync").logException(50, ex);
        }
        return false;
    }

    public void actionPerformed(SyncEvent syncEvent) {
        AppLog applog;
        if (syncEvent.getType() == 0 && LogSender.sendLogToBackend(applog = AppLog.getInstance("MI/Sync"))) {
            applog.reset();
        }
    }

    private Hashtable getSeverityLevelList() {
        if (this.severityLevelList == null) {
            this.severityLevelList = new Hashtable(10);
            this.severityLevelList.put("A", "All");
            this.severityLevelList.put("E", "Error");
            this.severityLevelList.put("W", "Warning");
            this.severityLevelList.put("P", "Path");
            this.severityLevelList.put("F", "Fatal");
            this.severityLevelList.put("D", "Debug");
            this.severityLevelList.put("I", "Information");
        }
        return this.severityLevelList;
    }

    private String replaceBodyOrHeaderMarkers(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer result = new StringBuffer(str.length() + 20);
        int start = 0;
        int pointer = 0;
        if (str.startsWith("IN")) {
            result.append("I N");
            pointer = start += 2;
        }
        pointer = str.indexOf("&IN", start);
        while (pointer != -1) {
            result.append(str.substring(start, pointer));
            result.append("+I N");
            start = pointer + 3;
            pointer = str.indexOf("&IN", start);
        }
        result.append(str.substring(start));
        return result.toString();
    }

    static class LogSenderInboundProcessor
    implements InboundProcessor,
    Serializable {
        private static final String METHOD_NAME = "CENTRAL_TRACING";

        LogSenderInboundProcessor() {
        }

        static void registerItself() {
            InboundProcessorRegistry inboundreg = InboundProcessorRegistry.getInstance();
            if (!inboundreg.isRegistered(METHOD_NAME)) {
                inboundreg.register(new LogSenderInboundProcessor());
            }
        }

        public String getMethodName() {
            return METHOD_NAME;
        }

        public void process(InboundContainer inboundContainer) {
        }
    }
}

