/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.sync;

import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.services.BufferedUTF8Reader;
import com.sap.ip.me.api.sync.SyncException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;

public class InboundTokenizer {
    static final String EOF_MESSAGE = "End of file reached";
    private static final String DELIMITERS = "&=";
    private static final String DELIMITER_1 = "=";
    private static final String DELIMITER_2 = "&";
    private static final String FIRST_TOKEN = "WAF_SYNC";
    private BufferedUTF8Reader reader = null;
    private StringTokenizer currentStringTokenizer = null;
    private boolean twoDelimitersFollowingEachOtherFound = false;
    private String next = null;
    private StringBuffer lastTokenPrefix = new StringBuffer(275);

    protected InboundTokenizer(String inboundFilePath) throws SyncException {
        File file = new File(inboundFilePath);
        if (file == null) {
            throw new SyncException(" filenames not set please check the configuration");
        }
        if (file.length() == 0L) {
            throw new SyncException("Received empty inbound container file");
        }
        try {
            this.reader = new BufferedUTF8Reader(file);
        }
        catch (FileNotFoundException e) {
            AppLog.getInstance("MI/Sync").logException(50, "FileNotFoundException while initializing InboundTokenizer: ", e, true);
            throw new SyncException("file not found: " + file.getName());
        }
        try {
            this.setInitialNext(this.reader);
        }
        catch (IOException e) {
            AppLog.getInstance("MI/Sync").logException(50, "Exception while initializing InboundTokenizer: ", e, true);
            throw new SyncException("Exception while initializing InboundTokenizer: " + file.getName());
        }
    }

    protected InboundTokenizer(InputStream inboundStream) throws SyncException {
        this.reader = new BufferedUTF8Reader(inboundStream);
        try {
            this.setInitialNext(this.reader);
        }
        catch (IOException e) {
            AppLog.getInstance("MI/Sync").logException(50, "Exception while initializing InboundTokenizer: ", e, true);
            throw new SyncException("Exception while initializing InboundTokenizer from inbound stream: ");
        }
    }

    protected boolean hasMoreTokens() {
        return this.next != null;
    }

    protected String nextToken() throws SyncException {
        if (this.next == null) {
            throw new SyncException(EOF_MESSAGE);
        }
        try {
            String currentToken = this.next;
            this.setNext(this.reader);
            return currentToken;
        }
        catch (IOException e) {
            throw new SyncException("IO Exception occured while iterating inbound file");
        }
    }

    protected void close() {
        if (this.reader != null) {
            Trace.getInstance("MI/Sync").log(90, "SyncInboundContainer: closing reader for inbound file / stream");
            try {
                this.reader.close();
            }
            catch (IOException e) {
                AppLog.getInstance("MI/Sync").logException(50, (Throwable)e, true);
            }
        }
    }

    private StringTokenizer getStringTokenizerForNextLine(BufferedUTF8Reader reader) throws IOException {
        String line = null;
        StringTokenizer st = null;
        line = reader.readLine();
        if (line != null) {
            st = new StringTokenizer(line, DELIMITERS, true);
        }
        return st;
    }

    private String getNextToken(boolean lastTokenWasDelimiter, StringTokenizer stringTokenizer) {
        String nextToken = null;
        if (stringTokenizer.hasMoreTokens() && this.checkIfDelimiter(nextToken = stringTokenizer.nextToken())) {
            if (lastTokenWasDelimiter) {
                this.twoDelimitersFollowingEachOtherFound = true;
                return " ";
            }
            nextToken = this.getNextToken(true, stringTokenizer);
        }
        if (!this.twoDelimitersFollowingEachOtherFound && !stringTokenizer.hasMoreTokens() && nextToken != null) {
            if (this.lastTokenPrefix.length() == 0) {
                this.lastTokenPrefix.append(nextToken);
            } else {
                this.lastTokenPrefix.append('\n').append(nextToken);
            }
            nextToken = null;
        }
        this.twoDelimitersFollowingEachOtherFound = false;
        return nextToken;
    }

    private void setNext(BufferedUTF8Reader reader) throws IOException {
        this.next = null;
        if (this.currentStringTokenizer == null) {
            this.currentStringTokenizer = this.getStringTokenizerForNextLine(reader);
        }
        this.lastTokenPrefix.setLength(0);
        boolean useprefix = false;
        while (this.currentStringTokenizer != null && this.next == null) {
            this.next = this.getNextToken(false, this.currentStringTokenizer);
            if (this.next == null) {
                useprefix = true;
            }
            if (this.currentStringTokenizer.hasMoreTokens()) continue;
            this.currentStringTokenizer = this.getStringTokenizerForNextLine(reader);
        }
        if (useprefix && this.lastTokenPrefix.length() != 0 && !"HEADERS".equals(this.next) && !"CONTAINERS".equals(this.next)) {
            this.lastTokenPrefix.append('\n').append(this.next);
            this.next = new String(this.lastTokenPrefix.toString());
        }
    }

    private boolean checkIfDelimiter(String str) {
        return DELIMITER_1.equals(str) || DELIMITER_2.equals(str);
    }

    private void setInitialNext(BufferedUTF8Reader reader) throws IOException {
        this.setNext(reader);
        while (!FIRST_TOKEN.equals(this.next) && this.next != null) {
            this.setNext(reader);
        }
    }
}

