/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.sync;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.conf.VisibilityType;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.services.IOUtils;
import com.sap.ip.me.api.sync.InboundProcessor;
import com.sap.ip.me.api.sync.InboundProcessorRegistry;
import com.sap.ip.me.api.user.User;
import com.sap.ip.me.core.ConversationId;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.core.UserManagerImpl;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class InboundProcessorRegistryImpl
extends InboundProcessorRegistry {
    private static final String REGISTRY_FILE_NAME_KEY = "MobileEngine.Sync.InboundProcessorsFileName";
    private static final String CREATED_CONTAINERS_FILE_NAME_KEY = "MobileEngine.Sync.RegisteredMethodsFileName";
    private static final String INBOUND_PROCESSORS_MAPPING_FOLDER = "inboundMapping";
    private File registryFile;
    private File createdContainersFile;
    private File inboundProcessorsMapping;
    private Hashtable inboundProcessors;
    private Hashtable createdContainers;
    private Hashtable inboundProcessors2msds;
    private static InboundProcessorRegistryImpl instance;
    private Trace trace = Trace.getInstance("MI/Sync");

    public InboundProcessorRegistryImpl() {
        if (instance != null) {
            throw new IllegalStateException("InboundProcessorRegistryImpl already exists");
        }
        try {
            StringBuffer syncDirectoryBuffer = new StringBuffer(Configuration.getInstance().getProperty("MobileEngine.InstallationPath"));
            syncDirectoryBuffer.append(File.separator);
            syncDirectoryBuffer.append(Configuration.getInstance().getProperty("MobileEngine.Sync.Directory"));
            syncDirectoryBuffer.append(File.separator);
            String syncDirectory = syncDirectoryBuffer.toString();
            this.registryFile = new File(syncDirectory + Configuration.getInstance().getProperty(REGISTRY_FILE_NAME_KEY));
            this.createdContainersFile = new File(syncDirectory + Configuration.getInstance().getProperty(CREATED_CONTAINERS_FILE_NAME_KEY));
            this.inboundProcessorsMapping = new File(syncDirectory + INBOUND_PROCESSORS_MAPPING_FOLDER);
            this.inboundProcessors = IOUtils.readHashtableFromDirectory(this.registryFile);
            this.createdContainers = IOUtils.readHashtableFromDirectory(this.createdContainersFile);
            this.inboundProcessors2msds = IOUtils.readHashtableFromDirectory(this.inboundProcessorsMapping);
        }
        catch (Exception e) {
            AppLog.getInstance("MI/Sync").logException(60, "Registered methods could not be read from file", e, true);
        }
        if (this.inboundProcessors == null) {
            this.inboundProcessors = new Hashtable(20);
        }
        if (this.createdContainers == null) {
            this.createdContainers = new Hashtable(20);
        }
        if (this.inboundProcessors2msds == null) {
            this.inboundProcessors2msds = new Hashtable(20);
        }
        instance = this;
    }

    public InboundProcessor getInboundProcessor(String methodName) {
        if (this.isRegistered(methodName)) {
            return (InboundProcessor)this.inboundProcessors.get(methodName);
        }
        return null;
    }

    public void resetCreatedOutboundContainers(String userName) {
        Trace.getInstance("MI/Sync").log(90, "resetting the info which outbound containers are already created for user {0}", (Object)userName);
        this.createdContainers.put(userName, new Vector());
        IOUtils.saveHashtableToDirectory(this.createdContainersFile, this.createdContainers);
    }

    public Vector getAlLNotNotifiedMethods(String userName) {
        Vector createdContainersPerUser = (Vector)this.createdContainers.get(userName);
        Enumeration processorEnum = this.inboundProcessors.elements();
        Vector<String> returnValue = new Vector<String>();
        while (processorEnum.hasMoreElements()) {
            InboundProcessor processor = (InboundProcessor)processorEnum.nextElement();
            String method = processor.getMethodName();
            if (method != null) {
                if (createdContainersPerUser != null && createdContainersPerUser.contains(method)) continue;
                returnValue.addElement(method);
                continue;
            }
            AppLog.getInstance("MI/Sync").log(60, "Processor {0} returns null as method name after deserialization", processor.getClass());
        }
        return returnValue;
    }

    public Vector getAlLNotNotifiedConvIds(String userName) {
        Vector createdContainersPerUser = (Vector)this.createdContainers.get(userName);
        ConversationId[] convIds = ConversationIdHandler.getInstance().getAllConversationIdsForUser(UserManagerImpl.getUserManagerImplInstance().getUser(userName));
        Vector<ConversationId> returnValue = new Vector<ConversationId>();
        int i = 0;
        while (i < convIds.length) {
            if (createdContainersPerUser == null || !createdContainersPerUser.contains(convIds[i].getServerCommunicationId())) {
                returnValue.addElement(convIds[i]);
            }
            ++i;
        }
        return returnValue;
    }

    public boolean isAlreadyInOutboundQueue(String methodName, VisibilityType visibility) {
        boolean result;
        User user = null;
        user = VisibilityType.USER_SHARED.equals(visibility) ? UserManagerImpl.getSharedUser() : UserManagerImpl.getUserManagerImplInstance().getCurrentUser();
        Vector createdContainersPerUser = (Vector)this.createdContainers.get(user.getUniqueName());
        boolean bl = result = createdContainersPerUser != null && createdContainersPerUser.contains(methodName);
        if (result) {
            this.trace.log(90, "There is already a container for method {0} and user {1} in the outbound queue", (Object)methodName, (Object)user.getUniqueID());
        } else {
            this.trace.log(90, "Successfully added container for method {0} and user {1} to the outbound queue", (Object)methodName, (Object)user.getUniqueID());
        }
        return result;
    }

    public boolean isNewDataAvailable(VisibilityType visibility) {
        User user = null;
        boolean isAvailable = true;
        if (VisibilityType.USER_SHARED.equals(visibility)) {
            isAvailable = this.isNewDataForUser(user);
        } else {
            user = UserManagerImpl.getSharedUser();
            isAvailable = this.isNewDataForUser(user);
            if (!isAvailable) {
                user = UserManagerImpl.getUserManagerImplInstance().getCurrentUser();
                isAvailable = this.isNewDataForUser(user);
            }
        }
        return isAvailable;
    }

    private boolean isNewDataForUser(User user) {
        if (user == null) {
            ConversationId[] convIds = ConversationIdHandler.getInstance().getAllConversationIds();
            int i = 0;
            while (i < convIds.length) {
                if (this.isNewDataForID(convIds[i])) {
                    this.trace.log(90, "GenericSync data from a user found");
                    return true;
                }
                ++i;
            }
        } else {
            ConversationId[] convIds = ConversationIdHandler.getInstance().getAllConversationIdsForUser(user);
            int i = 0;
            while (i < convIds.length) {
                if (this.isNewDataForID(convIds[i])) {
                    this.trace.log(90, "GenericSync data found from user ", (Object)user.getUniqueName());
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean isNewDataForID(ConversationId convId) {
        if (!convId.getMsd().isItASmartSyncApplication() && !convId.isFrameworkConversationId()) {
            String userName = convId.getUser().getUniqueName();
            Vector methodsPerUser = (Vector)this.createdContainers.get(userName);
            if (methodsPerUser == null) {
                return false;
            }
            return methodsPerUser.contains(convId.getServerCommunicationId());
        }
        return false;
    }

    public void register(InboundProcessor processor) {
        if (processor.getMethodName() != null) {
            this.inboundProcessors.put(processor.getMethodName(), processor);
            IOUtils.saveHashtableToDirectory(this.registryFile, this.inboundProcessors);
        } else {
            AppLog.getInstance("MI/Sync").log(50, "InboundProcessor {0} with method = null can not be registered", processor.getClass());
        }
    }

    public boolean isRegistered(String methodName) {
        if (methodName != null) {
            return this.inboundProcessors.containsKey(methodName);
        }
        return false;
    }

    protected void outboundContainerCreated(String userName, String methodName) {
        this.trace.log(80, "Created outbound container for user {0} and method {1}", (Object)userName, (Object)methodName);
        Vector<String> methodsPerUser = (Vector<String>)this.createdContainers.get(userName);
        if (methodsPerUser == null) {
            methodsPerUser = new Vector<String>();
            methodsPerUser.addElement(methodName);
            this.createdContainers.put(userName, methodsPerUser);
            IOUtils.saveHashtableToDirectory(this.createdContainersFile, this.createdContainers);
        } else if (!methodsPerUser.contains(methodName)) {
            methodsPerUser.addElement(methodName);
            this.createdContainers.put(userName, methodsPerUser);
            IOUtils.saveHashtableToDirectory(this.createdContainersFile, this.createdContainers);
        }
    }

    protected void outboundContainerCreated(ConversationId convId) {
        this.trace.log(80, "Created outbound container for conversationId {0}", (Object)convId);
        String userName = convId.getUser().getUniqueName();
        Vector<String> methodsPerUser = (Vector<String>)this.createdContainers.get(userName);
        if (methodsPerUser == null) {
            methodsPerUser = new Vector<String>();
            methodsPerUser.addElement(convId.getServerCommunicationId());
            this.createdContainers.put(userName, methodsPerUser);
            IOUtils.saveHashtableToDirectory(this.createdContainersFile, this.createdContainers);
        } else if (!methodsPerUser.contains(convId.getServerCommunicationId())) {
            methodsPerUser.addElement(convId.getServerCommunicationId());
            this.createdContainers.put(userName, methodsPerUser);
            IOUtils.saveHashtableToDirectory(this.createdContainersFile, this.createdContainers);
        }
    }

    protected void clearRegistry() {
        this.inboundProcessors.clear();
        if (this.registryFile != null) {
            this.registryFile.delete();
        }
    }

    void clear() {
        this.clearRegistry();
        this.createdContainers.clear();
        if (this.createdContainersFile.exists()) {
            this.createdContainersFile.delete();
        }
    }

    public static InboundProcessorRegistryImpl getInboundProcessorRegistryImplInstance() {
        return (InboundProcessorRegistryImpl)InboundProcessorRegistry.getInstance();
    }
}

