/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.sync;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.services.HttpConnectionException;
import com.sap.ip.me.api.services.IOUtils;
import com.sap.ip.me.api.sync.SyncException;
import com.sap.ip.me.api.sync.SyncManager;
import com.sap.ip.me.core.UserManagerImpl;
import com.sap.ip.me.sync.SyncManagerImpl;
import com.sap.ip.me.sync.Synchronizer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public abstract class HTTPSynchronizer
implements Synchronizer {
    private static final Trace trace = Trace.getInstance("MI/Sync");
    private static String currentSessionId;

    public void exchangeData(String selectedUser, String outboundFileName, String inboundFileName, boolean compressed) throws SyncException {
        Object perfLogTag = this.performanceLogStart(this);
        this.setPerformanceMonitorEntry("Start sending to backend via http");
        try {
            try {
                this.updateProxySettings();
                this.synchronize(this.getUrlString(), outboundFileName, inboundFileName, compressed);
                this.setPerformanceMonitorEntry("Finished sending to backend via http");
            }
            catch (HttpConnectionException e) {
                Trace.getInstance("MI/Sync").logException(50, "Exception while synchronizing via http", e, true);
                throw new SyncException("Transport-layer (http) sync exception raised (root cause: " + e.getMessage() + ")");
            }
            Object var8_6 = null;
            this.performanceLogFinished(perfLogTag);
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.performanceLogFinished(perfLogTag);
            throw throwable;
        }
    }

    protected abstract String getCurrentUserName();

    protected abstract String getCurrentUserPassword();

    protected abstract void setPerformanceMonitorEntry(String var1);

    protected abstract Object performanceLogStart(Object var1);

    protected abstract void performanceLogFinished(Object var1);

    protected abstract String getUrlString();

    protected abstract void updateProxySettings();

    static void setCurrentSessionId(String newSessionId) {
        if (newSessionId != null && newSessionId.trim().length() == 0) {
            newSessionId = null;
        }
        currentSessionId = newSessionId;
    }

    static String getCurrentSessionId() {
        return currentSessionId;
    }

    void synchronize(String urlString, String outboundFileName, String inboundFileName, boolean isCompressed) throws HttpConnectionException {
        FileOutputStream out;
        FileInputStream in;
        File outboundFile = new File(outboundFileName);
        long len = outboundFile.length();
        try {
            in = new FileInputStream(outboundFile);
        }
        catch (Exception e) {
            if (trace.isLogging(1000)) {
                trace.logException(1000, "HttpSynchronizer caught exception {0}: {1}", new Object[]{e.getClass().getName(), e.getMessage()}, e, true);
            }
            throw new HttpConnectionException("Exception while synchronizing (" + e.getClass().getName() + ": " + e.getMessage() + ")");
        }
        try {
            out = new FileOutputStream(inboundFileName);
        }
        catch (Exception e) {
            if (trace.isLogging(1000)) {
                trace.logException(1000, "HttpSynchronizer caught exception {0}: {1}", new Object[]{e.getClass().getName(), e.getMessage()}, e, true);
            }
            throw new HttpConnectionException("Exception while synchronizing (" + e.getClass().getName() + ": " + e.getMessage() + ")");
        }
        this.synchronize(urlString, in, len, out, isCompressed, true);
    }

    protected void synchronize(String urlString, InputStream outboundFileStream, long outboundlength, OutputStream inboundFileStream, boolean isCompressed, boolean closeInboundFileStream) throws HttpConnectionException {
        try {
            URL gatewayURL = new URL(urlString);
            IOUtils.isConnectable(gatewayURL);
            URLConnection connection = gatewayURL.openConnection();
            connection.setRequestProperty("content-type", "application/binary;charset=UTF-8");
            connection.setRequestProperty("content-length", Long.toString(outboundlength, 10));
            String userName = IOUtils.utf8AndUrlEncode(this.getCurrentUserName());
            connection.setRequestProperty("com.sap.ip.mi.user", userName);
            String syncPassword = this.getCurrentUserPassword();
            if (syncPassword != null && syncPassword.length() > 0) {
                syncPassword = IOUtils.utf8AndUrlEncode(syncPassword);
                connection.setRequestProperty("com.sap.ip.mi.syncpassword", syncPassword);
            } else if (Configuration.getInstance().getBoolean("MobileEngine.UM.SAPLogonTicketSupport", false)) {
                String ticket = UserManagerImpl.getUserManagerImplInstance().getCurrentUserImpl().getSSOTicket();
                if (ticket != null && ticket.length() > 0) {
                    connection.setRequestProperty("com.sap.ip.mi.ssoticket", ticket);
                } else {
                    throw new HttpConnectionException("SAP Logon ticket is missed.");
                }
            }
            connection.setRequestProperty("com.sap.ip.mi.exceptioninfo", "true");
            connection.setRequestProperty("com.sap.ip.mi.misync.synccount", String.valueOf(this.getSyncCount()));
            if (((SyncManagerImpl)SyncManager.getInstance()).isSyncCycleSuppressDownload()) {
                connection.setRequestProperty("suppressDownload", "true");
            }
            this.addAdditionalHeaderAttributes(connection);
            String syncCycleSessionID = HTTPSynchronizer.getCurrentSessionId();
            if (syncCycleSessionID != null) {
                connection.setRequestProperty("Cookie", syncCycleSessionID);
            }
            long timeout = Configuration.getInstance().getLong("MobileEngine.Sync.WaitForResultsTimeout", -1L);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            if (isCompressed) {
                trace.log(70, "GzipDataCompression: Gzip data compression is switched on");
                connection.setRequestProperty("Accept-Encoding", "compress, gzip");
                GZIPOutputStream gzipOutputStream = new GZIPOutputStream(connection.getOutputStream());
                trace.log(80, "Sending outbound file compressed to server.");
                IOUtils.copyStreams(outboundFileStream, gzipOutputStream);
                trace.log(80, "Outbound file was compressedly sent.");
                GZIPInputStream gzipInputStream = null;
                if (timeout != -1L) {
                    InputStream inputStream = this.getInputStreamFromURLConnection(connection, timeout);
                    gzipInputStream = new GZIPInputStream(inputStream);
                } else {
                    gzipInputStream = new GZIPInputStream(connection.getInputStream());
                }
                trace.log(80, "Receiving inbound file compressed from server.");
                IOUtils.copyStreams(gzipInputStream, inboundFileStream);
                trace.log(80, "Inbound file was compressedly received.");
            } else {
                trace.log(70, "GzipDataCompression: Gzip data compression is switched off");
                trace.log(80, "Sending outbound file to server.");
                IOUtils.copyStreams(outboundFileStream, connection.getOutputStream());
                trace.log(80, "Outbound file was sent.");
                InputStream inputStream = null;
                inputStream = timeout != -1L ? this.getInputStreamFromURLConnection(connection, timeout) : connection.getInputStream();
                trace.log(80, "Receiving inbound file from server.");
                IOUtils.copyStreams(inputStream, inboundFileStream, true, closeInboundFileStream);
                trace.log(80, "Inbound file was received.");
            }
            String sessionIDCookie = null;
            int j = 1;
            while (connection.getHeaderFieldKey(j) != null) {
                String key = connection.getHeaderFieldKey(j);
                String value = connection.getHeaderField(j);
                if (key != null && "Set-cookie".equalsIgnoreCase(key) && value.toLowerCase().startsWith("jsessionid")) {
                    sessionIDCookie = value.substring(0, value.indexOf(";"));
                }
                ++j;
            }
            HTTPSynchronizer.setCurrentSessionId(sessionIDCookie);
        }
        catch (HttpConnectionException connex) {
            throw connex;
        }
        catch (Exception e) {
            if (trace.isLogging(1000)) {
                trace.logException(1000, "HttpSynchronizer caught exception {0}: {1}", new Object[]{e.getClass().getName(), e.getMessage()}, e, true);
            }
            throw new HttpConnectionException("Exception while synchronizing (" + e.getClass().getName() + ": " + e.getMessage() + ")");
        }
    }

    protected void addAdditionalHeaderAttributes(URLConnection connection) {
    }

    private InputStream getInputStreamFromURLConnection(URLConnection connection, long timeout) throws IOException {
        URLInputStreamFetcher fetcher = new URLInputStreamFetcher(connection);
        long sleepingtime = timeout / 50L;
        trace.log(90, "Sleeping interval to wait for Mobile Infrastructure Server to respond is" + sleepingtime / 1000L + " seconds");
        fetcher.start();
        for (int tries = 0; tries < 50; ++tries) {
            try {
                if (fetcher.isFinished) break;
                Thread.sleep(sleepingtime);
                continue;
            }
            catch (InterruptedException e) {
                AppLog.getInstance("MI/Sync").logException(e);
                break;
            }
        }
        return fetcher.getInputStream();
    }

    public abstract int getSyncCount();

    private class URLInputStreamFetcher
    extends Thread {
        private InputStream inputStream = null;
        private URLConnection connection = null;
        private boolean isFinished = false;

        private URLInputStreamFetcher(URLConnection connection) {
            this.connection = connection;
        }

        public void run() {
            while (!this.isFinished) {
                try {
                    this.inputStream = this.connection.getInputStream();
                    this.isFinished = true;
                }
                catch (IOException e) {
                    AppLog.getInstance("MI/Sync").logException(e);
                    this.isFinished = true;
                }
            }
        }

        private InputStream getInputStream() throws IOException {
            if (this.inputStream == null) {
                throw new IOException("No InputStream available from: " + this.connection.getURL().toExternalForm());
            }
            return this.inputStream;
        }
    }
}

