/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.sync;

import com.sap.ip.me.api.logging.Trace;
import java.util.Random;

class GuidFactory {
    private static long lastTime = System.currentTimeMillis();
    private static Random random = new Random();
    private static StringBuffer buffer = new StringBuffer();
    private static final Trace trace = Trace.getInstance("MI/Sync");

    GuidFactory() {
    }

    static synchronized String getGUID() {
        return GuidFactory.getHexRepresentation(GuidFactory.getSystemTime(), 12) + GuidFactory.getHexRepresentation(random.nextLong(), 8);
    }

    private static long getSystemTime() {
        long time = System.currentTimeMillis();
        if (time <= lastTime) {
            trace.log(90, "GUID generation last time ({0}) was >= than current time ({1}) --> use this time instead {2}", Long.toString(lastTime), Long.toString(time), Long.toString(lastTime + 1L));
            time = lastTime + 1L;
        }
        lastTime = time;
        return lastTime;
    }

    private static String getHexRepresentation(long value, int length) {
        String str = Long.toHexString(value);
        int len = length - str.length();
        if (len < 0) {
            return str.substring(0, length);
        }
        buffer.setLength(0);
        int i = 0;
        while (i < len) {
            buffer.append('0');
            ++i;
        }
        return buffer.append(str).toString();
    }
}

