/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.sync;

import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.sync.SyncException;
import com.sap.ip.me.api.sync.SyncManager;
import com.sap.ip.me.api.user.User;
import com.sap.ip.me.core.UserManagerImpl;
import com.sap.ip.me.sync.DiscSyncController;
import com.sap.ip.me.sync.SyncManagerImpl;
import com.sap.ip.me.sync.Synchronizer;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class DiscSynchronizer
implements Synchronizer {
    private DiscSyncController controller;

    public DiscSynchronizer(DiscSyncController controller) {
        this.controller = controller;
    }

    public int getSyncCount() {
        return ((SyncManagerImpl)SyncManager.getInstance()).getNextSyncCountOut();
    }

    public void exchangeData(String username, String outboundFileName, String inboundFileName, boolean compressed) throws SyncException {
        User user = UserManagerImpl.getUserManagerImplInstance().getUser(username);
        try {
            this.controller.addSyncPackageToOutbound(user.getUniqueID(), new FileInputStream(outboundFileName), this.getSyncCount());
            this.controller.getNextSyncPackageFromInbound(user.getUniqueID(), new FileOutputStream(inboundFileName));
        }
        catch (Exception e) {
            AppLog.getInstance("MI/Sync").logException(50, (Throwable)e, true);
            throw new SyncException("Transport-layer sync exception raised");
        }
    }
}

