/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.sync;

import java.util.Hashtable;

public final class DiscSyncProcessInfo {
    String prefix;
    String deviceID;
    String synccount;
    int expectedNumberOfFiles;
    boolean encrypted;
    boolean signed;
    boolean initial = true;
    final Hashtable uploadedFilenumbers = new Hashtable();

    DiscSyncProcessInfo() {
        this.clear();
    }

    void clear() {
        this.prefix = "";
        this.deviceID = "";
        this.synccount = "";
        this.expectedNumberOfFiles = -1;
        this.encrypted = false;
        this.signed = false;
        this.initial = true;
        this.uploadedFilenumbers.clear();
    }

    boolean isInitial() {
        return this.initial;
    }

    String getDeviceID() {
        return this.deviceID;
    }

    void setDeviceID(String deviceID) {
        this.deviceID = deviceID;
        this.initial = false;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    void setEncrypted(boolean encrypted) {
        this.encrypted = encrypted;
        this.initial = false;
    }

    public int getExpectedNumberOfFiles() {
        return this.expectedNumberOfFiles;
    }

    void setExpectedNumberOfFiles(int expectedNumberOfFiles) {
        this.expectedNumberOfFiles = expectedNumberOfFiles;
        this.initial = false;
    }

    String getPrefix() {
        return this.prefix;
    }

    void setPrefix(String prefix) {
        if (prefix == null || prefix.length() == 0) {
            this.clear();
        } else {
            this.prefix = prefix;
            this.initial = false;
        }
    }

    public boolean isSigned() {
        return this.signed;
    }

    void setSigned(boolean signed) {
        this.signed = signed;
        this.initial = false;
    }

    String getSynccount() {
        return this.synccount;
    }

    void setSynccount(String synccount) {
        this.synccount = synccount;
        this.initial = false;
    }

    void addFileNumber(int number) {
        Integer i = new Integer(number);
        this.uploadedFilenumbers.put(i, i);
    }

    int getNextMissingFileNumber() {
        int result = 1;
        Integer i = new Integer(result);
        int maxcount = this.uploadedFilenumbers.size() + 1;
        int j = 0;
        while (j < maxcount) {
            i = new Integer(result);
            if (!this.uploadedFilenumbers.containsKey(i)) break;
            ++result;
            ++j;
        }
        return result;
    }

    void removeFileNumber(int number) {
        this.uploadedFilenumbers.remove(new Integer(number));
        if (this.uploadedFilenumbers.size() == 0) {
            this.clear();
        }
    }

    void setInitial() {
        this.initial = true;
    }
}

