/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.sync;

import com.sap.ip.me.api.logging.Trace;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class DiscSyncException
extends IOException {
    public static final int ERROR_NO_FILE_SPECIFIED = 0;
    public static final int ERROR_FILE_DOES_NOT_EXIST_1 = 1;
    public static final int ERROR_FILE_CANNOT_BE_READ_1 = 2;
    public static final int ERROR_UPLOADING_INBOUND_1 = 3;
    public static final int ERROR_FILENAME_DOES_NOT_MATCH_1 = 4;
    public static final int ERROR_TARGET_ALREADY_EXISTS_1 = 5;
    public static final int ERROR_PREFIX_DOES_NOT_MATCH_1 = 6;
    public static final int ERROR_NO_TARGET_FOLDER_SPECIFIED = 7;
    public static final int ERROR_TARGET_IS_NOT_A_FOLDER = 8;
    public static final int ERROR_CANNOT_WRITE_ON_TARGET = 9;
    public static final int ERROR_WHILE_COPYING_TO_TARGET_2 = 10;
    public static final int ERROR_MISSING_INBOUND_FILE_1 = 11;
    public static final int ERROR_INBOUND_CORRUPT_1 = 12;
    public static final int ERROR_OUTBOUND_CORRUPT = 13;
    public static final int ERROR_SIZE_ADJUSTED_1 = 14;
    public static final int ERROR_PARSING_SIZE_1 = 15;
    public static final int ERROR_WHILE_SYNC_1 = 16;
    public static final int ERROR_WHILE_SYNC = 17;
    public static final int ERROR_ENCRYPTION_NOT_CONFIGURED = 18;
    public static final int ERROR_SIGNING_NOT_CONFIGURED = 19;
    static final int MAX_ERROR_CODE = 19;
    private static final String[] ERROR_MESSAGES = new String[]{"no_file_specified", "No file specified; select synchronization file", "file_does_not_exist", "File {0} does not exist; select synchronization file", "file_cannot_be_read", "File {0} cannot be read", "error_uploading_inbound", "Error while uploading synchronization file {0}", "filename_does_not_match", "File {0} is no synchronization file", "error_target_exists", "File {0} already uploaded", "error_not_matched", "File {0} is part of another synchronization process", "error_no_targetfolder", "Select target folder", "error_target_not_folder", "Select a folder as target location", "error_cannot_write", "Cannot write on target; select another target location", "error_while_copying", "Error while copying file {0} to target {1}", "error_missing_files", "Upload file {0}", "error_sync_file_corrupt", "Synchronization file {0} is corrupt", "error_generating_outbound", "Synchronization file could not be generated because of IO errors", "error_size_adjusted", "User defined size was increased to minimum size {0}", "error_parsing_size", "{0} is no valid target size; select valid target size", "error_while_sync", "Synchronization aborted because of following reason: {0}", "error_while_sync_no_msg", "Synchronization aborted because of errors in synchronization layer; contact your system administrator", "error_no_encrypt_config", "Encryption plugin is not configured; add encryption plugin", "error_no_signing_config", "Signing plugin is not configured; add signing plugin"};
    private static String RESOURCEBUNDLE_NAME = "com.sap.ip.me.sync.mi_sync";
    private int errorCode;
    private Object[] params;

    DiscSyncException(int errorCode) {
        super(DiscSyncException.getDefaultExceptionMessage(errorCode, null));
        this.errorCode = errorCode;
        this.params = null;
    }

    DiscSyncException(int errorCode, Object param1) {
        super(DiscSyncException.getDefaultExceptionMessage(errorCode, new Object[]{param1}));
        this.errorCode = errorCode;
        this.params = new Object[]{param1};
    }

    DiscSyncException(int errorCode, Object param1, Object param2) {
        super(DiscSyncException.getDefaultExceptionMessage(errorCode, new Object[]{param1, param2}));
        this.errorCode = errorCode;
        this.params = new Object[]{param1, param2};
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getLocalizedMessage() {
        return this.getLocalizedExceptionMessage(this.errorCode, this.params);
    }

    public String toString() {
        return "DiscSnycException: " + this.getMessage();
    }

    static void setResourceBundleName(String newResourceBundleName) {
        RESOURCEBUNDLE_NAME = newResourceBundleName;
    }

    private static String getDefaultExceptionMessage(int error, Object[] objects) {
        if (error < 0 || error > 19) {
            throw new IllegalArgumentException("Cannot create DiscSnycException with error code " + error);
        }
        String msg = ERROR_MESSAGES[2 * error + 1];
        if (objects != null) {
            msg = MessageFormat.format(msg, objects);
        }
        return msg;
    }

    private String getLocalizedExceptionMessage(int error, Object[] objects) {
        String msg = this.getLocalizedNameFor(ERROR_MESSAGES[2 * error], ERROR_MESSAGES[2 * error + 1]);
        if (msg == null) {
            msg = ERROR_MESSAGES[2 * error + 1];
        }
        if (objects != null) {
            msg = MessageFormat.format(msg, objects);
        }
        return msg;
    }

    private String getLocalizedNameFor(String key, String defaultValue) {
        Trace trace = Trace.getInstance("MI/Sync");
        String localizedname = null;
        ResourceBundle resources = null;
        try {
            resources = ResourceBundle.getBundle(RESOURCEBUNDLE_NAME);
        }
        catch (Exception ex) {
            trace.log(60, "Cannot open resource bundle for disc sync: " + ex.getLocalizedMessage());
        }
        if (resources != null) {
            try {
                localizedname = resources.getString(key);
            }
            catch (Exception ex) {
                trace.log(60, "cannot resolve resource key " + key);
                localizedname = null;
            }
        }
        if (localizedname == null || localizedname.length() == 0) {
            localizedname = defaultValue;
        }
        return localizedname;
    }
}

