/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.sync;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.conf.VisibilityType;
import com.sap.ip.me.api.sync.SyncLog;
import com.sap.ip.me.api.sync.SyncManager;
import com.sap.ip.me.security.StreamFactory;
import com.sap.ip.me.sync.AbstractDiscSyncController;
import com.sap.ip.me.sync.SyncManagerImpl;

public class DiscSyncController
extends AbstractDiscSyncController {
    String[] messages;
    private boolean isonserver = false;
    private static final String[] CONFIGKEYS_FOR_PACKAGESIZES = new String[]{"MobileEngine.Packaging.VerySmall", "MobileEngine.Packaging.Small", "MobileEngine.Packaging.Normal", "MobileEngine.Packaging.Large"};

    protected int startSynchronization() {
        ((SyncManagerImpl)SyncManager.getInstance()).synchronizeWithBackend(VisibilityType.USER_SHARED, this, false);
        if (SyncLog.getInstance().isReady()) {
            return 1;
        }
        this.messages = SyncLog.getInstance().getFailureMessages();
        return 2;
    }

    public String[] getSyncMessages() {
        return this.messages;
    }

    protected boolean isOnServer() {
        return this.isonserver;
    }

    protected String getInstallationDirectory() {
        return Configuration.getInstallationDirectory();
    }

    protected String getClient() {
        return Configuration.getInstance().getProperty("MobileEngine.Sync.Client", "");
    }

    protected String getCompressionEnabledValue() {
        return Configuration.getInstance().getProperty("MobileEngine.Datacompression.Gzip", "false");
    }

    protected String getDeviceId() {
        return Configuration.getInstance().getProperty("MobileEngine.Sync.Deviceid", "");
    }

    protected String getLanguage() {
        return Configuration.getInstance().getProperty("MobileEngine.Sync.Language", "");
    }

    protected String getPackageSize() {
        Configuration config = Configuration.getInstance();
        if (config.getBoolean("MobileEngine.Packaging.Activated", false)) {
            int maxPackageSizeIndex = config.getInt("MobileEngine.Packaging.MaxPackageSize", 2);
            if (maxPackageSizeIndex < 0 || maxPackageSizeIndex > 3) {
                maxPackageSizeIndex = 2;
            }
            return config.getProperty(CONFIGKEYS_FOR_PACKAGESIZES[maxPackageSizeIndex], "0");
        }
        return "";
    }

    protected String getSystemId() {
        return Configuration.getInstance().getProperty("MobileEngine.Sync.Gateway.System");
    }

    void _setIsOnServer(boolean server) {
        this.isonserver = server;
    }

    protected boolean isEncryptionUsed() {
        return StreamFactory.isEncryptionSupported();
    }

    protected boolean isSigningUsed() {
        return StreamFactory.isSigningSupported();
    }
}

