/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.sync;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.sync.DiscSyncException;
import com.sap.ip.me.sync.DiscSyncProcessInfo;
import com.sap.ip.me.sync.MediaType;
import java.io.File;
import java.io.FilenameFilter;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class DiscSyncConfiguration {
    private final String DEVICEID = Configuration.getInstance().getProperty("MobileEngine.Sync.Deviceid", "");
    public static final String DISC_SYNC_FILEEXTENSION = ".mis";
    private final long MINIMUM_SIZE = Math.max(Configuration.getInstance().getLong("MobileEngine.Sync.ViaFile.MinimumTargetSize", 1024L), 256L);
    private static final String[] UNITS = new String[]{"B", "KB", "MB", "GB"};
    private static final long[] UNIT_SIZES = new long[]{1L, 1024L, 0x100000L, 0x40000000L};
    private MediaTypeImpl[] mediaTypes;
    private DiscSyncProcessInfo processInfo;
    private int currentMediaTypeIndex = 0;
    private Hashtable defaultSizes = new Hashtable();
    private ResourceBundle resources = null;
    private String tempInboundFolder;
    private String tempOutboundFolder;
    private String sourceLocation;
    private String targetLocation;

    protected DiscSyncConfiguration(String resourceBundleName) {
        this.initialize(resourceBundleName);
    }

    public static boolean isDiscSyncEnabled() {
        return Configuration.getInstance().getBoolean("MobileEngine.Sync.ViaFile.Enabled", false);
    }

    public MediaType[] getMediaTypes() {
        return this.mediaTypes;
    }

    public String[] getUnits() {
        return UNITS;
    }

    public MediaType getCurrentMediaType() {
        return this.mediaTypes[this.currentMediaTypeIndex];
    }

    public int getCurrentMediaTypeIndex() {
        return this.currentMediaTypeIndex;
    }

    public void setCurrentMediaSize(String value, int unit) throws DiscSyncException {
        if (value == null || value.trim().length() == 0) {
            this.setCurrentMediaSize(this.MINIMUM_SIZE);
            throw new DiscSyncException(14, Long.toString(this.MINIMUM_SIZE));
        }
        if (unit < 0 || unit >= UNITS.length) {
            throw new IllegalArgumentException("Unit index (" + unit + ") out of range; valid value is between 0 and " + UNITS.length);
        }
        try {
            Number number = NumberFormat.getInstance().parse(value.trim());
            long valueToBeSet = -1L;
            valueToBeSet = unit == 0 ? number.longValue() : (long)(number.doubleValue() * (double)UNIT_SIZES[unit]);
            this.setCurrentMediaSize(valueToBeSet);
            if (valueToBeSet < this.MINIMUM_SIZE) {
                throw new DiscSyncException(14, Long.toString(this.MINIMUM_SIZE));
            }
        }
        catch (ParseException ex) {
            Trace.getInstance("MI/Sync").logException(60, "Cannot parse value " + value, ex, true);
            throw new DiscSyncException(15, value);
        }
    }

    public void setCurrentMediaSize(long size) {
        if (size < this.MINIMUM_SIZE) {
            size = this.MINIMUM_SIZE;
        }
        int i = 0;
        while (i < this.mediaTypes.length) {
            if (this.mediaTypes[i].getSize() == size) {
                this.currentMediaTypeIndex = i;
            }
            ++i;
        }
        if (this.mediaTypes[this.currentMediaTypeIndex].getSize() != size) {
            this.currentMediaTypeIndex = this.mediaTypes.length - 1;
            this.mediaTypes[this.currentMediaTypeIndex].setSize(size);
            this.setProperty("MobileEngine.Sync.ViaFile.UserdefinedSize", Long.toString(size));
        }
        this.setProperty("MobileEngine.Sync.ViaFile.TargetSize", Long.toString(size));
    }

    public String getSourceLocation() {
        return this.sourceLocation;
    }

    public void setSourceLocation(String source) {
        if (source == null) {
            throw new IllegalArgumentException("Cannot set null as source location");
        }
        if (source.length() > 0) {
            source = new File(source).getAbsolutePath();
        }
        if (source.equals(this.sourceLocation)) {
            return;
        }
        this.sourceLocation = source;
        this.setProperty("MobileEngine.Sync.ViaFile.SourceLocation", source);
    }

    public String getTargetLocation() {
        return this.targetLocation;
    }

    public void setTargetLocation(String target) {
        if (target == null) {
            throw new IllegalArgumentException("Cannot set null as target location");
        }
        if (target.length() > 0) {
            target = new File(target).getAbsolutePath();
        }
        if (target.equals(this.targetLocation)) {
            return;
        }
        this.targetLocation = target;
        this.setProperty("MobileEngine.Sync.ViaFile.TargetLocation", target);
    }

    public String[] getUploadedFiles() {
        File f = new File(this.getDiscSyncTempInboundFolder());
        String[] files = f.list(new DiscSyncFileFilter(this.processInfo.getPrefix()));
        if (files == null) {
            return new String[0];
        }
        String[] result = new String[files.length];
        int i = 0;
        while (i < files.length) {
            int lastSeparator = files[i].lastIndexOf(File.separatorChar);
            result[i] = lastSeparator == -1 ? files[i] : files[i].substring(lastSeparator + 1);
            ++i;
        }
        return result;
    }

    public String[] getDownloadableFiles() {
        File f = new File(this.getDiscSyncTempOutboundFolder());
        String[] files = f.list(new DiscSyncFileFilter(null));
        if (files == null) {
            return new String[0];
        }
        String[] result = new String[files.length];
        int i = 0;
        while (i < files.length) {
            int lastSeparator = files[i].lastIndexOf(File.separatorChar);
            result[i] = lastSeparator == -1 ? files[i] : files[i].substring(lastSeparator + 1);
            ++i;
        }
        return result;
    }

    public String getDiscSyncFileExtension() {
        return DISC_SYNC_FILEEXTENSION;
    }

    public FilenameFilter getSyncFilenameFilter() {
        return new DiscSyncFileFilter(this.processInfo.getPrefix());
    }

    public DiscSyncProcessInfo getProcessInfo() {
        return this.processInfo;
    }

    protected void initialize(String resourceBundleName) {
        File f;
        long lastUserDefinedSize;
        Configuration config = Configuration.getInstance();
        Trace trace = Trace.getInstance("MI/Sync");
        try {
            this.resources = ResourceBundle.getBundle(resourceBundleName);
        }
        catch (Exception ex) {
            trace.log(60, "Cannot open resource bundle for disc sync: " + ex.getLocalizedMessage());
        }
        String types = config.getProperty("MobileEngine.Sync.ViaFile.DefaultTargetSizes", "");
        StringTokenizer tokenizer = new StringTokenizer(types, ";");
        Vector<MediaTypeImpl> medias = new Vector<MediaTypeImpl>(8);
        int colonposition = -1;
        String localizedname = null;
        while (tokenizer.hasMoreTokens()) {
            String name;
            String size;
            String nexttoken = tokenizer.nextToken();
            colonposition = nexttoken.indexOf(58);
            if (colonposition != -1) {
                size = nexttoken.substring(0, colonposition).trim();
                name = nexttoken.substring(colonposition + 1).trim();
                if (name.length() == 0) {
                    name = "?";
                }
                localizedname = null;
            } else {
                size = nexttoken.trim();
                name = "?";
                localizedname = null;
            }
            if (size.length() == 0) continue;
            try {
                long sizeInBytes = Long.parseLong(size);
                if (sizeInBytes < this.MINIMUM_SIZE) {
                    trace.log(60, "Media size has to be at least {0}. Configuration contains one a entry with size {1}. Media size updated to {0} Bytes", (Object)size, (Object)Long.toString(this.MINIMUM_SIZE));
                    sizeInBytes = this.MINIMUM_SIZE;
                }
                if (this.resources != null) {
                    try {
                        localizedname = this.resources.getString(name);
                    }
                    catch (Exception missing) {
                        trace.log(60, "cannot resolve resource key " + name);
                        localizedname = null;
                    }
                }
                if (localizedname == null || localizedname.length() == 0) {
                    localizedname = name.replace('_', ' ');
                }
                medias.addElement(new MediaTypeImpl(name, localizedname, sizeInBytes, false));
                this.defaultSizes.put(size, size);
            }
            catch (NumberFormatException nfex) {
                trace.log(60, "Cannot parse {0} as media size", (Object)size);
            }
        }
        long lastUsedSize = config.getLong("MobileEngine.Sync.ViaFile.TargetSize", 0L);
        boolean defaultsize = this.defaultSizes.containsKey(Long.toString(lastUsedSize));
        if (!defaultsize) {
            this.setProperty("MobileEngine.Sync.ViaFile.UserdefinedSize", Long.toString(lastUsedSize));
            lastUserDefinedSize = lastUsedSize;
        } else {
            lastUserDefinedSize = config.getLong("MobileEngine.Sync.ViaFile.UserdefinedSize", 0L);
        }
        localizedname = this.getLocalizedNameFor("user_defined", "User defined");
        medias.addElement(new MediaTypeImpl("user_defined", localizedname, lastUserDefinedSize, true));
        this.mediaTypes = new MediaTypeImpl[medias.size()];
        int i = 0;
        while (i < medias.size()) {
            this.mediaTypes[i] = (MediaTypeImpl)medias.elementAt(i);
            if (this.mediaTypes[i].getSize() == lastUsedSize) {
                this.currentMediaTypeIndex = i;
            }
            ++i;
        }
        String miFolder = Configuration.getInstallationDirectory();
        this.tempInboundFolder = config.getProperty("MobileEngine.Sync.ViaFile.TempInboundFolder", "");
        if (this.tempInboundFolder.length() == 0) {
            this.tempInboundFolder = miFolder + File.separator + "sync" + File.separatorChar + "_disc" + File.separatorChar + "in";
        }
        if (!(f = new File(this.tempInboundFolder)).exists()) {
            f.mkdirs();
        }
        this.tempInboundFolder = f.getAbsolutePath();
        this.tempOutboundFolder = config.getProperty("MobileEngine.Sync.ViaFile.TempOutboundFolder", "");
        if (this.tempOutboundFolder.length() == 0) {
            this.tempOutboundFolder = miFolder + File.separator + "sync" + File.separatorChar + "_disc" + File.separatorChar + "out";
        }
        if (!(f = new File(this.tempOutboundFolder)).exists()) {
            f.mkdirs();
        }
        this.tempOutboundFolder = f.getAbsolutePath();
        String defaultMIFolder = Configuration.getInstallationDirectory() + File.separator + "discSync" + File.separator;
        this.sourceLocation = config.getProperty("MobileEngine.Sync.ViaFile.SourceLocation", defaultMIFolder + "in");
        if (this.sourceLocation.length() > 0) {
            this.sourceLocation = new File(this.sourceLocation).getAbsolutePath();
        }
        this.targetLocation = config.getProperty("MobileEngine.Sync.ViaFile.TargetLocation", defaultMIFolder + "out");
        if (this.targetLocation.length() > 0) {
            this.targetLocation = new File(this.targetLocation).getAbsolutePath();
        }
        this.processInfo = new DiscSyncProcessInfo();
        String[] files = this.getUploadedFiles();
        if (files.length > 0 && files[0].length() == 12) {
            this.processInfo.setPrefix(files[0].substring(0, 4));
        } else {
            this.processInfo.setPrefix("");
        }
        this.processInfo.setEncrypted(config.getProperty("MobileEngine.Security.FilterStreams.Decryption", "").length() > 0 && config.getProperty("MobileEngine.Security.FilterStreams.Encryption", "").length() > 0);
        this.processInfo.setSigned(config.getProperty("MobileEngine.Security.FilterStreams.Signing", "").length() > 0 && config.getProperty("MobileEngine.Security.FilterStreams.Unsigning", "").length() > 0);
        if ((this.processInfo.getPrefix() == null || this.processInfo.getPrefix().length() == 0) && this.processInfo.getExpectedNumberOfFiles() == -1) {
            this.processInfo.setInitial();
        }
    }

    protected void removeFileFromList(File f) {
        if (f == null) {
            return;
        }
        try {
            int number = Integer.parseInt(f.getName().substring(4, 8));
            this.getProcessInfo().removeFileNumber(number);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void clearUploadProcessInfo() {
        this.getProcessInfo().clear();
    }

    protected void setProperty(String key, String value) {
        Configuration.getInstance().setDefaultProperty(key, value);
    }

    String getDiscSyncTempInboundFolder() {
        return this.tempInboundFolder;
    }

    String getDiscSyncTempOutboundFolder() {
        return this.tempOutboundFolder;
    }

    boolean isPrefixMatching(String filename) {
        String pref = this.processInfo.getPrefix();
        return filename.toLowerCase().startsWith(pref);
    }

    private String getLocalizedNameFor(String key, String defaultValue) {
        String localizedname = null;
        if (this.resources != null) {
            try {
                localizedname = this.resources.getString(key);
            }
            catch (Exception ex) {
                Trace.getInstance("MI/Sync").log(60, "cannot resolve resource key " + key);
                localizedname = null;
            }
        }
        if (localizedname == null || localizedname.length() == 0) {
            localizedname = defaultValue;
        }
        return localizedname;
    }

    protected boolean isDeviceIdValid(String deviceIdToBeCompared) {
        return deviceIdToBeCompared != null && deviceIdToBeCompared.equals(this.DEVICEID);
    }

    private class MediaTypeImpl
    implements MediaType {
        private static final long BYTES = 1L;
        private static final long KILOBYTES = 1024L;
        private static final long MEGABYTES = 0x100000L;
        private static final long GIGABYTES = 0x40000000L;
        private String name;
        private String localizedName;
        private long size;
        private boolean userDefined;
        private String description;

        MediaTypeImpl(String name, String localizedName, long size, boolean userDefined) {
            this.name = name;
            this.localizedName = localizedName != null ? localizedName : name;
            this.size = size;
            this.userDefined = userDefined;
            if (!userDefined) {
                StringBuffer descriptionBuffer = new StringBuffer(8 + localizedName.length());
                String suffix = " B - ";
                long divisor = 1L;
                if (size > 0x40000000L) {
                    suffix = " GB - ";
                    divisor = 0x40000000L;
                } else if (size > 0x100000L) {
                    suffix = " MB - ";
                    divisor = 0x100000L;
                } else if (size > 1024L) {
                    suffix = " KB - ";
                    divisor = 1024L;
                }
                NumberFormat formatter = NumberFormat.getInstance();
                if (divisor == 1L) {
                    formatter.setMinimumFractionDigits(0);
                    formatter.setMaximumFractionDigits(0);
                    descriptionBuffer.append(Long.toString(size));
                } else {
                    formatter.setMinimumFractionDigits(0);
                    formatter.setMaximumFractionDigits(2);
                    descriptionBuffer.append(formatter.format((double)size / (double)divisor));
                }
                descriptionBuffer.append(suffix);
                descriptionBuffer.append(localizedName);
                this.description = descriptionBuffer.toString();
            } else {
                this.description = this.localizedName;
            }
        }

        public String getLocalizedName() {
            return this.localizedName;
        }

        public String getName() {
            return this.name;
        }

        public long getSize() {
            return this.size;
        }

        public boolean isUserDefined() {
            return this.userDefined;
        }

        public String toString() {
            return this.description;
        }

        void setSize(long size) {
            this.size = size;
        }
    }

    private class DiscSyncFileFilter
    implements FilenameFilter {
        String prefix;

        DiscSyncFileFilter(String prefix) {
            this.prefix = prefix;
        }

        public boolean accept(File dir, String name) {
            String fname = name.toLowerCase();
            boolean result = fname.endsWith(DiscSyncConfiguration.DISC_SYNC_FILEEXTENSION);
            if (this.prefix != null) {
                result = result && fname.startsWith(this.prefix);
            }
            return result;
        }
    }
}

