/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.sync;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.core.ConversationIdHandler;
import java.util.ResourceBundle;

public class DCPackagingConfiguration {
    private final String[] sizeNames;
    private final long[] sizes;
    private boolean activated;
    private int currentlySelected;

    public DCPackagingConfiguration() {
        this(true);
    }

    public DCPackagingConfiguration(boolean localizationNeeded) {
        Configuration config = Configuration.getInstance();
        this.activated = config.getBoolean("MobileEngine.Packaging.Activated", false);
        Trace trace = Trace.getInstance("MI/Sync");
        if (localizationNeeded) {
            ResourceBundle resources = null;
            try {
                resources = ResourceBundle.getBundle("com.sap.ip.me.sync.mi_sync");
            }
            catch (Exception ex) {
                trace.log(60, "Cannot open resource bundle for datacontainer packaging sync: " + ex.getLocalizedMessage());
            }
            if (resources == null) {
                this.sizeNames = new String[]{"very small", "small", "medium", "large"};
            } else {
                this.sizeNames = new String[4];
                try {
                    this.sizeNames[0] = resources.getString("dc_packaging_very_small");
                }
                catch (Exception ex) {
                    trace.log(60, "Cannot find resource for data container packaging key 'dc_packaging_very_small'; Check mi_sync resource bundle");
                    this.sizeNames[0] = "very small";
                }
                try {
                    this.sizeNames[1] = resources.getString("dc_packaging_small");
                }
                catch (Exception ex) {
                    trace.log(60, "Cannot find resource for data container packaging key 'dc_packaging_small'; Check mi_sync resource bundle");
                    this.sizeNames[1] = "small";
                }
                try {
                    this.sizeNames[2] = resources.getString("dc_packaging_normal");
                }
                catch (Exception ex) {
                    trace.log(60, "Cannot find resource for data container packaging key 'dc_packaging_normal'; Check mi_sync resource bundle");
                    this.sizeNames[2] = "medium";
                }
                try {
                    this.sizeNames[3] = resources.getString("dc_packaging_large");
                }
                catch (Exception ex) {
                    trace.log(60, "Cannot find resource for data container packaging key 'dc_packaging_large'; Check mi_sync resource bundle");
                    this.sizeNames[3] = "large";
                }
            }
        } else {
            this.sizeNames = new String[]{"very small", "small", "medium", "large"};
        }
        long minimum = ConversationIdHandler.getInstance().getNumberOfConversationIds() + 5;
        boolean writeconfig = false;
        this.sizes = new long[4];
        this.sizes[0] = config.getLong("MobileEngine.Packaging.VerySmall", Long.MIN_VALUE);
        if (this.sizes[0] == Long.MIN_VALUE || this.sizes[0] < minimum) {
            this.sizes[0] = minimum;
            trace.log(60, "Value for {0} contains illegal value; automatically adjusted to {1}", (Object)"MobileEngine.Packaging.VerySmall", (Object)String.valueOf(this.sizes[0]));
            writeconfig = true;
        }
        this.sizes[1] = config.getLong("MobileEngine.Packaging.Small", Long.MIN_VALUE);
        if (this.sizes[1] == Long.MIN_VALUE || this.sizes[1] < minimum) {
            this.sizes[1] = 100L < minimum ? 5L * minimum : 100L;
            trace.log(60, "Value for {0} contains illegal value; automatically adjusted to {1}", (Object)"MobileEngine.Packaging.Small", (Object)String.valueOf(this.sizes[1]));
            writeconfig = true;
        }
        this.sizes[2] = config.getLong("MobileEngine.Packaging.Normal", Long.MIN_VALUE);
        if (this.sizes[0] == Long.MIN_VALUE || this.sizes[2] < minimum) {
            this.sizes[2] = 2500L < minimum ? 125L * minimum : 2500L;
            trace.log(60, "Value for {0} contains illegal value; automatically adjusted to {1}", (Object)"MobileEngine.Packaging.Normal", (Object)String.valueOf(this.sizes[2]));
            writeconfig = true;
        }
        this.sizes[3] = config.getLong("MobileEngine.Packaging.Large", Long.MIN_VALUE);
        if (this.sizes[0] == Long.MIN_VALUE || this.sizes[3] < minimum) {
            this.sizes[3] = 50000L < minimum ? 2500L * minimum : 50000L;
            trace.log(60, "Value for {0} contains illegal value; automatically adjusted to {1}", (Object)"MobileEngine.Packaging.Large", (Object)String.valueOf(this.sizes[3]));
            writeconfig = true;
        }
        if (this.sizes[0] >= this.sizes[1] || this.sizes[1] >= this.sizes[2] || this.sizes[2] >= this.sizes[3]) {
            trace.log(60, "Maximum data container packaging sizes were out of order; order adjusted");
            this.sort(this.sizes, 0);
            writeconfig = true;
        }
        this.currentlySelected = config.getInt("MobileEngine.Packaging.MaxPackageSize", 2);
        if (this.currentlySelected < 0 || this.currentlySelected > 3) {
            trace.log(60, "Data container packaging configuration out of bounds; use default package size");
            this.currentlySelected = 2;
            writeconfig = true;
        }
        if (writeconfig) {
            config.setDefaultProperty("MobileEngine.Packaging.VerySmall", Long.toString(this.sizes[0]));
            config.setDefaultProperty("MobileEngine.Packaging.Small", Long.toString(this.sizes[1]));
            config.setDefaultProperty("MobileEngine.Packaging.Normal", Long.toString(this.sizes[2]));
            config.setDefaultProperty("MobileEngine.Packaging.Large", Long.toString(this.sizes[3]));
            config.setInt("MobileEngine.Packaging.MaxPackageSize", this.currentlySelected);
        }
    }

    private void sort(long[] data, int from) {
        if (from < data.length) {
            int j = from + 1;
            while (j < data.length) {
                if (data[from] > data[j]) {
                    long tmp = data[from];
                    data[from] = data[j];
                    data[j] = tmp;
                }
                ++j;
            }
            this.sort(data, from + 1);
        }
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void setActivated(boolean activated) {
        if (this.activated != activated) {
            this.activated = activated;
            Configuration.getInstance().setDefaultProperty("MobileEngine.Packaging.Activated", String.valueOf(activated));
        }
    }

    public String[] getLocalizedOptions() {
        return this.sizeNames;
    }

    public int getSelectedOption() {
        return this.currentlySelected;
    }

    public void setSelectedOption(int newSelection) {
        if (newSelection < 0 || newSelection > 3) {
            throw new IllegalArgumentException("Data container packaging option has to be between 0 (very small) and 3 (large)");
        }
        if (this.currentlySelected != newSelection) {
            this.currentlySelected = newSelection;
            Configuration.getInstance().setProperty("MobileEngine.Packaging.MaxPackageSize", Integer.toString(newSelection));
        }
    }

    public long getMaximumPackageSize() {
        return this.sizes[this.currentlySelected];
    }
}

