/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.sync;

import com.sap.ip.me.api.conf.VisibilityType;
import com.sap.ip.me.api.sync.OutboundContainer;
import com.sap.ip.me.api.sync.OutboundContainerFactory;
import com.sap.ip.me.api.sync.SyncException;
import com.sap.ip.me.api.user.User;
import com.sap.ip.me.core.ApplicationManager;
import com.sap.ip.me.core.ConversationId;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.core.MobileSolutionDescriptor;
import com.sap.ip.me.core.SyncSettings;
import com.sap.ip.me.sync.SyncHeader;
import com.sap.ip.me.sync.SyncInboundContainer;
import com.sap.ip.me.sync.SyncOutboundContainer;

public final class ContainerFactory
extends OutboundContainerFactory {
    private static final int LENGTH_OF_GEN_BODY_FRAGMENT = 125;
    private static final String EOL_STRING = "<EOL>";
    private static ContainerFactory instance;

    public ContainerFactory() {
        if (instance != null) {
            throw new IllegalStateException("OutboundContainerFactory already exists");
        }
        instance = this;
    }

    public OutboundContainer createOutboundContainer(VisibilityType visibility, String method, String type) throws SyncException, IllegalArgumentException {
        return new SyncOutboundContainer(visibility, method, type);
    }

    public OutboundContainer createAttachmentOutboundContainer(VisibilityType visibility, String method, String type, String attachmentName, String attachment) throws SyncException, IllegalArgumentException {
        SyncOutboundContainer container = new SyncOutboundContainer(visibility, method, type);
        this.setAttachmentAndClose(container, attachmentName, attachment);
        return container;
    }

    public OutboundContainer createAttachmentOutboundContainer(VisibilityType visibility, String method, String type, String attachmentName, String attachment, String msgIndex, String msgType) throws SyncException, IllegalArgumentException {
        SyncOutboundContainer container = new SyncOutboundContainer(visibility, method, type);
        if (!SyncSettings.isNewProtocolActive()) {
            container.getHeader().setMsgIndex(msgIndex);
        }
        container.getHeader().setMsgType(msgType);
        this.setAttachmentAndClose(container, attachmentName, attachment);
        return container;
    }

    public OutboundContainer createAttachmentOutboundContainer(VisibilityType visibility, String method, String type, String attachmentName, String attachment, String msgType) throws SyncException, IllegalArgumentException {
        SyncOutboundContainer container = new SyncOutboundContainer(visibility, method, type);
        container.getHeader().setMsgType(msgType);
        this.setAttachmentAndClose(container, attachmentName, attachment);
        return container;
    }

    public OutboundContainer createAttachmentOutboundContainer(ConversationId convId, String method, String type, String attachmentName, String attachment, String msgType) throws SyncException, IllegalArgumentException {
        SyncOutboundContainer container = new SyncOutboundContainer(convId, method, type);
        container.getHeader().setMsgType(msgType);
        this.setAttachmentAndClose(container, attachmentName, attachment);
        return container;
    }

    static void createAcknowledgeContainer(SyncInboundContainer container, User user, String acknowledgeType) throws SyncException {
        ConversationId convId = null;
        if (container.getConversationId() == null) {
            MobileSolutionDescriptor frameworkMSD = ApplicationManager.getInstance().getFrameworkMobileSolutionDescriptor();
            convId = ConversationIdHandler.getInstance().getConversationId(frameworkMSD, user);
        } else {
            convId = container.getConversationId();
        }
        SyncOutboundContainer ackcontainer = new SyncOutboundContainer(convId, container.getMethod(), acknowledgeType);
        SyncHeader acknHeader = ackcontainer.getHeader();
        SyncHeader contHeader = container.getSyncHeader();
        acknHeader.setAncestorContainerId(container.getContainerId());
        acknHeader.setSubContainerId(contHeader.getSubContainerId());
        acknHeader.setSubContainerMax(contHeader.getSubContainerMax());
        acknHeader.setOwner(contHeader.getOwner());
        acknHeader.setMsgIndex(contHeader.getMsgIndex());
        acknHeader.setMsgType(contHeader.getMsgType());
        acknHeader.setBodyType(contHeader.getBodyType());
        acknHeader.setBodyLength(contHeader.getBodyLength());
        acknHeader.setItemFrom(contHeader.getItemFrom());
        acknHeader.setItemTo(contHeader.getItemTo());
        ackcontainer.close();
    }

    static void createNotifyContainer(String methodName, User user) throws SyncException {
        MobileSolutionDescriptor frameworkMSD = ApplicationManager.getInstance().getFrameworkMobileSolutionDescriptor();
        ConversationId convId = ConversationIdHandler.getInstance().getConversationId(frameworkMSD, user);
        SyncOutboundContainer container = new SyncOutboundContainer(convId, methodName, "N");
        container.close();
    }

    static void createNotifyContainer(ConversationId convId) throws SyncException {
        SyncOutboundContainer container = new SyncOutboundContainer(convId, "", "N");
        container.close();
    }

    private void setAttachmentAndClose(SyncOutboundContainer container, String bodyType, String body) throws SyncException {
        SyncHeader header = container.getHeader();
        header.setBodyType(bodyType);
        int ind = 0;
        int begin = 0;
        int end = begin + 125;
        while (end < body.length()) {
            container.addItem(header.getBodyType(), ind++, body.substring(begin, end) + EOL_STRING);
            end = (begin += 125) + 125;
        }
        if (begin < body.length()) {
            container.addItem(header.getBodyType(), ind++, body.substring(begin, body.length()) + EOL_STRING);
        }
        header.setBodyLength(body.length());
        container.close();
    }
}

