/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.sync;

import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.services.IOUtils;
import com.sap.ip.me.security.StreamFactory;
import com.sap.ip.me.sync.DiscSyncConfiguration;
import com.sap.ip.me.sync.DiscSyncException;
import com.sap.ip.me.sync.DiscSyncProcessInfo;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.zip.Adler32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public abstract class AbstractDiscSyncController {
    protected static final String SYNCCOUNT_KEY_PREFIX = "SyncCount.";
    protected static final String OUTBOUND_PACKAGEPREFIX = "/package";
    private static final String SYNC_PROPERTY_FILENAME = "sync.props";
    protected static final String DISCSYNC_USERLIST = "DiscSync.Userlist";
    static final String INBOUNDARCHIVE_NAME = "inboundArchive.sync";
    static final String OUTBOUNDARCHIVE_NAME = "outboundArchive.sync";
    static final String DUMMY_INBOUND = "<!-- This page was created by the SAP Java Connector; Version of the JCO-library: 2.1.1 (2003-08-01); Creation time: 0000-00-00 00:00:00 -->&WAF_SYNC&STATUS=S&Execution Time =110828& HeaderType = MEREPLICATION &MORE_PACKAGES_WAITING =  &";
    private static final String RESOURCEBUNDLE_NAME = "com.sap.ip.me.sync.mi_sync";
    private static final int PROLOG_LENGTH = 56;
    private static final int APPENDIX_LENGTH = 4;
    private static final int PROTOCOL_DATA_LENGTH = 60;
    private static final byte[] IDENTIFIER = new byte[]{77, 73, 83, 121, 110, 99, 2, 5, 3, 0};
    private static final int POS_FLAGS = 10;
    private static final int SIZE_FLAGS = 2;
    private static final int POS_DEVICEID = 12;
    private static final int SIZE_DEVICEID = 32;
    private static final int POS_SYNC_COUNTER = 44;
    private static final int SIZE_SYNC_COUNTER = 10;
    private static final int POS_DISC_NUMBER = 54;
    private static final int SIZE_DISC_NUMBER = 2;
    private static final int FLAG_SIGNED = 1;
    private static final int FLAG_ENCRYPTED = 2;
    private static final int FLAG_LASTFILE = 4;
    private static final int FLAG_GENERATED_ON_SERVER = 8;
    public static final int STATUS_OK = 1;
    public static final int STATUS_FAILED = 2;
    private DiscSyncConfiguration config;
    protected ZipFile inboundarchive;
    protected ZipOutputStream outboundarchive;
    private String currentUserName;
    private String currentUserList;
    private int currentPackageCountOut;
    private int currentPackageCountIn;
    private Trace trace = Trace.getInstance("MI/API/Sync");
    Properties configurationProperties = new Properties();

    public AbstractDiscSyncController() {
        this(true);
    }

    protected AbstractDiscSyncController(boolean initialize) {
        if (initialize) {
            this.initializeController(new DiscSyncConfiguration(RESOURCEBUNDLE_NAME));
        }
    }

    public DiscSyncConfiguration getConfiguration() {
        return this.config;
    }

    public void cleanUploadedFilesList() {
        String rootfolder = this.config.getDiscSyncTempInboundFolder();
        File dir = new File(rootfolder);
        IOUtils.deleteDirectoryRecursively(dir, false);
        this.config.getProcessInfo().clear();
    }

    public String uploadFile(String file) throws DiscSyncException {
        File target = null;
        String result = null;
        try {
            if (file == null || file.trim().length() == 0) {
                throw new DiscSyncException(0);
            }
            File source = new File(file);
            if (!source.exists()) {
                throw new DiscSyncException(1, file);
            }
            if (!source.canRead()) {
                throw new DiscSyncException(2, file);
            }
            String name = source.getName();
            if (name.length() != 12 || !name.toLowerCase().endsWith(this.config.getDiscSyncFileExtension())) {
                throw new DiscSyncException(4, file);
            }
            if (!this.config.isPrefixMatching(name)) {
                throw new DiscSyncException(6, file);
            }
            target = new File(this.config.getDiscSyncTempInboundFolder(), source.getName());
            if (target.exists()) {
                throw new DiscSyncException(5, file);
            }
            IOUtils.copyStreams(new FileInputStream(source), new FileOutputStream(target));
            this.checkInboundFileIfMatching(target);
            result = target.getName();
            this.trace.log(80, "DiscSync: File {0} successfully uploaded", (Object)result);
        }
        catch (Exception ex) {
            this.trace.logException("DiscSync: Error while uploading disc sync inbound file " + file, (Throwable)ex, true);
            if (ex instanceof DiscSyncException) {
                DiscSyncException dsex = (DiscSyncException)ex;
                if (dsex.getErrorCode() != 5 && target != null) {
                    target.delete();
                }
                throw dsex;
            }
            if (target != null) {
                target.delete();
            }
            throw new DiscSyncException(3, file);
        }
        return result;
    }

    public boolean isDiscSyncSetComplete() {
        String[] sources = this.config.getUploadedFiles();
        int expected = this.config.getProcessInfo().getExpectedNumberOfFiles();
        return expected != -1 && sources.length == expected || sources.length == 0;
    }

    public void callSync() throws DiscSyncException {
        try {
            this.trace.log(80, "DiscSync: Synchronization started");
            this.checkCompleteness();
            this.trace.log(80, "DiscSync: completeness checked");
            this.combineInboundFiles();
            this.trace.log(80, "DiscSync: inbound combined");
            this.cleanDownloadableFilesList();
            int syncstatus = 2;
            try {
                this.initializeArchives();
                this.trace.log(80, "DiscSync: archives initialized");
                syncstatus = this.startSynchronization();
                if (syncstatus == 2) {
                    this.trace.log(50, "DiscSync: synchronization failed");
                    String[] messages = this.getSyncMessages();
                    if (messages != null && messages.length > 0) {
                        throw new DiscSyncException(16, messages[messages.length - 1]);
                    }
                    throw new DiscSyncException(17);
                }
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.finalizeArchives();
                this.trace.log(80, "DiscSync: archive has been finalized");
                throw throwable;
            }
            this.finalizeArchives();
            this.trace.log(80, "DiscSync: archive has been finalized");
            this.splitAndDeleteFile(new File(this.config.getDiscSyncTempOutboundFolder(), OUTBOUNDARCHIVE_NAME));
            this.trace.log(80, "DiscSync: files have been created");
            if (syncstatus == 1) {
                this.cleanUploadedFilesList();
            }
        }
        catch (Exception ex) {
            this.trace.logException("DiscSync: Error while synchronizing via media", (Throwable)ex, true);
            if (ex instanceof DiscSyncException) {
                throw (DiscSyncException)ex;
            }
            throw new DiscSyncException(17);
        }
    }

    public void checkCompleteness() throws DiscSyncException {
        if (!this.isDiscSyncSetComplete()) {
            throw new DiscSyncException(11, this.getMissingFileName());
        }
    }

    public void cancelDiscSyncProcess() {
    }

    public void copyFileToMedia(String filename) throws DiscSyncException {
        File source = new File(this.config.getDiscSyncTempOutboundFolder(), filename);
        if (!source.exists()) {
            throw new DiscSyncException(1, source.getAbsolutePath());
        }
        if (!source.canRead()) {
            throw new DiscSyncException(2, source.getAbsolutePath());
        }
        String targetfolder = this.config.getTargetLocation();
        if (targetfolder == null || targetfolder.length() == 0) {
            throw new DiscSyncException(7);
        }
        File target = new File(targetfolder, "");
        if (!target.exists()) {
            target.mkdirs();
        }
        if (target.exists() && !target.isDirectory()) {
            throw new DiscSyncException(8);
        }
        if (!target.canWrite()) {
            throw new DiscSyncException(9);
        }
        try {
            IOUtils.copyStreams(new FileInputStream(source), new FileOutputStream(new File(target, source.getName())));
        }
        catch (Exception ex) {
            Trace.getInstance("MI/Sync").logException(60, "Error while copying file {0} to target {1}", new Object[]{source.getAbsolutePath(), target.getPath()}, ex, true);
            throw new DiscSyncException(10, source.getName(), target.getPath());
        }
    }

    protected void initializeController(DiscSyncConfiguration config) {
        this.config = config;
        this.updateProcessInfo();
        this.currentUserList = null;
    }

    protected abstract int startSynchronization() throws DiscSyncException;

    public abstract String[] getSyncMessages();

    void updateProcessInfo() {
        try {
            String[] files = this.config.getUploadedFiles();
            if (files.length > 0) {
                File f = null;
                String folder = this.config.getDiscSyncTempInboundFolder();
                int i = 0;
                while (i < files.length) {
                    f = new File(folder, files[i]);
                    InboundStream in = new InboundStream(f);
                    in.close();
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            this.trace.logException(50, "DiscSync: Error while updating process info; clean temporary inbound folder", ex, true);
            this.cleanUploadedFilesList();
        }
    }

    void cleanDownloadableFilesList() {
        File dir = new File(this.config.getDiscSyncTempOutboundFolder());
        IOUtils.deleteDirectoryRecursively(dir, false);
    }

    void combineInboundFiles() throws DiscSyncException {
        block17: {
            try {
                boolean renamed;
                File tmpSource;
                boolean deleted;
                this.trace.log(80, "DiscSync: combine inbound files called");
                DiscSyncProcessInfo processinfo = this.config.getProcessInfo();
                SequenceInputStream input = new SequenceInputStream(new InboundFileEnumeration(this.config.getDiscSyncTempInboundFolder(), processinfo.prefix, this.config.getDiscSyncFileExtension(), processinfo.expectedNumberOfFiles));
                File target = new File(this.config.getDiscSyncTempInboundFolder(), INBOUNDARCHIVE_NAME);
                target.delete();
                IOUtils.copyStreams(input, new FileOutputStream(target));
                input.close();
                this.trace.log(80, "DiscSync: files combined to one archive");
                boolean encrypted = processinfo.isEncrypted();
                boolean signed = processinfo.isSigned();
                if (!encrypted && !signed || target.length() <= 0L) break block17;
                if (encrypted) {
                    this.trace.log(80, "DiscSync: archive is encrypted");
                    if (!StreamFactory.isEncryptionSupported()) {
                        throw new DiscSyncException(18);
                    }
                }
                if (signed) {
                    this.trace.log(80, "DiscSync: archive is signed");
                    if (!StreamFactory.isSigningSupported()) {
                        throw new DiscSyncException(19);
                    }
                }
                if (!(deleted = (tmpSource = new File(target.getParent(), target.getName() + ".tmp")).delete()) && tmpSource.exists()) {
                    this.trace.log(60, "Cannot delete temporary inbound file: " + tmpSource.getAbsolutePath());
                }
                if (!(renamed = target.renameTo(tmpSource))) {
                    this.trace.log(60, "Cannot rename inbound file ({0}) to temporary inbound file ({1}): ", new Object[]{target.getAbsolutePath(), tmpSource.getAbsolutePath()});
                }
                target = new File(target.getParent(), INBOUNDARCHIVE_NAME);
                this.trace.log(80, "DiscSync: start unsigning and / or decryption");
                InputStream tmpin = new FileInputStream(tmpSource);
                if (encrypted && signed) {
                    try {
                        tmpin = StreamFactory.createUnsigningDecryptionInputStream(tmpin);
                    }
                    catch (Exception ex) {
                        AppLog.getInstance("MI/Sync").logException(60, "Cannot instantiate encryption or signing plugin", ex, true);
                        throw new DiscSyncException(18);
                    }
                }
                if (encrypted) {
                    try {
                        tmpin = StreamFactory.createDecryptionInputStream(tmpin);
                    }
                    catch (Exception ex) {
                        AppLog.getInstance("MI/Sync").logException(60, "Cannot instantiate encryption or signing plugin", ex, true);
                        throw new DiscSyncException(18);
                    }
                }
                try {
                    tmpin = StreamFactory.createUnsigningInputStream(tmpin);
                }
                catch (Exception ex) {
                    AppLog.getInstance("MI/Sync").logException(60, "Cannot instantiate encryption or signing plugin", ex, true);
                    throw new DiscSyncException(19);
                }
                IOUtils.copyStreams(tmpin, new FileOutputStream(target));
                tmpSource.delete();
                this.trace.log(80, "DiscSync: archive decrypted / unsigned");
            }
            catch (Exception ex) {
                this.trace.logException(50, "DiscSync: Error while combining inbound files", ex, true);
                if (ex instanceof DiscSyncException) {
                    throw (DiscSyncException)ex;
                }
                throw new DiscSyncException(12, INBOUNDARCHIVE_NAME);
            }
        }
    }

    protected abstract boolean isEncryptionUsed();

    protected abstract boolean isSigningUsed();

    void splitAndDeleteFile(File sourceFile) throws DiscSyncException {
        try {
            this.trace.log(80, "DiscSync: spilt result archive into partitions");
            String sourceFilename = sourceFile.getName();
            byte[] prefix = this.initializePrefix(sourceFile);
            Adler32 checksum = new Adler32();
            FileOutputStream out = null;
            String outFolder = this.config.getDiscSyncTempOutboundFolder();
            long mediasize = this.config.getCurrentMediaType().getSize() - 60L;
            String discId = this.getRandomDiscId();
            int currentDiscNumber = 1;
            StringBuffer filenamebuffer = new StringBuffer(12);
            filenamebuffer.append(discId);
            long currentCheckSum = 0L;
            byte[] checksumarray = new byte[4];
            boolean encrypted = this.isEncryptionUsed();
            boolean signed = this.isSigningUsed();
            if ((encrypted || signed) && sourceFile.length() > 0L) {
                boolean renamed;
                File tmpSource;
                boolean deleted;
                if (encrypted) {
                    this.trace.log(80, "DiscSync: archive has to be encrypted");
                    if (!StreamFactory.isEncryptionSupported()) {
                        throw new DiscSyncException(18);
                    }
                }
                if (signed) {
                    this.trace.log(80, "DiscSync: archive has to be signed");
                    if (!StreamFactory.isSigningSupported()) {
                        throw new DiscSyncException(19);
                    }
                }
                if (!(deleted = (tmpSource = new File(sourceFile.getParent(), sourceFile.getName() + ".tmp")).delete()) && tmpSource.exists()) {
                    this.trace.log(60, "Cannot delete temporary outbound file: " + tmpSource.getAbsolutePath());
                }
                if (!(renamed = sourceFile.renameTo(tmpSource))) {
                    this.trace.log(60, "Cannot rename inbound file ({0}) to temporary inbound file ({1}): ", new Object[]{sourceFile.getAbsolutePath(), tmpSource.getAbsolutePath()});
                    throw new DiscSyncException(13);
                }
                sourceFile = new File(tmpSource.getParent(), sourceFilename);
                OutputStream tmpout = new FileOutputStream(sourceFile);
                if (encrypted && signed) {
                    try {
                        tmpout = StreamFactory.createEncryptionSigningOutputStream(tmpout);
                    }
                    catch (Exception ex) {
                        AppLog.getInstance("MI/Sync").logException(60, "Cannot instantiate encryption or signing plugin", ex, true);
                        throw new DiscSyncException(18);
                    }
                }
                if (encrypted) {
                    try {
                        tmpout = StreamFactory.createEncryptionOutputStream(tmpout);
                    }
                    catch (Exception ex) {
                        AppLog.getInstance("MI/Sync").logException(60, "Cannot instantiate encryption or signing plugin", ex, true);
                        throw new DiscSyncException(18);
                    }
                }
                try {
                    tmpout = StreamFactory.createSigningOutputStream(tmpout);
                }
                catch (Exception ex) {
                    AppLog.getInstance("MI/Sync").logException(60, "Cannot instantiate encryption or signing plugin", ex, true);
                    throw new DiscSyncException(19);
                }
                IOUtils.copyStreams(new FileInputStream(tmpSource), tmpout);
                tmpSource.delete();
                this.trace.log(80, "DiscSync: outbound archive has been signed / encrypted");
            }
            long dataToBeWritten = sourceFile.length();
            byte[] data = new byte[(int)Math.min(16384L, dataToBeWritten)];
            FileInputStream in = new FileInputStream(sourceFile);
            do {
                checksum.reset();
                filenamebuffer.append(this.getFormatedNumber(currentDiscNumber)).append(this.config.getDiscSyncFileExtension());
                out = new FileOutputStream(new File(outFolder, filenamebuffer.toString()));
                this.trace.log(80, "DiscSync: create outbound partition file {0}", (Object)filenamebuffer.toString());
                out.write(prefix);
                checksum.update(prefix);
                long toBeRead = Math.min(mediasize, dataToBeWritten);
                while (toBeRead > 0L) {
                    int read;
                    if (toBeRead >= (long)data.length) {
                        read = in.read(data);
                        out.write(data, 0, read);
                        checksum.update(data, 0, read);
                        toBeRead -= (long)read;
                        continue;
                    }
                    read = in.read(data, 0, (int)toBeRead);
                    out.write(data, 0, read);
                    checksum.update(data, 0, read);
                    toBeRead -= (long)read;
                }
                currentCheckSum = checksum.getValue();
                checksumarray[0] = (byte)(currentCheckSum >> 24 & 0xFFL);
                checksumarray[1] = (byte)(currentCheckSum >> 16 & 0xFFL);
                checksumarray[2] = (byte)(currentCheckSum >> 8 & 0xFFL);
                checksumarray[3] = (byte)(currentCheckSum & 0xFFL);
                out.write(checksumarray);
                out.close();
                filenamebuffer.setLength(4);
                this.updateDiscNumber(prefix, ++currentDiscNumber);
                if ((dataToBeWritten -= mediasize) >= mediasize) continue;
                prefix[11] = (byte)(prefix[11] | 4);
            } while (dataToBeWritten > 0L);
            in.close();
            sourceFile.delete();
        }
        catch (IOException e) {
            Trace.getInstance("MI/Sync").logException(50, "Exception while splitting outbound archive", e, true);
            throw new DiscSyncException(13);
        }
    }

    String getFormatedNumber(int n) {
        StringBuffer result = new StringBuffer("0000");
        String hexvalue = Integer.toHexString(n);
        if (hexvalue.length() > 4) {
            hexvalue = hexvalue.substring(hexvalue.length() - 4);
        }
        int j = 3;
        int i = hexvalue.length() - 1;
        while (i >= 0) {
            result.setCharAt(j, hexvalue.charAt(i));
            --i;
            --j;
        }
        return result.toString();
    }

    protected void addSyncPackageToOutbound(String user, InputStream packagestream, int synccount) throws IOException {
        if (!this.currentUserName.equalsIgnoreCase(user)) {
            this.currentUserName = user.toUpperCase();
            this.currentPackageCountOut = 0;
            this.currentPackageCountIn = 0;
            this.currentUserList = this.currentUserList != null ? this.currentUserList + "," + user : user;
        }
        ZipEntry newEntry = new ZipEntry(this.currentUserName + OUTBOUND_PACKAGEPREFIX + String.valueOf(this.currentPackageCountOut) + ".sync");
        this.addProperty(SYNCCOUNT_KEY_PREFIX + newEntry.getName(), Long.toString(synccount));
        this.outboundarchive.putNextEntry(newEntry);
        IOUtils.copyStreams(packagestream, this.outboundarchive, true, false);
        this.outboundarchive.closeEntry();
        ++this.currentPackageCountOut;
    }

    protected void getNextSyncPackageFromInbound(String user, OutputStream packagestream) throws IOException {
        ZipEntry entry = this.getNextPackageEntryFromInbound(user, true);
        if (entry != null) {
            IOUtils.copyStreams(this.inboundarchive.getInputStream(entry), packagestream, true, true);
        } else {
            IOUtils.copyStreams(new ByteArrayInputStream(DUMMY_INBOUND.getBytes("UTF8")), packagestream, true, true);
        }
    }

    protected boolean hasMoreSyncPackagesFromInbound(String user) {
        ZipEntry entry = this.getNextPackageEntryFromInbound(user, false);
        return entry != null;
    }

    protected ZipEntry getNextPackageEntryFromInbound(String user, boolean increaseCounter) {
        ZipEntry result = null;
        if (this.inboundarchive != null) {
            if (!this.currentUserName.equalsIgnoreCase(user)) {
                this.currentUserName = user.toUpperCase();
                this.currentPackageCountIn = 0;
                this.currentPackageCountOut = 0;
            }
            result = this.inboundarchive.getEntry(this.currentUserName + OUTBOUND_PACKAGEPREFIX + String.valueOf(this.currentPackageCountIn) + ".sync");
            if (increaseCounter) {
                ++this.currentPackageCountIn;
            }
        }
        return result;
    }

    protected void addPropertiesToOutbound(Properties properties) throws DiscSyncException {
        try {
            ZipEntry newEntry = new ZipEntry(SYNC_PROPERTY_FILENAME);
            this.outboundarchive.putNextEntry(newEntry);
            File tmpfile = new File(this.getInstallationDirectory(), "syncprops.tmp");
            properties.save(new FileOutputStream(tmpfile), "Disc Sync properties generated by MI framework");
            IOUtils.copyStreams(new FileInputStream(tmpfile), this.outboundarchive, true, false);
            tmpfile.delete();
            this.outboundarchive.closeEntry();
        }
        catch (Exception ex) {
            Trace.getInstance("MI/Sync").logException(50, "Exception while adding property file to outbound archive", ex, true);
            throw new DiscSyncException(13);
        }
    }

    protected abstract String getInstallationDirectory();

    protected Properties getPropertiesFromInbound() throws DiscSyncException {
        if (this.inboundarchive != null) {
            try {
                ZipEntry newEntry = this.inboundarchive.getEntry(SYNC_PROPERTY_FILENAME);
                Properties result = new Properties();
                result.load(this.inboundarchive.getInputStream(newEntry));
                return result;
            }
            catch (Exception ex) {
                Trace.getInstance("MI/Sync").logException(50, "Exception while adding property file to outbound archive", ex, true);
                throw new DiscSyncException(13);
            }
        }
        throw new DiscSyncException(13);
    }

    protected void addProperty(String key, String value) {
        ((Hashtable)this.configurationProperties).put(key, value);
    }

    Properties getProperties() {
        Properties result = new Properties();
        if (this.inboundarchive == null) {
            return result;
        }
        try {
            ZipEntry entry = this.inboundarchive.getEntry(SYNC_PROPERTY_FILENAME);
            if (entry != null) {
                result.load(this.inboundarchive.getInputStream(entry));
            }
        }
        catch (Exception ex) {
            Trace.getInstance("MI/Sync").logException(50, "Exception while loading property file from inbound archive", ex, true);
        }
        return result;
    }

    void initializeArchives() throws DiscSyncException {
        try {
            this.currentUserList = null;
            this.currentUserName = "";
            this.currentPackageCountOut = 0;
            this.currentPackageCountIn = 0;
            File in = new File(this.config.getDiscSyncTempInboundFolder(), INBOUNDARCHIVE_NAME);
            this.inboundarchive = in != null && in.exists() && in.length() > 0L ? new ZipFile(in) : null;
            this.outboundarchive = new ZipOutputStream(new FileOutputStream(new File(this.config.getDiscSyncTempOutboundFolder(), OUTBOUNDARCHIVE_NAME)));
        }
        catch (Exception ex) {
            Trace.getInstance("MI/Sync").logException(50, "Exception while initializing inbound archive", ex, true);
            throw new DiscSyncException(12, INBOUNDARCHIVE_NAME);
        }
    }

    void finalizeArchives() throws DiscSyncException {
        Exception e = null;
        try {
            if (this.outboundarchive != null) {
                ((Hashtable)this.configurationProperties).put("MobileEngine.Sync.Gateway.System", this.getSystemId());
                ((Hashtable)this.configurationProperties).put("MobileEngine.Datacompression.Gzip", this.getCompressionEnabledValue());
                ((Hashtable)this.configurationProperties).put("MobileEngine.Sync.Deviceid", this.getDeviceId());
                ((Hashtable)this.configurationProperties).put("MobileEngine.Sync.Client", this.getClient());
                ((Hashtable)this.configurationProperties).put("MobileEngine.Sync.Language", this.getLanguage());
                ((Hashtable)this.configurationProperties).put("MobileEngine.Packaging.MaxPackageSize", this.getPackageSize());
                if (this.currentUserList != null) {
                    ((Hashtable)this.configurationProperties).put(DISCSYNC_USERLIST, this.currentUserList);
                }
                this.addPropertiesToOutbound(this.configurationProperties);
                this.outboundarchive.close();
            }
        }
        catch (Exception ex) {
            Trace.getInstance("MI/Sync").logException(50, "Exception while finalizing outbound archive", ex, true);
            e = ex;
        }
        try {
            if (this.inboundarchive != null) {
                this.inboundarchive.close();
            }
        }
        catch (Exception ex) {
            Trace.getInstance("MI/Sync").logException(50, "Exception while finalizing inbound archive", ex, true);
            e = ex;
        }
        if (e != null) {
            throw new DiscSyncException(13);
        }
    }

    protected abstract String getSystemId();

    protected abstract String getCompressionEnabledValue();

    protected abstract String getDeviceId();

    protected abstract String getClient();

    protected abstract String getLanguage();

    protected abstract String getPackageSize();

    private String getMissingFileName() {
        DiscSyncProcessInfo info = this.config.getProcessInfo();
        return info.getPrefix() + this.getFormatedNumber(info.getNextMissingFileNumber()) + this.config.getDiscSyncFileExtension();
    }

    private void checkInboundFileIfMatching(File inbound) throws DiscSyncException {
        try {
            InboundStream in = new InboundStream(inbound);
            in.close();
        }
        catch (Exception ex) {
            if (inbound != null) {
                inbound.delete();
            }
            if (ex instanceof DiscSyncException) {
                throw (DiscSyncException)ex;
            }
            this.trace.logException("Disc Sync: Exception while checking inbound file", (Throwable)ex, true);
            throw new DiscSyncException(6, inbound.getAbsolutePath());
        }
    }

    private byte[] initializePrefix(File source) {
        long mediaSize = this.config.getCurrentMediaType().getSize();
        byte[] prefix = new byte[56];
        int i = 0;
        while (i < 10) {
            prefix[i] = IDENTIFIER[i];
            ++i;
        }
        int flags = 0;
        if (this.isSigningUsed()) {
            flags |= 1;
        }
        if (this.isEncryptionUsed()) {
            flags |= 2;
        }
        if (mediaSize >= source.length() + 60L) {
            flags |= 4;
        }
        if (this.isOnServer()) {
            flags |= 8;
        }
        prefix[10] = (byte)(flags >> 8 & 0xFF);
        prefix[11] = (byte)(flags & 0xFF);
        String deviceId = this.getDeviceId();
        int end = Math.min(deviceId.length(), 32);
        int j = 12;
        int i2 = 0;
        while (i2 < end) {
            prefix[j] = (byte)deviceId.charAt(i2);
            ++i2;
            ++j;
        }
        j = 44;
        int i3 = 0;
        while (i3 < 10) {
            prefix[j] = 48;
            ++i3;
            ++j;
        }
        prefix[54] = 0;
        prefix[55] = 1;
        return prefix;
    }

    private String getRandomDiscId() {
        int r = (int)(Math.random() * 26.0);
        StringBuffer result = new StringBuffer(4);
        int i = 0;
        while (i < 4) {
            result.append((char)(97 + r));
            r = (int)(Math.random() * 26.0);
            ++i;
        }
        return result.toString();
    }

    private void updateDiscNumber(byte[] prefix, int number) {
        byte high = (byte)(number >> 8 & 0xFF);
        byte low = (byte)(number & 0xFF);
        prefix[54] = high;
        prefix[55] = low;
    }

    protected abstract boolean isOnServer();

    final class InboundStream
    extends FileInputStream {
        String filename;
        long datacount;
        Adler32 checksum;

        InboundStream(File file) throws IOException {
            super(file);
            try {
                boolean locallyGenerated;
                DiscSyncProcessInfo processinfo = AbstractDiscSyncController.this.config.getProcessInfo();
                if (file == null || file.getName().length() != 12 || !file.getName().endsWith(AbstractDiscSyncController.this.config.getDiscSyncFileExtension())) {
                    throw new DiscSyncException(4, file.getName());
                }
                if (!processinfo.isInitial() && !file.getName().startsWith(processinfo.getPrefix())) {
                    throw new DiscSyncException(6, file.getName());
                }
                this.filename = file.getName();
                int fileNumberFromFilename = Integer.parseInt(this.filename.substring(4, 8), 16);
                this.checksum = new Adler32();
                this.checksum.reset();
                this.datacount = file.length() - 4L;
                int read = 0;
                int offset = 0;
                byte[] fileprolog = new byte[56];
                try {
                    while (read != -1 && offset < fileprolog.length) {
                        read = this.read(fileprolog, offset, fileprolog.length - offset);
                        if (read == -1) continue;
                        offset += read;
                    }
                    if (read == -1 || offset < 56) {
                        throw new DiscSyncException(12, file.getName());
                    }
                }
                catch (IOException ioex) {
                    throw new DiscSyncException(12, file.getName());
                }
                boolean result = true;
                int i = 0;
                while (i < IDENTIFIER.length) {
                    result = result && fileprolog[i] == IDENTIFIER[i];
                    ++i;
                }
                if (!result) {
                    throw new DiscSyncException(6, file.getName());
                }
                int flag = (fileprolog[10] << 8 | fileprolog[11]) & 0xFFFF;
                boolean encrypted = (flag & 2) > 0;
                boolean signed = (flag & 1) > 0;
                boolean lastFile = (flag & 4) > 0;
                boolean bl = locallyGenerated = (flag & 8) > 0 == AbstractDiscSyncController.this.isOnServer();
                if (locallyGenerated) {
                    throw new DiscSyncException(12, file.getName());
                }
                String deviceID = new String(fileprolog, 12, 32);
                if (!AbstractDiscSyncController.this.config.isDeviceIdValid(deviceID)) {
                    throw new DiscSyncException(6, file.getName());
                }
                String syncCount = new String(fileprolog, 44, 10);
                int discNo = (fileprolog[54] << 8 | fileprolog[55]) & 0xFFFF;
                if (discNo != fileNumberFromFilename) {
                    throw new DiscSyncException(12, this.filename);
                }
                if (processinfo.isInitial()) {
                    processinfo.setPrefix(file.getName().substring(0, 4));
                    processinfo.setDeviceID(deviceID);
                    processinfo.setEncrypted(encrypted);
                    processinfo.setSigned(signed);
                    processinfo.setSynccount(syncCount);
                } else {
                    result = result && encrypted == processinfo.isEncrypted();
                    result = result && signed == processinfo.isSigned();
                    boolean bl2 = result = result && processinfo.getDeviceID().equals(deviceID);
                    if (!result) {
                        throw new DiscSyncException(6, this.filename);
                    }
                }
                processinfo.addFileNumber(discNo);
                if (lastFile) {
                    processinfo.setExpectedNumberOfFiles(discNo);
                }
            }
            catch (IOException e) {
                this.close();
                throw e;
            }
        }

        public int read() throws IOException {
            if (this.datacount > 0L) {
                int read = super.read();
                if (read == -1) {
                    throw new DiscSyncException(12, AbstractDiscSyncController.INBOUNDARCHIVE_NAME);
                }
                this.checksum.update(read);
                --this.datacount;
                return read;
            }
            if (this.datacount == 0L) {
                --this.datacount;
                this.checkCheckSum();
            }
            return -1;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int min = (int)Math.min((long)(len - off), this.datacount);
            int result = super.read(b, off, min);
            if (this.datacount > 0L) {
                if (result != -1) {
                    this.checksum.update(b, off, result);
                    this.datacount -= (long)result;
                }
            } else {
                if (this.datacount == 0L) {
                    --this.datacount;
                    this.checkCheckSum();
                }
                result = -1;
            }
            return result;
        }

        public long skip(long n) throws IOException {
            throw new IOException("skip is not supported");
        }

        private void checkCheckSum() throws DiscSyncException {
            long currentCheckSum = this.checksum.getValue();
            try {
                int checksumarray1 = super.read();
                int checksumarray2 = super.read();
                int checksumarray3 = super.read();
                int checksumarray4 = super.read();
                long expected = (long)(checksumarray1 << 24 | checksumarray2 << 16 | checksumarray3 << 8 | checksumarray4) & 0xFFFFFFFFL;
                if (currentCheckSum != expected) {
                    throw new DiscSyncException(12, this.filename);
                }
            }
            catch (Exception ex) {
                Trace.getInstance("MI/Sync").logException("Error while checksum validation", (Throwable)ex, true);
                throw new DiscSyncException(12, this.filename);
            }
        }
    }

    final class InboundFileEnumeration
    implements Enumeration {
        String folder;
        String prefix;
        int numberOfFiles;
        int currentCount;
        String extension;

        InboundFileEnumeration(String folder, String prefix, String extension, int numberOfFiles) {
            this.folder = folder;
            this.prefix = prefix;
            this.extension = extension;
            this.numberOfFiles = numberOfFiles;
            this.currentCount = 1;
        }

        public boolean hasMoreElements() {
            return this.currentCount <= this.numberOfFiles;
        }

        public Object nextElement() {
            InboundStream result = null;
            String nextName = this.prefix + AbstractDiscSyncController.this.getFormatedNumber(this.currentCount) + this.extension;
            try {
                result = new InboundStream(new File(this.folder, nextName));
                ++this.currentCount;
            }
            catch (Exception ex) {
                Trace.getInstance("MI/Sync").logException(50, "Error while creating next inbound stream for file " + nextName, ex, true);
                result = null;
            }
            return result;
        }
    }
}

