/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.util;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.smartsync.Row;
import com.sap.ip.me.api.smartsync.SyncBo;
import com.sap.ip.me.smartsync.util.SmartSyncUtil;
import java.io.File;
import java.io.IOException;

public class XTrace {
    private static final int defaultSeverity = 1000;
    private final Trace TRC = Trace.getInstance("MI/Smartsync");
    private int currentSeverity = 1000;
    private boolean DEBUG_MODE = XTrace.checkDebugFile();
    private final String packageName;
    private static final String MARK = "--------------------------";
    private static final String INSTALL_DIR = Configuration.getInstallationDirectory();
    private static final String DEBUG_FILE = INSTALL_DIR + File.separatorChar + "_DEBUG_";
    private static final String DEBUG_FOLDER = INSTALL_DIR + File.separatorChar + ".DEBUG";
    private static final String FILE_EXT = ".txt";
    public static final String PKG_DATA = ".data";
    public static final String PKG_META = ".meta";
    public static final String PKG_SYNC = ".sync";
    public static final String PKG_DELTA = ".delta";
    public static final String PKG_CORE = ".core";
    private static final String STR_DETAIL = " Details: ";
    private static final String STR_START = " --- <START> --- ";
    private static final String STR_END = " --- <END> --- ";
    private static final String ERROR_FILENAME = "Error";

    public XTrace(String pkgName) {
        this.packageName = pkgName;
    }

    public XTrace(String pkgName, int severity) {
        this.packageName = pkgName;
        this.setSeverity(severity);
    }

    public XTrace setSeverity(int severity) {
        this.currentSeverity = severity;
        return this;
    }

    public XTrace setToEffectiveSeverity() {
        this.currentSeverity = this.TRC.getEffectiveSeverity();
        return this;
    }

    public XTrace setMarker(String marker) {
        this.TRC.log(this.currentSeverity, MARK + marker + MARK + '\n');
        return this;
    }

    public boolean isLogging() {
        return this.TRC.isLogging(this.currentSeverity);
    }

    public XTrace log(String message) {
        this.TRC.log(this.currentSeverity, message);
        return this;
    }

    public XTrace log(String marker, String message) {
        this.setMarker(marker);
        this.setMarker(STR_START);
        this.TRC.log(this.currentSeverity, message);
        this.setMarker(STR_END);
        return this;
    }

    public XTrace log(Throwable t) {
        this.TRC.logException(this.currentSeverity, t);
        return this;
    }

    public XTrace log(String msg, Throwable t) {
        this.TRC.logException(this.currentSeverity, msg, t, true);
        return this;
    }

    public XTrace log(File file) {
        this.setMarker("File  Details:  FilePath = " + file.getAbsolutePath());
        this.setMarker(STR_START);
        this.TRC.logFileContent(this.currentSeverity, file);
        this.setMarker(STR_END);
        return this;
    }

    public XTrace log(SyncBo syncBo) {
        String dt = syncBo.toString();
        return this.log(new StringBuffer(dt.length() + 60).append("SyncBo").append(STR_DETAIL).append(" SyncKey = ").append(syncBo.getSyncKey()).append(" Name = ").append(syncBo.getSyncBoDescriptor().getSyncBoName()).append('\n').append(dt).toString());
    }

    public XTrace log(Row row) {
        String dt = row.toString();
        return this.log(new StringBuffer(dt.length() + 50).append("Row").append(STR_DETAIL).append(" Key = ").append(row.getKey()).append(" Name = ").append(row.getRowDescriptor().getRowName()).append('\n').append(dt).toString());
    }

    public XTrace newLog(String fileName, String text) {
        this.write(fileName, text, false);
        return this;
    }

    public XTrace newLog(String text) {
        return this.newLog(SmartSyncUtil.getTimeFileName(), text);
    }

    public XTrace appendLog(String fileName, String text) {
        this.write(fileName, text, true);
        return this;
    }

    public XTrace appendLog(String fileName, String[] text) {
        return this.appendLog(fileName, this.concatStrings(text));
    }

    public XTrace logError(String message, String error) {
        return this.appendLog(ERROR_FILENAME, message + '\n' + error);
    }

    public XTrace logError(String message, String[] error) {
        return this.logError(message, this.concatStrings(error));
    }

    public XTrace logError(String message, Throwable t) {
        this.write(ERROR_FILENAME, message, t, true);
        return this;
    }

    public boolean isDebugMode() {
        return this.DEBUG_MODE;
    }

    public XTrace setDebugMode(boolean mode) {
        this.DEBUG_MODE = mode;
        return this;
    }

    public void clearLogs() {
        SmartSyncUtil.removeAllObjects(DEBUG_FOLDER + File.separatorChar + this.packageName);
    }

    private static boolean checkDebugFile() {
        try {
            File debugFile = new File(DEBUG_FILE);
            return debugFile.exists() && debugFile.isFile();
        }
        catch (Exception e) {
            return false;
        }
    }

    private void write(String fileName, String text, boolean append) {
        String filePath = DEBUG_FOLDER + File.separatorChar + this.packageName + File.separatorChar + fileName + FILE_EXT;
        try {
            SmartSyncUtil.writeFile(filePath, text, append);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void write(String fileName, String message, Throwable t, boolean append) {
        String filePath = DEBUG_FOLDER + File.separatorChar + this.packageName + File.separatorChar + fileName + FILE_EXT;
        try {
            SmartSyncUtil.writeFile(filePath, message, t, append);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private String concatStrings(String[] msgs) {
        if (msgs == null || msgs.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(msgs[0]);
        int i = 1;
        while (i < msgs.length) {
            sb.append('\n').append(msgs[i]);
            ++i;
        }
        return sb.toString();
    }
}

