/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.util;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.smartsync.util.SmartSyncXMLParseException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SmartSyncXMLUtil {
    static final Trace TRACE = Trace.getInstance("MI/Smartsync");

    public static DocumentBuilder _getDocumentBuilder() throws Exception, SmartSyncXMLParseException {
        DocumentBuilder builder = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            builder = dbf.newDocumentBuilder();
        }
        catch (IllegalArgumentException e) {
            throw new SmartSyncXMLParseException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new SmartSyncXMLParseException(e);
        }
        catch (ParserConfigurationException e) {
            throw new SmartSyncXMLParseException(e);
        }
        return builder;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document _getDocument(InputStream xmlAsByteArray) throws Exception, SmartSyncXMLParseException {
        Document doc = null;
        StringReader reader = null;
        try {
            try {
                DocumentBuilder builder = SmartSyncXMLUtil._getDocumentBuilder();
                builder.setErrorHandler(new MyErrorHandler());
                InputSource source = new InputSource(xmlAsByteArray);
                doc = builder.parse(source);
            }
            catch (SAXException e) {
                throw new SmartSyncXMLParseException(e.getMessage());
            }
            catch (IllegalArgumentException e) {
                throw new SmartSyncXMLParseException(e.getMessage());
            }
            catch (IOException e) {
                throw new SmartSyncXMLParseException(e.getMessage());
            }
            catch (Exception e) {
                throw e;
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                if (reader == null) throw throwable;
                reader.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        if (reader == null) return doc;
        reader.close();
        return doc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document _getDocument(String xmlAsString) throws SmartSyncXMLParseException, Exception {
        Document doc = null;
        StringReader reader = null;
        try {
            try {
                DocumentBuilder builder = SmartSyncXMLUtil._getDocumentBuilder();
                builder.setErrorHandler(new MyErrorHandler());
                reader = new StringReader(xmlAsString);
                InputSource source = new InputSource(reader);
                doc = builder.parse(source);
            }
            catch (SAXException e) {
                throw new SmartSyncXMLParseException(e.getMessage());
            }
            catch (IllegalArgumentException e) {
                throw new SmartSyncXMLParseException(e.getMessage());
            }
            catch (IOException e) {
                throw new SmartSyncXMLParseException(e.getMessage());
            }
            catch (Exception e) {
                throw e;
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                if (reader == null) throw throwable;
                reader.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        if (reader == null) return doc;
        reader.close();
        return doc;
    }

    public static Document getDocument(String rootName) throws SmartSyncXMLParseException, Exception {
        Document doc;
        try {
            DocumentBuilder builder = SmartSyncXMLUtil._getDocumentBuilder();
            DOMImplementation impl = builder.getDOMImplementation();
            doc = impl.createDocument(null, rootName, null);
        }
        catch (SmartSyncXMLParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        return doc;
    }

    public static Element getRootElement(InputStream xmlAsByteArray) throws Exception {
        Element root = null;
        Document doc = SmartSyncXMLUtil._getDocument(xmlAsByteArray);
        root = doc.getDocumentElement();
        return root;
    }

    public static Element getRootElement(String xmlAsString) throws SmartSyncXMLParseException, Exception {
        Element root = null;
        try {
            Document doc = SmartSyncXMLUtil._getDocument(xmlAsString);
            root = doc.getDocumentElement();
        }
        catch (SmartSyncXMLParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        return root;
    }

    public static Element getRootElement(Document doc) throws Exception {
        Element root = null;
        root = doc.getDocumentElement();
        return root;
    }

    public static void save2File(Document doc, String file_name) throws Exception {
        SmartSyncXMLUtil.save2File((Node)doc, file_name);
    }

    public static void save2File(Node node, String file_name) throws Exception {
        TransformerFactory tfactory = TransformerFactory.newInstance();
        Transformer tformer = tfactory.newTransformer();
        DOMSource source = new DOMSource(node);
        StreamResult result = new StreamResult(new FileWriter(file_name));
        tformer.transform(source, result);
    }

    public static String elementToString(Element node) {
        try {
            TransformerFactory tfactory = TransformerFactory.newInstance();
            Transformer tformer = tfactory.newTransformer();
            DOMSource source = new DOMSource(node);
            StringWriter rnt = new StringWriter();
            StreamResult result = new StreamResult(rnt);
            tformer.transform(source, result);
            return rnt.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getNodeType(Node node) {
        if (node.getNodeType() == 2) {
            return "Attr";
        }
        if (node.getNodeType() == 4) {
            return "CDATASection";
        }
        if (node.getNodeType() == 8) {
            return "Comment";
        }
        if (node.getNodeType() == 11) {
            return "DocumentFragment";
        }
        if (node.getNodeType() == 9) {
            return "Document";
        }
        if (node.getNodeType() == 10) {
            return "DocumentType";
        }
        if (node.getNodeType() == 1) {
            return "Element";
        }
        if (node.getNodeType() == 6) {
            return "Entity";
        }
        if (node.getNodeType() == 5) {
            return "EntityReference";
        }
        if (node.getNodeType() == 12) {
            return "Notation";
        }
        if (node.getNodeType() == 7) {
            return "ProcessingInstruction";
        }
        if (node.getNodeType() == 3) {
            return "Text";
        }
        return "Obscure";
    }

    static class MyErrorHandler
    implements ErrorHandler {
        MyErrorHandler() {
        }

        public void warning(SAXParseException e) throws SAXException {
            TRACE.log(60, "**Parsing Warning**" + this._getMessage(e));
            throw new SAXException("Warning encountered");
        }

        public void error(SAXParseException e) throws SAXException {
            TRACE.log(50, "**Parsing Error**" + this._getMessage(e));
            throw new SAXException("Error encountered");
        }

        public void fatalError(SAXParseException e) throws SAXException {
            TRACE.log(10, "**Parsing Fatal Error**" + this._getMessage(e));
            throw new SAXException("Fatal Error encountered");
        }

        private String _getMessage(SAXParseException e) {
            String msg = " Line:" + e.getLineNumber() + " URI:" + e.getSystemId() + " Message: " + e.getMessage();
            return msg;
        }
    }
}

