/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.util;

import com.sap.ip.me.api.smartsync.BasisFieldType;
import com.sap.ip.me.api.smartsync.DependencyType;
import com.sap.ip.me.api.smartsync.FieldInputQualifyType;
import com.sap.ip.me.api.smartsync.SyncProcessingType;
import com.sap.ip.me.api.smartsync.SyncReplyType;
import com.sap.ip.me.smartsync.util.SmartSyncXMLUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SmartSyncXMLParser
extends SmartSyncXMLUtil {
    public static Element[] getChildElements(Element parent, String tagName) throws Exception {
        NodeList children = parent.getChildNodes();
        int max = children.getLength();
        Vector<Element> entry = new Vector<Element>(max);
        int i = 0;
        while (i < max) {
            Element element;
            String name;
            Node node = children.item(i);
            if (node instanceof Element && (name = (element = (Element)node).getTagName()).equals(tagName)) {
                entry.addElement(element);
            }
            ++i;
        }
        int size = entry.size();
        Element[] result = new Element[size];
        int i2 = 0;
        while (i2 < size) {
            result[i2] = (Element)entry.elementAt(i2);
            ++i2;
        }
        return result;
    }

    public static String getRequiredAttribute(Element root, String tagName) throws Exception {
        try {
            String attValue = SmartSyncXMLParser.getAttrAsString(root, tagName);
            if (attValue == null || "".equals(attValue)) {
                throw new Exception("Required attribute <" + tagName + "> is missing.");
            }
            return attValue;
        }
        catch (Exception e) {
            String msg = "Required attribute <" + tagName + "> is missing.";
            throw new Exception(msg);
        }
    }

    public static boolean getRequiredAttributeAsBoolean(Element element, String name) throws Exception {
        return SmartSyncXMLParser.getRequiredAttribute(element, name).equals("true");
    }

    public static Integer getRequiredAttributeAsIntegerObject(Element element, String name) throws Exception {
        String value = null;
        try {
            value = SmartSyncXMLParser.getAttrAsString(element, name);
            value = value.trim();
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            String tag = element.getTagName();
            throw new Exception("tag/name/value:" + tag + "/" + name + "/" + value);
        }
    }

    public static String getOptionalAttribute(Element root, String tagName) {
        try {
            return SmartSyncXMLParser.getAttrAsString(root, tagName);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static int getOptionalIntegerAttribute(Element root, String tagName, int defaultValue) {
        try {
            return SmartSyncXMLParser.getAttrAsInt(root, tagName);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Integer getOptionalIntegerObjectAttribute(Element root, String tagName, int defaultValue) {
        return new Integer(SmartSyncXMLParser.getOptionalIntegerAttribute(root, tagName, defaultValue));
    }

    public static boolean getOptionalBooleanAttribute(Element root, String tagName) {
        try {
            return SmartSyncXMLParser.getAttrAsBoolean(root, tagName);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Boolean getOptionalBooleanObjectAttribute(Element root, String tagName) {
        return new Boolean(SmartSyncXMLParser.getOptionalBooleanAttribute(root, tagName));
    }

    public static String getOptionalValue(Element element) {
        try {
            return SmartSyncXMLParser.getValue(element);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Element getChildElement(Element parent, String tagName) throws Exception {
        Element[] elts = SmartSyncXMLParser.getChildElements(parent, tagName);
        if (elts.length > 0) {
            return elts[0];
        }
        return null;
    }

    public static Element getFirstChild(Element root) throws Exception {
        Element child = null;
        NodeList list = root.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            short type = node.getNodeType();
            if (1 == type) {
                child = (Element)node;
                break;
            }
            ++i;
        }
        return child;
    }

    public static String getValue(Element element) throws Exception {
        String value = null;
        value = element.getFirstChild().getNodeValue();
        return value;
    }

    public static boolean getValueAsBoolean(Element element) throws Exception {
        boolean value = false;
        String flag = SmartSyncXMLParser.getValue(element);
        if ("true".equals(flag)) {
            return true;
        }
        return value;
    }

    public static boolean isCreateInputQualityType(Element element, String name) throws Exception {
        String inputType = SmartSyncXMLParser.getAttrAsString(element, name);
        if ("create".equals(inputType)) {
            return true;
        }
        return false;
    }

    public static FieldInputQualifyType getValueAsFieldInputQualityType(Element element) throws Exception {
        FieldInputQualifyType type = FieldInputQualifyType.FORBIDDEN;
        if (SmartSyncXMLParser.getValueAsBoolean(element)) {
            return FieldInputQualifyType.MANDATORY;
        }
        return type;
    }

    public static String getChildValue(Element element) throws Exception {
        String value = null;
        try {
            value = element.getFirstChild().getNodeValue();
        }
        catch (Exception e) {
            return null;
        }
        return value;
    }

    public static String getChildAsString(Element element, String name) throws Exception {
        String value = null;
        try {
            value = SmartSyncXMLParser.getChildElements(element, name)[0].getFirstChild().getNodeValue();
        }
        catch (Exception e) {
            String tag = element.getTagName();
            throw new Exception("tag/name/value:" + tag + "/" + name + "/" + value);
        }
        return value;
    }

    public static int getChildAsInt(Element element, String name) throws Exception {
        String value = null;
        try {
            value = SmartSyncXMLParser.getChildAsString(element, name);
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            String tag = element.getTagName();
            throw new Exception("tag/name/value:" + tag + "/" + name + "/" + value);
        }
        catch (Exception e) {
            throw e;
        }
    }

    public static boolean getChildAsBoolean(Element element, String name) throws Exception {
        String value = null;
        try {
            value = SmartSyncXMLParser.getChildAsString(element, name);
            if ("true".equals(value)) {
                return true;
            }
        }
        catch (Exception e) {
            String tag = element.getTagName();
            throw new Exception("tag/name/value:" + tag + "/" + name + "/" + value);
        }
        return false;
    }

    public static String getAttrAsString(Element element, String name) throws Exception {
        String value = null;
        try {
            value = element.getAttribute(name);
        }
        catch (Exception e) {
            String tag = element.getTagName();
            throw new Exception("tag/name/value:" + tag + "/" + name + "/" + value);
        }
        return value;
    }

    public static int getAttrAsInt(Element element, String name) throws Exception {
        String value = null;
        try {
            value = SmartSyncXMLParser.getAttrAsString(element, name);
            value = value.trim();
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            String tag = element.getTagName();
            throw new Exception("tag/name/value:" + tag + "/" + name + "/" + value);
        }
        catch (Exception e) {
            throw e;
        }
    }

    public static Integer getAttrAsIntegerObject(Element element, String name) throws Exception {
        String value = null;
        try {
            value = SmartSyncXMLParser.getAttrAsString(element, name);
            value = value.trim();
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            String tag = element.getTagName();
            throw new Exception("tag/name/value:" + tag + "/" + name + "/" + value);
        }
        catch (Exception e) {
            throw e;
        }
    }

    public static Date getAttrAsDate(Element element, String name) throws Exception {
        String value = null;
        try {
            value = SmartSyncXMLParser.getAttrAsString(element, name);
            String year = value.substring(0, 4);
            String month = value.substring(4, 6);
            String day = value.substring(6);
            Calendar cal = Calendar.getInstance();
            cal.set(2, new Integer(month) - 1);
            cal.set(5, new Integer(day));
            cal.set(1, new Integer(year));
            return cal.getTime();
        }
        catch (NumberFormatException e) {
            String tag = element.getTagName();
            throw new Exception("tag/name/value:" + tag + "/" + name + "/" + value);
        }
        catch (Exception e) {
            throw e;
        }
    }

    public static boolean getAttrAsBoolean(Element element, String name) throws Exception {
        String value = null;
        try {
            value = SmartSyncXMLParser.getAttrAsString(element, name);
            if ("true".equals(value)) {
                return true;
            }
        }
        catch (Exception e) {
            String tag = element.getTagName();
            throw new Exception("tag/name/value:" + tag + "/" + name + "/" + value);
        }
        return false;
    }

    public static Boolean getAttrAsBooleanObject(Element element, String name) throws Exception {
        return new Boolean(SmartSyncXMLParser.getAttrAsBoolean(element, name));
    }

    public static SyncReplyType getAttrAsSyncReplyType(Element element, String name) throws Exception {
        SyncReplyType type = null;
        String value = null;
        try {
            value = SmartSyncXMLParser.getAttrAsString(element, name);
            type = SyncReplyType.forString(value);
            if (type == null) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            String tag = element.getTagName();
            throw new Exception("tag/name/value:" + tag + "/" + name + "/" + value);
        }
        return type;
    }

    public static BasisFieldType getAttrAsBasisFieldType(Element element, String name) throws Exception {
        BasisFieldType type = null;
        String value = null;
        try {
            value = SmartSyncXMLParser.getAttrAsString(element, name);
            Hashtable<String, BasisFieldType> types = new Hashtable<String, BasisFieldType>();
            types.put("C", BasisFieldType.C);
            types.put("D", BasisFieldType.D);
            types.put("P", BasisFieldType.P);
            types.put("N", BasisFieldType.N);
            types.put("T", BasisFieldType.T);
            type = (BasisFieldType)types.get(value);
            if (type == null) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            String tag = element.getTagName();
            throw new Exception("tag/name/value:" + tag + "/" + name + "/" + value);
        }
        return type;
    }

    public static BasisFieldType getRequiredAttributeAsBasisFieldType(Element element, String name) throws Exception {
        return BasisFieldType.forString(SmartSyncXMLParser.getRequiredAttribute(element, name));
    }

    public static DependencyType getAttrAsDependencyType(Element element, String name) throws Exception {
        DependencyType type = null;
        String value = null;
        try {
            value = SmartSyncXMLParser.getAttrAsString(element, name);
            Hashtable<String, DependencyType> types = new Hashtable<String, DependencyType>();
            types.put("independent", DependencyType.INDEPENDENT);
            types.put("relatingDependent", DependencyType.RELATING_DEPENDENT);
            types.put("relatedDependent", DependencyType.RELATED_DEPENDENT);
            type = (DependencyType)types.get(value);
            if (type == null) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            String tag = element.getTagName();
            throw new Exception("tag/name/value:" + tag + "/" + name + "/" + value);
        }
        return type;
    }

    public static SyncProcessingType getAttrAsSyncProcessingType(Element element, String name) throws Exception {
        SyncProcessingType type = null;
        String value = null;
        try {
            value = SmartSyncXMLParser.getAttrAsString(element, name);
            Hashtable<String, SyncProcessingType> types = new Hashtable<String, SyncProcessingType>();
            types.put("download", SyncProcessingType.DOWNLOAD);
            types.put("upload", SyncProcessingType.UPLOAD);
            types.put("twoWay", SyncProcessingType.TWO_WAY);
            types.put("timedTwoWay", SyncProcessingType.TIMED_TWO_WAY);
            types.put("local", SyncProcessingType.LOCAL);
            type = (SyncProcessingType)types.get(value);
            if (type == null) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            String tag = element.getTagName();
            throw new Exception("tag/name/value:" + tag + "/" + name + "/" + value);
        }
        return type;
    }

    public static SyncProcessingType getRequiredAttributeAsSyncProcessingType(Element element, String name) throws Exception {
        return SyncProcessingType.forString(SmartSyncXMLParser.getRequiredAttribute(element, name));
    }
}

