/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Random;

public class SmartSyncUtil {
    private static final SimpleDateFormat DATEFORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS");
    private static final SimpleDateFormat FILENAMEFORMAT = new SimpleDateFormat("yyyyMMdd_HHmmss_SSS");
    private static Random rn = new Random();

    public static String insertLeadingZeros(String in, int len) {
        if (in.startsWith("-")) {
            return in;
        }
        if (in.getBytes().length >= len) {
            return in.substring(0, len);
        }
        StringBuffer sb = new StringBuffer(in);
        int i = in.getBytes().length;
        while (i < len) {
            sb.insert(0, '0');
            ++i;
        }
        return sb.toString();
    }

    public static void writeFile(String filePath, String data) throws IOException {
        SmartSyncUtil.writeFile(filePath, data, false);
    }

    public static void writeFile(String filePath, String data, boolean append) throws IOException {
        OutputStreamWriter fw = null;
        try {
            File f = new File(new File(filePath).getParent());
            if (!f.exists()) {
                f.mkdirs();
            }
            fw = new FileWriter(filePath, append);
            if (append) {
                fw.write('[' + SmartSyncUtil.getCurrentTime() + "]\n");
            }
            fw.write(data);
            fw.write(10);
            fw.flush();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                if (fw != null) {
                    fw.close();
                }
            }
            catch (IOException e1) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (fw != null) {
                fw.close();
            }
        }
        catch (IOException e1) {}
    }

    public static void writeFile(String filePath, String message, Throwable t, boolean append) throws IOException {
        PrintWriter p = null;
        try {
            File f = new File(new File(filePath).getParent());
            if (!f.exists()) {
                f.mkdirs();
            }
            p = new PrintWriter(new FileOutputStream(filePath, append));
            if (append) {
                p.write('[' + SmartSyncUtil.getCurrentTime() + "]\n");
            }
            p.write(message);
            t.printStackTrace(p);
            p.flush();
            Object var7_6 = null;
            if (p != null) {
                p.close();
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (p != null) {
                p.close();
            }
            throw throwable;
        }
    }

    public static String readFile(String directory, String name) throws IOException {
        String res = "";
        File f = new File(directory, name);
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(f));
            res = br.readLine();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e1) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (br != null) {
                br.close();
            }
        }
        catch (IOException e1) {}
        return res;
    }

    public static String readStream(InputStream in) throws IOException {
        String res = "";
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(in));
            res = br.readLine();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e1) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (br != null) {
                br.close();
            }
        }
        catch (IOException e1) {}
        return res;
    }

    public static String getCurrentTime() {
        return DATEFORMAT.format(new Date());
    }

    public static String getTimeFileName() {
        return FILENAMEFORMAT.format(new Date());
    }

    public static String generateGUID() {
        return SmartSyncUtil.randomAlphaNumericOfLength(32);
    }

    public static int randomCharacterBetween(int lo, int hi) {
        int n = hi - lo + 1;
        int i = rn.nextInt() % n;
        if (i < 0) {
            i = -i;
        }
        n = lo + i;
        return n;
    }

    public static int randomAlphaNumeric(int lo, int hi) {
        int n = SmartSyncUtil.randomCharacterBetween(lo, hi);
        if (n >= 58 && n <= 64 || n >= 91 && n <= 96) {
            n = SmartSyncUtil.randomAlphaNumeric(lo, hi);
        }
        return n;
    }

    public static String randomStringOfLength(int length, char lo, char hi) {
        if (length <= 0) {
            return "";
        }
        char[] b = new char[length];
        int i = 0;
        while (i < length) {
            b[i] = (char)SmartSyncUtil.randomCharacterBetween(lo, hi);
            ++i;
        }
        return new String(b);
    }

    public static String randomAlphaNumericOfLength(int length) {
        if (length <= 0) {
            return "";
        }
        char[] b = new char[length];
        int i = 0;
        while (i < length) {
            b[i] = (char)SmartSyncUtil.randomAlphaNumeric(48, 122);
            ++i;
        }
        return new String(b);
    }

    public static void saveObject(String directory, String objecName, Object object) throws IOException {
        SmartSyncUtil.saveObject(new File(directory), objecName, object);
    }

    public static void saveObject(File directory, String objecName, Object object) throws IOException {
        if (!directory.exists()) {
            directory.mkdirs();
        }
        File f = new File(directory, objecName);
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(f.getAbsolutePath()));
        try {
            oos.writeObject(object);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            oos.close();
            throw throwable;
        }
        oos.close();
    }

    public static Object readObject(String directory, String objecName) throws IOException, ClassNotFoundException {
        File f = new File(directory, objecName);
        if (!f.isFile()) {
            return null;
        }
        return SmartSyncUtil.readObject(f);
    }

    public static Object readObject(File filePath) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(filePath.getAbsolutePath()));
        Object obj = null;
        try {
            obj = ois.readObject();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ois.close();
            throw throwable;
        }
        ois.close();
        return obj;
    }

    public static void removeObject(String directory, String objecName) {
        File f = new File(directory, objecName);
        if (f.exists() && f.isFile()) {
            f.delete();
        }
    }

    public static void removeObject(File directory, String objecName) {
        File f = new File(directory, objecName);
        if (f.exists() && f.isFile()) {
            f.delete();
        }
    }

    public static void removeObjects(File directory) {
        String[] files = SmartSyncUtil.listObjects(directory);
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                SmartSyncUtil.removeObject(directory, files[i]);
                ++i;
            }
        }
    }

    public static void removeAllObjects(String directory) {
        String[] objects = SmartSyncUtil.listObjects(directory);
        if (objects == null) {
            return;
        }
        int i = 0;
        while (i < objects.length) {
            String path = directory + File.separatorChar + objects[i];
            File f = new File(path);
            if (f.isDirectory()) {
                SmartSyncUtil.removeAllObjects(path);
            }
            f.delete();
            ++i;
        }
    }

    public static Hashtable readObjects(String directory) throws IOException, ClassNotFoundException {
        return SmartSyncUtil.readObjects(new File(directory));
    }

    public static Hashtable readObjects(File directory) throws IOException, ClassNotFoundException {
        String[] objectNames = SmartSyncUtil.listObjects(directory);
        if (objectNames == null) {
            return new Hashtable();
        }
        Hashtable<String, Object> table = new Hashtable<String, Object>(objectNames.length);
        int i = 0;
        while (i < objectNames.length) {
            File f = new File(directory, objectNames[i]);
            if (f.isFile()) {
                Object object = SmartSyncUtil.readObject(f);
                table.put(objectNames[i], object);
            }
            ++i;
        }
        return table;
    }

    public static String[] listObjects(String directory) {
        return SmartSyncUtil.listObjects(new File(directory));
    }

    public static String[] listObjects(File directory) {
        if (directory.exists() && directory.isDirectory()) {
            return directory.list();
        }
        return null;
    }
}

