/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.util;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.smartsync.util.SmartSyncUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;

public class SmartSyncCache {
    protected Hashtable pool = new Hashtable();
    protected String currentKey = "";
    protected Object currentObject = null;

    SmartSyncCache() {
    }

    public boolean containsKey(String key) {
        if (key == null) {
            return false;
        }
        return this.pool.containsKey(key);
    }

    public void remove(String key) {
        if (key == null) {
            return;
        }
        this.pool.remove(key);
        if (key.equals(this.currentKey)) {
            this.currentKey = "";
        }
    }

    public void add(String key, Object value) {
        if (key == null || value == null) {
            return;
        }
        this.pool.put(key, value);
        this.setCurrentKey(key);
    }

    public void setCurrentKey(String key) {
        this.currentKey = key;
        this.currentObject = this.get(this.currentKey);
    }

    public Object getCurrentObject() {
        return this.currentObject;
    }

    public Object get(String key) {
        if (key == null) {
            return null;
        }
        return this.pool.get(key);
    }

    public String getCurrentKey() {
        return this.currentKey;
    }

    public boolean isCurrentKey(String key) {
        return this.currentKey.equals(key);
    }

    public void init() {
        this.currentKey = "";
        this.currentObject = null;
        this.pool.clear();
    }

    public static SmartSyncCache newInstance() {
        return new SmartSyncCache();
    }

    public static SmartSyncCache newInstance(String directoryPath) {
        return new SmartSyncSerializedCache(directoryPath);
    }

    static class SmartSyncSerializedCache
    extends SmartSyncCache {
        private File storeFolder;

        SmartSyncSerializedCache(String dirPath) {
            if (dirPath == null) {
                throw new NullPointerException("Target directory is null");
            }
            this.storeFolder = new File(dirPath);
            this.initialize();
        }

        private void initialize() {
            if (this.storeFolder.exists()) {
                try {
                    this.pool = SmartSyncUtil.readObjects(this.storeFolder);
                }
                catch (Exception exception) {}
            } else {
                this.storeFolder.mkdirs();
            }
        }

        public void remove(String key) {
            if (!this.containsKey(key)) {
                return;
            }
            super.remove(key);
            SmartSyncUtil.removeObject(this.storeFolder, key);
        }

        public void add(String key, Object value) {
            if (this.containsKey(key)) {
                return;
            }
            if (value instanceof Serializable) {
                try {
                    SmartSyncUtil.saveObject(this.storeFolder, key, value);
                }
                catch (IOException e) {
                    Trace.getInstance("MI/Smartsync").logException(60, "Can not serialize Object of class " + value.getClass().getName(), e, false);
                }
            }
            super.add(key, value);
        }

        public void init() {
            super.init();
            this.initialize();
        }
    }
}

