/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.sync.out;

import com.sap.ip.me.api.smartsync.SyncBoDescriptor;
import com.sap.ip.me.api.smartsync.SyncBoOutDelta;
import com.sap.ip.me.api.smartsync.SyncBoOutDeltaNotifier;
import com.sap.ip.me.api.smartsync.SyncBoOutDeltaObserver;
import com.sap.ip.me.core.ConversationId;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.smartsync.sync.SyncPackageManager;
import com.sap.ip.me.smartsync.util.SmartSyncCache;
import com.sap.ip.me.smartsync.util.XTrace;

public class SyncBoOutDeltaNotifierImpl
implements SyncBoOutDeltaNotifier {
    private SmartSyncCache pool = SmartSyncCache.newInstance(SyncPackageManager.getOutDeltaObserverDirName());
    private static XTrace TRACE = SyncPackageManager.getTrace();

    public void registerSyncBoOutDeltaObserver(SyncBoOutDeltaObserver syncBoOutDeltaObserver) {
        this.pool.add(this.getConvId().getId(), syncBoOutDeltaObserver);
    }

    private ConversationId getConvId() {
        return ConversationIdHandler.getInstance().getCurrentConversationId();
    }

    public void unregisterSyncBoOutDeltaObserver(SyncBoOutDeltaObserver syncBoOutDeltaObserver) {
        this.pool.remove(this.getConvId().getId());
    }

    public void notifySyncBoOutDeltaObservers(ConversationId convId, SyncBoOutDelta syncBoOutDelta) {
        String target = syncBoOutDelta.getSyncBoDescriptor().getSyncBoName();
        if (!this.pool.containsKey(convId.getId())) {
            return;
        }
        SyncBoOutDeltaObserver obv = (SyncBoOutDeltaObserver)this.pool.get(convId.getId());
        if (obv == null) {
            return;
        }
        SyncBoDescriptor[] syncBoDescriptors = obv.observeSyncBoTypes();
        if (syncBoDescriptors == null || syncBoDescriptors.length == 0) {
            return;
        }
        int i = 0;
        while (i < syncBoDescriptors.length) {
            block8: {
                String boName = syncBoDescriptors[i].getSyncBoName();
                if (target.equals(boName)) {
                    try {
                        obv.sendingSyncBoOutDelta(syncBoOutDelta);
                    }
                    catch (Exception e) {
                        if (TRACE.isLogging()) {
                            TRACE.log("Ignoring Exception during SyncBoOutDelta notification for syncBo <" + target + ">.", e);
                        }
                        if (!TRACE.isDebugMode()) break block8;
                        TRACE.logError("Exception during SyncBoOutDelta notification for syncBo <" + boName + ">.", e);
                    }
                }
            }
            ++i;
        }
    }
}

