/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.sync.out;

import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.smartsync.FieldDescriptor;
import com.sap.ip.me.api.smartsync.FieldDescriptorIterator;
import com.sap.ip.me.api.smartsync.RowChange;
import com.sap.ip.me.api.smartsync.RowChangeActionType;
import com.sap.ip.me.api.smartsync.RowDescriptor;
import com.sap.ip.me.api.smartsync.SyncBoChangeActionType;
import com.sap.ip.me.api.smartsync.SyncBoDeltaRequest;
import com.sap.ip.me.api.smartsync.SyncBoDeltaRequestType;
import com.sap.ip.me.api.smartsync.SyncBoOutDelta;
import com.sap.ip.me.api.smartsync.SyncBoOutDeltaSendType;
import com.sap.ip.me.core.ConversationId;
import com.sap.ip.me.smartsync.ipi.InterDataPackageManager;
import com.sap.ip.me.smartsync.ipi.InternalSyncBoDataFacade;
import com.sap.ip.me.smartsync.sync.OutboundTransformException;
import com.sap.ip.me.smartsync.sync.ResetStatusRepository;
import com.sap.ip.me.smartsync.sync.SmartSynchronizationException;
import com.sap.ip.me.smartsync.sync.SyncPackageManager;
import com.sap.ip.me.smartsync.sync.out.OutboundMessage;
import com.sap.ip.me.smartsync.util.XTrace;
import java.util.Vector;

public class OutboundProcessor {
    private static XTrace TRACE = SyncPackageManager.getTrace();
    private final InterDataPackageManager DATA_MGR;

    public OutboundProcessor(InterDataPackageManager dataPkgMgr) {
        this.DATA_MGR = dataPkgMgr;
    }

    public OutboundMessage createResetRequest(ConversationId convId) throws OutboundTransformException, SmartSynchronizationException {
        InternalSyncBoDataFacade dataFacade = null;
        try {
            dataFacade = this.DATA_MGR.getInternalSyncBoDataFacade();
            dataFacade.setModificationLock();
            OutboundMessage request = OutboundMessage.createResetRequest();
            ResetStatusRepository.getInstance().enableResetMode(convId.getId(), request.getMessageId());
            return request;
        }
        catch (Exception e) {
            block6: {
                try {
                    if (dataFacade != null) {
                        dataFacade.releaseModificationLock();
                    }
                }
                catch (PersistenceException e1) {
                    if (!TRACE.isDebugMode()) break block6;
                    TRACE.logError("[PersistenceException during releaseModificationLock for ConvID <" + convId + ">.", e);
                }
            }
            if (TRACE.isDebugMode()) {
                TRACE.logError("[Exception during createResetRequest for ConvID <" + convId + ">.", e);
            }
            throw new SmartSynchronizationException("Could not create a ResetRequest.", e);
        }
    }

    public OutboundMessage createDownloadRequest(SyncBoDeltaRequest deltaRequest) throws OutboundTransformException, SmartSynchronizationException {
        boolean isDirectSync = this.isDirectSync(deltaRequest);
        String boName = deltaRequest.getSyncBoDescriptor().getSyncBoName();
        try {
            return OutboundMessage.createDeltaDownloadRequest(isDirectSync, boName);
        }
        catch (Exception e) {
            if (TRACE.isDebugMode()) {
                TRACE.logError("[Exception during createDownloadRequest for SyncBo <" + boName + ">.", e);
            }
            throw new SmartSynchronizationException("Could not create a DownloadRequest", e);
        }
    }

    public OutboundMessage createDeltaUploadRequest(SyncBoOutDelta delta) throws OutboundTransformException, SmartSynchronizationException {
        boolean isDirectSync = this.isDirectSync(delta);
        SyncBoChangeActionType action = delta.getAction();
        String type = delta.getSyncBoDescriptor().getSyncBoName();
        String id = delta.getSyncKey().toString();
        try {
            OutboundMessage request = OutboundMessage.createDeltaUploadRequest(isDirectSync, type, id, action);
            request.appendStateId("PreStateID", delta.getStateId());
            request.appendStateId("PostStateID", request.getMessageId());
            MeIterator rowItr = delta.getRowChanges();
            while (rowItr.hasNext()) {
                RowChange rowChange = (RowChange)rowItr.next();
                RowChangeActionType rowAction = rowChange.getAction();
                if (rowAction == RowChangeActionType.NOOPER) continue;
                RowDescriptor rowDesc = rowChange.getRowDescriptor();
                if (rowDesc.isTop()) {
                    if (rowAction == RowChangeActionType.DELETE) continue;
                    String[] fields = this.constractFieldArray(rowDesc, rowChange.getChangedFieldValues());
                    request.appendFields(fields);
                    continue;
                }
                String rowName = rowDesc.getRowName();
                String rowId = rowChange.getSyncKey().toString();
                if (rowAction == RowChangeActionType.DELETE) {
                    request.appendChildDelta(rowName, rowId, rowAction, null);
                    continue;
                }
                String[] fields = this.constractFieldArray(rowDesc, rowChange.getChangedFieldValues());
                request.appendChildDelta(rowName, rowId, rowAction, fields);
            }
            return request;
        }
        catch (Exception e) {
            if (TRACE.isDebugMode()) {
                TRACE.logError("[Exception during createDeltaUploadRequest for SyncBo <" + type + ">, SyncKey <" + id + ">, Action <" + action.toString() + ">.", e);
            }
            throw new SmartSynchronizationException("Could not create DeltaUploadRequest", e);
        }
    }

    private boolean isDirectSync(SyncBoDeltaRequest request) {
        if (request.getProcessing() == SyncBoDeltaRequestType.DEFAULT) {
            return request.getSyncBoDescriptor().isRequiredDirectSync();
        }
        return request.getProcessing() == SyncBoDeltaRequestType.DIRECT_REQUEST;
    }

    private boolean isDirectSync(SyncBoOutDelta delta) {
        if (delta.getSendType() == SyncBoOutDeltaSendType.DEFAULT) {
            return delta.getSyncBoDescriptor().isRequiredDirectSync();
        }
        return delta.getSendType() == SyncBoOutDeltaSendType.SEND_DIRECT;
    }

    private String[] constractFieldArray(RowDescriptor rowDesc, MeIterator itr) {
        FieldDescriptorIterator fitr = rowDesc.getAllFieldDescriptors();
        Vector<String> list = new Vector<String>(rowDesc.getFieldCount() - 1);
        int i = 0;
        while (itr.hasNext()) {
            FieldDescriptor fieldDesc = fitr.next();
            Object field = itr.next();
            if (fieldDesc.isKey()) continue;
            list.insertElementAt(fieldDesc.to25String(field), i++);
        }
        String[] fields = new String[list.size()];
        int i2 = 0;
        while (i2 < list.size()) {
            fields[i2] = (String)list.elementAt(i2);
            ++i2;
        }
        return fields;
    }
}

