/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.sync.out;

import com.sap.ip.me.api.smartsync.RowChangeActionType;
import com.sap.ip.me.api.smartsync.SyncBoChangeActionType;
import com.sap.ip.me.smartsync.sync.OutboundTransformException;
import com.sap.ip.me.smartsync.util.SmartSyncUtil;
import com.sap.ip.me.smartsync.util.SmartSyncXMLBuilder;
import com.sap.ip.me.smartsync.util.SmartSyncXMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OutboundMessage
extends SmartSyncXMLBuilder {
    private Document doc;
    private Element root;
    private String id;

    OutboundMessage(boolean isDirectSync) throws OutboundTransformException {
        try {
            this.id = SmartSyncUtil.generateGUID();
            this.doc = SmartSyncXMLUtil.getDocument("Message");
            this.root = this.doc.getDocumentElement();
            this.root.setAttribute("xmlns", "http://www.sap.com/ip/me/smartsync/data");
            this.root.setAttribute("schemaVersion", "2.0");
            this.root.setAttribute("clientID", "");
            this.root.setAttribute("id", this.id);
            this.root.setAttribute("synchronous", String.valueOf(isDirectSync));
        }
        catch (Exception e) {
            throw new OutboundTransformException("Failed to initialized XML document.Node Name: <Message>", e);
        }
    }

    public String getMessageId() {
        return this.id;
    }

    void appendElement(Element childElement) throws OutboundTransformException {
        try {
            this.root.appendChild(childElement);
        }
        catch (Exception e) {
            throw new OutboundTransformException("Failed to append a child element.Child Element: <" + SmartSyncXMLUtil.elementToString(childElement) + ">", e);
        }
    }

    Element createElement(String name) throws OutboundTransformException {
        try {
            return SmartSyncXMLBuilder.createElement(this.doc, name);
        }
        catch (Exception e) {
            throw new OutboundTransformException("Failed to create a child element.Child Name: <" + name + ">", e);
        }
    }

    Element createElement(String name, String value) throws OutboundTransformException {
        try {
            return SmartSyncXMLBuilder.createElement(this.doc, name, value);
        }
        catch (Exception e) {
            throw new OutboundTransformException("Failed to create a child element. Child Name: <" + name + "> Value: <" + value + ">", e);
        }
    }

    public String toXMLString() throws OutboundTransformException {
        try {
            return SmartSyncXMLBuilder.documentToString(this.doc);
        }
        catch (Exception e) {
            throw new OutboundTransformException("Failed to transform document to XML string.", e);
        }
    }

    void appendStateId(String nodeName, String stateId) throws OutboundTransformException {
    }

    void appendFields(String[] fields) throws OutboundTransformException {
    }

    void appendChildDelta(String type, String id, RowChangeActionType actionType, String[] fields) throws OutboundTransformException {
    }

    void setAttributes(Element target, String type, String id, String action) throws OutboundTransformException {
        try {
            target.setAttribute("objectType", type);
            target.setAttribute("objectID", id);
            target.setAttribute("action", action);
        }
        catch (Exception e) {
            throw new OutboundTransformException("Failed to set attributes. Attributes: type=" + type + " id= " + id + " action=" + action, e);
        }
    }

    void appendFields(Element target, String[] fields) throws OutboundTransformException {
        String fieldValue = "";
        try {
            int i = 0;
            while (i < fields.length) {
                fieldValue = fields[i];
                Element field = this.createElement("F", fieldValue);
                field.setAttribute("pos", "" + (i + 1));
                target.appendChild(field);
                ++i;
            }
        }
        catch (Exception e) {
            throw new OutboundTransformException("Failed to append a child element. <F>" + fieldValue + "</" + "F" + ">", e);
        }
    }

    public static OutboundMessage createResetRequest() {
        return new ResetRequest();
    }

    public static OutboundMessage createDeltaUploadRequest(boolean isDirectSync, String type, String id, SyncBoChangeActionType actionType) {
        return new DeltaUploadRequest(isDirectSync, type, id, actionType);
    }

    public static OutboundMessage createDeltaDownloadRequest(boolean isDirectSync, String boName) {
        return new DownloadRequest(isDirectSync, boName);
    }

    private static class DeltaUploadRequest
    extends OutboundMessage {
        private Element deltaRoot = this.createElement("Delta");

        public DeltaUploadRequest(boolean isDirectSync, String type, String id, SyncBoChangeActionType actionType) throws OutboundTransformException {
            super(isDirectSync);
            this.appendElement(this.deltaRoot);
            this.setAttributes(this.deltaRoot, type, id, actionType.toXMLString());
        }

        void appendStateId(String nodeName, String stateId) throws OutboundTransformException {
            Element state = this.createElement(nodeName, stateId);
            state.setAttribute("type", "changedID");
            this.deltaRoot.appendChild(state);
        }

        void appendFields(String[] fields) throws OutboundTransformException {
            this.appendFields(this.deltaRoot, fields);
        }

        void appendChildDelta(String type, String id, RowChangeActionType actionType, String[] fields) throws OutboundTransformException {
            Element child = this.createElement("Delta");
            String action = actionType.toXMLString();
            this.setAttributes(child, type, id, action);
            if (fields != null) {
                this.appendFields(child, fields);
            }
            this.deltaRoot.appendChild(child);
        }
    }

    private static class DownloadRequest
    extends OutboundMessage {
        private Element downloadRoot = this.createElement("DownloadRequest");

        public DownloadRequest(boolean isDirectSync, String boName) throws OutboundTransformException {
            super(isDirectSync);
            this.appendElement(this.downloadRoot);
            Element objectType = this.createElement("ObjectType", boName);
            this.downloadRoot.appendChild(objectType);
        }
    }

    private static class ResetRequest
    extends OutboundMessage {
        private Element resetRoot = this.createElement("Reset");

        public ResetRequest() throws OutboundTransformException {
            super(true);
            this.appendElement(this.resetRoot);
        }
    }
}

