/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.sync.in;

import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.smartsync.RowChange;
import com.sap.ip.me.api.smartsync.SyncBoChangeActionType;
import com.sap.ip.me.api.smartsync.SyncBoDescriptor;
import com.sap.ip.me.api.smartsync.SyncBoInDelta;
import com.sap.ip.me.api.smartsync.SyncReply;
import com.sap.ip.me.core.MeIteratorVectorImpl;
import com.sap.ip.me.smartsync.ipi.InternalRowChange;
import java.util.Vector;

class SyncBoInDeltaImpl
implements SyncBoInDelta {
    private final Object syncKey;
    private final SyncBoDescriptor boDesc;
    private final String timestamp;
    private final boolean isOnlySemanticKeys;
    private final SyncBoChangeActionType action;
    private SyncReply syncReply;
    private Vector childRows;
    private String preStateId;
    private String postStateId;

    SyncBoInDeltaImpl(String objectId, SyncBoDescriptor boDesc, boolean isOnlySemanticKeys, SyncBoChangeActionType action) {
        this.syncKey = objectId;
        this.boDesc = boDesc;
        this.isOnlySemanticKeys = isOnlySemanticKeys;
        this.timestamp = Long.toString(System.currentTimeMillis());
        this.action = action;
        this.childRows = new Vector();
    }

    void setTopRow(RowChange rowChange) {
        this.childRows.insertElementAt(rowChange, 0);
    }

    void addRowChange(InternalRowChange rowChange) {
        this.childRows.addElement(rowChange);
    }

    void setSyncReplyImpl(SyncReply syncReply) {
        this.syncReply = syncReply;
    }

    public boolean hasAction() {
        return this.action != null;
    }

    public boolean isOnlySemanticKeys() {
        return this.isOnlySemanticKeys;
    }

    public String getPostStateId() {
        return this.postStateId;
    }

    public String getPreStateId() {
        return this.preStateId;
    }

    public void setPostStateId(String postStateId) {
        this.postStateId = postStateId;
    }

    public void setPreStateId(String preStateId) {
        this.preStateId = preStateId;
    }

    public SyncReply getSyncReply() {
        return this.syncReply;
    }

    public String getTimeStamp() {
        return this.timestamp;
    }

    public SyncBoDescriptor getSyncBoDescriptor() {
        return this.boDesc;
    }

    public SyncBoChangeActionType getAction() {
        return this.action;
    }

    public MeIterator getRowChanges() {
        return new MeIteratorVectorImpl(this.childRows);
    }

    public Object getSyncKey() {
        return this.syncKey;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(500);
        sb.append("<SyncBoDelta syncKey=").append(this.getSyncKey().toString());
        sb.append(" type=").append(this.getSyncBoDescriptor().getSyncBoName());
        sb.append(" timeStamp=").append(this.getTimeStamp());
        sb.append(" preStateId=").append(this.getPreStateId());
        sb.append(" postStateId=").append(this.getPostStateId());
        if (this.hasAction()) {
            sb.append(" action=").append(this.getAction().toXMLString());
        }
        sb.append(">");
        if (this.getSyncReply() != null) {
            sb.append("<SyncReply ").append(this.getSyncReply().toString()).append("/>");
        }
        MeIterator rows = this.getRowChanges();
        while (rows.hasNext()) {
            sb.append("<RowDelta ").append(rows.next().toString()).append("/>");
        }
        return sb.toString();
    }
}

