/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.sync.in;

import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.smartsync.FieldDescriptor;
import com.sap.ip.me.api.smartsync.RowChangeActionType;
import com.sap.ip.me.api.smartsync.RowDescriptor;
import com.sap.ip.me.core.MeIteratorVectorImpl;
import com.sap.ip.me.smartsync.ipi.FieldChange;
import com.sap.ip.me.smartsync.ipi.InternalRowChange;
import com.sap.ip.me.smartsync.ipi.SelectableRowChange;
import java.util.Vector;

class RowChangeImpl
implements InternalRowChange {
    private Vector fieldValues;
    private String objectId;
    private RowChangeActionType action = null;
    private RowDescriptor rowDescriptor;

    RowChangeImpl(String objectId, RowDescriptor rowDesc, RowChangeActionType action) {
        this.objectId = objectId;
        this.rowDescriptor = rowDesc;
        this.action = action;
        this.fieldValues = new Vector(rowDesc.getFieldCount());
    }

    public RowChangeActionType getAction() {
        return this.action;
    }

    public Object getSyncKey() {
        return this.objectId;
    }

    public RowDescriptor getRowDescriptor() {
        return this.rowDescriptor;
    }

    public void addField(FieldDescriptor fieldDescriptor, String value) {
        this.addField(fieldDescriptor.to25Object(value));
    }

    void addField(Object fieldValue) {
        this.fieldValues.addElement(fieldValue);
    }

    public MeIterator getChangedFieldValues() {
        return new MeIteratorVectorImpl(this.fieldValues);
    }

    public boolean isSelectable() {
        return false;
    }

    static InternalRowChange createRowChange(String objectId, RowDescriptor rowDesc, RowChangeActionType action, boolean isSelectable) {
        return isSelectable ? new SelectableRowChangeImpl(objectId, rowDesc, action) : new RowChangeImpl(objectId, rowDesc, action);
    }

    private static class FieldChangeImpl
    implements FieldChange {
        private FieldDescriptor fieldDesc;
        private Object value;

        FieldChangeImpl(FieldDescriptor fieldDesc, Object value) {
            this.fieldDesc = fieldDesc;
            this.value = value;
        }

        public FieldDescriptor getFieldDescriptor() {
            return this.fieldDesc;
        }

        public Object getValue() {
            return this.value;
        }
    }

    private static class SelectableRowChangeImpl
    extends RowChangeImpl
    implements SelectableRowChange {
        private Vector fieldChanges = new Vector();

        SelectableRowChangeImpl(String objectId, RowDescriptor rowDesc, RowChangeActionType action) {
            super(objectId, rowDesc, action);
        }

        public MeIterator getFieldChanges() {
            return new MeIteratorVectorImpl(this.fieldChanges);
        }

        public void addField(FieldDescriptor fieldDescriptor, String value) {
            Object fieldValue = fieldDescriptor.to25Object(value);
            this.fieldChanges.addElement(new FieldChangeImpl(fieldDescriptor, fieldValue));
            super.addField(fieldValue);
        }

        public boolean isSelectable() {
            return true;
        }
    }
}

