/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.sync.in;

import com.sap.ip.me.api.smartsync.MessageReply;
import com.sap.ip.me.api.smartsync.MessageReplyType;
import com.sap.ip.me.api.smartsync.SyncReply;
import com.sap.ip.me.api.smartsync.SyncReplyType;

public class Reply {
    private final String type;
    private final String text;
    private final String msgClass;
    private final int number;
    public static MessageReply MESSAGEREPLY_901 = new MessageReplyImpl("SYNC_BEGIN", "Start SmartSync Synchronization", "SmartSync Client synchronization start 901", 901);
    public static MessageReply MESSAGEREPLY_902 = new MessageReplyImpl("SYNC_END", "End SmartSync Synchronization", "SmartSync Client synchronization end 902", 902);

    Reply(String mType, String mText, String mClass, int mNumber) {
        this.type = mType;
        this.text = mText;
        this.msgClass = mClass;
        this.number = mNumber;
    }

    public String getMessageClass() {
        return this.msgClass;
    }

    public String getText() {
        return this.text;
    }

    public String getStringType() {
        return this.type;
    }

    public int getNumber() {
        return this.number;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(250).append("type: ").append(this.type).append(" class: ").append(this.msgClass).append(" number: ").append(this.number).append(" text: ").append(this.text);
        return sb.toString();
    }

    static SyncReply createSyncReply(String type, String text, String mClass, int number) {
        return new SyncReplyImpl(type, text, mClass, number);
    }

    static MessageReply createMessageReply(String type, String text, String mClass, int number) {
        return new MessageReplyImpl(type, text, mClass, number);
    }

    private static class MessageReplyImpl
    extends Reply
    implements MessageReply {
        private final MessageReplyType mtype;

        public MessageReplyImpl(String type, String text, String mClass, int number) {
            super(type, text, mClass, number);
            this.mtype = MessageReplyType.forString(type);
        }

        public MessageReplyType getType() {
            return this.mtype;
        }

        public String getMsgClass() {
            return super.getMessageClass();
        }
    }

    private static class SyncReplyImpl
    extends Reply
    implements SyncReply {
        private final SyncReplyType rtype;

        SyncReplyImpl(String type, String text, String mClass, int number) {
            super(type, text, mClass, number);
            this.rtype = SyncReplyType.forString(type);
        }

        public SyncReplyType getType() {
            return this.rtype;
        }
    }
}

