/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.sync.in;

import com.sap.ip.me.api.smartsync.MessageReply;
import com.sap.ip.me.smartsync.ipi.InterSyncPackageManager;
import com.sap.ip.me.smartsync.ipi.MessageType;
import com.sap.ip.me.smartsync.sync.ResetStatusRepository;
import com.sap.ip.me.smartsync.sync.SmartSynchronizationException;
import com.sap.ip.me.smartsync.sync.SyncPackageManager;
import com.sap.ip.me.smartsync.sync.in.InboundMessage;
import com.sap.ip.me.smartsync.util.XTrace;

public class MessageReplyHelper
implements MessageType {
    private final InterSyncPackageManager syncManager;
    private static final XTrace TRACE = SyncPackageManager.getTrace();

    public MessageReplyHelper(InterSyncPackageManager syncMgr) {
        this.syncManager = syncMgr;
    }

    public void handleMessageReply(InboundMessage message) {
        int code = message.getType();
        switch (code) {
            case 6: {
                this.handleErrorReply(message);
                break;
            }
            case 5: {
                this.handleSuccessReply(message);
            }
        }
    }

    private void handleErrorReply(InboundMessage message) throws SmartSynchronizationException {
        MessageReply messageReply = null;
        try {
            String convId = message.getConversationId();
            messageReply = message.getMessageReply();
            if (ResetStatusRepository.getInstance().isResetMode(convId)) {
                this.syncManager.releaseResetLocksOfDataFacade();
            }
            this.syncManager.sendMessageReply(messageReply);
            if (TRACE.isLogging()) {
                TRACE.log("Handling an Error MessageReply", convId);
            }
            if (TRACE.isDebugMode()) {
                TRACE.appendLog("MessageReplies", "Handling an Error MessageReply for " + convId);
            }
        }
        catch (Exception e) {
            throw new SmartSynchronizationException("Received ErrorMessageReply: " + messageReply.toString(), e);
        }
    }

    private void handleSuccessReply(InboundMessage message) throws SmartSynchronizationException {
        try {
            String convId = message.getConversationId();
            ResetStatusRepository reset = ResetStatusRepository.getInstance();
            if (TRACE.isLogging()) {
                TRACE.log("Handling an Success MessageReply", convId);
            }
            if (TRACE.isDebugMode()) {
                TRACE.appendLog("MessageReplies", "Handling an Success MessageReply for " + convId);
            }
            if (reset.isResetMode(convId)) {
                this.syncManager.processResetOperation();
                reset.disableResetMode(convId);
                if (TRACE.isLogging()) {
                    TRACE.log("Reset success message for conversation ID:", convId);
                }
                if (TRACE.isDebugMode()) {
                    TRACE.appendLog("MessageReplies", "Reset success message for conversation ID " + convId);
                }
            }
            this.syncManager.sendMessageReply(message.getMessageReply());
        }
        catch (Exception e) {
            throw new SmartSynchronizationException("Received SuccessMessageReply: " + message.getMessageReply().toString(), e);
        }
    }
}

