/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.sync.in;

import com.sap.ip.me.api.conf.VisibilityType;
import com.sap.ip.me.api.smartsync.ErrorConflictInbox;
import com.sap.ip.me.api.smartsync.InboxNotifier;
import com.sap.ip.me.api.smartsync.MessageReply;
import com.sap.ip.me.api.smartsync.MessageReplyObserver;
import com.sap.ip.me.api.smartsync.MessageReplyType;
import com.sap.ip.me.api.smartsync.SyncBoDescriptor;
import com.sap.ip.me.api.smartsync.SyncBoInDelta;
import com.sap.ip.me.api.smartsync.SyncBoInDeltaObserver;
import com.sap.ip.me.core.ApplicationManager;
import com.sap.ip.me.core.ConversationId;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.smartsync.ipi.InterDataPackageManager;
import com.sap.ip.me.smartsync.sync.SyncPackageManager;
import com.sap.ip.me.smartsync.util.SmartSyncCache;
import com.sap.ip.me.smartsync.util.XTrace;

public class InboxNotifierImpl
implements InboxNotifier {
    private static XTrace TRACE = SyncPackageManager.getTrace();
    private final InterDataPackageManager DATA_MGR;
    private SmartSyncCache deltaPool = null;
    private SmartSyncCache messagePool = null;

    public InboxNotifierImpl(InterDataPackageManager dataPkgMgr) {
        this.DATA_MGR = dataPkgMgr;
        this.deltaPool = SmartSyncCache.newInstance(SyncPackageManager.getInDeltaObserverDirName());
        this.messagePool = SmartSyncCache.newInstance(SyncPackageManager.getMessageReplyObserverDirName());
    }

    public void registerMessageReplyObserver(MessageReplyObserver messageReplyObserver) {
        this.messagePool.add(this.getSharedConvId().getId(), messageReplyObserver);
    }

    public void registerSyncBoInDeltaObserver(SyncBoInDeltaObserver syncBoInDeltaObserver) {
        this.deltaPool.add(this.getSharedConvId().getId(), syncBoInDeltaObserver);
    }

    public void notifySyncBoInDeltaObservers(SyncBoInDelta syncBoInDelta) {
        String target = syncBoInDelta.getSyncBoDescriptor().getSyncBoName();
        ConversationId convId = this.getSharedConvId();
        if (!this.deltaPool.containsKey(convId.getId())) {
            return;
        }
        SyncBoInDeltaObserver obv = (SyncBoInDeltaObserver)this.deltaPool.get(convId.getId());
        if (obv == null) {
            return;
        }
        SyncBoDescriptor[] syncBoDescriptors = obv.observeSyncBoTypes();
        if (syncBoDescriptors == null || syncBoDescriptors.length == 0) {
            return;
        }
        int i = 0;
        while (i < syncBoDescriptors.length) {
            block8: {
                String boName = syncBoDescriptors[i].getSyncBoName();
                if (target.equals(boName)) {
                    try {
                        obv.receivedSyncBoInDelta(syncBoInDelta);
                    }
                    catch (Exception e) {
                        if (TRACE.isLogging()) {
                            TRACE.log("Ignoring Exception during SyncBoInDelta notification for syncBo <" + target + ">.", e);
                        }
                        if (!TRACE.isDebugMode()) break block8;
                        TRACE.logError("Exception during SyncBoOutDelta notification for syncBo <" + boName + ">.", e);
                    }
                }
            }
            ++i;
        }
    }

    public void notifyMessageReplyObservers(MessageReply messageReply) {
        MessageReplyType target = messageReply.getType();
        ConversationId convId = this.getSharedConvId();
        if (!this.messagePool.containsKey(convId.getId())) {
            return;
        }
        MessageReplyObserver obv = (MessageReplyObserver)this.messagePool.get(convId.getId());
        if (obv == null) {
            return;
        }
        MessageReplyType[] types = obv.observeMessageReplyTypes();
        if (types == null || types.length == 0) {
            return;
        }
        int i = 0;
        while (i < types.length) {
            block8: {
                if (target == types[i]) {
                    try {
                        obv.messageReplyReceived(messageReply);
                    }
                    catch (Exception e) {
                        if (TRACE.isLogging()) {
                            TRACE.log("Ignoring Exception during MessageReply notification for type <" + target + ">.", e);
                        }
                        if (!TRACE.isDebugMode()) break block8;
                        TRACE.logError("Exception during SyncBoOutDelta notification for type <" + target + ">.", e);
                    }
                }
            }
            ++i;
        }
    }

    public boolean isSyncStatusComplete() {
        boolean useSharedConvid = ApplicationManager.getInstance().getCurrentMSD().sharedDataVisible();
        ConversationId convId = useSharedConvid ? ConversationIdHandler.getInstance().getCurrentConversationId(VisibilityType.USER_SHARED) : ConversationIdHandler.getInstance().getCurrentConversationId(VisibilityType.SEPARATED);
        if (convId == null) {
            return false;
        }
        return convId.isSyncComplete();
    }

    public void resetSyncStatusToComplete() {
        boolean useSharedConvid = ApplicationManager.getInstance().getCurrentMSD().sharedDataVisible();
        ConversationId convId = useSharedConvid ? ConversationIdHandler.getInstance().getCurrentConversationId(VisibilityType.USER_SHARED) : ConversationIdHandler.getInstance().getCurrentConversationId(VisibilityType.SEPARATED);
        if (convId != null) {
            convId.setLastSyncContainerId(null);
        }
    }

    private ConversationId getSharedConvId() {
        return ConversationIdHandler.getInstance().getCurrentConversationId(VisibilityType.USER_SHARED);
    }

    public ErrorConflictInbox getErrorConflictInbox() {
        return this.DATA_MGR.getErrorConflictInbox();
    }
}

