/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.sync.in;

import com.sap.ip.me.api.smartsync.FieldDescriptor;
import com.sap.ip.me.api.smartsync.MessageReply;
import com.sap.ip.me.api.smartsync.RowChangeActionType;
import com.sap.ip.me.api.smartsync.RowDescriptor;
import com.sap.ip.me.api.smartsync.SyncBoChangeActionType;
import com.sap.ip.me.api.smartsync.SyncBoDescriptor;
import com.sap.ip.me.api.smartsync.SyncBoDescriptorFacade;
import com.sap.ip.me.api.smartsync.SyncReply;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.smartsync.ipi.InternalRowChange;
import com.sap.ip.me.smartsync.ipi.InternalRowDescriptor;
import com.sap.ip.me.smartsync.sync.InboundTransformException;
import com.sap.ip.me.smartsync.sync.SyncPackageManager;
import com.sap.ip.me.smartsync.sync.in.InboundMessage;
import com.sap.ip.me.smartsync.sync.in.Reply;
import com.sap.ip.me.smartsync.sync.in.RowChangeImpl;
import com.sap.ip.me.smartsync.sync.in.SyncBoInDeltaImpl;
import com.sap.ip.me.smartsync.util.SmartSyncXMLParser;
import com.sap.ip.me.smartsync.util.SmartSyncXMLUtil;
import com.sap.ip.me.smartsync.util.XTrace;
import org.w3c.dom.Element;

public class InboundTransformer
extends SmartSyncXMLParser {
    private static XTrace TRACE = SyncPackageManager.getTrace();
    private SyncBoDescriptorFacade metaFacade;

    public InboundTransformer(SyncBoDescriptorFacade descFacade) {
        this.metaFacade = descFacade;
    }

    public InboundMessage transformToInboundMessage(String xmlAsString, String convId) throws InboundTransformException {
        InboundMessage message;
        Element root;
        try {
            root = SmartSyncXMLUtil.getRootElement(xmlAsString);
        }
        catch (Exception e) {
            if (TRACE.isDebugMode()) {
                TRACE.logError(e.toString() + " XMLString>", xmlAsString);
            }
            throw new InboundTransformException("Not wellformed nor collapsed xml.", e);
        }
        try {
            Element eStatus;
            String rootName = root.getNodeName();
            if (!"Message".equals(rootName)) {
                if (TRACE.isDebugMode()) {
                    TRACE.logError("Unsupported root element <" + rootName + ">. XMLString>", xmlAsString);
                }
                throw new InboundTransformException("Root element should be <Message>. " + rootName + " is not supported.");
            }
            String messageId = SmartSyncXMLParser.getRequiredAttribute(root, "id");
            String requestId = SmartSyncXMLParser.getOptionalAttribute(root, "requestID");
            message = new InboundMessage(messageId, requestId);
            Element eDelta = SmartSyncXMLParser.getChildElement(root, "Delta");
            if (eDelta != null) {
                SyncBoInDeltaImpl delta = this.handleDeltaElement(eDelta);
                message.setDelta(delta);
            }
            if ((message.isErrorResponse() || message.isConflictResponse()) && (eStatus = SmartSyncXMLParser.getChildElement(root, "Status")) != null) {
                MessageReply msgReply = (MessageReply)this.handleReplyElement(eStatus, true);
                message.setMessageReply(msgReply);
                message.setConversationId(convId);
            }
        }
        catch (Exception e) {
            if (TRACE.isDebugMode()) {
                TRACE.logError("Exception at transformToInboundMessage.<" + xmlAsString + ">", e);
            }
            throw new InboundTransformException("Unknown exception is occured during parsing Message Element.", e);
        }
        return message;
    }

    private Object handleReplyElement(Element root, boolean isMsgReply) throws InboundTransformException {
        try {
            String text = SmartSyncXMLParser.getChildAsString(root, "Text");
            String code = SmartSyncXMLParser.getChildAsString(root, "Code");
            Element eText = SmartSyncXMLParser.getChildElement(root, "Text");
            String mClass = SmartSyncXMLParser.getAttrAsString(eText, "messageClass");
            int number = SmartSyncXMLParser.getAttrAsInt(eText, "messageNumber");
            if (isMsgReply) {
                return Reply.createMessageReply(code, text, mClass, number);
            }
            return Reply.createSyncReply(code, text, mClass, number);
        }
        catch (Exception e) {
            throw new InboundTransformException("Error occurred durint parsing of the reply element.<" + SmartSyncXMLUtil.elementToString(root) + ">", e);
        }
    }

    private SyncBoInDeltaImpl handleDeltaElement(Element root) throws InboundTransformException {
        SyncBoInDeltaImpl delta;
        try {
            Element[] fields;
            Element pre;
            String boName = SmartSyncXMLParser.getRequiredAttribute(root, "objectType");
            String objectId = SmartSyncXMLParser.getRequiredAttribute(root, "objectID");
            String action = SmartSyncXMLParser.getOptionalAttribute(root, "action");
            boolean isOnlySemanticKeys = SmartSyncXMLParser.getAttrAsBoolean(root, "isFieldDelta");
            SyncBoDescriptor boDesc = this.metaFacade.getSyncBoDescriptor(boName);
            if (boDesc == null) {
                if (TRACE.isDebugMode()) {
                    TRACE.logError("Couldn't retrieve the SyncBoDescriptor for type " + boName + ".", ConversationIdHandler.getInstance().getCurrentConversationId().getMsd().toString());
                }
                throw new InboundTransformException("Couldn't retrieve the SyncBoDescriptor for type " + boName + ".");
            }
            if (TRACE.isDebugMode()) {
                TRACE.appendLog("InboundMessages_" + boName, SmartSyncXMLUtil.elementToString(root));
            }
            delta = new SyncBoInDeltaImpl(objectId, boDesc, isOnlySemanticKeys, SyncBoChangeActionType.forXMLString(action));
            Element post = SmartSyncXMLParser.getChildElement(root, "PostStateID");
            if (post != null) {
                String postID = SmartSyncXMLParser.getValue(post);
                delta.setPostStateId(postID);
            }
            if ((pre = SmartSyncXMLParser.getChildElement(root, "PreStateID")) != null) {
                String preID = SmartSyncXMLParser.getValue(pre);
                delta.setPreStateId(preID);
            }
            if ((fields = SmartSyncXMLParser.getChildElements(root, "F")) != null && fields.length > 0) {
                RowDescriptor rowDesc = boDesc.getRowDescriptor("TOP");
                RowChangeActionType type = RowChangeActionType.forXMLString(action);
                InternalRowChange topRow = this.createInternalRowChange(fields, isOnlySemanticKeys, objectId, rowDesc, type);
                delta.setTopRow(topRow);
            }
            Element[] childs = SmartSyncXMLParser.getChildElements(root, "Delta");
            int j = 0;
            while (j < childs.length) {
                InternalRowChange rowChange = this.handleChildDeltaElement(boDesc, action, isOnlySemanticKeys, childs[j]);
                delta.addRowChange(rowChange);
                ++j;
            }
            Element status = SmartSyncXMLParser.getChildElement(root, "Status");
            if (status != null) {
                SyncReply syncReply = (SyncReply)this.handleReplyElement(status, false);
                delta.setSyncReplyImpl(syncReply);
            }
        }
        catch (Exception e) {
            if (TRACE.isDebugMode()) {
                TRACE.logError("Parsing Error on Delta Element.", e);
            }
            throw new InboundTransformException("Unknown error during parsing Root Delta Element", e);
        }
        return delta;
    }

    private InternalRowChange handleChildDeltaElement(SyncBoDescriptor boDesc, String deltaAction, boolean isOnlySemanticKeys, Element root) throws Exception {
        InternalRowChange topRow = null;
        try {
            RowChangeActionType parentAction = RowChangeActionType.forXMLString(deltaAction);
            if (RowChangeActionType.DELETE == parentAction) {
                throw new InboundTransformException("Delta with delete action can not have Child Delta");
            }
            String objectId = SmartSyncXMLParser.getRequiredAttribute(root, "objectID");
            String objectType = SmartSyncXMLParser.getRequiredAttribute(root, "objectType");
            String childAction = SmartSyncXMLParser.getOptionalAttribute(root, "action");
            RowDescriptor rowDesc = boDesc.getRowDescriptor(objectType);
            Element[] fields = SmartSyncXMLParser.getChildElements(root, "F");
            topRow = this.createInternalRowChange(fields, isOnlySemanticKeys, objectId, rowDesc, RowChangeActionType.forXMLString(childAction));
        }
        catch (Exception e) {
            String msg = "Unknown error during parsing Child Delta Element.";
            if (TRACE.isDebugMode()) {
                TRACE.logError(msg, e);
            }
            if (TRACE.isLogging()) {
                TRACE.log(e);
            }
            throw new InboundTransformException(msg, e);
        }
        return topRow;
    }

    private void addField(InternalRowChange rowChange, RowDescriptor rowDesc, int position, String value) {
        FieldDescriptor fieldDesc = ((InternalRowDescriptor)rowDesc).getFieldDescriptor(position);
        rowChange.addField(fieldDesc, value);
    }

    private InternalRowChange createInternalRowChange(Element[] fields, boolean isOnlySemanticKeys, String objectId, RowDescriptor rowDesc, RowChangeActionType type) {
        InternalRowChange rowChange = RowChangeImpl.createRowChange(objectId, rowDesc, type, isOnlySemanticKeys);
        try {
            if (!isOnlySemanticKeys) {
                if (RowChangeActionType.DELETE == type) {
                    return rowChange;
                }
                rowChange.addField(rowDesc.getKeyFieldDescriptor(), objectId);
                int i = 0;
                while (i < fields.length) {
                    this.addField(rowChange, rowDesc, i + 1, SmartSyncXMLParser.getOptionalValue(fields[i]));
                    ++i;
                }
            } else {
                int i = 0;
                while (i < fields.length) {
                    int position = SmartSyncXMLParser.getAttrAsInt(fields[i], "pos");
                    this.addField(rowChange, rowDesc, position, SmartSyncXMLParser.getOptionalValue(fields[i]));
                    ++i;
                }
            }
            return rowChange;
        }
        catch (Exception e) {
            String msg = "Unknown error during creating InternalRowChange object.";
            if (TRACE.isDebugMode()) {
                TRACE.logError(msg, e);
            }
            if (TRACE.isLogging()) {
                TRACE.log(e);
            }
            throw new InboundTransformException(msg, e);
        }
    }
}

