/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.sync.in;

import com.sap.ip.me.api.smartsync.MessageReply;
import com.sap.ip.me.api.smartsync.MessageReplyType;
import com.sap.ip.me.api.smartsync.SyncBoChangeActionType;
import com.sap.ip.me.api.smartsync.SyncReplyType;
import com.sap.ip.me.smartsync.ipi.MessageType;
import com.sap.ip.me.smartsync.sync.in.SyncBoInDeltaImpl;

public class InboundMessage
implements MessageType {
    private String convId;
    private String messageId;
    private String requestId;
    private SyncBoInDeltaImpl delta;
    private MessageReply messageReply;
    private int type = -999;

    public InboundMessage(String msgId, String reqId) {
        this.messageId = msgId;
        this.requestId = reqId;
    }

    public int getType() {
        if (this.type != -999) {
            return this.type;
        }
        this.type = this.finalizeMessageType();
        return this.type;
    }

    private int finalizeMessageType() {
        SyncBoChangeActionType ctype;
        if (this.messageReply != null) {
            MessageReplyType mtype = this.messageReply.getType();
            if (MessageReplyType.SUCCESS == mtype) {
                return 5;
            }
            if (MessageReplyType.ERROR == mtype) {
                return 6;
            }
            return -1;
        }
        if (this.delta.getSyncReply() != null) {
            SyncReplyType rtype = this.delta.getSyncReply().getType();
            if (SyncReplyType.SUCCESS == rtype) {
                if (this.delta.isOnlySemanticKeys()) {
                    return 1;
                }
                if (this.delta.hasAction()) {
                    return 2;
                }
                return 0;
            }
            if (SyncReplyType.CONFLICT == rtype) {
                return 3;
            }
            if (SyncReplyType.ERROR == rtype) {
                return 4;
            }
        }
        if (SyncBoChangeActionType.INSERT == (ctype = this.delta.getAction())) {
            return 10;
        }
        if (SyncBoChangeActionType.MODIFY == ctype) {
            return 8;
        }
        if (SyncBoChangeActionType.DELETE == ctype) {
            return 7;
        }
        if (SyncBoChangeActionType.REPLACE == ctype) {
            return 9;
        }
        return -1;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getRequestMessageId() {
        return this.requestId;
    }

    public SyncBoInDeltaImpl getDelta() {
        return this.delta;
    }

    public void setDelta(SyncBoInDeltaImpl inDelta) {
        this.delta = inDelta;
    }

    public boolean isDeltaDownload() {
        return this.delta != null && this.delta.getSyncReply() == null;
    }

    public boolean isResponseMessage() {
        return this.delta != null && this.delta.getSyncReply() != null;
    }

    public boolean isSuccessResponse() {
        return this.isResponseMessage() && this.delta.getSyncReply().getType() == SyncReplyType.SUCCESS;
    }

    public boolean isErrorResponse() {
        return this.isResponseMessage() && this.delta.getSyncReply().getType() == SyncReplyType.ERROR;
    }

    public boolean isConflictResponse() {
        return this.isResponseMessage() && this.delta.getSyncReply().getType() == SyncReplyType.CONFLICT;
    }

    public boolean isMessageReply() {
        return this.messageReply != null;
    }

    public MessageReply getMessageReply() {
        return this.messageReply;
    }

    public void setMessageReply(MessageReply msgReply) {
        this.messageReply = msgReply;
    }

    public void setConversationId(String convid) {
        this.convId = convid;
    }

    public String getConversationId() {
        return this.convId;
    }
}

