/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.sync;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.conf.VisibilityType;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.smartsync.GlobalResetProcessing;
import com.sap.ip.me.api.smartsync.InboxNotifier;
import com.sap.ip.me.api.smartsync.MessageReply;
import com.sap.ip.me.api.smartsync.SyncBoDeltaRequest;
import com.sap.ip.me.api.smartsync.SyncBoDeltaRequestFacade;
import com.sap.ip.me.api.smartsync.SyncBoDeltaRequestType;
import com.sap.ip.me.api.smartsync.SyncBoDescriptor;
import com.sap.ip.me.api.smartsync.SyncBoDescriptorFacade;
import com.sap.ip.me.api.smartsync.SyncBoInDelta;
import com.sap.ip.me.api.smartsync.SyncBoOutDelta;
import com.sap.ip.me.api.smartsync.SyncBoOutDeltaNotifier;
import com.sap.ip.me.api.smartsync.SyncBoOutDeltaSendType;
import com.sap.ip.me.api.sync.InboundContainer;
import com.sap.ip.me.api.sync.OutboundContainer;
import com.sap.ip.me.api.sync.OutboundContainerFactory;
import com.sap.ip.me.api.sync.SyncEvent;
import com.sap.ip.me.api.sync.SyncManager;
import com.sap.ip.me.core.ConversationId;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.smartsync.ipi.InterDataPackageManager;
import com.sap.ip.me.smartsync.ipi.InterDeltaPackageManager;
import com.sap.ip.me.smartsync.ipi.InterMetaPackageManager;
import com.sap.ip.me.smartsync.ipi.InterSyncPackageManager;
import com.sap.ip.me.smartsync.ipi.InternalOutDeltaFacade;
import com.sap.ip.me.smartsync.ipi.MessageManager;
import com.sap.ip.me.smartsync.ipi.PersistenceAdapter;
import com.sap.ip.me.smartsync.ipi.SmartSyncTransaction;
import com.sap.ip.me.smartsync.sync.InboundTransformException;
import com.sap.ip.me.smartsync.sync.OutboundTransformException;
import com.sap.ip.me.smartsync.sync.SmartSynchronizationException;
import com.sap.ip.me.smartsync.sync.in.InboundMessage;
import com.sap.ip.me.smartsync.sync.in.InboundTransformer;
import com.sap.ip.me.smartsync.sync.in.InboxNotifierImpl;
import com.sap.ip.me.smartsync.sync.in.MessageReplyHelper;
import com.sap.ip.me.smartsync.sync.in.Reply;
import com.sap.ip.me.smartsync.sync.in.SyncBoInDeltaImpl;
import com.sap.ip.me.smartsync.sync.out.OutboundMessage;
import com.sap.ip.me.smartsync.sync.out.OutboundProcessor;
import com.sap.ip.me.smartsync.sync.out.SyncBoOutDeltaNotifierImpl;
import com.sap.ip.me.smartsync.util.XTrace;
import com.sap.ip.me.sync.ContainerFactory;
import com.sap.ip.me.sync.SyncInboundContainer;
import com.sap.ip.me.sync.SyncManagerImplNewProtocol;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;

public class SyncPackageManager
implements InterSyncPackageManager {
    public static final String INBOUND_FILENAME = "InboundMessages_";
    public static final String DELTAREQUEST_FILENAME = "DeltaRequests_";
    public static final String UPLOADMESSAGE_FILENAME = "UploadMessages_";
    public static final String CONTAINER_FILENAME = "OutboundContainers";
    public static final String NOTIFIER_FILENAME = "NotifiedMessages";
    public static final String MESSAGE_FILENAME = "MessageReplies";
    private static final String METHOD_NAME = "SMARTSYNC";
    private static final String MESSAGE_DELIM = String.valueOf('\u0000');
    private static final String R = "R";
    private static final String D = "D";
    private static final String XML = "XML";
    private static String DIRPATH_SYNC = null;
    private static String DIRPATH_INDELTA_OBS = null;
    private static String DIRPATH_OUTDELTA_OBS = null;
    private static String DIRPATH_MSGREPLY_OBS = null;
    private static String DIRPATH_RESET_REPOSITORY = null;
    private static XTrace TRACE = new XTrace(".sync");
    private boolean isNewProtocol = Configuration.getInstance().getBoolean("MobileEngine.Sync.NewProtocol", false);
    private final InboxNotifierImpl inboxNotifier;
    private final SyncBoOutDeltaNotifierImpl outboxNotifier;
    private final PersistenceAdapter PERS_ADAPTER;
    private final InterMetaPackageManager META_MGR;
    private final InterDataPackageManager DATA_MGR;
    private final InterDeltaPackageManager DELTA_MGR;
    private final SyncManager syncManager;
    private final OutboundProcessor processor;
    private final Vector syncBosNotToUpload = new Vector();
    private StringBuffer _outboundLog = null;
    private static final Trace CORE_TRACE = Trace.getInstance("MI/Smartsync");
    private static String DIR_OBSERVER = ".observers" + File.separatorChar;

    public SyncPackageManager(PersistenceAdapter dataPersistenceAdapter, InterMetaPackageManager metaPackageMgr, InterDataPackageManager dataPackageMgr, InterDeltaPackageManager deltaPackageMgr) {
        this.PERS_ADAPTER = dataPersistenceAdapter;
        this.META_MGR = metaPackageMgr;
        this.DATA_MGR = dataPackageMgr;
        this.DELTA_MGR = deltaPackageMgr;
        this.inboxNotifier = new InboxNotifierImpl(this.DATA_MGR);
        this.outboxNotifier = new SyncBoOutDeltaNotifierImpl();
        this.syncManager = SyncManager.getInstance();
        this.processor = new OutboundProcessor(this.DATA_MGR);
    }

    public boolean registerPersistenceMaster() {
        return true;
    }

    public void registerEntityFactory() {
    }

    public void onSwitchConversationId() {
    }

    public InboxNotifier getInboxNotifier() {
        return this.inboxNotifier;
    }

    public SyncBoOutDeltaNotifier getSyncBoOutDeltaNotifier() {
        return this.outboxNotifier;
    }

    public void sendMessageReply(MessageReply messageReply) throws SmartSynchronizationException {
        block4: {
            try {
                this.inboxNotifier.notifyMessageReplyObservers(messageReply);
                if (TRACE.isLogging()) {
                    TRACE.log("Notifying MessageReplyObservers:");
                    TRACE.log(messageReply.toString());
                }
                if (TRACE.isDebugMode()) {
                    TRACE.appendLog(NOTIFIER_FILENAME, messageReply.toString());
                }
            }
            catch (Exception e) {
                if (!TRACE.isLogging()) break block4;
                TRACE.log(e);
            }
        }
    }

    public void notifyObservers(ConversationId convId, SyncBoOutDelta outDelta) {
        block4: {
            try {
                this.outboxNotifier.notifySyncBoOutDeltaObservers(convId, outDelta);
                if (TRACE.isLogging()) {
                    TRACE.log("Notifying SyncBoOutDeltaObservers:");
                    TRACE.log(outDelta.toString());
                }
                if (TRACE.isDebugMode()) {
                    TRACE.appendLog(NOTIFIER_FILENAME, outDelta.toString());
                }
            }
            catch (Exception e) {
                if (!TRACE.isLogging()) break block4;
                TRACE.log(e);
            }
        }
    }

    public void notifyObservers(SyncBoInDelta inDelta) {
        block4: {
            try {
                this.inboxNotifier.notifySyncBoInDeltaObservers(inDelta);
                if (TRACE.isLogging()) {
                    TRACE.log("Notifying SyncBoInDeltaObservers:");
                    TRACE.log(inDelta.toString());
                }
                if (TRACE.isDebugMode()) {
                    TRACE.appendLog(NOTIFIER_FILENAME, inDelta.toString());
                }
            }
            catch (Exception e) {
                if (!TRACE.isLogging()) break block4;
                TRACE.log(e);
            }
        }
    }

    public String getMethodName() {
        return METHOD_NAME;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(InboundContainer inboundContainer) {
        ConversationId currenId;
        if (inboundContainer == null) {
            throw new SmartSynchronizationException("Given InboundContainer is null.");
        }
        if (TRACE.isLogging()) {
            TRACE.log("Processing InboundContainer: contId=" + inboundContainer.getContainerId());
            TRACE.log("Dumping container contents:");
            TRACE.log(inboundContainer.toString());
        }
        String[] messages = this.parseMessages(inboundContainer.getGenericBody());
        ConversationId convId = ((SyncInboundContainer)inboundContainer).getConversationId();
        if (!convId.equals(currenId = ConversationIdHandler.getInstance().getCurrentConversationId(convId.isSharedConversationId() ? VisibilityType.USER_SHARED : VisibilityType.SEPARATED))) {
            throw new InboundTransformException("The current ConversationId <" + currenId + "> is not equal to the conversationId <" + convId + "> of the processed container!");
        }
        SmartSyncTransaction tx = null;
        try {
            try {
                SyncBoDescriptorFacade facade = this.META_MGR.getSyncBoDescriptorFacade();
                InboundTransformer transformer = new InboundTransformer(facade);
                MessageManager manager = this.DATA_MGR.getMessageManager();
                tx = this.beginTx();
                int i = 0;
                while (i < messages.length) {
                    InboundMessage message;
                    if (TRACE.isLogging()) {
                        TRACE.log("Dumping InboundMessage[" + i + "]");
                        TRACE.log(messages[i]);
                    }
                    if (TRACE.isDebugMode()) {
                        TRACE.appendLog(INBOUND_FILENAME, messages[i]);
                    }
                    if ((message = transformer.transformToInboundMessage(messages[i], convId.getId())).isMessageReply()) {
                        new MessageReplyHelper(this).handleMessageReply(message);
                    } else {
                        SyncBoInDeltaImpl delta = message.getDelta();
                        if (delta != null) {
                            this.notifyObservers(delta);
                        }
                        if (message.isDeltaDownload()) {
                            manager.handleDeltaDownload(delta, message.getType());
                        } else if (message.isSuccessResponse()) {
                            String messageId = message.getRequestMessageId();
                            manager.handleSuccessResponse(delta, message.getType(), messageId);
                        } else if (message.isConflictResponse() || message.isErrorResponse()) {
                            manager.handleConflictAndErrorResponse(delta, message.getType(), message.getRequestMessageId());
                        }
                    }
                    ++i;
                }
                this.commitTx(tx);
                return;
            }
            catch (Exception e) {
                if (TRACE.isLogging()) {
                    TRACE.log(e.toString(), e);
                }
                if (!TRACE.isDebugMode()) throw new InboundTransformException(e.toString(), e);
                TRACE.logError(e.toString(), e);
                throw new InboundTransformException(e.toString(), e);
            }
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            if (tx == null) throw throwable;
            this.rollbackTx(tx);
            throw throwable;
        }
    }

    public void actionPerformed(SyncEvent event, ConversationId convid) {
        try {
            if (1 == event.getType()) {
                this.sendMessageReply(Reply.MESSAGEREPLY_902);
            } else if (0 == event.getType()) {
                this.sendMessageReply(Reply.MESSAGEREPLY_901);
                if (!this.isDeleteAllDeltaAndReset()) {
                    this.processSyncBoDeltaUploads(convid);
                }
                this.processSyncBoDeltaRequests(convid);
            }
        }
        catch (SmartSynchronizationException e) {
            if (TRACE.isLogging()) {
                TRACE.log(e.toString(), e);
            }
            if (TRACE.isDebugMode()) {
                TRACE.logError(e.toString(), e);
            }
            throw e;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isDeleteAllDeltaAndReset() {
        SyncBoDeltaRequestFacade requestFacade = null;
        requestFacade = this.DELTA_MGR.getSyncBoDeltaRequestFacade();
        if (GlobalResetProcessing.DELETE_OUT_DELTA_AND_RESET != requestFacade.getGlobalResetProcessing()) return false;
        InternalOutDeltaFacade deltaFacade = null;
        SmartSyncTransaction tx = null;
        try {
            try {
                deltaFacade = this.DELTA_MGR.getInternalOutDeltaFacade();
                tx = this.beginTx();
                deltaFacade.deleteAllDelta();
                this.commitTx(tx);
                return true;
            }
            catch (Exception e) {
                if (TRACE.isLogging()) {
                    TRACE.log(e.toString(), e);
                }
                if (!TRACE.isDebugMode()) throw new SmartSynchronizationException(e.toString(), e);
                TRACE.logError("Exception @ isDeleteAllDeltaAndReset.", e);
                throw new SmartSynchronizationException(e.toString(), e);
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (tx == null) throw throwable;
            this.rollbackTx(tx);
            throw throwable;
        }
    }

    private void processResetRequest(ConversationId convId) {
        SyncBoDeltaRequestFacade requestFacade = this.DELTA_MGR.getSyncBoDeltaRequestFacade();
        GlobalResetProcessing globalResetProcessing = requestFacade.getGlobalResetProcessing();
        if (GlobalResetProcessing.NO_RESET != globalResetProcessing && GlobalResetProcessing.DEFAULT != globalResetProcessing) {
            OutboundMessage message = this.processor.createResetRequest(convId);
            requestFacade.setGlobalResetProcessing(GlobalResetProcessing.DEFAULT);
            this.saveOutboundContainer(message, convId);
            if (TRACE.isLogging()) {
                TRACE.log("Dumping ResetRequest: ", message.toXMLString());
            }
            if (TRACE.isDebugMode()) {
                TRACE.appendLog(DELTAREQUEST_FILENAME, message.toXMLString());
            }
        }
    }

    public void releaseResetLocksOfDataFacade() throws PersistenceException {
        this.DATA_MGR.getInternalSyncBoDataFacade().releaseModificationLock();
    }

    public void processResetOperation() throws PersistenceException {
        this.DATA_MGR.deleteAllPersistedData();
        this.DATA_MGR.getInternalSyncBoDataFacade().releaseModificationLock();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processSyncBoDeltaUploads(ConversationId convId) throws SmartSynchronizationException, OutboundTransformException {
        OutboundMessage message = null;
        InternalOutDeltaFacade deltaFacade = this.DELTA_MGR.getInternalOutDeltaFacade();
        SmartSyncTransaction tx = null;
        try {
            try {
                tx = this.beginTx();
                MeIterator iter = deltaFacade.getAllDelta();
                this.commitTx(tx);
                tx = null;
                MessageManager manager = this.DATA_MGR.getMessageManager();
                this.beginContainerTransaction();
                boolean filterUpload = this.syncBosNotToUpload.size() > 0;
                tx = this.beginTx();
                while (iter.hasNext()) {
                    SyncBoOutDelta outDelta = (SyncBoOutDelta)iter.next();
                    if (SyncBoOutDeltaSendType.NO_SEND == outDelta.getSendType() || this.isFilteredSyncBo(outDelta)) continue;
                    this.notifyObservers(convId, outDelta);
                    message = this.processor.createDeltaUploadRequest(outDelta);
                    String messageId = message.getMessageId();
                    manager.handleDeltaUpload(outDelta, messageId, messageId);
                    this.saveOutboundContainer(message, convId);
                    deltaFacade.deleteDelta(outDelta);
                    if (!TRACE.isDebugMode()) continue;
                    TRACE.appendLog(UPLOADMESSAGE_FILENAME + outDelta.getSyncBoDescriptor().getSyncBoName(), message.toXMLString());
                }
                this.commitTx(tx);
                tx = null;
                this.commitContainerTransaction();
            }
            catch (Exception e) {
                if (TRACE.isLogging()) {
                    TRACE.log(e.toString(), e);
                }
                if (!TRACE.isDebugMode()) throw new SmartSynchronizationException(e.toString(), e);
                TRACE.logError("Exception @ processSyncBoDeltaUpload.", e);
                throw new SmartSynchronizationException(e.toString(), e);
            }
            Object var11_11 = null;
            if (tx == null) return;
            this.rollbackContainerTransaction();
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (tx == null) throw throwable;
            this.rollbackContainerTransaction();
            this.rollbackTx(tx);
            throw throwable;
        }
        this.rollbackTx(tx);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processSyncBoDeltaRequests(ConversationId convId) throws SmartSynchronizationException, OutboundTransformException {
        SyncBoDeltaRequestFacade requestFacade = this.DELTA_MGR.getSyncBoDeltaRequestFacade();
        SmartSyncTransaction tx = null;
        try {
            block9: {
                try {
                    MeIterator iter = requestFacade.getAllSyncBoDeltaRequests();
                    if (!this.inboxNotifier.isSyncStatusComplete() || !iter.hasNext()) break block9;
                    this.beginContainerTransaction();
                    tx = this.beginTx();
                    OutboundMessage message = null;
                    while (true) {
                        if (!iter.hasNext()) {
                            requestFacade.resetAllSyncBoDeltaRequests();
                            this.processResetRequest(convId);
                            this.commitTx(tx);
                            tx = null;
                            this.commitContainerTransaction();
                            break;
                        }
                        SyncBoDeltaRequest request = (SyncBoDeltaRequest)iter.next();
                        if (request.getProcessing() == SyncBoDeltaRequestType.NO_REQUEST || this.isFilteredSyncBo(request.getSyncBoDescriptor())) continue;
                        message = this.processor.createDownloadRequest(request);
                        this.saveOutboundContainer(message, convId);
                        if (TRACE.isLogging()) {
                            TRACE.log("Dumping DeltaRequest: ", message.toXMLString());
                        }
                        if (!TRACE.isDebugMode()) continue;
                        TRACE.appendLog(DELTAREQUEST_FILENAME + request.getSyncBoDescriptor().getSyncBoName(), message.toXMLString());
                    }
                }
                catch (Exception e) {
                    if (TRACE.isLogging()) {
                        TRACE.log(e.toString(), e);
                    }
                    if (!TRACE.isDebugMode()) throw new SmartSynchronizationException(e.toString(), e);
                    TRACE.logError("Exception @ processSyncBoDeltaRequests.", e);
                    throw new SmartSynchronizationException(e.toString(), e);
                }
            }
            Object var8_8 = null;
            if (tx == null) return;
            this.rollbackContainerTransaction();
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (tx == null) throw throwable;
            this.rollbackContainerTransaction();
            this.rollbackTx(tx);
            throw throwable;
        }
        this.rollbackTx(tx);
    }

    private boolean isFilteredSyncBo(SyncBoDescriptor boDesc) {
        String log = null;
        if (CORE_TRACE.isLogging(90)) {
            log = "Skipping download request for type " + boDesc.getSyncBoName();
        }
        return this.isFilteredSyncBo(boDesc, 90, log);
    }

    private boolean isFilteredSyncBo(SyncBoDescriptor boDesc, int logSeverity, String log) {
        if (this.syncBosNotToUpload.size() > 0 && this.syncBosNotToUpload.contains(boDesc)) {
            if (log != null) {
                CORE_TRACE.log(90, log);
            }
            return true;
        }
        return false;
    }

    private boolean isFilteredSyncBo(SyncBoOutDelta outDelta) {
        String log = null;
        if (CORE_TRACE.isLogging(90)) {
            log = "Skipping upload delta for SyncBo " + outDelta.getSyncBoDescriptor().getSyncBoName() + " with SyncKey " + outDelta.getSyncKey();
        }
        return this.isFilteredSyncBo(outDelta.getSyncBoDescriptor(), 90, log);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void deleteAllDeltaData() throws SmartSynchronizationException, OutboundTransformException {
        InternalOutDeltaFacade deltaFacade = null;
        SmartSyncTransaction tx = null;
        try {
            try {
                deltaFacade = this.DELTA_MGR.getInternalOutDeltaFacade();
                tx = this.beginTx();
                deltaFacade.deleteAllDelta();
                this.commitTx(tx);
                return;
            }
            catch (Exception e) {
                if (TRACE.isLogging()) {
                    TRACE.log(e.toString(), e);
                }
                if (!TRACE.isDebugMode()) throw new SmartSynchronizationException(e.toString(), e);
                TRACE.logError("Exception @ deleteAllDeltaData.", e);
                throw new SmartSynchronizationException(e.toString(), e);
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (tx == null) throw throwable;
            this.rollbackTx(tx);
            throw throwable;
        }
    }

    private void saveOutboundContainer(OutboundMessage message, ConversationId currentConvId) throws SmartSynchronizationException {
        if (message == null) {
            String msg = "Skip saving NULL message to container for " + currentConvId.toString();
            if (TRACE.isLogging()) {
                TRACE.log(msg);
            }
            if (TRACE.isDebugMode()) {
                TRACE.logError(msg, "");
            }
            return;
        }
        boolean useSharedConvid = currentConvId.getMsd().sharedDataVisible();
        ConversationId convId = ConversationIdHandler.getInstance().getCurrentConversationId(useSharedConvid ? VisibilityType.USER_SHARED : VisibilityType.SEPARATED);
        try {
            String smartSyncOutboundMessage = message.toXMLString();
            ContainerFactory factory = (ContainerFactory)OutboundContainerFactory.getInstance();
            OutboundContainer outbound = factory.createAttachmentOutboundContainer(convId, METHOD_NAME, R, XML, smartSyncOutboundMessage, D);
            if (TRACE.isLogging()) {
                StringBuffer buf = new StringBuffer().append("Saved Smart Sync Message to OutboundContainer ").append(outbound.getContainerId()).append(" ConvId = ").append(convId.getId()).append("\n").append("[START ").append(METHOD_NAME).append("_OUTBOUND]\n").append(smartSyncOutboundMessage).append("\n[END ").append(METHOD_NAME).append("_OUTBOUND]\n");
                TRACE.log(buf.toString());
            }
            if (TRACE.isDebugMode()) {
                TRACE.appendLog(CONTAINER_FILENAME, new String[]{convId.toString(), smartSyncOutboundMessage});
            }
            if (this._outboundLog != null) {
                this._outboundLog.append(smartSyncOutboundMessage);
            }
        }
        catch (Exception e) {
            if (TRACE.isLogging()) {
                TRACE.log(e.toString(), message.toXMLString());
            }
            if (TRACE.isDebugMode()) {
                TRACE.logError("Exception when saving to container.", e);
            }
            throw new SmartSynchronizationException("Failed to save message to outboundContainer", e);
        }
    }

    private String[] parseMessages(String body) {
        if (body == null) {
            throw new SmartSynchronizationException("Given InboundContainer has no body.");
        }
        try {
            StringTokenizer tokenizer = new StringTokenizer(body, MESSAGE_DELIM);
            String[] messages = new String[tokenizer.countTokens()];
            int count = 0;
            while (tokenizer.hasMoreTokens()) {
                messages[count++] = tokenizer.nextToken();
            }
            return messages;
        }
        catch (Exception e) {
            if (TRACE.isLogging()) {
                TRACE.log("[Message Parsing Problem] XML Body Details:", body);
            }
            if (TRACE.isDebugMode()) {
                TRACE.logError("[Message Parsing Problem]", body);
            }
            throw new SmartSynchronizationException("Multiple messages could not be parsed.", e);
        }
    }

    private void beginContainerTransaction() {
        if (this.isNewProtocol) {
            ((SyncManagerImplNewProtocol)this.syncManager).beginTransaction();
        }
    }

    private void commitContainerTransaction() {
        if (this.isNewProtocol) {
            ((SyncManagerImplNewProtocol)this.syncManager).commitTransaction();
        }
    }

    private void rollbackContainerTransaction() {
        if (this.isNewProtocol) {
            ((SyncManagerImplNewProtocol)this.syncManager).rollbackTransaction();
        }
    }

    private SmartSyncTransaction beginTx() throws SmartSynchronizationException {
        SmartSyncTransaction tx;
        try {
            tx = this.PERS_ADAPTER.beginTransaction();
        }
        catch (Exception e) {
            throw new SmartSynchronizationException("Failed to begin TX", e);
        }
        return tx;
    }

    private void commitTx(SmartSyncTransaction tx) throws SmartSynchronizationException {
        try {
            this.PERS_ADAPTER.commit(tx);
        }
        catch (Exception e) {
            throw new SmartSynchronizationException("Failed to commit TX", e);
        }
    }

    private void rollbackTx(SmartSyncTransaction tx) throws SmartSynchronizationException {
        try {
            this.PERS_ADAPTER.rollback(tx);
        }
        catch (Exception e) {
            throw new SmartSynchronizationException("Failed to rollback TX", e);
        }
    }

    private static String getSyncPackageRootDirName() {
        if (DIRPATH_SYNC == null) {
            StringBuffer dir = new StringBuffer(200).append(Configuration.getInstance().getProperty("MobileEngine.InstallationPath"));
            dir.append(File.separatorChar + "sync" + File.separatorChar);
            DIRPATH_SYNC = dir.toString();
        }
        return DIRPATH_SYNC;
    }

    public static String getInDeltaObserverDirName() {
        if (DIRPATH_INDELTA_OBS == null) {
            DIRPATH_INDELTA_OBS = new StringBuffer(SyncPackageManager.getSyncPackageRootDirName().length() + 15).append(SyncPackageManager.getSyncPackageRootDirName()).append(DIR_OBSERVER).append(File.separatorChar).append("in").toString();
        }
        return DIRPATH_INDELTA_OBS;
    }

    public static String getOutDeltaObserverDirName() {
        if (DIRPATH_OUTDELTA_OBS == null) {
            DIRPATH_OUTDELTA_OBS = new StringBuffer(SyncPackageManager.getSyncPackageRootDirName().length() + 15).append(SyncPackageManager.getSyncPackageRootDirName()).append(DIR_OBSERVER).append(File.separatorChar).append("out").toString();
        }
        return DIRPATH_OUTDELTA_OBS;
    }

    public static String getMessageReplyObserverDirName() {
        if (DIRPATH_MSGREPLY_OBS == null) {
            DIRPATH_MSGREPLY_OBS = new StringBuffer(SyncPackageManager.getSyncPackageRootDirName().length() + 15).append(SyncPackageManager.getSyncPackageRootDirName()).append(DIR_OBSERVER).append(File.separatorChar).append("msg").toString();
        }
        return DIRPATH_MSGREPLY_OBS;
    }

    public static String getResetStateDirName() {
        if (DIRPATH_RESET_REPOSITORY == null) {
            DIRPATH_RESET_REPOSITORY = new StringBuffer(SyncPackageManager.getSyncPackageRootDirName().length() + 7).append(SyncPackageManager.getSyncPackageRootDirName()).append(File.separatorChar).append("msg").toString();
        }
        return DIRPATH_RESET_REPOSITORY;
    }

    public static XTrace getTrace() {
        return TRACE;
    }

    public void ignoreSyncBosForDeltaUpload(SyncBoDescriptor[] syncBoDescriptorsToIgnore) {
        this.syncBosNotToUpload.removeAllElements();
        if (syncBoDescriptorsToIgnore == null) {
            CORE_TRACE.log(70, "List of SyncBos to be ignored for delta upload was resetted.");
            return;
        }
        StringBuffer debugMessage = null;
        if (CORE_TRACE.isLogging(70)) {
            debugMessage = new StringBuffer();
            debugMessage.append("Ingoring the following SyncBos for upload: ");
        }
        int i = 0;
        while (i < syncBoDescriptorsToIgnore.length) {
            this.syncBosNotToUpload.addElement(syncBoDescriptorsToIgnore[i]);
            if (CORE_TRACE.isLogging(70)) {
                debugMessage.append(syncBoDescriptorsToIgnore[i].getSyncBoName()).append(' ');
            }
            ++i;
        }
        if (CORE_TRACE.isLogging(70)) {
            CORE_TRACE.log(70, debugMessage.toString());
        }
    }

    public void _setOutboundLog(StringBuffer log) {
        this._outboundLog = log;
    }
}

