/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.persadp;

import com.sap.ip.me.api.conf.VisibilityType;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.app.PackagePersistenceMaster;
import com.sap.ip.me.api.persist.app.PersistableEntity;
import com.sap.ip.me.api.persist.core.PersistedObjectFactory;
import com.sap.ip.me.api.persist.core.PersistenceContainer;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.core.PersistenceManager;
import com.sap.ip.me.api.persist.core.PersistenceRuntime;
import com.sap.ip.me.api.persist.core.TreeOptionType;
import com.sap.ip.me.api.persist.meta.AttributeDescriptor;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.persist.meta.DescriptorRuntime;
import com.sap.ip.me.api.persist.query.Condition;
import com.sap.ip.me.api.persist.query.JQuery;
import com.sap.ip.me.api.persist.query.JQueryParameterSet;
import com.sap.ip.me.api.persist.query.JQueryResult;
import com.sap.ip.me.api.persist.query.LogicalOperatorType;
import com.sap.ip.me.api.persist.query.Query;
import com.sap.ip.me.api.persist.query.QueryRuntime;
import com.sap.ip.me.api.persist.query.RelationalOperatorType;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.smartsync.Row;
import com.sap.ip.me.api.smartsync.SmartSyncException;
import com.sap.ip.me.api.smartsync.SmartSyncTransactionManager;
import com.sap.ip.me.api.smartsync.SyncBo;
import com.sap.ip.me.core.ApplicationManager;
import com.sap.ip.me.core.ConversationId;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.core.MobileSolutionDescriptor;
import com.sap.ip.me.smartsync.ipi.PersistenceAdapter;
import com.sap.ip.me.smartsync.ipi.PersistenceConstants;
import com.sap.ip.me.smartsync.ipi.SmartSyncEntityFactory;
import com.sap.ip.me.smartsync.ipi.SmartSyncTransaction;
import com.sap.ip.me.smartsync.persadp.SmartSyncEntityFactoryImpl;
import com.sap.ip.me.smartsync.persadp.SmartSyncTransactionImpl;
import java.util.Hashtable;
import java.util.Vector;

public class PersistenceAdapterImpl
implements PersistenceAdapter {
    static final Trace TRACE = Trace.getInstance("MI/Smartsync");
    private final SmartSyncTransactionMangerImpl SMART_SYNC_TRANSACTION_MANAGER = new SmartSyncTransactionMangerImpl();
    private PersistenceManager persistenceManger = null;
    boolean syncBoChangedInCurrentTx;
    private boolean dataPersistenceAdapter = false;
    private SmartSyncTransactionImpl currentTransaction = null;
    private final SmartSyncTransactionPool POOL = new SmartSyncTransactionPool();
    private VisibilityType visibility;
    MobileSolutionDescriptor msd;
    private final SmartSyncEntityFactory smartSyncEntityFactory;
    private static final String DEFAULT_DATA_AREA_UPPER_BORDER = "9999999999";
    private static final String CONFLICT_DATA_AREA_KEYPREFIX = "q";
    private Hashtable copiedEntities;
    private final int instanceNumber;
    private static int instanceCounter = 0;

    public PersistenceAdapterImpl(VisibilityType visibility) {
        MobileSolutionDescriptor msd;
        this.visibility = visibility;
        if (this.visibility == VisibilityType.SEPARATED) {
            this.dataPersistenceAdapter = true;
        }
        if ((msd = ApplicationManager.getInstance().getCurrentMSD()).sharedDataVisible()) {
            this.visibility = VisibilityType.USER_SHARED;
        }
        this.msd = ConversationIdHandler.getInstance().getCurrentConversationId().getMsd();
        this.smartSyncEntityFactory = new SmartSyncEntityFactoryImpl();
        this.instanceNumber = ++instanceCounter;
        TRACE.log(90, "New instance of PersistenceAdapter created, number=" + this.instanceNumber + " isDataPersistenceAdatper = " + this.dataPersistenceAdapter);
    }

    public SmartSyncTransactionManager getSmartSyncTransactionManager() {
        return this.SMART_SYNC_TRANSACTION_MANAGER;
    }

    public void insert(PersistableEntity entity, TreeOptionType treeOption, int dataArea) throws PersistenceException, IllegalArgumentException {
        this.traceDebugInformation(" insert entity " + entity.getPersistedObject().getClasstype() + " with key " + entity.getPersistedObject().getKey());
        if (this.currentTransaction == null) {
            throw new RuntimeException("No transaction opened.");
        }
        String entityKey = entity.getPersistedObject().getKey();
        switch (dataArea) {
            case 0: {
                if (entityKey.length() == DEFAULT_DATA_AREA_UPPER_BORDER.length()) break;
                if (entityKey.length() == DEFAULT_DATA_AREA_UPPER_BORDER.length() + CONFLICT_DATA_AREA_KEYPREFIX.length() && entityKey.startsWith(CONFLICT_DATA_AREA_KEYPREFIX)) {
                    entity = this.copyAndAddPrefixKeyAndSetSub(entity, treeOption, false);
                    break;
                }
                throw new IllegalArgumentException("Entity key is not valid: " + entityKey);
            }
            case 1: {
                entity = this.copyAndAddPrefixKeyAndSetSub(entity, treeOption, true);
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("No legal data area specified: " + dataArea);
            }
        }
        this.persistenceManger.insert(entity, treeOption);
        if (!this.currentTransaction.isFrameworkTransaction()) {
            this.syncBoChangedInCurrentTx = true;
        }
    }

    private PersistableEntity copyAndAddPrefixKeyAndSetSub(PersistableEntity originalEntity, TreeOptionType treeOptionType, boolean sub) throws PersistenceException {
        boolean firstMethodCall = false;
        if (this.copiedEntities == null) {
            this.copiedEntities = new Hashtable();
            firstMethodCall = true;
        }
        try {
            String originalEntityKey = originalEntity.getPersistedObject().getKey();
            String newEntityKey = null;
            newEntityKey = sub ? CONFLICT_DATA_AREA_KEYPREFIX + originalEntityKey : originalEntityKey.substring(CONFLICT_DATA_AREA_KEYPREFIX.length());
            PersistenceContainer copiedContainer = this.persistenceManger.getPersistedObjectFactory().createPersistedObject(originalEntity.getPersistedObject(), newEntityKey);
            PersistenceContainer originalContainer = originalEntity.getPersistedObject();
            PersistableEntity copiedEntity = this.smartSyncEntityFactory.createEntity(copiedContainer);
            this.copiedEntities.put(originalEntity.getPersistedObject().getClasstype() + originalEntityKey, copiedEntity);
            if (copiedEntity instanceof SyncBo || copiedEntity instanceof Row) {
                copiedEntity.getPersistedObject().setAttribute(0, new Boolean(sub));
            }
            if (treeOptionType != TreeOptionType.SKELETON) {
                ClassDescriptor classDescriptor = PersistenceRuntime.getInstance().getClassDescriptor(originalEntity.getPersistedObject().getClasstype());
                int links = originalContainer.sizeLink();
                int i = 0;
                while (i < links) {
                    if (treeOptionType != TreeOptionType.DEPENDENT || classDescriptor.getLinkDescriptor(i).isDependent()) {
                        PersistableEntity originalChildEntity = null;
                        PersistableEntity copiedChildEntity = null;
                        PersistenceContainer originalChildContainer = null;
                        PersistenceContainer copiedChildContainer = null;
                        if (originalContainer.isMultipleLink(i)) {
                            int multipeLinkSize = originalContainer.sizeLink(i);
                            int mult = 0;
                            while (mult < multipeLinkSize) {
                                originalChildEntity = originalContainer.getMultipleLink(i, mult);
                                originalChildContainer = originalEntity.getPersistedObject();
                                copiedChildContainer = this.persistenceManger.getPersistedObjectFactory().createPersistedObject(originalChildContainer, originalChildContainer.getKey());
                                String id = copiedChildContainer.getClasstype() + copiedChildContainer.getKey();
                                copiedChildEntity = this.copiedEntities.contains(id) ? (PersistableEntity)this.copiedEntities.get(id) : this.copyAndAddPrefixKeyAndSetSub(originalChildEntity, treeOptionType, sub);
                                copiedContainer.addMultipleLink(i, copiedChildEntity);
                                ++mult;
                            }
                        } else {
                            originalChildEntity = originalContainer.getSingleLink(i);
                            originalChildContainer = originalChildEntity.getPersistedObject();
                            copiedChildContainer = this.persistenceManger.getPersistedObjectFactory().createPersistedObject(originalChildContainer, originalChildContainer.getKey());
                            String id = copiedChildContainer.getClasstype() + copiedChildContainer.getKey();
                            copiedChildEntity = this.copiedEntities.containsKey(id) ? (PersistableEntity)this.copiedEntities.get(id) : this.copyAndAddPrefixKeyAndSetSub(originalChildEntity, treeOptionType, sub);
                            copiedContainer.setSingleLink(i, copiedChildEntity);
                        }
                    }
                    ++i;
                }
            }
            PersistableEntity persistableEntity = copiedEntity;
            Object var21_21 = null;
            if (firstMethodCall) {
                this.copiedEntities = null;
            }
            return persistableEntity;
        }
        catch (Throwable throwable) {
            block11: {
                Object var21_22 = null;
                if (!firstMethodCall) break block11;
                this.copiedEntities = null;
            }
            throw throwable;
        }
    }

    public String getCorrespondingConflictKey(String defaultKey) throws IllegalArgumentException {
        if (defaultKey.length() == DEFAULT_DATA_AREA_UPPER_BORDER.length()) {
            return CONFLICT_DATA_AREA_KEYPREFIX + defaultKey;
        }
        if (defaultKey.length() == DEFAULT_DATA_AREA_UPPER_BORDER.length() + 1 && defaultKey.startsWith(CONFLICT_DATA_AREA_KEYPREFIX)) {
            return defaultKey;
        }
        throw new IllegalArgumentException("Key " + defaultKey + " can not be mapped ot a conflict key.");
    }

    public String getCorrespondingDefaultKey(String conflictKey) throws IllegalArgumentException {
        if (conflictKey.length() == DEFAULT_DATA_AREA_UPPER_BORDER.length() + 1 && conflictKey.startsWith(CONFLICT_DATA_AREA_KEYPREFIX)) {
            return conflictKey.substring(CONFLICT_DATA_AREA_KEYPREFIX.length());
        }
        if (conflictKey.length() == DEFAULT_DATA_AREA_UPPER_BORDER.length()) {
            return conflictKey;
        }
        throw new IllegalArgumentException("Key " + conflictKey + " can not be mapped ot a conflict key.");
    }

    public void update(PersistableEntity entity, TreeOptionType treeOption, int dataArea) throws PersistenceException {
        this.traceDebugInformation("update entity " + entity.getPersistedObject().getClasstype() + " with key " + entity.getPersistedObject().getKey());
        if (this.currentTransaction == null) {
            throw new RuntimeException("No transaction opened.");
        }
        String entityKey = entity.getPersistedObject().getKey();
        switch (dataArea) {
            case 0: {
                if (entityKey.length() == DEFAULT_DATA_AREA_UPPER_BORDER.length()) break;
                if (entityKey.length() == DEFAULT_DATA_AREA_UPPER_BORDER.length() + CONFLICT_DATA_AREA_KEYPREFIX.length() && entityKey.startsWith(CONFLICT_DATA_AREA_KEYPREFIX)) {
                    entity = this.copyAndAddPrefixKeyAndSetSub(entity, treeOption, false);
                    break;
                }
                throw new IllegalArgumentException("Entity does not hava a valid key: " + entityKey);
            }
            case 1: {
                entity = this.copyAndAddPrefixKeyAndSetSub(entity, treeOption, true);
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("No legal data area specified: " + dataArea);
            }
        }
        this.persistenceManger.update(entity, treeOption);
        if (!this.currentTransaction.isFrameworkTransaction()) {
            this.syncBoChangedInCurrentTx = true;
        }
    }

    public void modify(PersistableEntity entity, TreeOptionType treeOption, int dataArea) throws PersistenceException {
        this.traceDebugInformation("modify entity " + entity.getPersistedObject().getClasstype() + " with key " + entity.getPersistedObject().getKey());
        if (this.currentTransaction == null) {
            throw new RuntimeException("No transaction opened.");
        }
        String entityKey = entity.getPersistedObject().getKey();
        switch (dataArea) {
            case 0: {
                if (entityKey.length() == DEFAULT_DATA_AREA_UPPER_BORDER.length()) break;
                entity = this.copyAndAddPrefixKeyAndSetSub(entity, treeOption, false);
                break;
            }
            case 1: {
                if (entityKey.length() == DEFAULT_DATA_AREA_UPPER_BORDER.length() + 1 && entityKey.startsWith(CONFLICT_DATA_AREA_KEYPREFIX)) break;
                throw new RuntimeException("Modifcation of entity " + entityKey + " can not be done in conflict data area.");
            }
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("No legal data area specified: " + dataArea);
            }
        }
        this.persistenceManger.modify(entity, treeOption);
        if (this.currentTransaction.isFrameworkTransaction()) {
            this.syncBoChangedInCurrentTx = true;
        }
    }

    public PersistableEntity get(ClassDescriptor cdes, String entityKey, int dataArea) throws PersistenceException {
        this.traceDebugInformation("Get entity " + cdes.getClasstype() + " with key " + entityKey);
        if (this.currentTransaction == null) {
            throw new RuntimeException("No transaction opened.");
        }
        switch (dataArea) {
            case 0: {
                if (entityKey.length() == DEFAULT_DATA_AREA_UPPER_BORDER.length()) break;
                throw new RuntimeException("Entity " + entityKey + " can not be requested from default data area.");
            }
            case 1: {
                if (entityKey.length() == DEFAULT_DATA_AREA_UPPER_BORDER.length()) {
                    entityKey = CONFLICT_DATA_AREA_KEYPREFIX + entityKey;
                    break;
                }
                if (entityKey.length() == DEFAULT_DATA_AREA_UPPER_BORDER.length() + 1 && entityKey.startsWith(CONFLICT_DATA_AREA_KEYPREFIX)) break;
                throw new RuntimeException("Entity " + entityKey + " can not be requested from conflict data area.");
            }
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("No legal data area specified: " + dataArea);
            }
        }
        return this.persistenceManger.get(cdes, entityKey);
    }

    public MeIterator get(Query query, int dataArea) throws PersistenceException {
        this.traceDebugInformation("Get with query " + query.getClasstype());
        if (this.currentTransaction == null) {
            throw new RuntimeException("No transaction opened.");
        }
        String classType = query.getClasstype();
        if ((dataArea == 0 || dataArea == 1) && classType.charAt(0) != PersistenceConstants.SYNC_BO_CLASSTYPE_PREFIX && classType.charAt(0) != PersistenceConstants.ROW_CLASSTYPE_PREFIX) {
            throw new IllegalArgumentException("Query for classtype " + classType + " can only be started" + "in complete data area");
        }
        QueryRuntime queryRuntime = QueryRuntime.getInstance();
        AttributeDescriptor subAttrDesc = DescriptorRuntime.getInstance().getClassDescriptor(classType).getAttributeDescriptor(0);
        Condition filterCondition = null;
        Condition defaultCondition = query.getCondition();
        switch (dataArea) {
            case 0: {
                filterCondition = queryRuntime.createCondition(subAttrDesc, RelationalOperatorType.EQUALS, Boolean.FALSE);
                break;
            }
            case 1: {
                filterCondition = queryRuntime.createCondition(subAttrDesc, RelationalOperatorType.EQUALS, Boolean.TRUE);
                break;
            }
            case 2: {
                return this.persistenceManger.get(query);
            }
            default: {
                throw new IllegalArgumentException("No legal data area specified: " + dataArea);
            }
        }
        if (defaultCondition == null) {
            query = queryRuntime.createQuery(query.getClasstype(), filterCondition, query.getSortOrder(), query.getStartIndex(), query.getMaxResults());
        } else {
            Condition[] multipleCondition = new Condition[]{defaultCondition, filterCondition};
            Condition compositeCondition = queryRuntime.createCondition(multipleCondition, LogicalOperatorType.AND);
            query = queryRuntime.createQuery(query.getClasstype(), compositeCondition, query.getSortOrder(), query.getStartIndex(), query.getMaxResults());
        }
        return this.persistenceManger.get(query);
    }

    public MeIterator getAll(ClassDescriptor cdes, int dataArea) throws PersistenceException {
        this.traceDebugInformation("getAll " + cdes.getClasstype());
        if (this.currentTransaction == null) {
            throw new RuntimeException("No transaction opened.");
        }
        String classType = cdes.getClasstype();
        if ((dataArea == 0 || dataArea == 1) && classType.charAt(0) != PersistenceConstants.SYNC_BO_CLASSTYPE_PREFIX && classType.charAt(0) != PersistenceConstants.ROW_CLASSTYPE_PREFIX) {
            throw new IllegalArgumentException("Query for classtype " + classType + " can only be started " + "in complete data area");
        }
        QueryRuntime queryRuntime = QueryRuntime.getInstance();
        AttributeDescriptor subAttrDesc = cdes.getAttributeDescriptor(0);
        Condition filterCondition = null;
        switch (dataArea) {
            case 0: {
                filterCondition = queryRuntime.createCondition(subAttrDesc, RelationalOperatorType.EQUALS, Boolean.FALSE);
                break;
            }
            case 1: {
                filterCondition = queryRuntime.createCondition(subAttrDesc, RelationalOperatorType.EQUALS, Boolean.TRUE);
                break;
            }
            case 2: {
                return this.persistenceManger.getAll(cdes);
            }
            default: {
                throw new IllegalArgumentException("No legal data area specified: " + dataArea);
            }
        }
        Query query = queryRuntime.createQuery(cdes.getClasstype(), filterCondition);
        return this.persistenceManger.get(query);
    }

    public int getCount(Query query, int dataArea) throws PersistenceException {
        if (this.currentTransaction == null) {
            throw new RuntimeException("No transaction opened.");
        }
        String classType = query.getClasstype();
        this.traceDebugInformation("getCount " + classType);
        if ((dataArea == 0 || dataArea == 1) && classType.charAt(0) != PersistenceConstants.SYNC_BO_CLASSTYPE_PREFIX && classType.charAt(0) != PersistenceConstants.ROW_CLASSTYPE_PREFIX) {
            throw new IllegalArgumentException("Query for classtype " + classType + " can only be started" + "in complete data area");
        }
        QueryRuntime queryRuntime = QueryRuntime.getInstance();
        AttributeDescriptor subAttrDesc = DescriptorRuntime.getInstance().getClassDescriptor(query.getClasstype()).getAttributeDescriptor(0);
        Condition filterCondition = null;
        Condition defaultCondition = query.getCondition();
        switch (dataArea) {
            case 0: {
                filterCondition = queryRuntime.createCondition(subAttrDesc, RelationalOperatorType.EQUALS, Boolean.FALSE);
                break;
            }
            case 1: {
                filterCondition = queryRuntime.createCondition(subAttrDesc, RelationalOperatorType.EQUALS, Boolean.TRUE);
                break;
            }
            case 2: {
                return this.persistenceManger.getCount(query);
            }
            default: {
                throw new IllegalArgumentException("No legal data area specified: " + dataArea);
            }
        }
        if (defaultCondition == null) {
            query = queryRuntime.createQuery(query.getClasstype(), filterCondition, query.getSortOrder(), query.getStartIndex(), query.getMaxResults());
        } else {
            Condition[] multipleCondition = new Condition[]{defaultCondition, filterCondition};
            Condition compositeCondition = queryRuntime.createCondition(multipleCondition, LogicalOperatorType.AND);
            query = queryRuntime.createQuery(query.getClasstype(), compositeCondition, query.getSortOrder(), query.getStartIndex(), query.getMaxResults());
        }
        return this.persistenceManger.getCount(query);
    }

    public JQueryResult executeQuery(JQuery query, JQueryParameterSet params, int startIdx, int maxCount) throws PersistenceException {
        if (this.currentTransaction == null) {
            throw new RuntimeException("No transaction opened.");
        }
        return this.persistenceManger.executeQuery(query, params, startIdx, maxCount);
    }

    public void delete(PersistableEntity entity, TreeOptionType treeOption, int dataArea) throws PersistenceException {
        this.traceDebugInformation("delete entity " + entity.getPersistedObject().getClasstype() + " with key " + entity.getPersistedObject().getKey());
        if (this.currentTransaction == null) {
            throw new RuntimeException("No transaction opened.");
        }
        String entityKey = entity.getPersistedObject().getKey();
        switch (dataArea) {
            case 0: {
                if (entityKey.length() == DEFAULT_DATA_AREA_UPPER_BORDER.length()) break;
                throw new RuntimeException("Deletion of entity " + entityKey + " can not be done in default data area.");
            }
            case 1: {
                if (entityKey.length() == DEFAULT_DATA_AREA_UPPER_BORDER.length() + 1 && entityKey.startsWith(CONFLICT_DATA_AREA_KEYPREFIX)) break;
                throw new RuntimeException("Deletion of entity " + entityKey + " can not be done in conflict data area.");
            }
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("No legal data area specified: " + dataArea);
            }
        }
        this.persistenceManger.delete(entity, treeOption);
        if (!this.currentTransaction.isFrameworkTransaction()) {
            this.syncBoChangedInCurrentTx = true;
        }
    }

    public void deleteAll(ClassDescriptor cdes, TreeOptionType treeOption, int dataArea) throws PersistenceException {
        this.traceDebugInformation("deleteAll " + cdes.getClasstype());
        if (this.currentTransaction == null) {
            throw new RuntimeException("No transaction opened.");
        }
        String classType = cdes.getClasstype();
        if ((dataArea == 0 || dataArea == 1) && classType.charAt(0) != PersistenceConstants.SYNC_BO_CLASSTYPE_PREFIX && classType.charAt(0) != PersistenceConstants.ROW_CLASSTYPE_PREFIX) {
            throw new IllegalArgumentException("Query for classtype " + classType + " can only be started" + "in complete data area");
        }
        QueryRuntime queryRuntime = QueryRuntime.getInstance();
        AttributeDescriptor subAttrDesc = cdes.getAttributeDescriptor(0);
        Condition filterCondition = null;
        switch (dataArea) {
            case 0: {
                filterCondition = queryRuntime.createCondition(subAttrDesc, RelationalOperatorType.EQUALS, Boolean.FALSE);
                break;
            }
            case 1: {
                filterCondition = queryRuntime.createCondition(subAttrDesc, RelationalOperatorType.EQUALS, Boolean.TRUE);
                break;
            }
            case 2: {
                this.persistenceManger.deleteAll(cdes, treeOption);
                return;
            }
            default: {
                throw new IllegalArgumentException("No legal data area specified: " + dataArea);
            }
        }
        Query query = queryRuntime.createQuery(cdes.getClasstype(), filterCondition);
        MeIterator it = this.persistenceManger.get(query);
        boolean entryDeleted = false;
        while (it.hasNext()) {
            this.persistenceManger.delete((PersistableEntity)it.next(), treeOption);
            entryDeleted = true;
        }
        if (!this.currentTransaction.isFrameworkTransaction() && entryDeleted) {
            this.syncBoChangedInCurrentTx = true;
        }
        this.persistenceManger.deleteAll(cdes, treeOption);
    }

    public PersistedObjectFactory getPersistedObjectFactory() {
        if (this.currentTransaction == null) {
            throw new RuntimeException("No transaction opened.");
        }
        return this.persistenceManger.getPersistedObjectFactory();
    }

    private void traceDebugInformation(String information) {
        if (TRACE.isLogging(90)) {
            ConversationId currentConvId = ConversationIdHandler.getInstance().getCurrentConversationId();
            String convIdName = currentConvId == null ? "null" : currentConvId.getId();
            String threadName = Thread.currentThread().getName();
            TRACE.log(90, "PersistenceAdapterImpl(" + this.instanceNumber + "): (ConvId = " + convIdName + ", Thread = " + threadName + ") :  " + information);
        }
    }

    synchronized SmartSyncTransaction beginTransaction(boolean isFrameworkTransaction) throws SmartSyncException, PersistenceException {
        if (this.currentTransaction != null) {
            if (isFrameworkTransaction) {
                return this.POOL.getTransaction(true);
            }
            String message = "Illegal transaction opend. There is already an open transaction: " + this.currentTransaction;
            TRACE.log(50, message);
            throw new SmartSyncException(message);
        }
        this.traceDebugInformation(" beginTransaction() isFramework=" + isFrameworkTransaction);
        this.persistenceManger = PersistenceRuntime.getInstance().getPersistenceManager(this.visibility);
        this.persistenceManger.beginTransaction(true);
        this.persistenceManger.registerEntityFactory(this.smartSyncEntityFactory);
        this.currentTransaction = this.POOL.getTransaction(isFrameworkTransaction);
        return this.currentTransaction;
    }

    public SmartSyncTransaction beginTransaction() throws PersistenceException {
        try {
            return this.beginTransaction(true);
        }
        catch (SmartSyncException e) {
            String message = "Can not start SmartSync Transaction. ";
            TRACE.logException(50, message, e, true);
            throw new RuntimeException(message);
        }
    }

    synchronized void commit(boolean isFramework, SmartSyncTransaction tx) throws SmartSyncException, PersistenceException {
        if (tx == null) {
            throw new SmartSyncException("SmartSyncTransaction must not be null");
        }
        if (this.currentTransaction == null) {
            throw new SmartSyncException("No transaction opened to commit");
        }
        if (this.currentTransaction != tx && isFramework) {
            return;
        }
        if (this.currentTransaction != tx && !this.currentTransaction.isFrameworkTransaction()) {
            throw new RuntimeException("Illegal transaction from application.");
        }
        this.traceDebugInformation("commit() isFramework = " + isFramework);
        try {
            this.persistenceManger.commit();
            Object var4_3 = null;
            this.persistenceManger = null;
            this.currentTransaction = null;
            this.POOL.takeTranasaction(tx);
            this.syncBoChangedInCurrentTx = false;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.persistenceManger = null;
            this.currentTransaction = null;
            this.POOL.takeTranasaction(tx);
            this.syncBoChangedInCurrentTx = false;
            throw throwable;
        }
    }

    public void commit(SmartSyncTransaction tx) throws PersistenceException {
        try {
            this.commit(true, tx);
        }
        catch (SmartSyncException e) {
            String message = "Could not commit framework transaction. ";
            TRACE.logException(50, message, e, true);
            throw new RuntimeException(message);
        }
    }

    synchronized void rollback(boolean isFramework, SmartSyncTransaction tx) throws SmartSyncException, PersistenceException {
        if (this.currentTransaction == null || tx == null) {
            throw new SmartSyncException("No transaction opened to roll back");
        }
        if (this.currentTransaction != tx && isFramework) {
            return;
        }
        try {
            this.persistenceManger.rollback();
            Object var4_3 = null;
            this.persistenceManger = null;
            this.currentTransaction = null;
            this.POOL.takeTranasaction(tx);
            this.syncBoChangedInCurrentTx = false;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.persistenceManger = null;
            this.currentTransaction = null;
            this.POOL.takeTranasaction(tx);
            this.syncBoChangedInCurrentTx = false;
            throw throwable;
        }
        if (isFramework) {
            TRACE.log(90, "Framework transaction was successfully rolled back.");
        }
    }

    public void rollback(SmartSyncTransaction tx) throws PersistenceException {
        try {
            this.rollback(true, tx);
        }
        catch (SmartSyncException e) {
            String message = "Could not roll back framework transaction. ";
            TRACE.logException(50, message, e, true);
            throw new RuntimeException(message);
        }
    }

    public boolean inManualCommitMode() {
        return this.currentTransaction != null && !this.currentTransaction.isFrameworkTransaction();
    }

    public static ClassDescriptor getClassDescriptor(String classtype) throws PersistenceException {
        return PersistenceRuntime.getInstance().getClassDescriptor(classtype);
    }

    public void registerPersistenceMaster(PackagePersistenceMaster persistenceMaster) throws PersistenceException {
        if (persistenceMaster != null) {
            if (TRACE.isLogging(90)) {
                StringBuffer sb = new StringBuffer();
                String[] classTypeArray = persistenceMaster.getClasstypes();
                int i = 0;
                while (i < classTypeArray.length) {
                    sb.append(classTypeArray[i]);
                    sb.append(',');
                    ++i;
                }
                this.traceDebugInformation("registerPersistenceMaster for classtypes " + sb);
            }
            PersistenceRuntime.getInstance().registerPersistenceMaster(persistenceMaster);
        }
    }

    public SmartSyncEntityFactory getSmartSyncEntityFactory() {
        return this.smartSyncEntityFactory;
    }

    public boolean registerPersistenceMaster() {
        return true;
    }

    public void registerEntityFactory() {
    }

    public void onSwitchConversationId() {
        if (this.currentTransaction != null) {
            try {
                this.rollback(this.currentTransaction);
                this.SMART_SYNC_TRANSACTION_MANAGER.reset();
                Trace.getInstance("MI/Smartsync").log(70, "Current SmartSyncTransaction was rolled back by the framework because application was deactivated andthere is still a pending application transaction.");
            }
            catch (Exception e) {
                TRACE.logException(50, "ConversationID was switched with a pending application transactionbut the transaction could not be rolled back: ", e, true);
            }
        }
        ConversationId newConvId = ConversationIdHandler.getInstance().getCurrentConversationId();
        this.msd = newConvId.getMsd();
        if (this.dataPersistenceAdapter) {
            this.visibility = this.msd.sharedDataVisible() ? VisibilityType.USER_SHARED : VisibilityType.SEPARATED;
        }
    }

    private static final class SmartSyncTransactionPool {
        private Vector freeTransactions = new Vector(5);

        SmartSyncTransactionPool() {
        }

        SmartSyncTransactionImpl getTransaction(boolean frameworkTransaction) {
            SmartSyncTransactionImpl transactionToUse = null;
            if (this.freeTransactions.size() == 0) {
                transactionToUse = new SmartSyncTransactionImpl(frameworkTransaction);
            } else {
                transactionToUse = (SmartSyncTransactionImpl)this.freeTransactions.firstElement();
                transactionToUse.setFrameworkTransaction(frameworkTransaction);
                this.freeTransactions.removeElement(transactionToUse);
            }
            return transactionToUse;
        }

        void takeTranasaction(SmartSyncTransaction tx) {
            if (!this.freeTransactions.contains(tx)) {
                this.freeTransactions.addElement(tx);
            }
        }
    }

    private final class SmartSyncTransactionMangerImpl
    implements SmartSyncTransactionManager {
        private SmartSyncTransaction currentApplicationTransaction;

        SmartSyncTransactionMangerImpl() {
        }

        public void beginTransaction() throws SmartSyncException, PersistenceException {
            if (this.currentApplicationTransaction != null) {
                throw new SmartSyncException("Can not start new transaction because there is still a pending one.");
            }
            this.currentApplicationTransaction = PersistenceAdapterImpl.this.beginTransaction(false);
        }

        public void commit() throws SmartSyncException, PersistenceException {
            if (this.currentApplicationTransaction == null) {
                throw new SmartSyncException("Application has not opened a transaction to commit. ");
            }
            try {
                PersistenceAdapterImpl.this.commit(false, this.currentApplicationTransaction);
                Object var2_1 = null;
                this.currentApplicationTransaction = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.currentApplicationTransaction = null;
                throw throwable;
            }
        }

        public void rollback() throws SmartSyncException, PersistenceException {
            if (this.currentApplicationTransaction == null) {
                throw new SmartSyncException("Application has not opened a transaction to roll back. ");
            }
            try {
                PersistenceAdapterImpl.this.rollback(false, this.currentApplicationTransaction);
                Object var2_1 = null;
                this.currentApplicationTransaction = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.currentApplicationTransaction = null;
                throw throwable;
            }
        }

        public boolean isTransactionStarted() {
            return this.currentApplicationTransaction != null;
        }

        void reset() {
            if (this.currentApplicationTransaction != null) {
                TRACE.log(70, "SmartSyncTransactionManger reseted, destroying application transaction");
                this.currentApplicationTransaction = null;
            }
        }

        public boolean hasSyncBoChanged() {
            if (this.currentApplicationTransaction == null) {
                return false;
            }
            return PersistenceAdapterImpl.this.syncBoChangedInCurrentTx;
        }
    }
}

