/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.meta;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.app.PersistableEntity;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.core.TreeOptionType;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.smartsync.RowDescriptorIterator;
import com.sap.ip.me.api.smartsync.SyncBoDescriptor;
import com.sap.ip.me.api.smartsync.SyncBoDescriptorIterator;
import com.sap.ip.me.core.NestableRuntimeException;
import com.sap.ip.me.smartsync.ipi.InternalRowDescriptor;
import com.sap.ip.me.smartsync.ipi.InternalSyncBoDescriptor;
import com.sap.ip.me.smartsync.ipi.InternalSyncBoDescriptorFacade;
import com.sap.ip.me.smartsync.ipi.PersistenceAdapter;
import com.sap.ip.me.smartsync.ipi.SmartSyncTransaction;
import com.sap.ip.me.smartsync.meta.AbstractFieldDescriptorImpl;
import com.sap.ip.me.smartsync.meta.DescriptorManager;
import com.sap.ip.me.smartsync.meta.FieldGroupDescriptorImpl;
import com.sap.ip.me.smartsync.meta.RelationDescriptorImpl;
import com.sap.ip.me.smartsync.meta.RowDescriptorImpl;
import com.sap.ip.me.smartsync.meta.SyncBoDescriptorImpl;
import java.io.InputStream;
import java.util.Hashtable;

final class SyncBoDescriptorRepository
implements InternalSyncBoDescriptorFacade {
    private static final Trace TRACE = Trace.getInstance("MI/Smartsync");
    private final Hashtable descriptorsByName;
    private final Hashtable descriptorsByKey;
    SyncBoDescriptor[] orderedDescriptors;
    private final PersistenceAdapter metaPersistenceAdapter;

    SyncBoDescriptorRepository(PersistenceAdapter metaPersistenceAdapter) {
        this(metaPersistenceAdapter, null);
    }

    SyncBoDescriptorRepository(PersistenceAdapter metaPersistenceAdapter, InputStream xmlByteArray) {
        if (metaPersistenceAdapter == null) {
            throw new IllegalArgumentException("The MetaPersistenceAdpater should not be NULL!");
        }
        this.metaPersistenceAdapter = metaPersistenceAdapter;
        this.descriptorsByName = new Hashtable();
        this.descriptorsByKey = new Hashtable();
        this.initializeRepositories(xmlByteArray);
    }

    private void initializeRepositories(InputStream xmlByteArray) {
        MeIterator syncBoDescriptors = null;
        if (xmlByteArray != null) {
            syncBoDescriptors = this.transformAndPersistMetaData(xmlByteArray);
        } else {
            try {
                syncBoDescriptors = this.metaPersistenceAdapter.getAll(SyncBoDescriptorImpl.getClassDescriptor(), 2);
            }
            catch (PersistenceException e) {
                if (TRACE.isLogging(50)) {
                    TRACE.logException(50, "Error occurred while retrieving the all SyncBoDescriptors from the persistence layer.", e, true);
                }
                throw new RuntimeException(e.toString());
            }
        }
        this.setSyncBoDescriptors(syncBoDescriptors);
    }

    private MeIterator transformAndPersistMetaData(InputStream xmlByteArray) {
        SmartSyncTransaction tx = null;
        try {
            tx = this.metaPersistenceAdapter.beginTransaction();
            DescriptorManager descriptorMgr = new DescriptorManager(this.metaPersistenceAdapter);
            descriptorMgr.transformToSyncBoDescriptor(xmlByteArray);
            MeIterator syncBoDescs = descriptorMgr.getSyncBoDescriptors();
            while (syncBoDescs.hasNext()) {
                PersistableEntity e = (PersistableEntity)syncBoDescs.next();
                if (this.metaPersistenceAdapter.get(SyncBoDescriptorImpl.getClassDescriptor(), e.getPersistedObject().getKey(), 2) != null) continue;
                this.metaPersistenceAdapter.insert(e, TreeOptionType.DEPENDENT, 2);
            }
            this.metaPersistenceAdapter.commit(tx);
            tx = null;
            return syncBoDescs;
        }
        catch (Exception e) {
            block8: {
                if (TRACE.isLogging(10)) {
                    TRACE.logException(10, "Error occured when persisting the meta data.", e, true);
                }
                try {
                    if (tx != null) {
                        if (TRACE.isLogging(70)) {
                            TRACE.logException(70, "Trying to rollback metadata persisting action.", e, true);
                        }
                        this.metaPersistenceAdapter.rollback(tx);
                    }
                }
                catch (Exception e1) {
                    if (!TRACE.isLogging(50)) break block8;
                    TRACE.logException(50, "Error occured during the rollback of persisting metadata.", e, true);
                }
            }
            throw new NestableRuntimeException(e);
        }
    }

    public SyncBoDescriptor getSyncBoDescriptor(String syncBoName) {
        return (SyncBoDescriptor)this.descriptorsByName.get(syncBoName);
    }

    public InternalSyncBoDescriptor getSyncBoDescriptorForEntityKey(String key) {
        return (InternalSyncBoDescriptor)this.descriptorsByKey.get(key);
    }

    public InternalRowDescriptor getRowDescriptorForEntityKey(String key) {
        return (InternalRowDescriptor)this.descriptorsByKey.get(key);
    }

    public SyncBoDescriptorIterator getAllSyncBoDescriptors() {
        return new SyncBoDescriptorIterator(){
            int next = 0;

            public SyncBoDescriptor next() {
                return SyncBoDescriptorRepository.this.orderedDescriptors[this.next++];
            }

            public boolean hasNext() {
                return SyncBoDescriptorRepository.this.orderedDescriptors.length > this.next;
            }

            public Object nextElement() {
                return this.next();
            }

            public int size() {
                return SyncBoDescriptorRepository.this.orderedDescriptors.length;
            }
        };
    }

    private void setSyncBoDescriptors(MeIterator descriptors) {
        descriptors.reset();
        this.orderedDescriptors = new SyncBoDescriptorImpl[descriptors.elementCount()];
        while (descriptors.hasNext()) {
            SyncBoDescriptorImpl syncBo = (SyncBoDescriptorImpl)descriptors.next();
            this.descriptorsByName.put(syncBo.getSyncBoName(), syncBo);
            this.descriptorsByKey.put(syncBo.getPersistedObject().getKey(), syncBo);
            this.orderedDescriptors[syncBo.getPosition()] = syncBo;
            RowDescriptorImpl row = (RowDescriptorImpl)syncBo.getTopRowDescriptor();
            this.descriptorsByKey.put(row.getPersistedObject().getKey(), row);
            RowDescriptorIterator rows = syncBo.getAllRowDescriptors();
            while (rows.hasNext()) {
                row = (RowDescriptorImpl)rows.next();
                this.descriptorsByKey.put(row.getPersistedObject().getKey(), row);
            }
        }
    }

    /*
     * Loose catch block
     */
    public void _purgeAllDescriptors() {
        block10: {
            SmartSyncTransaction tx = null;
            tx = this.metaPersistenceAdapter.beginTransaction();
            this.metaPersistenceAdapter.deleteAll(SyncBoDescriptorImpl.getClassDescriptor(), TreeOptionType.SKELETON, 2);
            this.metaPersistenceAdapter.deleteAll(RowDescriptorImpl.getClassDescriptor(), TreeOptionType.SKELETON, 2);
            this.metaPersistenceAdapter.deleteAll(AbstractFieldDescriptorImpl.getClassDescriptor(), TreeOptionType.SKELETON, 2);
            this.metaPersistenceAdapter.deleteAll(FieldGroupDescriptorImpl.getClassDescriptor(), TreeOptionType.SKELETON, 2);
            this.metaPersistenceAdapter.deleteAll(RelationDescriptorImpl.getClassDescriptor(), TreeOptionType.SKELETON, 2);
            this.metaPersistenceAdapter.commit(tx);
            tx = null;
            Object var4_2 = null;
            try {
                if (tx != null) {
                    this.metaPersistenceAdapter.rollback(tx);
                }
                break block10;
            }
            catch (PersistenceException e1) {
                if (TRACE.isLogging(50)) {
                    TRACE.logException(50, "Error occured during the rollback of purging metadata.", e1, true);
                }
                break block10;
            }
            {
                catch (PersistenceException e) {
                    throw new NestableRuntimeException(e);
                }
            }
            catch (Throwable throwable) {
                block11: {
                    Object var4_3 = null;
                    try {
                        if (tx != null) {
                            this.metaPersistenceAdapter.rollback(tx);
                        }
                    }
                    catch (PersistenceException e1) {
                        if (!TRACE.isLogging(50)) break block11;
                        TRACE.logException(50, "Error occured during the rollback of purging metadata.", e1, true);
                    }
                }
                throw throwable;
            }
        }
    }
}

