/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.meta;

import com.sap.ip.me.api.conf.VisibilityType;
import com.sap.ip.me.api.persist.core.PersistenceContainer;
import com.sap.ip.me.api.persist.meta.AttributeDescriptor;
import com.sap.ip.me.api.persist.meta.AttributeType;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.persist.meta.DescriptorException;
import com.sap.ip.me.api.persist.meta.DescriptorRuntime;
import com.sap.ip.me.api.persist.meta.LinkDescriptor;
import com.sap.ip.me.api.persist.meta.MultiplicityType;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.smartsync.RelationDescriptor;
import com.sap.ip.me.api.smartsync.RelationDescriptorIterator;
import com.sap.ip.me.api.smartsync.RowDescriptor;
import com.sap.ip.me.api.smartsync.RowDescriptorIterator;
import com.sap.ip.me.api.smartsync.SyncProcessingType;
import com.sap.ip.me.core.ConversationId;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.core.NestableRuntimeException;
import com.sap.ip.me.smartsync.ipi.InternalSyncBoDescriptor;
import com.sap.ip.me.smartsync.ipi.PersistenceConstants;
import com.sap.ip.me.smartsync.meta.RelationDescriptorImpl;
import com.sap.ip.me.smartsync.meta.RowDescriptorImpl;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

final class SyncBoDescriptorImpl
implements InternalSyncBoDescriptor {
    static final int TOTAL_KEY_LEN = 11;
    static final int ATTR_LEN_NAME = 11;
    static final int ATTR_POS_NAME = 0;
    static final int ATTR_POS_VER = 1;
    static final int ATTR_POS_SYNCTYPE = 2;
    static final int ATTR_POS_CREATE = 3;
    static final int ATTR_POS_MODIFY = 4;
    static final int ATTR_POS_DELETE = 5;
    static final int ATTR_POS_REQDS = 6;
    static final int ATTR_POS_MULTILANG = 7;
    static final int ATTR_POS_POSITION = 8;
    static final int ATTR_POS_DOWNLOADORDER = 9;
    static final int LINK_POS_TOP = 0;
    static final int LINK_POS_ROWS = 1;
    static final int LINK_POS_DEPENDENCY = 2;
    private final PersistenceContainer obj;
    private static ClassDescriptor persistableClass = null;
    private final String name;
    private final int version;
    private final SyncProcessingType syncProcessing;
    private final boolean allowCreate;
    private final boolean allowModify;
    private final boolean allowDelete;
    private final boolean reqDirectSync;
    private final boolean multiLangSupport;
    private final int downloadOrder;
    private final int position;
    private RowDescriptor topRowDescriptor;
    Vector rowDescriptorsByIndex;
    private Hashtable childRowDescriptorsByKey;
    private Hashtable childRowDescriptorsIndexTable;
    private int rowIndex;
    Vector dependencyRelations;
    private final ConversationId convId;
    private int hash;

    SyncBoDescriptorImpl(PersistenceContainer o) {
        this(o, (String)o.getAttribute(0), (Integer)o.getAttribute(1), SyncProcessingType.forInt((Integer)o.getAttribute(2)), (Boolean)o.getAttribute(3), (Boolean)o.getAttribute(4), (Boolean)o.getAttribute(5), (Boolean)o.getAttribute(6), (Boolean)o.getAttribute(7), (Integer)o.getAttribute(9), (Integer)o.getAttribute(8));
        this.setRowDescriptors(o.getMultipleLink(1));
        this.setDependencyRelations(o.getMultipleLink(2));
    }

    private SyncBoDescriptorImpl(PersistenceContainer o, String name, int version, SyncProcessingType syncProcessing, boolean allowCreate, boolean allowModify, boolean allowDelete, boolean reqDirectSync, boolean multiLangSupport, int downloadOrder, int position) {
        this.obj = o;
        this.name = name;
        this.version = version;
        this.syncProcessing = syncProcessing;
        this.allowCreate = allowCreate;
        this.allowModify = allowModify;
        this.allowDelete = allowDelete;
        this.reqDirectSync = reqDirectSync;
        this.multiLangSupport = multiLangSupport;
        this.downloadOrder = downloadOrder;
        this.position = position;
        this.convId = ConversationIdHandler.getInstance().getCurrentConversationId(VisibilityType.USER_SHARED);
        this.rowDescriptorsByIndex = new Vector();
        this.childRowDescriptorsByKey = new Hashtable();
        this.childRowDescriptorsIndexTable = new Hashtable();
        this.dependencyRelations = new Vector();
        this.rowIndex = 0;
    }

    int getPosition() {
        return this.position;
    }

    private void setRowDescriptors(MeIterator it) {
        this.rowDescriptorsByIndex.removeAllElements();
        this.childRowDescriptorsByKey.clear();
        this.childRowDescriptorsIndexTable.clear();
        while (it.hasNext()) {
            this.addRowDescriptorToTable((RowDescriptor)it.next());
        }
    }

    private void setDependencyRelations(MeIterator it) {
        this.dependencyRelations.removeAllElements();
        while (it.hasNext()) {
            this.addDependencyRelationToTable((RelationDescriptorImpl)it.next());
        }
    }

    private void addRowDescriptorToTable(RowDescriptor rowDescriptor) {
        this.rowDescriptorsByIndex.addElement(rowDescriptor);
        this.childRowDescriptorsByKey.put(rowDescriptor.getRowName(), rowDescriptor);
        this.childRowDescriptorsIndexTable.put(rowDescriptor, new Integer(this.rowIndex++));
    }

    private void addDependencyRelationToTable(RelationDescriptorImpl relationDescriptor) {
        this.dependencyRelations.addElement(relationDescriptor);
    }

    void addRowDescriptor(RowDescriptorImpl rowDescriptor) {
        this.addRowDescriptorToTable(rowDescriptor);
        this.obj.addMultipleLink(1, rowDescriptor);
    }

    void setTopRowDescriptor(RowDescriptorImpl rowDescriptor) {
        if (rowDescriptor.isTop()) {
            this.obj.setSingleLink(0, rowDescriptor);
            this.topRowDescriptor = rowDescriptor;
        }
    }

    void addRelationDescriptor(RelationDescriptorImpl relationDescriptor) {
        this.addDependencyRelationToTable(relationDescriptor);
        this.obj.addMultipleLink(2, relationDescriptor);
    }

    public PersistenceContainer getPersistedObject() {
        return this.obj;
    }

    public int getPosition(RowDescriptor rowDescriptor) {
        Integer index = (Integer)this.childRowDescriptorsIndexTable.get(rowDescriptor);
        if (index == null) {
            return -1;
        }
        return index;
    }

    public String getSyncBoName() {
        return this.name;
    }

    public SyncProcessingType getSyncProcessing() {
        return this.syncProcessing;
    }

    public RowDescriptor getRowDescriptor(String rowName) {
        if (rowName == null) {
            return null;
        }
        if (rowName.equalsIgnoreCase("TOP")) {
            return this.getTopRowDescriptor();
        }
        return (RowDescriptor)this.childRowDescriptorsByKey.get(rowName);
    }

    public RowDescriptorIterator getAllRowDescriptors() {
        return new RowDescriptorIterator(){
            Enumeration e;
            {
                this.e = SyncBoDescriptorImpl.this.rowDescriptorsByIndex.elements();
            }

            public RowDescriptor next() {
                return (RowDescriptor)this.e.nextElement();
            }

            public boolean hasNext() {
                return this.e.hasMoreElements();
            }

            public int size() {
                return SyncBoDescriptorImpl.this.rowDescriptorsByIndex.size();
            }

            public Object nextElement() {
                return this.e.nextElement();
            }
        };
    }

    public int getRowDescriptorCount() {
        return this.rowDescriptorsByIndex.size();
    }

    public boolean isRequiredDirectSync() {
        return this.reqDirectSync;
    }

    public boolean isAllowedCreate() {
        return this.allowCreate;
    }

    public boolean isAllowedModify() {
        return this.allowModify;
    }

    public boolean isAllowedDelete() {
        return this.allowDelete;
    }

    public boolean isMultiLangSupport() {
        return this.multiLangSupport;
    }

    public RelationDescriptorIterator getDependencyRelations() {
        return new RelationDescriptorIterator(){
            Enumeration e;
            {
                this.e = SyncBoDescriptorImpl.this.dependencyRelations.elements();
            }

            public RelationDescriptor next() {
                return (RelationDescriptor)this.e.nextElement();
            }

            public boolean hasNext() {
                return this.e.hasMoreElements();
            }

            public Object nextElement() {
                return this.e.nextElement();
            }

            public int size() {
                return SyncBoDescriptorImpl.this.dependencyRelations.size();
            }
        };
    }

    public int getVersionUid() {
        return this.version;
    }

    public RowDescriptor getTopRowDescriptor() {
        return this.topRowDescriptor != null ? this.topRowDescriptor : (this.topRowDescriptor = (RowDescriptor)((Object)this.obj.getSingleLink(0)));
    }

    public int getDownloadOrder() {
        return this.downloadOrder;
    }

    public String toString() {
        return this.getSyncBoName();
    }

    public boolean equals(Object objectToCompare) {
        if (objectToCompare == this) {
            return true;
        }
        if (!(objectToCompare instanceof SyncBoDescriptorImpl)) {
            return false;
        }
        SyncBoDescriptorImpl syncBoDescriptorToCompare = (SyncBoDescriptorImpl)objectToCompare;
        return syncBoDescriptorToCompare.convId.equals(this.convId) && syncBoDescriptorToCompare.obj.getKey().equals(this.obj.getKey());
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.convId.hashCode() ^ this.obj.getKey().hashCode();
        }
        return this.hash;
    }

    static SyncBoDescriptorImpl createSyncBoDescriptor(PersistenceContainer o, String name, int version, SyncProcessingType syncProcessing, boolean allowCreate, boolean allowModify, boolean allowDelete, boolean reqDirectSync, boolean multiLangSupport, int downloadOrder, int position) {
        o.setAttribute(0, name);
        o.setAttribute(1, new Integer(version));
        o.setAttribute(2, new Integer(syncProcessing.toInt()));
        o.setAttribute(3, new Boolean(allowCreate));
        o.setAttribute(4, new Boolean(allowModify));
        o.setAttribute(5, new Boolean(allowDelete));
        o.setAttribute(6, new Boolean(reqDirectSync));
        o.setAttribute(7, new Boolean(multiLangSupport));
        o.setAttribute(9, new Integer(downloadOrder));
        o.setAttribute(8, new Integer(position));
        return new SyncBoDescriptorImpl(o, name, version, syncProcessing, allowCreate, allowModify, allowDelete, reqDirectSync, multiLangSupport, downloadOrder, position);
    }

    static ClassDescriptor getClassDescriptor() {
        if (persistableClass == null) {
            try {
                DescriptorRuntime PDR = DescriptorRuntime.getInstance();
                AttributeDescriptor[] attrib = new AttributeDescriptor[]{PDR.createAttributeDescriptor("name", AttributeType.STRING, 1, 11), PDR.createAttributeDescriptor("Version", AttributeType.INTEGER, 1, 1), PDR.createAttributeDescriptor("SyncType", AttributeType.INTEGER, 1, 1), PDR.createAttributeDescriptor("Creatable", AttributeType.BOOLEAN, 1, 1), PDR.createAttributeDescriptor("Modifiable", AttributeType.BOOLEAN, 1, 1), PDR.createAttributeDescriptor("Deletable", AttributeType.BOOLEAN, 1, 1), PDR.createAttributeDescriptor("ReqDirectSync", AttributeType.BOOLEAN, 1, 1), PDR.createAttributeDescriptor("MultiLang", AttributeType.BOOLEAN, 1, 1), PDR.createAttributeDescriptor("Position", AttributeType.INTEGER, 1, 1), PDR.createAttributeDescriptor("DownloadOrder", AttributeType.INTEGER, 1, 1)};
                LinkDescriptor[] link = new LinkDescriptor[]{PDR.createLinkDescriptor("TopRowDescriptor", PersistenceConstants.ROW_DESCRIPTOR_CLASSTYPE, MultiplicityType.SINGLE, true), PDR.createLinkDescriptor("RowDescriptor", PersistenceConstants.ROW_DESCRIPTOR_CLASSTYPE, MultiplicityType.MULTIPLE_VECTOR, true), PDR.createLinkDescriptor("DependencyRelation", PersistenceConstants.RELATION_DESCRIPTOR_CLASSTYPE, MultiplicityType.MULTIPLE_VECTOR, false)};
                persistableClass = PDR.createClassDescriptor(PersistenceConstants.SYNC_BO_DESCRIPTOR_CLASSTYPE, attrib, link, 11);
            }
            catch (DescriptorException e) {
                throw new NestableRuntimeException(e);
            }
        }
        return persistableClass;
    }
}

