/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.meta;

import com.sap.ip.me.api.conf.VisibilityType;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.app.PersistableEntity;
import com.sap.ip.me.api.persist.core.PersistenceContainer;
import com.sap.ip.me.api.persist.meta.AttributeDescriptor;
import com.sap.ip.me.api.persist.meta.AttributeType;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.persist.meta.DescriptorException;
import com.sap.ip.me.api.persist.meta.DescriptorRuntime;
import com.sap.ip.me.api.persist.meta.LinkDescriptor;
import com.sap.ip.me.api.persist.meta.MultiplicityType;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.smartsync.FieldDescriptor;
import com.sap.ip.me.api.smartsync.FieldDescriptorIterator;
import com.sap.ip.me.api.smartsync.RelationDescriptor;
import com.sap.ip.me.api.smartsync.RelationDescriptorIterator;
import com.sap.ip.me.api.smartsync.SyncBoDescriptor;
import com.sap.ip.me.core.ConversationId;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.core.NestableRuntimeException;
import com.sap.ip.me.smartsync.ipi.InternalRowDescriptor;
import com.sap.ip.me.smartsync.ipi.PersistenceConstants;
import com.sap.ip.me.smartsync.meta.SyncBoDescriptorImpl;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

final class RowDescriptorImpl
implements InternalRowDescriptor {
    private static final Trace TRACE = Trace.getInstance("MI/Smartsync");
    static final int TOTAL_KEY_LEN = 15;
    static final int ATTR_POS_ROWNAME = 0;
    static final int ATTR_LEN_ROWNAME = 4;
    static final int ATTR_POS_MAND = 1;
    static final int LINK_POS_SYNC_BO = 0;
    static final int LINK_POS_KEY_FIELD = 1;
    static final int LINK_POS_FIELDS = 2;
    static final int LINK_POS_RELATION = 3;
    private static ClassDescriptor persistableClass = null;
    private final PersistenceContainer obj;
    private final String name;
    private final boolean isMandantory;
    private SyncBoDescriptor syncBoDescriptor = null;
    private Hashtable fieldDescriptorsByKey = null;
    private Hashtable fieldDescriptorsIndexTable;
    Vector fieldDescriptorsByIndex = null;
    Vector relatingRelations = null;
    private FieldDescriptor keyFieldDescriptor = null;
    private int fieldIndex;
    private int hash;
    private final ConversationId convId;

    RowDescriptorImpl(PersistenceContainer obj) {
        this(obj, (String)obj.getAttribute(0), (Boolean)obj.getAttribute(1), obj.sizeLink(2));
        this.setFieldDescriptors(obj.getMultipleLink(2));
        this.setRelationDescriptors(obj.getMultipleLink(3));
    }

    private RowDescriptorImpl(PersistenceContainer obj, String name, boolean isMandantory, int fieldCount) {
        this.obj = obj;
        this.name = name;
        this.isMandantory = isMandantory;
        this.fieldDescriptorsByKey = new Hashtable(fieldCount);
        this.fieldDescriptorsIndexTable = new Hashtable(fieldCount);
        this.fieldDescriptorsByIndex = new Vector(fieldCount);
        this.relatingRelations = new Vector();
        this.convId = ConversationIdHandler.getInstance().getCurrentConversationId(VisibilityType.USER_SHARED);
        this.fieldIndex = 0;
    }

    private void setRelationDescriptors(MeIterator it) {
        this.relatingRelations.removeAllElements();
        while (it.hasNext()) {
            this.addRelationDescriptorToTable((RelationDescriptor)it.next());
        }
    }

    private void setFieldDescriptors(MeIterator it) {
        this.fieldDescriptorsByIndex.removeAllElements();
        this.fieldDescriptorsByKey.clear();
        this.fieldDescriptorsIndexTable.clear();
        while (it.hasNext()) {
            this.addFieldDescriptorToTable((FieldDescriptor)it.next());
        }
    }

    private void addRelationDescriptorToTable(RelationDescriptor relationDescriptor) {
        this.relatingRelations.addElement(relationDescriptor);
    }

    private void addFieldDescriptorToTable(FieldDescriptor fieldDescriptor) {
        this.fieldDescriptorsByIndex.addElement(fieldDescriptor);
        this.fieldDescriptorsByKey.put(fieldDescriptor.getFieldName(), fieldDescriptor);
        this.fieldDescriptorsIndexTable.put(fieldDescriptor, new Integer(this.fieldIndex++));
    }

    void addFieldDescriptor(FieldDescriptor fieldDescriptor) {
        this.addFieldDescriptorToTable(fieldDescriptor);
        this.obj.addMultipleLink(2, (PersistableEntity)((Object)fieldDescriptor));
        if (fieldDescriptor.isKey()) {
            this.obj.setSingleLink(1, (PersistableEntity)((Object)fieldDescriptor));
            this.keyFieldDescriptor = fieldDescriptor;
        }
    }

    void addRelationDescriptor(RelationDescriptor relationDescriptor) {
        this.addRelationDescriptorToTable(relationDescriptor);
        this.obj.addMultipleLink(3, (PersistableEntity)((Object)relationDescriptor));
    }

    void setSyncBoDescriptor(SyncBoDescriptorImpl syncBoDescriptor) {
        this.obj.setSingleLink(0, syncBoDescriptor);
        this.syncBoDescriptor = syncBoDescriptor;
    }

    public PersistenceContainer getPersistedObject() {
        return this.obj;
    }

    public boolean isTop() {
        return this.name.equalsIgnoreCase("TOP");
    }

    public String getRowName() {
        return this.name;
    }

    public boolean isMandatory() {
        return this.isMandantory;
    }

    public FieldDescriptor getKeyFieldDescriptor() {
        return this.keyFieldDescriptor != null ? this.keyFieldDescriptor : (this.keyFieldDescriptor = (FieldDescriptor)((Object)this.obj.getSingleLink(1)));
    }

    public FieldDescriptor getFieldDescriptor(String fieldName) {
        return (FieldDescriptor)this.fieldDescriptorsByKey.get(fieldName);
    }

    public FieldDescriptor getFieldDescriptor(int index) {
        if (index < 0 || index > this.fieldDescriptorsByIndex.size()) {
            return null;
        }
        return (FieldDescriptor)this.fieldDescriptorsByIndex.elementAt(index);
    }

    public FieldDescriptorIterator getAllFieldDescriptors() {
        return new FieldDescriptorIterator(){
            Enumeration e;
            {
                this.e = RowDescriptorImpl.this.fieldDescriptorsByIndex.elements();
            }

            public FieldDescriptor next() {
                return (FieldDescriptor)this.e.nextElement();
            }

            public boolean hasNext() {
                return this.e.hasMoreElements();
            }

            public Object nextElement() {
                return this.e.nextElement();
            }

            public int size() {
                return RowDescriptorImpl.this.fieldDescriptorsByIndex.size();
            }
        };
    }

    public RelationDescriptorIterator getRelatingRelations() {
        return new RelationDescriptorIterator(){
            Enumeration e;
            {
                this.e = RowDescriptorImpl.this.relatingRelations.elements();
            }

            public RelationDescriptor next() {
                return (RelationDescriptor)this.e.nextElement();
            }

            public boolean hasNext() {
                return this.e.hasMoreElements();
            }

            public Object nextElement() {
                return this.e.nextElement();
            }

            public int size() {
                return RowDescriptorImpl.this.relatingRelations.size();
            }
        };
    }

    public SyncBoDescriptor getSyncBoDescriptor() {
        return this.syncBoDescriptor != null ? this.syncBoDescriptor : (this.syncBoDescriptor = (SyncBoDescriptor)((Object)this.obj.getSingleLink(0)));
    }

    public int getFieldCount() {
        return this.fieldDescriptorsByIndex.size();
    }

    public int getFieldIndex(FieldDescriptor descriptor) {
        Integer index = (Integer)this.fieldDescriptorsIndexTable.get(descriptor);
        if (index == null) {
            return -1;
        }
        return index;
    }

    public boolean hasFieldDescriptor(FieldDescriptor fieldDescriptor) {
        int index = this.getFieldIndex(fieldDescriptor);
        return index > -1 && index < this.getFieldCount();
    }

    public String toString() {
        return this.getSyncBoDescriptor() + "/" + this.getRowName();
    }

    public boolean equals(Object objectToCompare) {
        if (objectToCompare == this) {
            return true;
        }
        if (!(objectToCompare instanceof RowDescriptorImpl)) {
            return false;
        }
        RowDescriptorImpl rowDescriptorToCompare = (RowDescriptorImpl)objectToCompare;
        return rowDescriptorToCompare.convId.equals(this.convId) && rowDescriptorToCompare.obj.getKey().equals(this.obj.getKey());
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.convId.hashCode() ^ this.obj.getKey().hashCode();
        }
        return this.hash;
    }

    static RowDescriptorImpl createRowDescriptor(PersistenceContainer o, String name, Boolean isMandantory, int fieldCount) {
        try {
            o.setAttribute(0, name);
            o.setAttribute(1, isMandantory);
            return new RowDescriptorImpl(o, name, isMandantory, fieldCount);
        }
        catch (Exception e) {
            if (TRACE.isLogging(50)) {
                TRACE.logException(50, e);
            }
            return null;
        }
    }

    static ClassDescriptor getClassDescriptor() {
        if (persistableClass == null) {
            try {
                DescriptorRuntime PDR = DescriptorRuntime.getInstance();
                AttributeDescriptor[] attrib = new AttributeDescriptor[]{PDR.createAttributeDescriptor("RowName", AttributeType.STRING, 1, 4), PDR.createAttributeDescriptor("IsMandatory", AttributeType.BOOLEAN, 1, 1)};
                LinkDescriptor[] link = new LinkDescriptor[]{PDR.createLinkDescriptor("SyncBoDescriptor", PersistenceConstants.SYNC_BO_DESCRIPTOR_CLASSTYPE, MultiplicityType.SINGLE, false), PDR.createLinkDescriptor("KeyFieldDescriptor", PersistenceConstants.FIELD_DESCRIPTOR_CLASSTYPE, MultiplicityType.SINGLE, true), PDR.createLinkDescriptor("FieldDescriptor", PersistenceConstants.FIELD_DESCRIPTOR_CLASSTYPE, MultiplicityType.MULTIPLE_VECTOR, true), PDR.createLinkDescriptor("RelatingRelation", PersistenceConstants.RELATION_DESCRIPTOR_CLASSTYPE, MultiplicityType.MULTIPLE_VECTOR, false)};
                persistableClass = PDR.createClassDescriptor(PersistenceConstants.ROW_DESCRIPTOR_CLASSTYPE, attrib, link, 15);
            }
            catch (DescriptorException e) {
                throw new NestableRuntimeException(e);
            }
        }
        return persistableClass;
    }
}

