/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.meta;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.app.PersistableEntity;
import com.sap.ip.me.api.persist.core.PersistenceContainer;
import com.sap.ip.me.api.persist.meta.AttributeDescriptor;
import com.sap.ip.me.api.persist.meta.AttributeType;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.persist.meta.DescriptorException;
import com.sap.ip.me.api.persist.meta.DescriptorRuntime;
import com.sap.ip.me.api.persist.meta.LinkDescriptor;
import com.sap.ip.me.api.persist.meta.MultiplicityType;
import com.sap.ip.me.api.smartsync.DependencyType;
import com.sap.ip.me.api.smartsync.FieldDescriptor;
import com.sap.ip.me.api.smartsync.RelationDescriptor;
import com.sap.ip.me.api.smartsync.RowDescriptor;
import com.sap.ip.me.core.NestableRuntimeException;
import com.sap.ip.me.smartsync.ipi.PersistenceConstants;

final class RelationDescriptorImpl
implements PersistableEntity,
RelationDescriptor {
    private static final Trace TRACE = Trace.getInstance("MI/Smartsync");
    private static ClassDescriptor persistableClass = null;
    static final int TOTAL_KEY_LEN = 61;
    static final int ATTR_POS_DEPENDENCY = 0;
    static final int LINK_POS_RELATING_FIELD = 0;
    static final int LINK_POS_RELATED_ROW = 1;
    private FieldDescriptor relatingFieldDescriptor;
    private RowDescriptor relatedRowDescriptor;
    private final PersistenceContainer obj;
    private final DependencyType dependency;
    private final String key;
    private String relatedSyncBo = null;
    private String relatedRow = null;

    RelationDescriptorImpl(PersistenceContainer obj) {
        this(obj, DependencyType.forString((String)obj.getAttribute(0)));
    }

    private RelationDescriptorImpl(PersistenceContainer obj, DependencyType type) {
        this.obj = obj;
        this.key = obj.getKey();
        this.dependency = type;
    }

    void setRelatedAttributes(String syncBoName, String rowName) {
        this.relatedSyncBo = syncBoName;
        this.relatedRow = rowName;
    }

    void setRelatedRowDescriptor(RowDescriptor relatedRowDescriptor) {
        this.relatedRowDescriptor = relatedRowDescriptor;
        this.obj.setSingleLink(1, (PersistableEntity)((Object)relatedRowDescriptor));
    }

    void setRelatingFieldDescriptor(FieldDescriptor relatingFieldDescriptor) {
        this.relatingFieldDescriptor = relatingFieldDescriptor;
        this.obj.setSingleLink(0, (PersistableEntity)((Object)relatingFieldDescriptor));
    }

    String getRelatedRowName() {
        return this.relatedRow;
    }

    String getRelatedSyncBoName() {
        return this.relatedSyncBo;
    }

    public FieldDescriptor getRelatingFieldDescriptor() {
        if (this.relatingFieldDescriptor == null) {
            this.relatingFieldDescriptor = (FieldDescriptor)((Object)this.obj.getSingleLink(0));
        }
        return this.relatingFieldDescriptor;
    }

    public RowDescriptor getRelatedRowDescriptor() {
        if (this.relatedRowDescriptor == null) {
            this.relatedRowDescriptor = (RowDescriptor)((Object)this.obj.getSingleLink(1));
        }
        return this.relatedRowDescriptor;
    }

    public DependencyType getDependency() {
        return this.dependency;
    }

    public String getRelationDescriptorId() {
        return this.obj.getKey();
    }

    public PersistenceContainer getPersistedObject() {
        return this.obj;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object o) {
        return this.key.equals(o);
    }

    static RelationDescriptorImpl createRelationDescriptor(PersistenceContainer o, DependencyType type) {
        try {
            o.setAttribute(0, type.toString());
            return new RelationDescriptorImpl(o, type);
        }
        catch (Exception e) {
            if (TRACE.isLogging(50)) {
                TRACE.logException(50, e);
            }
            return null;
        }
    }

    static ClassDescriptor getClassDescriptor() {
        if (persistableClass == null) {
            try {
                DescriptorRuntime PDR = DescriptorRuntime.getInstance();
                AttributeDescriptor[] attrib = new AttributeDescriptor[]{PDR.createAttributeDescriptor("DependencyType", AttributeType.STRING, 1, 20)};
                LinkDescriptor[] link = new LinkDescriptor[]{PDR.createLinkDescriptor("relatingFieldDescriptor", PersistenceConstants.FIELD_DESCRIPTOR_CLASSTYPE, MultiplicityType.SINGLE, false), PDR.createLinkDescriptor("relatedRowDescriptor", PersistenceConstants.ROW_DESCRIPTOR_CLASSTYPE, MultiplicityType.SINGLE, false)};
                persistableClass = PDR.createClassDescriptor(PersistenceConstants.RELATION_DESCRIPTOR_CLASSTYPE, attrib, link, 61);
            }
            catch (DescriptorException e) {
                throw new NestableRuntimeException(e);
            }
        }
        return persistableClass;
    }
}

