/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.meta;

import com.sap.ip.me.api.conf.VisibilityType;
import com.sap.ip.me.api.persist.app.EntityFactory;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.core.TreeOptionType;
import com.sap.ip.me.api.smartsync.SyncBoDescriptorFacade;
import com.sap.ip.me.core.ConversationId;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.core.NestableRuntimeException;
import com.sap.ip.me.smartsync.ipi.InterMetaPackageManager;
import com.sap.ip.me.smartsync.ipi.InternalSyncBoDescriptorFacade;
import com.sap.ip.me.smartsync.ipi.PersistenceAdapter;
import com.sap.ip.me.smartsync.ipi.PersistenceConstants;
import com.sap.ip.me.smartsync.ipi.SmartSyncEntityFactory;
import com.sap.ip.me.smartsync.ipi.SmartSyncTransaction;
import com.sap.ip.me.smartsync.meta.AbstractFieldDescriptorImpl;
import com.sap.ip.me.smartsync.meta.FieldGroupDescriptorImpl;
import com.sap.ip.me.smartsync.meta.MetaEntityFactory;
import com.sap.ip.me.smartsync.meta.MetaPackagePersistenceMaster;
import com.sap.ip.me.smartsync.meta.RelationDescriptorImpl;
import com.sap.ip.me.smartsync.meta.RowDescriptorImpl;
import com.sap.ip.me.smartsync.meta.SyncBoDescriptorImpl;
import com.sap.ip.me.smartsync.meta.SyncBoDescriptorRepository;
import com.sap.ip.me.smartsync.util.SmartSyncCache;
import com.sap.ip.me.smartsync.util.SmartSyncUtil;
import com.sap.ip.me.smartsync.util.XTrace;
import java.io.IOException;
import java.io.InputStream;

public class MetaPackageManager
implements InterMetaPackageManager {
    private SmartSyncCache repositoryPool = SmartSyncCache.newInstance();
    private static XTrace TRACE = new XTrace(".data");
    private final PersistenceAdapter PERSISTENCE_ADAPTER;
    private static final String META_FILENAME = "MetaInfo";

    public MetaPackageManager(PersistenceAdapter metaPersitenceAdapter) {
        this.PERSISTENCE_ADAPTER = metaPersitenceAdapter;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onSwitchConversationId() {
        share = ConversationIdHandler.getInstance().getCurrentConversationId(VisibilityType.USER_SHARED);
        tx = null;
        try {
            block15: {
                if (!this.repositoryPool.isCurrentKey(share.getId())) break block15;
                var5_3 = null;
                ** GOTO lbl41
            }
            tx = this.PERSISTENCE_ADAPTER.beginTransaction();
            if (this.repositoryPool.containsKey(share.getId())) {
                this.repositoryPool.setCurrentKey(share.getId());
            } else {
                this.repositoryPool.add(share.getId(), new SyncBoDescriptorRepository(this.PERSISTENCE_ADAPTER));
            }
            this.PERSISTENCE_ADAPTER.commit(tx);
            tx = null;
            ** GOTO lbl53
        }
        catch (PersistenceException e) {
            if (MetaPackageManager.TRACE.isLogging()) {
                MetaPackageManager.TRACE.log("Error while onSwitch event in MetaPackageManger.", e.getMessage());
            }
            if (MetaPackageManager.TRACE.isDebugMode() == false) throw new NestableRuntimeException(e);
            MetaPackageManager.TRACE.logError("Persistence Exception at onSwitchConversatioId.", e);
            throw new NestableRuntimeException(e);
        }
        {
            catch (Throwable var4_10) {
                var5_5 = null;
                try {
                    if (tx == null) throw var4_10;
                    this.PERSISTENCE_ADAPTER.rollback(tx);
                    throw var4_10;
                }
                catch (Exception e1) {
                    if (MetaPackageManager.TRACE.isLogging()) {
                        MetaPackageManager.TRACE.log("Can not rollback transaction. ", e1.getMessage());
                    }
                    if (MetaPackageManager.TRACE.isDebugMode() == false) throw var4_10;
                    MetaPackageManager.TRACE.logError("Exception during Rollback invocation at onSwitchConversatioId.", e1);
                }
                throw var4_10;
            }
lbl41:
            // 1 sources

            ** try [egrp 2[TRYBLOCK] [2 : 169->186)] { 
lbl42:
            // 1 sources

            if (tx == null) return;
            this.PERSISTENCE_ADAPTER.rollback(tx);
            return;
lbl45:
            // 1 sources

            catch (Exception e1) {
                if (MetaPackageManager.TRACE.isLogging()) {
                    MetaPackageManager.TRACE.log("Can not rollback transaction. ", e1.getMessage());
                }
                if (MetaPackageManager.TRACE.isDebugMode() == false) return;
                MetaPackageManager.TRACE.logError("Exception during Rollback invocation at onSwitchConversatioId.", e1);
            }
            return;
lbl53:
            // 1 sources

            var5_4 = null;
            try {}
            catch (Exception e1) {}
            if (MetaPackageManager.TRACE.isLogging()) {
                MetaPackageManager.TRACE.log("Can not rollback transaction. ", e1.getMessage());
            }
            if (MetaPackageManager.TRACE.isDebugMode() == false) return;
            MetaPackageManager.TRACE.logError("Exception during Rollback invocation at onSwitchConversatioId.", e1);
            return;
            if (tx == null) return;
            this.PERSISTENCE_ADAPTER.rollback(tx);
            return;
        }
    }

    public void initializeSyncBoDescriptorRepository(ConversationId convId, InputStream xmlByteArray) {
        ConversationId sharedConvId = ConversationIdHandler.getInstance().getCurrentConversationId(VisibilityType.USER_SHARED);
        this.repositoryPool.add(sharedConvId.getId(), new SyncBoDescriptorRepository(this.PERSISTENCE_ADAPTER, xmlByteArray));
        try {
            String xml;
            if (TRACE.isLogging()) {
                xml = SmartSyncUtil.readStream(xmlByteArray);
                String msg = "Initializing SyncBoRepository from InputStream for ConvID[" + convId.toString() + "].";
                TRACE.log(msg, xml);
            }
            if (TRACE.isDebugMode()) {
                xml = SmartSyncUtil.readStream(xmlByteArray);
                TRACE.appendLog(META_FILENAME, xml);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void importXmlMeta(InputStream xmlByteArray) throws PersistenceException {
        ConversationId sharedConvId;
        block4: {
            SmartSyncTransaction tx;
            block5: {
                sharedConvId = ConversationIdHandler.getInstance().getCurrentConversationId(VisibilityType.USER_SHARED);
                tx = null;
                try {
                    tx = this.PERSISTENCE_ADAPTER.beginTransaction();
                    this.PERSISTENCE_ADAPTER.deleteAll(SyncBoDescriptorImpl.getClassDescriptor(), TreeOptionType.SKELETON, 2);
                    this.PERSISTENCE_ADAPTER.deleteAll(RowDescriptorImpl.getClassDescriptor(), TreeOptionType.SKELETON, 2);
                    this.PERSISTENCE_ADAPTER.deleteAll(AbstractFieldDescriptorImpl.getClassDescriptor(), TreeOptionType.SKELETON, 2);
                    this.PERSISTENCE_ADAPTER.deleteAll(FieldGroupDescriptorImpl.getClassDescriptor(), TreeOptionType.SKELETON, 2);
                    this.PERSISTENCE_ADAPTER.deleteAll(RelationDescriptorImpl.getClassDescriptor(), TreeOptionType.SKELETON, 2);
                    this.PERSISTENCE_ADAPTER.commit(tx);
                    tx = null;
                    Object var5_4 = null;
                    if (tx == null) break block4;
                    if (!TRACE.isLogging()) break block5;
                    TRACE.log("Error while importing xml metadata. Try to rollback transaction.");
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (tx != null) {
                        if (TRACE.isLogging()) {
                            TRACE.log("Error while importing xml metadata. Try to rollback transaction.");
                        }
                        this.PERSISTENCE_ADAPTER.rollback(tx);
                    }
                    throw throwable;
                }
            }
            this.PERSISTENCE_ADAPTER.rollback(tx);
            {
            }
        }
        this.repositoryPool.add(sharedConvId.getId(), new SyncBoDescriptorRepository(this.PERSISTENCE_ADAPTER, xmlByteArray));
    }

    public void _clearRepositoryPool() {
        this.repositoryPool.init();
    }

    public SyncBoDescriptorFacade getSyncBoDescriptorFacade() {
        return (SyncBoDescriptorFacade)this.repositoryPool.getCurrentObject();
    }

    public InternalSyncBoDescriptorFacade getInternalSyncBoDescriptorFacade() {
        return (InternalSyncBoDescriptorFacade)this.getSyncBoDescriptorFacade();
    }

    public boolean registerPersistenceMaster() {
        MetaPackagePersistenceMaster master = new MetaPackagePersistenceMaster();
        try {
            this.PERSISTENCE_ADAPTER.registerPersistenceMaster(master);
        }
        catch (PersistenceException e) {
            if (TRACE.isLogging()) {
                TRACE.log("Exception caught at registerPersistenceMaster.", e.getMessage());
            }
            if (TRACE.isDebugMode()) {
                TRACE.logError("Exception caught at registerPersistenceMaster for classtypes:", master.getClasstypes());
                TRACE.logError("Exception caught at registerPersistenceMaster.", e);
            }
            throw new NestableRuntimeException(e);
        }
        return true;
    }

    public void registerEntityFactory() {
        SmartSyncEntityFactory entityFactory = this.PERSISTENCE_ADAPTER.getSmartSyncEntityFactory();
        MetaEntityFactory member = new MetaEntityFactory();
        entityFactory.registerMember(PersistenceConstants.SYNC_BO_DESCRIPTOR_CLASSTYPE_PREFIX, (EntityFactory)member);
        entityFactory.registerMember(PersistenceConstants.ROW_DESCRIPTOR_CLASSTYPE_PREFIX, (EntityFactory)member);
        entityFactory.registerMember(PersistenceConstants.FIELD_DESCRIPTOR_CLASSTYPE_PREFIX, (EntityFactory)member);
        entityFactory.registerMember(PersistenceConstants.RELATION_DESCRIPTOR_CLASSTYPE_PREFIX, (EntityFactory)member);
        entityFactory.registerMember(PersistenceConstants.FIELDGROUP_DESCRIPTOR_CLASSTYPE_PREFIX, (EntityFactory)member);
    }
}

