/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.meta;

import com.sap.ip.me.api.persist.app.EntityFactory;
import com.sap.ip.me.api.persist.app.PersistableEntity;
import com.sap.ip.me.api.persist.core.PersistenceContainer;
import com.sap.ip.me.smartsync.ipi.PersistenceConstants;
import com.sap.ip.me.smartsync.meta.AbstractFieldDescriptorImpl;
import com.sap.ip.me.smartsync.meta.FieldGroupDescriptorImpl;
import com.sap.ip.me.smartsync.meta.RelationDescriptorImpl;
import com.sap.ip.me.smartsync.meta.RowDescriptorImpl;
import com.sap.ip.me.smartsync.meta.SyncBoDescriptorImpl;
import java.util.Hashtable;

final class MetaEntityFactory
implements EntityFactory {
    static final int MAX_LENGTH_FIELDNAME = 31;
    static final int MAX_LENGTH_ROWNAME = 4;
    static final int MAX_LENGTH_SYNCBONAME = 11;
    static final int MAX_LENGTH_RELATIONNAME = 46;
    private Hashtable _handlers = new Hashtable(5);

    MetaEntityFactory() {
        this.setHandlers();
    }

    private void setHandlers() {
        this._handlers.put(PersistenceConstants.FIELD_DESCRIPTOR_CLASSTYPE, new FieldDescriptorHandler());
        this._handlers.put(PersistenceConstants.FIELDGROUP_DESCRIPTOR_CLASSTYPE, new FieldGroupDescriptorHandler());
        this._handlers.put(PersistenceConstants.ROW_DESCRIPTOR_CLASSTYPE, new RowDescriptorHandler());
        this._handlers.put(PersistenceConstants.SYNC_BO_DESCRIPTOR_CLASSTYPE, new SyncBoDescriptorHandler());
        this._handlers.put(PersistenceConstants.RELATION_DESCRIPTOR_CLASSTYPE, new RelationDescriptorHandler());
    }

    public PersistableEntity createEntity(PersistenceContainer o) {
        String classtype = o.getClasstype();
        Handler handler = (Handler)this._handlers.get(classtype);
        if (handler == null) {
            return null;
        }
        return (PersistableEntity)handler.createDescriptor(o);
    }

    class RelationDescriptorHandler
    implements Handler {
        RelationDescriptorHandler() {
        }

        public Object createDescriptor(PersistenceContainer o) {
            return new RelationDescriptorImpl(o);
        }
    }

    class FieldGroupDescriptorHandler
    implements Handler {
        FieldGroupDescriptorHandler() {
        }

        public Object createDescriptor(PersistenceContainer o) {
            return new FieldGroupDescriptorImpl(o);
        }
    }

    class SyncBoDescriptorHandler
    implements Handler {
        SyncBoDescriptorHandler() {
        }

        public Object createDescriptor(PersistenceContainer o) {
            return new SyncBoDescriptorImpl(o);
        }
    }

    class RowDescriptorHandler
    implements Handler {
        RowDescriptorHandler() {
        }

        public Object createDescriptor(PersistenceContainer o) {
            return new RowDescriptorImpl(o);
        }
    }

    class FieldDescriptorHandler
    implements Handler {
        FieldDescriptorHandler() {
        }

        public Object createDescriptor(PersistenceContainer o) {
            return AbstractFieldDescriptorImpl.createFieldDescriptor(o);
        }
    }

    static interface Handler {
        public Object createDescriptor(PersistenceContainer var1);
    }
}

