/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.meta;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.app.PersistableEntity;
import com.sap.ip.me.api.persist.core.PersistenceContainer;
import com.sap.ip.me.api.persist.meta.AttributeDescriptor;
import com.sap.ip.me.api.persist.meta.AttributeType;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.persist.meta.DescriptorException;
import com.sap.ip.me.api.persist.meta.DescriptorRuntime;
import com.sap.ip.me.api.persist.meta.LinkDescriptor;
import com.sap.ip.me.api.persist.meta.MultiplicityType;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.smartsync.FieldDescriptor;
import com.sap.ip.me.api.smartsync.FieldDescriptorIterator;
import com.sap.ip.me.api.smartsync.FieldGroupDescriptor;
import com.sap.ip.me.api.smartsync.FieldGroupType;
import com.sap.ip.me.core.NestableRuntimeException;
import com.sap.ip.me.smartsync.ipi.PersistenceConstants;
import java.util.Enumeration;
import java.util.Vector;

final class FieldGroupDescriptorImpl
implements PersistableEntity,
FieldGroupDescriptor {
    private static final Trace TRACE = Trace.getInstance("MI/Smartsync");
    private static ClassDescriptor persistableClass = null;
    private final PersistenceContainer obj;
    static final int ATTR_POS_NAME = 0;
    static final int ATTR_LEN_NAME = 20;
    static final int ATTR_POS_TYPE = 1;
    static final int ATTR_LEN_TYPE = 1;
    static final int LINK_POS_FIELDS = 0;
    private final String name;
    private final FieldGroupType type;
    Vector fieldDescriptors;

    FieldGroupDescriptorImpl(PersistenceContainer obj) {
        this(obj, (String)obj.getAttribute(0), FieldGroupType.forString((String)obj.getAttribute(1)));
        this.setFieldDescriptors(obj.getMultipleLink(0));
    }

    private FieldGroupDescriptorImpl(PersistenceContainer obj, String name, FieldGroupType type) {
        this.obj = obj;
        this.name = name;
        this.type = type;
        this.fieldDescriptors = new Vector();
    }

    private void setFieldDescriptors(MeIterator it) {
        this.fieldDescriptors.removeAllElements();
        while (it.hasNext()) {
            this.addFieldDescriptorToTable((FieldDescriptor)it.next());
        }
    }

    private void addFieldDescriptorToTable(FieldDescriptor fieldDescriptor) {
        this.fieldDescriptors.addElement(fieldDescriptor);
    }

    void addFieldDescriptor(FieldDescriptor fieldDescriptor) {
        this.addFieldDescriptorToTable(fieldDescriptor);
        this.obj.addMultipleLink(0, (PersistableEntity)((Object)fieldDescriptor));
    }

    public PersistenceContainer getPersistedObject() {
        return this.obj;
    }

    public FieldGroupType getFieldGroupType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public FieldDescriptorIterator getAllFieldDescriptors() {
        return new FieldDescriptorIterator(){
            Enumeration e;
            {
                this.e = FieldGroupDescriptorImpl.this.fieldDescriptors.elements();
            }

            public FieldDescriptor next() {
                return (FieldDescriptor)this.e.nextElement();
            }

            public int size() {
                return FieldGroupDescriptorImpl.this.fieldDescriptors.size();
            }

            public boolean hasNext() {
                return this.e.hasMoreElements();
            }

            public Object nextElement() {
                return (FieldDescriptor)this.e.nextElement();
            }
        };
    }

    static FieldGroupDescriptorImpl createFieldGroupDescriptor(PersistenceContainer o, String name, FieldGroupType type) {
        try {
            o.setAttribute(0, name);
            o.setAttribute(1, type.toString());
            return new FieldGroupDescriptorImpl(o, name, type);
        }
        catch (Exception e) {
            if (TRACE.isLogging(50)) {
                TRACE.logException(50, e);
            }
            return null;
        }
    }

    static ClassDescriptor getClassDescriptor() {
        if (persistableClass == null) {
            try {
                DescriptorRuntime PDR = DescriptorRuntime.getInstance();
                AttributeDescriptor[] attrib = new AttributeDescriptor[]{PDR.createAttributeDescriptor("Name", AttributeType.STRING, 1, 20), PDR.createAttributeDescriptor("Type", AttributeType.STRING, 1, 1)};
                LinkDescriptor[] link = new LinkDescriptor[]{PDR.createLinkDescriptor("FieldDescriptor", PersistenceConstants.FIELD_DESCRIPTOR_CLASSTYPE, MultiplicityType.MULTIPLE_VECTOR, true)};
                persistableClass = PDR.createClassDescriptor(PersistenceConstants.FIELDGROUP_DESCRIPTOR_CLASSTYPE, attrib, link);
            }
            catch (DescriptorException e) {
                throw new NestableRuntimeException(e);
            }
        }
        return persistableClass;
    }
}

