/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.meta;

import com.sap.ip.me.api.persist.core.PersistenceContainer;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.smartsync.BasisFieldType;
import com.sap.ip.me.api.smartsync.DependencyType;
import com.sap.ip.me.api.smartsync.FieldDescriptor;
import com.sap.ip.me.api.smartsync.FieldDescriptorIterator;
import com.sap.ip.me.api.smartsync.FieldGroupType;
import com.sap.ip.me.api.smartsync.FieldInputQualifyType;
import com.sap.ip.me.api.smartsync.RelationDescriptor;
import com.sap.ip.me.api.smartsync.RowDescriptor;
import com.sap.ip.me.api.smartsync.RowDescriptorIterator;
import com.sap.ip.me.api.smartsync.SmartSyncException;
import com.sap.ip.me.api.smartsync.SyncBoDescriptor;
import com.sap.ip.me.api.smartsync.SyncProcessingType;
import com.sap.ip.me.smartsync.ipi.PersistenceAdapter;
import com.sap.ip.me.smartsync.meta.AbstractFieldDescriptorImpl;
import com.sap.ip.me.smartsync.meta.FieldGroupDescriptorImpl;
import com.sap.ip.me.smartsync.meta.RelationDescriptorImpl;
import com.sap.ip.me.smartsync.meta.RowDescriptorImpl;
import com.sap.ip.me.smartsync.meta.SyncBoDescriptorImpl;
import com.sap.ip.me.smartsync.util.SmartSyncXMLParser;
import com.sap.ip.me.smartsync.util.SmartSyncXMLUtil;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Element;

public class DescriptorManager
extends SmartSyncXMLParser {
    private Hashtable syncBoDescriptorsByKey = null;
    Vector syncBoDescriptorsByIndex = null;
    private Hashtable handlers_ = null;
    PersistenceAdapter metaPersAdapter;
    private int positionCounter = 1;

    DescriptorManager(PersistenceAdapter metaPers) {
        this.metaPersAdapter = metaPers;
        this.syncBoDescriptorsByKey = new Hashtable();
        this.syncBoDescriptorsByIndex = new Vector();
        this._setHandlers();
    }

    private void addSyncBoDescriptor(SyncBoDescriptor boDesc) {
        this.syncBoDescriptorsByKey.put(boDesc.getSyncBoName(), boDesc);
        this.syncBoDescriptorsByIndex.addElement(boDesc);
    }

    private void _setHandlers() {
        this.handlers_ = new Hashtable();
        this.handlers_.put("SyncBO", new SyncBoDescriptorHandler());
        this.handlers_.put("TopStructure", new TopStructureHandler("TopStructure"));
        this.handlers_.put("ChildStructure", new ChildStructureHandler("ChildStructure"));
        this.handlers_.put("Field", new FieldHandler("Field"));
        this.handlers_.put("FieldGroup", new FieldGroupHandler("FieldGroup"));
        this.handlers_.put("Relation", new RelationHandler("Relation"));
    }

    Handler _getHandler(String tag) throws Exception {
        return (Handler)this.handlers_.get(tag);
    }

    int getNextOrderNumber() {
        return this.positionCounter++;
    }

    MeIterator getSyncBoDescriptors() {
        return new MeIterator(){
            Enumeration e;
            {
                this.e = DescriptorManager.this.syncBoDescriptorsByIndex.elements();
            }

            public boolean hasNext() {
                return this.e.hasMoreElements();
            }

            public Object next() {
                return this.e.nextElement();
            }

            public int elementCount() {
                return DescriptorManager.this.syncBoDescriptorsByIndex.size();
            }

            public void reset() {
                this.e = DescriptorManager.this.syncBoDescriptorsByIndex.elements();
            }
        };
    }

    void transformToSyncBoDescriptor(InputStream xmlAsByteArray) throws Exception {
        Element root = SmartSyncXMLUtil.getRootElement(xmlAsByteArray);
        Handler handler = this._getHandler("SyncBO");
        Element[] syncBos = SmartSyncXMLParser.getChildElements(root, "SyncBO");
        int i = 0;
        while (i < syncBos.length) {
            SyncBoDescriptorImpl boDesc = (SyncBoDescriptorImpl)handler.transform(syncBos[i], new Integer(i));
            this.addSyncBoDescriptor(boDesc);
            ++i;
        }
        this.processRelations();
    }

    private void processRelations(RowDescriptor parentRd) {
        FieldDescriptorIterator itr = parentRd.getAllFieldDescriptors();
        while (itr.hasNext()) {
            RelationDescriptorImpl rd = (RelationDescriptorImpl)itr.next().getRelatedRelation();
            if (rd == null) continue;
            SyncBoDescriptor bod = (SyncBoDescriptor)this.syncBoDescriptorsByKey.get(rd.getRelatedSyncBoName());
            RowDescriptor rowd = bod.getRowDescriptor(rd.getRelatedRowName());
            rd.setRelatedRowDescriptor(rowd);
            ((RowDescriptorImpl)rowd).addRelationDescriptor(rd);
        }
    }

    private void processRelations() {
        Enumeration e = this.syncBoDescriptorsByKey.elements();
        while (e.hasMoreElements()) {
            SyncBoDescriptorImpl boDesc = (SyncBoDescriptorImpl)e.nextElement();
            this.processRelations(boDesc.getTopRowDescriptor());
            RowDescriptorIterator rowIt = boDesc.getAllRowDescriptors();
            while (rowIt.hasNext()) {
                this.processRelations(rowIt.next());
            }
        }
    }

    public String toString() {
        String header = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n";
        StringBuffer sb = new StringBuffer(header);
        sb.append("<MeRepApplication schemaVersion=\"1.0\" id=\"TESTAPPLICATION\" version=\"1.0\">\n");
        Enumeration e = this.syncBoDescriptorsByIndex.elements();
        while (e.hasMoreElements()) {
            sb.append(e.nextElement().toString()).append("\n");
        }
        sb.append("</MeRepApplication>");
        return sb.toString();
    }

    private class RelationHandler
    extends Handler {
        public RelationHandler(String structureName) {
            this.setRoot(structureName);
        }

        public Object transform(Element root, Object parentObject) throws Exception {
            this.validateRoot(root);
            DependencyType type = DependencyType.forString(SmartSyncXMLParser.getRequiredAttribute(root, "type"));
            String baseSyncBo = SmartSyncXMLParser.getChildValue(SmartSyncXMLParser.getChildElement(root, "BaseSyncBO"));
            String baseStructure = SmartSyncXMLParser.getChildValue(SmartSyncXMLParser.getChildElement(root, "BaseStructure"));
            AbstractFieldDescriptorImpl fieldDescriptor = (AbstractFieldDescriptorImpl)parentObject;
            String key = fieldDescriptor.getPersistedObject().getKey();
            RelationDescriptorImpl relationDescriptor = RelationDescriptorImpl.createRelationDescriptor(this.createEmptyContainer(RelationDescriptorImpl.getClassDescriptor(), key), type);
            relationDescriptor.setRelatedAttributes(baseSyncBo, baseStructure);
            relationDescriptor.setRelatingFieldDescriptor(fieldDescriptor);
            fieldDescriptor.setRelatedRelation(relationDescriptor);
            return relationDescriptor;
        }
    }

    private class FieldGroupHandler
    extends Handler {
        public FieldGroupHandler(String structureName) {
            this.setRoot(structureName);
        }

        public Object transform(Element root, Object parentObject) throws Exception {
            this.validateRoot(root);
            String name = SmartSyncXMLParser.getRequiredAttribute(root, "name");
            FieldGroupType type = FieldGroupType.forString(SmartSyncXMLParser.getRequiredAttribute(root, "type"));
            RowDescriptor parentDescriptor = (RowDescriptor)parentObject;
            SyncBoDescriptor grandParent = parentDescriptor.getSyncBoDescriptor();
            String key = this.createKey(grandParent.getSyncBoName(), parentDescriptor.getRowName(), name);
            FieldGroupDescriptorImpl fieldGroup = FieldGroupDescriptorImpl.createFieldGroupDescriptor(this.createEmptyContainer(FieldGroupDescriptorImpl.getClassDescriptor(), key), name, type);
            Element[] fields = SmartSyncXMLParser.getChildElements(root, "Field");
            int i = 0;
            while (i < fields.length) {
                String fieldName = SmartSyncXMLParser.getAttrAsString(fields[i], "name");
                AbstractFieldDescriptorImpl fieldDescriptor = (AbstractFieldDescriptorImpl)parentDescriptor.getFieldDescriptor(fieldName);
                fieldGroup.addFieldDescriptor(fieldDescriptor);
                fieldDescriptor.addFieldGroupDescriptor(fieldGroup);
                ++i;
            }
            return fieldGroup;
        }
    }

    private class FieldHandler
    extends Handler {
        private static final String INPUT_CREATE = "create";
        private static final String INPUT_MODIFY = "modify";

        public FieldHandler(String structureName) {
            this.setRoot(structureName);
        }

        public Object transform(Element root, Object parentObject) throws Exception {
            this.validateRoot(root);
            String name = SmartSyncXMLParser.getRequiredAttribute(root, "name");
            BasisFieldType fieldType = SmartSyncXMLParser.getRequiredAttributeAsBasisFieldType(root, "type");
            Integer length = SmartSyncXMLParser.getRequiredAttributeAsIntegerObject(root, "length");
            Integer decimalLength = SmartSyncXMLParser.getOptionalIntegerObjectAttribute(root, "decimalLength", 0);
            Boolean isKey = SmartSyncXMLParser.getOptionalBooleanObjectAttribute(root, "isKey");
            Boolean isIndex = SmartSyncXMLParser.getOptionalBooleanObjectAttribute(root, "isIndex");
            Boolean signed = SmartSyncXMLParser.getOptionalBooleanObjectAttribute(root, "signed");
            RowDescriptorImpl parentDescriptor = (RowDescriptorImpl)parentObject;
            SyncBoDescriptor grandParent = parentDescriptor.getSyncBoDescriptor();
            String key = this.createKey(grandParent.getSyncBoName(), parentDescriptor.getRowName(), name);
            AbstractFieldDescriptorImpl fieldDescriptor = AbstractFieldDescriptorImpl.createFieldDescriptor(this.createEmptyContainer(AbstractFieldDescriptorImpl.getClassDescriptor(), key), fieldType, name, length, decimalLength, isKey, isIndex, signed);
            fieldDescriptor.setRowDescriptor(parentDescriptor);
            Element[] inputs = SmartSyncXMLParser.getChildElements(root, "Input");
            int i = 0;
            while (i < inputs.length) {
                String type = SmartSyncXMLParser.getRequiredAttribute(inputs[i], "type");
                if (type != null && type.equalsIgnoreCase(INPUT_CREATE)) {
                    if (SmartSyncXMLParser.getValueAsBoolean(inputs[i])) {
                        fieldDescriptor.setCreateInputQualifyType(FieldInputQualifyType.MANDATORY);
                    } else {
                        fieldDescriptor.setCreateInputQualifyType(FieldInputQualifyType.FORBIDDEN);
                    }
                }
                if (type != null && type.equalsIgnoreCase(INPUT_MODIFY)) {
                    if (SmartSyncXMLParser.getValueAsBoolean(inputs[i])) {
                        fieldDescriptor.setModifyInputQualifyType(FieldInputQualifyType.MANDATORY);
                    } else {
                        fieldDescriptor.setModifyInputQualifyType(FieldInputQualifyType.FORBIDDEN);
                    }
                }
                ++i;
            }
            Element[] relations = SmartSyncXMLParser.getChildElements(root, "Relation");
            Handler handler = DescriptorManager.this._getHandler("Relation");
            int i2 = 0;
            while (i2 < relations.length) {
                RelationDescriptor relationDescriptor = (RelationDescriptor)handler.transform(relations[i2], fieldDescriptor);
                ++i2;
            }
            return fieldDescriptor;
        }
    }

    private class ChildStructureHandler
    extends Handler {
        public ChildStructureHandler(String structureName) {
            this.setRoot(structureName);
        }

        public Object transform(Element root, Object parentObject) throws Exception {
            this.validateRoot(root);
            String name = SmartSyncXMLParser.getRequiredAttribute(root, "name");
            boolean mandatory = SmartSyncXMLParser.getOptionalBooleanAttribute(root, "mandatory");
            SyncBoDescriptorImpl parentDescriptor = (SyncBoDescriptorImpl)parentObject;
            Element[] fields = SmartSyncXMLParser.getChildElements(root, "Field");
            String key = this.createKey(parentDescriptor.getSyncBoName(), name);
            RowDescriptorImpl rowDescriptor = RowDescriptorImpl.createRowDescriptor(this.createEmptyContainer(RowDescriptorImpl.getClassDescriptor(), key), name, new Boolean(mandatory), fields.length);
            rowDescriptor.setSyncBoDescriptor(parentDescriptor);
            Handler fieldHandler = DescriptorManager.this._getHandler("Field");
            int i = 0;
            while (i < fields.length) {
                FieldDescriptor fieldDescriptor = (FieldDescriptor)fieldHandler.transform(fields[i], rowDescriptor);
                rowDescriptor.addFieldDescriptor(fieldDescriptor);
                ++i;
            }
            Element[] fieldGroups = SmartSyncXMLParser.getChildElements(root, "FieldGroup");
            Handler fieldGroupHandler = DescriptorManager.this._getHandler("FieldGroup");
            int i2 = 0;
            while (i2 < fieldGroups.length) {
                fieldGroupHandler.transform(fieldGroups[i2], rowDescriptor);
                ++i2;
            }
            return rowDescriptor;
        }
    }

    private class TopStructureHandler
    extends ChildStructureHandler {
        public TopStructureHandler(String structureName) {
            super(structureName);
        }

        public Object transform(Element root, Object parentObject) throws Exception {
            RowDescriptorImpl topRowDescriptor = (RowDescriptorImpl)super.transform(root, parentObject);
            SyncBoDescriptorImpl parentDescriptor = (SyncBoDescriptorImpl)parentObject;
            Element[] childStructures = SmartSyncXMLParser.getChildElements(root, "ChildStructure");
            Handler childStructureHandler = DescriptorManager.this._getHandler("ChildStructure");
            int i = 0;
            while (i < childStructures.length) {
                RowDescriptorImpl rowDescriptor = (RowDescriptorImpl)childStructureHandler.transform(childStructures[i], parentDescriptor);
                parentDescriptor.addRowDescriptor(rowDescriptor);
                ++i;
            }
            return topRowDescriptor;
        }
    }

    private class SyncBoDescriptorHandler
    extends Handler {
        public SyncBoDescriptorHandler() {
            this.setRoot("SyncBO");
        }

        public Object transform(Element root, Object positionIndex) throws Exception {
            this.validateRoot(root);
            int position = (Integer)positionIndex;
            String name = SmartSyncXMLParser.getRequiredAttribute(root, "id");
            int version = SmartSyncXMLParser.getOptionalIntegerAttribute(root, "version", 0);
            SyncProcessingType type = SmartSyncXMLParser.getRequiredAttributeAsSyncProcessingType(root, "type");
            boolean allowCreate = SmartSyncXMLParser.getRequiredAttributeAsBoolean(root, "allowCreate");
            boolean allowModify = SmartSyncXMLParser.getRequiredAttributeAsBoolean(root, "allowModify");
            boolean allowDelete = SmartSyncXMLParser.getRequiredAttributeAsBoolean(root, "allowDelete");
            boolean reqSync = SmartSyncXMLParser.getOptionalBooleanAttribute(root, "directSync");
            boolean multiLang = SmartSyncXMLParser.getAttrAsBoolean(root, "multiLangSupport");
            int downloadOrder = 0;
            if (type != SyncProcessingType.UPLOAD) {
                downloadOrder = SmartSyncXMLParser.getOptionalIntegerAttribute(root, "downloadOrder", DescriptorManager.this.getNextOrderNumber());
            }
            SyncBoDescriptorImpl boDesc = SyncBoDescriptorImpl.createSyncBoDescriptor(this.createEmptyContainer(SyncBoDescriptorImpl.getClassDescriptor(), name), name, version, type, allowCreate, allowModify, allowDelete, reqSync, multiLang, downloadOrder, position);
            Handler handler = DescriptorManager.this._getHandler("TopStructure");
            Element topStructure = SmartSyncXMLParser.getChildElement(root, "TopStructure");
            RowDescriptorImpl topRowDesc = (RowDescriptorImpl)handler.transform(topStructure, boDesc);
            boDesc.setTopRowDescriptor(topRowDesc);
            return boDesc;
        }
    }

    private abstract class Handler {
        protected String rootName = null;
        protected static final char KEY_DELIM = '.';
        protected static final String ATTR_ID = "id";
        protected static final String ATTR_VERSION = "version";
        protected static final String ATTR_ALLOW_CREATE = "allowCreate";
        protected static final String ATTR_ALLOW_MODIFY = "allowModify";
        protected static final String ATTR_ALLOW_DELETE = "allowDelete";
        protected static final String ATTR_LENGTH = "length";
        protected static final String ATTR_DECIMAL = "decimalLength";
        protected static final String ATTR_SIGNED = "signed";
        protected static final String ATTR_ISKEY = "isKey";
        protected static final String ATTR_ISINDEX = "isIndex";
        protected static final String ATTR_REQDIRECTSYNC = "directSync";
        protected static final String ATTR_MANDATORY = "mandatory";
        protected static final String ATTR_MULTILANGUAGE = "multiLangSupport";
        public static final String NODE_FIELDGROUP = "FieldGroup";
        public static final String NODE_RELATION = "Relation";
        public static final String NODE_INPUT = "Input";
        protected static final String NODE_BASESYNCBO = "BaseSyncBO";
        protected static final String NODE_BASESTRUCTURE = "BaseStructure";
        protected static final String NODE_BASEFIELD = "BaseField";

        private Handler() {
        }

        public void setRoot(String rootTagName) {
            this.rootName = rootTagName;
        }

        protected String createKey(String syncBoName, String rowName, String fieldName) {
            return this.createKey(46, new String[]{syncBoName, rowName, fieldName}).toString();
        }

        protected String createKey(String syncBoName, String rowName) {
            return this.createKey(46, new String[]{syncBoName, rowName}).toString();
        }

        private StringBuffer createKey(int length, String[] attr) {
            StringBuffer sb = new StringBuffer(length);
            int i = 0;
            while (i < attr.length) {
                sb.append(attr[i]);
                if (i < attr.length - 1) {
                    sb.append('.');
                }
                ++i;
            }
            return sb;
        }

        PersistenceContainer createEmptyContainer(ClassDescriptor classDescriptor, String key) {
            return DescriptorManager.this.metaPersAdapter.getPersistedObjectFactory().createPersistedObject(classDescriptor, key);
        }

        void validateRoot(Element root) throws Exception {
            if (root == null) {
                throw new SmartSyncException("The metadata root element is NULL!");
            }
            String tagName = root.getTagName();
            if (!this.rootName.equals(tagName)) {
                throw new SmartSyncException("Invalid element tag. Expected tag is <" + this.rootName + ">, given was <" + tagName + ">");
            }
        }

        public abstract Object transform(Element var1, Object var2) throws Exception;
    }
}

