/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.meta;

import com.sap.ip.me.api.conf.VisibilityType;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.app.PersistableEntity;
import com.sap.ip.me.api.persist.core.PersistenceContainer;
import com.sap.ip.me.api.persist.meta.AttributeDescriptor;
import com.sap.ip.me.api.persist.meta.AttributeType;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.persist.meta.DescriptorException;
import com.sap.ip.me.api.persist.meta.DescriptorRuntime;
import com.sap.ip.me.api.persist.meta.LinkDescriptor;
import com.sap.ip.me.api.persist.meta.MultiplicityType;
import com.sap.ip.me.api.services.DateConverter;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.smartsync.BasisFieldType;
import com.sap.ip.me.api.smartsync.FieldGroupDescriptor;
import com.sap.ip.me.api.smartsync.FieldGroupDescriptorIterator;
import com.sap.ip.me.api.smartsync.FieldGroupType;
import com.sap.ip.me.api.smartsync.FieldInputQualifyType;
import com.sap.ip.me.api.smartsync.FixedDecimal;
import com.sap.ip.me.api.smartsync.RelationDescriptor;
import com.sap.ip.me.api.smartsync.RowDescriptor;
import com.sap.ip.me.core.ConversationId;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.core.NestableRuntimeException;
import com.sap.ip.me.smartsync.ipi.InternalFieldDescriptor;
import com.sap.ip.me.smartsync.ipi.PersistenceConstants;
import com.sap.ip.me.smartsync.meta.FieldGroupDescriptorImpl;
import com.sap.ip.me.smartsync.meta.RelationDescriptorImpl;
import com.sap.ip.me.smartsync.meta.RowDescriptorImpl;
import com.sap.ip.me.smartsync.util.SmartSyncUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.TimeZone;
import java.util.Vector;

abstract class AbstractFieldDescriptorImpl
implements AttributeDescriptor,
PersistableEntity,
InternalFieldDescriptor {
    static final int TOTAL_KEY_LEN = 46;
    static final int ATTR_POS_NAME = 0;
    static final int ATTR_POS_TYPE = 1;
    static final int ATTR_POS_LENGTH = 2;
    static final int ATTR_POS_DECIMALS = 3;
    static final int ATTR_POS_INDEX = 4;
    static final int ATTR_POS_KEY = 5;
    static final int ATTR_POS_SIGNED = 6;
    static final int ATTR_POS_CREATE = 7;
    static final int ATTR_POS_MODIFY = 8;
    static final int LINK_POS_ROW_DESCRIPTOR = 0;
    static final int LINK_POS_RELATION = 1;
    static final int LINK_POS_FIELDGROUP = 2;
    static final String EMPTY_STRING = "";
    protected static final TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");
    protected final boolean isKey;
    protected final AttributeDescriptor att;
    protected FieldInputQualifyType createInput;
    protected FieldInputQualifyType modifyInput;
    protected final boolean signed;
    private RowDescriptor rowDescriptor;
    private RelationDescriptor relatedRelation;
    Vector fieldGroups = null;
    private static ClassDescriptor persistableClass;
    private final PersistenceContainer obj;
    protected static final Trace TRACE;
    private final ConversationId convId;
    private int hash = 0;

    AbstractFieldDescriptorImpl(PersistenceContainer pObj, AttributeDescriptor attrDesc, boolean bKey, boolean bSigned) {
        this.obj = pObj;
        this.att = attrDesc;
        this.isKey = bKey;
        this.signed = bSigned;
        this.convId = ConversationIdHandler.getInstance().getCurrentConversationId(VisibilityType.USER_SHARED);
    }

    private void addFieldGroupDescriptorToTable(FieldGroupDescriptor fieldGroupDescriptor) {
        if (this.fieldGroups == null) {
            this.fieldGroups = new Vector();
        }
        this.fieldGroups.addElement(fieldGroupDescriptor);
    }

    private void setFieldGroupDescriptors() {
        MeIterator it = this.obj.getMultipleLink(2);
        if (this.fieldGroups == null) {
            this.fieldGroups = new Vector(it.elementCount());
        }
        while (it.hasNext()) {
            this.addFieldGroupDescriptorToTable((FieldGroupDescriptor)it.next());
        }
    }

    void setRelatedRelation(RelationDescriptorImpl relation) {
        this.relatedRelation = relation;
        this.obj.setSingleLink(1, relation);
    }

    void setRowDescriptor(RowDescriptorImpl rwDescriptor) {
        this.obj.setSingleLink(0, rwDescriptor);
        this.rowDescriptor = rwDescriptor;
    }

    void setCreateInputQualifyType(FieldInputQualifyType creInput) {
        this.createInput = creInput;
        this.obj.setAttribute(7, new Integer(creInput.toInt()));
    }

    void setModifyInputQualifyType(FieldInputQualifyType modInput) {
        this.modifyInput = modInput;
        this.obj.setAttribute(8, new Integer(modInput.toInt()));
    }

    void addFieldGroupDescriptor(FieldGroupDescriptorImpl fieldGroupDescriptor) {
        this.addFieldGroupDescriptorToTable(fieldGroupDescriptor);
        this.obj.addMultipleLink(2, fieldGroupDescriptor);
    }

    public final PersistenceContainer getPersistedObject() {
        return this.obj;
    }

    public final String getFieldName() {
        return this.att.getName();
    }

    public final String getName() {
        return this.att.getName();
    }

    public final int getLength() {
        return this.att.getLength();
    }

    public int getRealLength() {
        return this.getLength();
    }

    public final int getDecimals() {
        return this.att.getDecimals();
    }

    public final boolean isKey() {
        return this.isKey;
    }

    public final FieldInputQualifyType getCreateInputQualifyType() {
        if (this.createInput == null) {
            this.createInput = FieldInputQualifyType.forInt((Integer)this.obj.getAttribute(7));
        }
        return this.createInput;
    }

    public final FieldInputQualifyType getModifyInputQualifyType() {
        if (this.modifyInput == null) {
            this.modifyInput = FieldInputQualifyType.forInt((Integer)this.obj.getAttribute(8));
        }
        return this.modifyInput;
    }

    public final boolean signed() {
        return this.signed;
    }

    public final boolean isIndexed() {
        return this.att.isIndex();
    }

    public final boolean isIndex() {
        return this.att.isIndex();
    }

    public final RelationDescriptor getRelatedRelation() {
        if (this.relatedRelation == null) {
            this.relatedRelation = (RelationDescriptor)((Object)this.obj.getSingleLink(1));
        }
        return this.relatedRelation;
    }

    public FieldGroupDescriptorIterator getAllFieldGroupDescriptors() {
        if (this.fieldGroups == null) {
            this.setFieldGroupDescriptors();
        }
        return new FieldGroupDescriptorIterator(){
            Enumeration e;
            {
                this.e = AbstractFieldDescriptorImpl.this.fieldGroups.elements();
            }

            public FieldGroupDescriptor next() {
                return (FieldGroupDescriptor)this.e.nextElement();
            }

            public int size() {
                return AbstractFieldDescriptorImpl.this.fieldGroups.size();
            }

            public boolean hasNext() {
                return this.e.hasMoreElements();
            }

            public Object nextElement() {
                return (FieldGroupDescriptor)this.e.nextElement();
            }
        };
    }

    public FieldGroupDescriptor getFieldGroupDescriptor(FieldGroupType type) {
        FieldGroupDescriptorIterator it = this.getAllFieldGroupDescriptors();
        while (it.hasNext()) {
            FieldGroupDescriptor target = it.next();
            if (!target.getFieldGroupType().toString().equals(type.toString())) continue;
            return target;
        }
        return null;
    }

    public final RowDescriptor getRowDescriptor() {
        if (this.rowDescriptor == null) {
            this.rowDescriptor = (RowDescriptor)((Object)this.obj.getSingleLink(0));
        }
        return this.rowDescriptor;
    }

    public final int getMultiple() {
        return 1;
    }

    public boolean isMultiple() {
        return false;
    }

    public final String toSqlString() {
        return this.att.toSqlString();
    }

    public boolean equals(Object objectToCompare) {
        if (objectToCompare == this) {
            return true;
        }
        if (!(objectToCompare instanceof AbstractFieldDescriptorImpl)) {
            return false;
        }
        AbstractFieldDescriptorImpl fieldDescriptorToCompare = (AbstractFieldDescriptorImpl)objectToCompare;
        return fieldDescriptorToCompare.convId.equals(this.convId) && fieldDescriptorToCompare.obj.getKey().equals(this.obj.getKey());
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.convId.hashCode() ^ this.obj.getKey().hashCode();
        }
        return this.hash;
    }

    public abstract BasisFieldType getFieldType();

    public abstract AttributeType getType();

    public abstract String toString(Object var1);

    public abstract Object toObject(String var1);

    public abstract boolean checkFieldValue(Object var1);

    public abstract int compare(Object var1, Object var2);

    private static AttributeDescriptor createAttributeDescriptor(String name, BasisFieldType type, int length, int decimals, boolean isIndexed) throws DescriptorException {
        return DescriptorRuntime.getInstance().createAttributeDescriptor(name, type.getPersistenceRepresentation(), 1, length, decimals, isIndexed);
    }

    static AbstractFieldDescriptorImpl createFieldDescriptor(PersistenceContainer o, BasisFieldType type, String name, Integer length, Integer decimals, Boolean isKey, Boolean isIndexed, Boolean isSigned) {
        try {
            o.setAttribute(0, name);
            o.setAttribute(1, type.toString());
            o.setAttribute(2, length);
            o.setAttribute(3, decimals);
            o.setAttribute(4, isIndexed);
            o.setAttribute(5, isKey);
            o.setAttribute(6, isSigned);
            o.setAttribute(7, new Integer(FieldInputQualifyType.DEFAULT.toInt()));
            o.setAttribute(8, new Integer(FieldInputQualifyType.DEFAULT.toInt()));
            AttributeDescriptor att = AbstractFieldDescriptorImpl.createAttributeDescriptor(name, type, length, decimals, isIndexed);
            return AbstractFieldDescriptorImpl.createFieldDescriptor(o, att, type, isKey, isSigned);
        }
        catch (DescriptorException e) {
            if (TRACE.isLogging(50)) {
                TRACE.logException(50, e);
            }
            throw new RuntimeException(e.toString());
        }
    }

    static AbstractFieldDescriptorImpl createFieldDescriptor(PersistenceContainer o) {
        try {
            String name = (String)o.getAttribute(0);
            BasisFieldType type = BasisFieldType.forString((String)o.getAttribute(1));
            Integer length = (Integer)o.getAttribute(2);
            Integer decimals = (Integer)o.getAttribute(3);
            Boolean isIndexed = (Boolean)o.getAttribute(4);
            Boolean isKey = (Boolean)o.getAttribute(5);
            Boolean isSigned = (Boolean)o.getAttribute(6);
            AttributeDescriptor att = AbstractFieldDescriptorImpl.createAttributeDescriptor(name, type, length, decimals, isIndexed);
            return AbstractFieldDescriptorImpl.createFieldDescriptor(o, att, type, isKey, isSigned);
        }
        catch (DescriptorException e) {
            if (TRACE.isLogging(50)) {
                TRACE.logException(50, e);
            }
            throw new RuntimeException(e.toString());
        }
    }

    private static AbstractFieldDescriptorImpl createFieldDescriptor(PersistenceContainer o, AttributeDescriptor att, BasisFieldType type, Boolean isKey, Boolean isSigned) {
        o.setAttribute(1, type.toString());
        o.setAttribute(5, isKey);
        o.setAttribute(6, isSigned);
        if (type == BasisFieldType.C) {
            return new FieldDescriptorCImpl(o, att, isKey, isSigned);
        }
        if (type == BasisFieldType.D) {
            return new FieldDescriptorDImpl(o, att, isKey, isSigned);
        }
        if (type == BasisFieldType.N) {
            return new FieldDescriptorNImpl(o, att, isKey, isSigned);
        }
        if (type == BasisFieldType.P) {
            return new FieldDescriptorPImpl(o, att, isKey, isSigned);
        }
        if (type == BasisFieldType.T) {
            return new FieldDescriptorTImpl(o, att, isKey, isSigned);
        }
        if (TRACE.isLogging(60)) {
            TRACE.log(60, "Returning null FieldDescriptor instance for unsupported basisFieldType: " + type.toString());
        }
        return null;
    }

    static ClassDescriptor getClassDescriptor() {
        if (persistableClass == null) {
            try {
                DescriptorRuntime PDR = DescriptorRuntime.getInstance();
                AttributeDescriptor[] attrib = new AttributeDescriptor[]{PDR.createAttributeDescriptor("Name", AttributeType.STRING, 1, 31), PDR.createAttributeDescriptor("Type", AttributeType.STRING, 1, 1), PDR.createAttributeDescriptor("Len", AttributeType.INTEGER, 1, 1), PDR.createAttributeDescriptor("Dec", AttributeType.INTEGER, 1, 1), PDR.createAttributeDescriptor("IsIndexed", AttributeType.BOOLEAN, 1, 1), PDR.createAttributeDescriptor("IsKey", AttributeType.BOOLEAN, 1, 1), PDR.createAttributeDescriptor("Sign", AttributeType.BOOLEAN, 1, 1), PDR.createAttributeDescriptor("CreateInputType", AttributeType.INTEGER, 1, 1), PDR.createAttributeDescriptor("ModifyInputType", AttributeType.INTEGER, 1, 1)};
                LinkDescriptor[] link = new LinkDescriptor[]{PDR.createLinkDescriptor("rowDescriptor", PersistenceConstants.ROW_DESCRIPTOR_CLASSTYPE, MultiplicityType.SINGLE, false), PDR.createLinkDescriptor("relatedRelationDescriptor", PersistenceConstants.RELATION_DESCRIPTOR_CLASSTYPE, MultiplicityType.SINGLE, true), PDR.createLinkDescriptor("FieldGroupDescriptor", PersistenceConstants.FIELDGROUP_DESCRIPTOR_CLASSTYPE, MultiplicityType.MULTIPLE_VECTOR, true)};
                persistableClass = PDR.createClassDescriptor(PersistenceConstants.FIELD_DESCRIPTOR_CLASSTYPE, attrib, link, 46);
            }
            catch (DescriptorException e) {
                throw new NestableRuntimeException(e);
            }
        }
        return persistableClass;
    }

    public String toString() {
        return this.getRowDescriptor() + "/" + this.getFieldName();
    }

    public boolean checkCreateFieldValue(Object fieldValue) {
        if (this.getCreateInputQualifyType() == FieldInputQualifyType.FORBIDDEN) {
            if (fieldValue != null) {
                TRACE.log(60, "Application set a forbitten field value for field " + this.getFieldName());
                return true;
            }
        } else if (this.getCreateInputQualifyType() == FieldInputQualifyType.MANDATORY && fieldValue == null) {
            return false;
        }
        return true;
    }

    public boolean checkModifyFieldValue(Object fieldValue) {
        if (this.getModifyInputQualifyType() == FieldInputQualifyType.FORBIDDEN) {
            return false;
        }
        return this.getModifyInputQualifyType() != FieldInputQualifyType.MANDATORY || fieldValue != null;
    }

    public abstract Object convertTo25DataType(Object var1);

    public abstract Object convertTo21DataType(Object var1);

    public abstract Object to25Object(String var1);

    public abstract String to25String(Object var1);

    static {
        TRACE = Trace.getInstance("MI/Smartsync");
    }

    private static final class FieldDescriptorTImpl
    extends AbstractFieldDescriptorImpl {
        private static final SimpleDateFormat ABAPTIMEFORMATTER = new SimpleDateFormat("HHmmss");
        private static final SimpleDateFormat SQLTIMEFORMATTER = new SimpleDateFormat("HH:mm:ss");

        FieldDescriptorTImpl(PersistenceContainer o, AttributeDescriptor att, boolean isKey, boolean isSigned) {
            super(o, att, isKey, isSigned);
        }

        public final Object toObject(String string) {
            if (string == null) {
                return null;
            }
            string = string.trim();
            Calendar iCal = DateConverter.createInitializedCalendar();
            if (string.length() > super.getLength()) {
                string = string.substring(0, super.getLength());
            } else if (string.length() < super.getLength()) {
                return iCal;
            }
            try {
                int h = Integer.parseInt(string.substring(0, 2));
                int m = Integer.parseInt(string.substring(2, 4));
                int s = Integer.parseInt(string.substring(4, 6));
                iCal.set(11, h);
                iCal.set(12, m);
                iCal.set(13, s);
            }
            catch (NumberFormatException nfe) {
                return iCal;
            }
            return iCal;
        }

        public final String toString(Object object) {
            if (object != null && object instanceof Calendar) {
                return ABAPTIMEFORMATTER.format(((Calendar)object).getTime());
            }
            return AbstractFieldDescriptorImpl.EMPTY_STRING;
        }

        public final boolean checkFieldValue(Object object) {
            return object instanceof Time || object instanceof Calendar;
        }

        public final int compare(Object valueToCompare, Object referenceValue) {
            if (referenceValue == null && valueToCompare == null) {
                return 0;
            }
            if (referenceValue instanceof Time && valueToCompare instanceof Time) {
                Time rV = (Time)referenceValue;
                Time cV = (Time)valueToCompare;
                if (rV.equals(valueToCompare)) {
                    return 0;
                }
                if (cV.before(rV)) {
                    return 1;
                }
                return -1;
            }
            if (referenceValue instanceof Calendar && valueToCompare instanceof Calendar) {
                Calendar rV = (Calendar)referenceValue;
                Calendar cV = (Calendar)valueToCompare;
                if (rV.equals(valueToCompare)) {
                    return 0;
                }
                if (cV.before(rV)) {
                    return 1;
                }
                return -1;
            }
            throw new RuntimeException("Invalid comparison due to different object type: expected is java.sql.Time for MI25 and Calendar for ME21");
        }

        public final BasisFieldType getFieldType() {
            return BasisFieldType.T;
        }

        public final AttributeType getType() {
            return BasisFieldType.T.getPersistenceRepresentation();
        }

        public Object convertTo21DataType(Object sqTimeObject) {
            if (sqTimeObject instanceof Calendar) {
                return sqTimeObject;
            }
            if (sqTimeObject instanceof Time) {
                return DateConverter.sqlDateTimeToCalendar(null, (Time)sqTimeObject);
            }
            return null;
        }

        public Object convertTo25DataType(Object calendarObject) {
            if (calendarObject instanceof Time) {
                return calendarObject;
            }
            if (calendarObject instanceof Calendar) {
                Calendar cal = (Calendar)calendarObject;
                return Time.valueOf(SQLTIMEFORMATTER.format(cal.getTime()));
            }
            return null;
        }

        public String to25String(Object sqlTimeObject) {
            if (sqlTimeObject == null) {
                return AbstractFieldDescriptorImpl.EMPTY_STRING;
            }
            if (sqlTimeObject instanceof Time) {
                return ABAPTIMEFORMATTER.format((Time)sqlTimeObject);
            }
            if (TRACE.isLogging(50)) {
                TRACE.log(50, "FieldDescriptorDImpl.to25String, the value must be a java.sql.Date.");
            }
            throw new IllegalArgumentException("FieldDescriptorDImpl.to25String, the value must be a java.sql.Date.");
        }

        public Object to25Object(String timeString) {
            if (timeString == null) {
                throw new IllegalArgumentException("null value is not allowed for T type");
            }
            if (timeString.trim().length() != 6) {
                if (TRACE.isLogging(50)) {
                    TRACE.log(50, "FieldDescriptorTImpl.to25Object: Illegal the timeString length 6! Data was {0}", (Object)timeString);
                }
                throw new IllegalArgumentException("FieldDescriptorTImpl.to25Object, the timeString must be of length 6!");
            }
            StringBuffer buff = new StringBuffer(timeString);
            buff.insert(4, ':');
            buff.insert(2, ':');
            try {
                return Time.valueOf(buff.toString());
            }
            catch (NumberFormatException e) {
                if (TRACE.isLogging(50)) {
                    TRACE.log(50, "FieldDescriptorTImpl.to25Object: NumberFormatException occurred and is returning null. Data was {0}", (Object)timeString);
                }
                return null;
            }
        }
    }

    private static final class FieldDescriptorPImpl
    extends AbstractFieldDescriptorImpl {
        private int trueLen = this.adjustToTrueLength(super.getLength());

        FieldDescriptorPImpl(PersistenceContainer o, AttributeDescriptor att, boolean isKey, boolean isSigned) {
            super(o, att, isKey, isSigned);
        }

        private int adjustToTrueLength(int orgLen) {
            if (this.signed) {
                return super.getDecimals() > 0 ? orgLen - 2 : orgLen - 1;
            }
            return super.getDecimals() > 0 ? orgLen - 1 : orgLen;
        }

        public final Object toObject(String string) {
            if (string != null) {
                return new FixedDecimal(string, super.getLength(), super.getDecimals());
            }
            return null;
        }

        public final String toString(Object object) {
            if (object != null && object instanceof FixedDecimal) {
                return ((FixedDecimal)object).toString();
            }
            return AbstractFieldDescriptorImpl.EMPTY_STRING;
        }

        public int getRealLength() {
            return this.trueLen;
        }

        public final boolean checkFieldValue(Object object) {
            if (object == null) {
                return true;
            }
            if (object instanceof FixedDecimal) {
                FixedDecimal fd = (FixedDecimal)object;
                if (this.getDecimals() >= fd.getDecimals() && this.getLength() >= fd.getLength()) {
                    return true;
                }
            }
            if (object instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)object;
                int definedDecimalSize = this.getDecimals();
                int objectDecimalSize = bigDecimal.scale();
                int intPartLength = bigDecimal.movePointRight(objectDecimalSize).abs().toString().length() - objectDecimalSize;
                return (definedDecimalSize >= objectDecimalSize || definedDecimalSize == 0 && objectDecimalSize == 1) && this.getLength() >= intPartLength;
            }
            return false;
        }

        public final int compare(Object valueToCompare, Object referenceValue) {
            if (referenceValue == null && valueToCompare == null) {
                return 0;
            }
            if (referenceValue instanceof BigDecimal && valueToCompare instanceof BigDecimal) {
                return ((BigDecimal)referenceValue).compareTo((BigDecimal)valueToCompare);
            }
            if (referenceValue instanceof FixedDecimal && valueToCompare instanceof FixedDecimal) {
                return ((FixedDecimal)referenceValue).compareTo((FixedDecimal)valueToCompare);
            }
            throw new RuntimeException("Invalid comparison due to different object type: both should be BigDecimal for MI25 and FixedDecimal for ME21.");
        }

        public final BasisFieldType getFieldType() {
            return BasisFieldType.P;
        }

        public final AttributeType getType() {
            return BasisFieldType.P.getPersistenceRepresentation();
        }

        public String to25String(Object bigDecimalObject) {
            if (bigDecimalObject == null) {
                return AbstractFieldDescriptorImpl.EMPTY_STRING;
            }
            if (bigDecimalObject instanceof BigDecimal) {
                return bigDecimalObject.toString();
            }
            if (TRACE.isLogging(50)) {
                TRACE.log(50, "FieldDescriptorPImpl.to25String, the value must be a BigDecimal data.");
            }
            throw new IllegalArgumentException("FieldDescriptorPImpl.to25String, the value must be a BigDecimal data.");
        }

        public Object to25Object(String string) {
            if (string == null) {
                throw new IllegalArgumentException("null value is not allowed for P type");
            }
            BigDecimal val = new BigDecimal(string.trim());
            return val.setScale(this.getDecimals(), 1);
        }

        public Object convertTo21DataType(Object bigDecimalObject) {
            if (bigDecimalObject instanceof FixedDecimal) {
                return bigDecimalObject;
            }
            if (bigDecimalObject instanceof BigDecimal) {
                return new FixedDecimal(((BigDecimal)bigDecimalObject).toString(), this.getLength(), this.getDecimals());
            }
            return null;
        }

        public Object convertTo25DataType(Object fixedDecimalObject) {
            if (fixedDecimalObject instanceof BigDecimal) {
                return fixedDecimalObject;
            }
            if (fixedDecimalObject instanceof FixedDecimal) {
                return ((FixedDecimal)fixedDecimalObject).bigDecimalValue();
            }
            return null;
        }

        public boolean checkCreateFieldValue(Object fieldValue) {
            if (!this.checkFieldValue(fieldValue)) {
                return false;
            }
            return super.checkCreateFieldValue(fieldValue);
        }

        public boolean checkModifyFieldValue(Object fieldValue) {
            if (!this.checkFieldValue(fieldValue)) {
                return false;
            }
            return super.checkModifyFieldValue(fieldValue);
        }
    }

    private static final class FieldDescriptorNImpl
    extends AbstractFieldDescriptorImpl {
        FieldDescriptorNImpl(PersistenceContainer o, AttributeDescriptor att, boolean isKey, boolean isSigned) {
            super(o, att, isKey, isSigned);
        }

        public final Object toObject(String string) {
            if (string == null) {
                return null;
            }
            return string.length() <= super.getLength() ? string : string.substring(0, super.getLength());
        }

        public final String toString(Object object) {
            if (object instanceof String) {
                return (String)object;
            }
            return AbstractFieldDescriptorImpl.EMPTY_STRING;
        }

        public final boolean checkFieldValue(Object object) {
            if (object == null) {
                return true;
            }
            if (object instanceof String) {
                String fd = (String)object;
                if (this.getLength() >= fd.length()) {
                    return true;
                }
            }
            if (object instanceof BigInteger) {
                BigInteger bd = (BigInteger)object;
                if (this.getLength() >= bd.toString().length()) {
                    return true;
                }
            }
            return false;
        }

        public final int compare(Object valueToCompare, Object referenceValue) {
            if (referenceValue == null && valueToCompare == null) {
                return 0;
            }
            if (referenceValue instanceof BigInteger && valueToCompare instanceof BigInteger) {
                return ((BigInteger)referenceValue).compareTo((BigInteger)valueToCompare);
            }
            if (referenceValue instanceof String && valueToCompare instanceof String) {
                return ((String)referenceValue).compareTo((String)valueToCompare);
            }
            throw new RuntimeException("Invalid comparison due to different object type: both should be BigInteger for MI25 and String for ME21.");
        }

        public final BasisFieldType getFieldType() {
            return BasisFieldType.N;
        }

        public final AttributeType getType() {
            return BasisFieldType.N.getPersistenceRepresentation();
        }

        public Object convertTo21DataType(Object bigIntegerObject) {
            if (bigIntegerObject instanceof String) {
                return bigIntegerObject;
            }
            if (bigIntegerObject instanceof BigInteger) {
                return SmartSyncUtil.insertLeadingZeros(((BigInteger)bigIntegerObject).toString(), this.getLength());
            }
            return null;
        }

        public Object convertTo25DataType(Object stringObject) {
            if (stringObject instanceof BigInteger) {
                return stringObject;
            }
            if (stringObject instanceof String) {
                if (((String)stringObject).trim().length() == 0) {
                    stringObject = "0";
                }
                return new BigInteger((String)stringObject);
            }
            return null;
        }

        public String to25String(Object bigIntegerObject) {
            if (bigIntegerObject == null) {
                return AbstractFieldDescriptorImpl.EMPTY_STRING;
            }
            if (bigIntegerObject instanceof BigInteger) {
                return ((BigInteger)bigIntegerObject).toString();
            }
            throw new IllegalArgumentException("FieldDescriptorNImpl.to25String, the value should NOT be NULL and must be BigInteger data.");
        }

        public Object to25Object(String integerString) {
            if (integerString == null) {
                throw new IllegalArgumentException("null value is not allowed for N type");
            }
            if (integerString.trim().length() == 0) {
                integerString = "0";
            }
            return new BigInteger(integerString);
        }

        public boolean checkCreateFieldValue(Object fieldValue) {
            if (!this.checkFieldValue(fieldValue)) {
                return false;
            }
            return super.checkCreateFieldValue(fieldValue);
        }

        public boolean checkModifyFieldValue(Object fieldValue) {
            if (!this.checkFieldValue(fieldValue)) {
                return false;
            }
            return super.checkModifyFieldValue(fieldValue);
        }
    }

    private static final class FieldDescriptorDImpl
    extends AbstractFieldDescriptorImpl {
        private static final String EMPTY_DATE = "00000000";
        private static final SimpleDateFormat SQLDATEFORMATTER = new SimpleDateFormat("yyyy-MM-dd");
        private static final SimpleDateFormat ABAPDATEFORMATTER = new SimpleDateFormat("yyyyMMdd");

        FieldDescriptorDImpl(PersistenceContainer o, AttributeDescriptor att, boolean isKey, boolean isSigned) {
            super(o, att, isKey, isSigned);
        }

        public final Object toObject(String string) {
            if (string == null) {
                return null;
            }
            string = string.trim();
            Calendar iCal = DateConverter.createInitializedCalendar();
            if (string.length() > super.getLength()) {
                string = string.substring(0, super.getLength());
            } else if (string.length() < super.getLength()) {
                return iCal;
            }
            try {
                int y = Integer.parseInt(string.substring(0, 4));
                int m = Integer.parseInt(string.substring(4, 6));
                int d = Integer.parseInt(string.substring(6, 8));
                m = m > 0 ? m - 1 : m;
                iCal.set(1, y);
                iCal.set(2, m);
                iCal.set(5, d);
            }
            catch (NumberFormatException nfe) {
                return iCal;
            }
            return iCal;
        }

        public final String toString(Object object) {
            if (object == null) {
                return null;
            }
            if (object instanceof Calendar) {
                return ABAPDATEFORMATTER.format(((Calendar)object).getTime());
            }
            return AbstractFieldDescriptorImpl.EMPTY_STRING;
        }

        public final boolean checkFieldValue(Object object) {
            return object instanceof Date || object instanceof Calendar;
        }

        public final int compare(Object valueToCompare, Object referenceValue) {
            if (referenceValue == null && valueToCompare == null) {
                return 0;
            }
            if (referenceValue instanceof Date && valueToCompare instanceof Date) {
                Date rV = (Date)referenceValue;
                Date cV = (Date)valueToCompare;
                if (rV.equals(valueToCompare)) {
                    return 0;
                }
                if (cV.before(rV)) {
                    return 1;
                }
                return -1;
            }
            if (referenceValue instanceof Calendar && valueToCompare instanceof Calendar) {
                Calendar rV = (Calendar)referenceValue;
                Calendar cV = (Calendar)valueToCompare;
                if (rV.equals(valueToCompare)) {
                    return 0;
                }
                if (cV.before(rV)) {
                    return 1;
                }
                return -1;
            }
            throw new RuntimeException("Invalid comparison due to different object type: expected is java.sql.Date for MI25 and Calendar for ME21");
        }

        public final BasisFieldType getFieldType() {
            return BasisFieldType.D;
        }

        public final AttributeType getType() {
            return BasisFieldType.D.getPersistenceRepresentation();
        }

        public Object convertTo21DataType(Object sqlDateObject) {
            if (sqlDateObject instanceof Calendar) {
                return sqlDateObject;
            }
            if (sqlDateObject instanceof Date) {
                return DateConverter.sqlDateTimeToCalendar((Date)sqlDateObject, null);
            }
            return null;
        }

        public Object convertTo25DataType(Object calendarObject) {
            if (calendarObject instanceof Date) {
                return calendarObject;
            }
            if (calendarObject instanceof Calendar) {
                Calendar cal = (Calendar)calendarObject;
                return Date.valueOf(SQLDATEFORMATTER.format(cal.getTime()));
            }
            return null;
        }

        public String to25String(Object sqlDateObject) {
            if (sqlDateObject == null) {
                return AbstractFieldDescriptorImpl.EMPTY_STRING;
            }
            if (sqlDateObject instanceof Date) {
                return ABAPDATEFORMATTER.format((Date)sqlDateObject);
            }
            if (TRACE.isLogging(50)) {
                TRACE.log(50, "FieldDescriptorDImpl.to25String, the value must be java.sql.Date");
            }
            throw new IllegalArgumentException("FieldDescriptorDImpl.to25String, the value must be java.sql.Date.");
        }

        public Object to25Object(String dateString) {
            if (dateString == null) {
                return null;
            }
            if (dateString.equals(EMPTY_DATE)) {
                if (TRACE.isLogging(50)) {
                    TRACE.log(50, "FieldDescriptorDImpl.to25Object: Illegal dateString {0}", (Object)dateString);
                }
                throw new IllegalArgumentException("00000000 is not allowed, use null");
            }
            if (dateString.trim().length() != 8) {
                if (TRACE.isLogging(50)) {
                    TRACE.log(50, "FieldDescriptorDImpl.to25Object: Illegal the dateString length 8! Data was {0}", (Object)dateString);
                }
                throw new IllegalArgumentException("FieldDescriptorDImpl.to25Object, the dateString must be of length 8! Passed argument was [" + dateString + "].");
            }
            StringBuffer buff = new StringBuffer(dateString);
            buff.insert(6, '-');
            buff.insert(4, '-');
            try {
                return Date.valueOf(buff.toString());
            }
            catch (NumberFormatException e) {
                if (TRACE.isLogging(50)) {
                    TRACE.log(50, "FieldDescriptorDImpl.to25Object: NumberFormatException occurred and is returning null. Data was {0}", (Object)dateString);
                }
                return null;
            }
        }
    }

    private static final class FieldDescriptorCImpl
    extends AbstractFieldDescriptorImpl {
        FieldDescriptorCImpl(PersistenceContainer o, AttributeDescriptor att, boolean isKey, boolean isSigned) {
            super(o, att, isKey, isSigned);
        }

        public final Object toObject(String string) {
            if (string != null) {
                return string.length() <= super.getLength() ? string : string.substring(0, super.getLength());
            }
            return AbstractFieldDescriptorImpl.EMPTY_STRING;
        }

        public final String toString(Object object) {
            if (object != null && object instanceof String) {
                String string = (String)object;
                return string.length() <= super.getLength() ? string : string.substring(super.getLength());
            }
            return AbstractFieldDescriptorImpl.EMPTY_STRING;
        }

        public final boolean checkFieldValue(Object object) {
            if (object instanceof String) {
                String fd = (String)object;
                if (this.getLength() >= fd.length()) {
                    return true;
                }
            }
            return false;
        }

        public final int compare(Object valueToCompare, Object referenceValue) {
            if (referenceValue == null && valueToCompare == null) {
                return 0;
            }
            if (referenceValue instanceof String && valueToCompare instanceof String) {
                return ((String)referenceValue).compareTo((String)valueToCompare);
            }
            throw new RuntimeException("Invalid comparison due to different object type: expected is String");
        }

        public final BasisFieldType getFieldType() {
            return BasisFieldType.C;
        }

        public final AttributeType getType() {
            return BasisFieldType.C.getPersistenceRepresentation();
        }

        public String to25String(Object stringObject) {
            return this.toString(stringObject);
        }

        public Object to25Object(String string) {
            return this.toObject(string);
        }

        public Object convertTo21DataType(Object stringObject) {
            if (stringObject instanceof String) {
                return (String)stringObject;
            }
            return null;
        }

        public Object convertTo25DataType(Object stringObject) {
            if (stringObject instanceof String) {
                return (String)stringObject;
            }
            return null;
        }

        public boolean checkCreateFieldValue(Object fieldValue) {
            if (this.getCreateInputQualifyType() == FieldInputQualifyType.FORBIDDEN) {
                TRACE.log(60, "Application set a forbidden field value for field " + this.getFieldName());
                return true;
            }
            if (this.getCreateInputQualifyType() == FieldInputQualifyType.MANDATORY) {
                return this.checkMandatory((String)fieldValue);
            }
            return true;
        }

        public boolean checkModifyFieldValue(Object fieldValue) {
            if (this.getModifyInputQualifyType() == FieldInputQualifyType.FORBIDDEN) {
                return false;
            }
            if (this.getModifyInputQualifyType() == FieldInputQualifyType.MANDATORY) {
                return this.checkMandatory((String)fieldValue);
            }
            return true;
        }

        private boolean checkForbidden(String fieldValue) {
            return fieldValue == null || fieldValue.length() == 0;
        }

        private boolean checkMandatory(String fieldValue) {
            return fieldValue != null && fieldValue.length() > 0;
        }
    }
}

