/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.depladp;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.services.IOUtils;
import com.sap.ip.me.core.ConversationId;
import com.sap.ip.me.core.NestableRuntimeException;
import com.sap.ip.me.smartsync.ipi.InterMetaPackageManager;
import com.sap.ip.me.spi.smartsync.SmartSyncDeplAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class DeplAdapter
implements SmartSyncDeplAdapter {
    private static final String TMP_FILENAME_POSTFIX = "Meta.tmp";
    private final Hashtable filesToProcess = new Hashtable(5);
    private final InterMetaPackageManager metaPackageManger;

    public DeplAdapter(InterMetaPackageManager metaPackageManger) {
        this.metaPackageManger = metaPackageManger;
    }

    public void setMetaDataFile(String appliId, ZipFile zip, ZipEntry sourceEntry) {
        try {
            File metaFile = new File(appliId + TMP_FILENAME_POSTFIX);
            String fileName = metaFile.getCanonicalPath();
            File file = IOUtils.extractZipFile(zip, sourceEntry, fileName);
            this.filesToProcess.put(appliId, file);
        }
        catch (IOException e) {
            throw new NestableRuntimeException(e);
        }
    }

    public void setMetaDataFile(String appliId, File f) {
        this.filesToProcess.put(appliId, f);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processMetaData(ConversationId convId) {
        InputStream is;
        File fileToProcess;
        block10: {
            block9: {
                if (!convId.isSharedConversationId()) return;
                fileToProcess = null;
                is = null;
                try {
                    try {
                        String msdName = convId.getMsd().getName();
                        fileToProcess = (File)this.filesToProcess.get(msdName);
                        if (fileToProcess == null) {
                            Object var6_6 = null;
                            if (fileToProcess == null) return;
                            break block9;
                        }
                        is = new FileInputStream(fileToProcess);
                        this.metaPackageManger.initializeSyncBoDescriptorRepository(convId, is);
                        this.filesToProcess.remove(msdName);
                        break block10;
                    }
                    catch (Exception e) {
                        Trace.getInstance("MI/Smartsync").logException("Exception while processing meta data", (Throwable)e, true);
                        throw new RuntimeException(e.toString());
                    }
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    if (fileToProcess == null) throw throwable;
                    try {
                        is.close();
                        fileToProcess.delete();
                        throw throwable;
                    }
                    catch (Exception e) {
                        Trace.getInstance("MI/Smartsync").logException("Exception while closing stream / deleting temp file", (Throwable)e, true);
                        throw new RuntimeException(e.toString());
                    }
                }
            }
            try {}
            catch (Exception e) {
                Trace.getInstance("MI/Smartsync").logException("Exception while closing stream / deleting temp file", (Throwable)e, true);
                throw new RuntimeException(e.toString());
            }
            is.close();
            fileToProcess.delete();
            return;
        }
        Object var6_7 = null;
        if (fileToProcess == null) return;
        try {}
        catch (Exception e) {
            Trace.getInstance("MI/Smartsync").logException("Exception while closing stream / deleting temp file", (Throwable)e, true);
            throw new RuntimeException(e.toString());
        }
        is.close();
        fileToProcess.delete();
    }
}

