/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.delta;

import com.sap.ip.me.api.persist.app.PersistableEntity;
import com.sap.ip.me.api.persist.core.PersistenceContainer;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.smartsync.Row;
import com.sap.ip.me.api.smartsync.SyncBoChangeActionType;
import com.sap.ip.me.api.smartsync.SyncBoDescriptor;
import com.sap.ip.me.api.smartsync.SyncBoOutDelta;
import com.sap.ip.me.api.smartsync.SyncBoOutDeltaSendType;
import com.sap.ip.me.smartsync.delta.RowDelta;
import com.sap.ip.me.smartsync.ipi.InternalSyncBoDescriptor;
import com.sap.ip.me.smartsync.ipi.InternalSyncBoDescriptorFacade;

final class SyncBoDelta
implements PersistableEntity,
SyncBoOutDelta {
    private static final int TIMESTAMP_POS = 0;
    private static final int ACTION_POS = 1;
    private static final int DESCRIPTOR_POS = 2;
    private static final int STATEID_POS = 3;
    private static final int ROW_DELTA_LINK_POS = 0;
    final PersistenceContainer obj;
    private transient SyncBoOutDeltaSendType sendType = SyncBoOutDeltaSendType.DEFAULT;
    private final InternalSyncBoDescriptorFacade internalSyncBoDescriptorFacade;

    SyncBoDelta(InternalSyncBoDescriptorFacade internalSyncBoDescriptorFacade, PersistenceContainer o) {
        if (internalSyncBoDescriptorFacade == null) {
            throw new NullPointerException("internalSyncBoDescriptorFacade");
        }
        if (o == null) {
            throw new NullPointerException("o");
        }
        this.internalSyncBoDescriptorFacade = internalSyncBoDescriptorFacade;
        this.obj = o;
    }

    public final String getTimeStamp() {
        return (String)this.obj.getAttribute(0);
    }

    public final Object getSyncKey() {
        return this.obj.getKey();
    }

    final void setTimeStamp(String s) throws PersistenceException {
        this.obj.setAttribute(0, s);
    }

    public final PersistenceContainer getPersistedObject() {
        return this.obj;
    }

    public final MeIterator getRowChanges() {
        return this.obj.getMultipleLink(0);
    }

    public final String getChangeSeqNo() {
        throw new RuntimeException("unsupported");
    }

    void setSyncBoDescriptor(SyncBoDescriptor d) throws PersistenceException {
        this.obj.setAttribute(2, ((InternalSyncBoDescriptor)d).getPersistedObject().getKey());
    }

    public final SyncBoDescriptor getSyncBoDescriptor() {
        String key = (String)this.obj.getAttribute(2);
        return this.internalSyncBoDescriptorFacade.getSyncBoDescriptorForEntityKey(key);
    }

    final void addRowDelta(RowDelta rowOutDelta) throws PersistenceException {
        this.obj.addMultipleLink(0, rowOutDelta);
    }

    final void deleteRowDelta(RowDelta rowOutDelta) throws PersistenceException {
        int rowPos = this.getRowPositionInMultipleLink(0, rowOutDelta);
        this.obj.removeMultipleLink(0, rowPos);
    }

    private int getRowPositionInMultipleLink(int linkPos, RowDelta row) {
        int max = this.obj.sizeLink(linkPos);
        String key = row.getPersistedObject().getKey();
        int x = 0;
        while (x < max) {
            PersistableEntity cmpRow = this.obj.getMultipleLink(linkPos, x);
            if (key.equals(cmpRow.getPersistedObject().getKey())) {
                return x;
            }
            ++x;
        }
        return -1;
    }

    final RowDelta getRowDeltaForRow(Row row) {
        String syncKey = row.getKey();
        MeIterator it = this.obj.getMultipleLink(0);
        while (it.hasNext()) {
            RowDelta currentRowDelta = (RowDelta)it.next();
            if (!currentRowDelta.getSyncKey().equals(syncKey)) continue;
            return currentRowDelta;
        }
        return null;
    }

    public SyncBoChangeActionType getAction() {
        String actionString = (String)this.obj.getAttribute(1);
        return SyncBoChangeActionType.forString(actionString);
    }

    void setAction(SyncBoChangeActionType newAction) throws PersistenceException {
        SyncBoChangeActionType prevAction = this.getAction();
        SyncBoChangeActionType mergedAction = prevAction.getMerged(newAction);
        this.obj.setAttribute(1, mergedAction.toString());
    }

    public void setSendType(SyncBoOutDeltaSendType sendType) {
        this.sendType = sendType;
    }

    public SyncBoOutDeltaSendType getSendType() {
        return this.sendType;
    }

    public String getStateId() {
        return (String)this.obj.getAttribute(3);
    }

    void setStateId(String stateId) {
        this.obj.setAttribute(3, stateId);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(500);
        sb.append("<SyncBoDelta syncKey=").append(this.getSyncKey().toString());
        sb.append(" type=").append(this.getSyncBoDescriptor().getSyncBoName());
        sb.append(" timeStamp=").append(this.getTimeStamp());
        sb.append(" action=").append(this.getAction().toXMLString());
        sb.append(" sendType=").append(this.getSendType().toString());
        sb.append(" stateId=").append(this.getStateId());
        MeIterator rows = this.getRowChanges();
        if (rows.hasNext()) {
            sb.append(">");
            while (rows.hasNext()) {
                sb.append("<RowDelta ").append(rows.next().toString()).append("/>");
            }
        } else {
            sb.append("/>");
        }
        return sb.toString();
    }
}

