/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.delta;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.app.PersistableEntity;
import com.sap.ip.me.api.persist.core.PersistenceContainer;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.smartsync.Row;
import com.sap.ip.me.api.smartsync.RowChange;
import com.sap.ip.me.api.smartsync.RowChangeActionType;
import com.sap.ip.me.api.smartsync.RowDescriptor;
import com.sap.ip.me.api.smartsync.SmartSyncRuntime;
import com.sap.ip.me.core.MeIteratorArrayImpl;
import com.sap.ip.me.smartsync.ipi.InternalRowDescriptor;
import com.sap.ip.me.smartsync.ipi.InternalSyncBoDescriptorFacade;
import java.math.BigInteger;

final class RowDelta
implements PersistableEntity,
RowChange {
    private static final int ACTION_POS = 0;
    private static final int DESCRIPTOR_POS = 1;
    final PersistenceContainer obj;

    RowDelta(PersistenceContainer o) {
        if (o == null) {
            throw new NullPointerException("o");
        }
        this.obj = o;
    }

    void setAction(RowChangeActionType newAction) throws PersistenceException {
        RowChangeActionType prevAction = this.getAction();
        RowChangeActionType mergedAction = prevAction.getMerged(newAction);
        this.obj.setAttribute(0, mergedAction.toString());
    }

    public final Object getSyncKey() {
        return this.obj.getKey();
    }

    void setRowDescriptor(RowDescriptor d) throws PersistenceException {
        this.obj.setAttribute(1, ((InternalRowDescriptor)d).getPersistedObject().getKey());
    }

    public final MeIterator getChangedFieldValues() {
        Row row = this.getRow();
        if (row != null) {
            return this.getRow().getFieldValues();
        }
        return new MeIteratorArrayImpl(new Object[]{new BigInteger(this.obj.getKey())});
    }

    public final RowDescriptor getRowDescriptor() {
        String key = (String)this.obj.getAttribute(1);
        return ((InternalSyncBoDescriptorFacade)SmartSyncRuntime.getInstance().getSyncBoDescriptorFacade()).getRowDescriptorForEntityKey(key);
    }

    public RowChangeActionType getAction() {
        String actionString = (String)this.obj.getAttribute(0);
        return RowChangeActionType.forString(actionString);
    }

    private Row getRow() {
        if (this.getAction() == RowChangeActionType.DELETE) {
            return null;
        }
        RowDescriptor d = this.getRowDescriptor();
        try {
            return SmartSyncRuntime.getInstance().getSyncBoDataFacade().getRow(d, (String)this.getSyncKey());
        }
        catch (PersistenceException e) {
            Trace.getInstance("MI/Smartsync").logException(60, "Could not find row of row delta, RowChangeAction=" + this.getAction(), e, true);
            return null;
        }
    }

    public PersistenceContainer getPersistedObject() {
        return this.obj;
    }

    public String toString() {
        return this.getSyncKey() + " ( " + this.getAction().toString() + " ) ";
    }
}

