/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.delta;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.app.PersistableEntity;
import com.sap.ip.me.api.persist.core.PersistenceContainer;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.core.TreeOptionType;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.persist.query.Query;
import com.sap.ip.me.api.persist.query.QueryRuntime;
import com.sap.ip.me.api.services.MeComparator;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.smartsync.Row;
import com.sap.ip.me.api.smartsync.RowChangeActionType;
import com.sap.ip.me.api.smartsync.RowCollection;
import com.sap.ip.me.api.smartsync.RowDescriptor;
import com.sap.ip.me.api.smartsync.SmartSyncException;
import com.sap.ip.me.api.smartsync.StatusType;
import com.sap.ip.me.api.smartsync.SyncBo;
import com.sap.ip.me.api.smartsync.SyncBoChange;
import com.sap.ip.me.api.smartsync.SyncBoChangeActionType;
import com.sap.ip.me.api.smartsync.SyncBoDescriptor;
import com.sap.ip.me.api.smartsync.SyncBoDescriptorIterator;
import com.sap.ip.me.api.smartsync.SyncBoOutDelta;
import com.sap.ip.me.core.CompositeMeIteratorImpl;
import com.sap.ip.me.core.MeArrays;
import com.sap.ip.me.core.MeIteratorVectorImpl;
import com.sap.ip.me.smartsync.delta.DeltaPackagePersistenceMaster;
import com.sap.ip.me.smartsync.delta.RowDelta;
import com.sap.ip.me.smartsync.delta.SyncBoDelta;
import com.sap.ip.me.smartsync.ipi.InterDataPackageManager;
import com.sap.ip.me.smartsync.ipi.InterMetaPackageManager;
import com.sap.ip.me.smartsync.ipi.InternalOutDeltaFacade;
import com.sap.ip.me.smartsync.ipi.PersistenceAdapter;
import com.sap.ip.me.smartsync.ipi.SmartSyncTransaction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

final class OutDeltaManagerMerged
implements InternalOutDeltaFacade {
    private static final Trace TRACE = Trace.getInstance("MI/Smartsync");
    private final PersistenceAdapter dataPersistenceAdapter;
    private final InterDataPackageManager interDataPackageManager;
    private final DeltaPackagePersistenceMaster deltaPackagePersistenceMaster;
    private final InterMetaPackageManager interMetaPackageManager;

    OutDeltaManagerMerged(PersistenceAdapter dataPersistenceAdapter, InterDataPackageManager interDataPackageManager, DeltaPackagePersistenceMaster deltaPackagePersistenceMaster, InterMetaPackageManager interMetaPackageManager) {
        if (dataPersistenceAdapter == null) {
            throw new NullPointerException("dataPersistenceAdapter");
        }
        if (interDataPackageManager == null) {
            throw new NullPointerException("interDataPackageManager");
        }
        if (deltaPackagePersistenceMaster == null) {
            throw new NullPointerException("deltaPackagePersistenceMaster");
        }
        if (interMetaPackageManager == null) {
            throw new NullPointerException("interMetaPackageManager");
        }
        this.interDataPackageManager = interDataPackageManager;
        this.dataPersistenceAdapter = dataPersistenceAdapter;
        this.deltaPackagePersistenceMaster = deltaPackagePersistenceMaster;
        this.interMetaPackageManager = interMetaPackageManager;
    }

    private MeIterator getAllDelta(MeIterator delta, SyncBoDescriptorIterator order, boolean asc) {
        Hashtable<String, Vector<SyncBoChange>> ht = new Hashtable<String, Vector<SyncBoChange>>();
        while (delta.hasNext()) {
            SyncBoChange bo = (SyncBoChange)delta.next();
            Vector<SyncBoChange> v = (Vector<SyncBoChange>)ht.get(bo.getSyncBoDescriptor().getSyncBoName());
            if (v == null) {
                v = new Vector<SyncBoChange>();
                ht.put(bo.getSyncBoDescriptor().getSyncBoName(), v);
            }
            v.addElement(bo);
        }
        Enumeration enumeration = ht.elements();
        while (enumeration.hasMoreElements()) {
            Vector resBySyncBo = (Vector)enumeration.nextElement();
            Object[] toBeSortedRes = new Object[resBySyncBo.size()];
            resBySyncBo.copyInto(toBeSortedRes);
            MeArrays.sort(toBeSortedRes, new MeComparator(){

                public int compare(Object o1, Object o2) {
                    return ((String)((SyncBoOutDelta)o1).getSyncKey()).compareTo((String)((SyncBoOutDelta)o2).getSyncKey());
                }

                public boolean equals(Object obj) {
                    return obj == this;
                }
            });
            resBySyncBo.removeAllElements();
            int i = 0;
            while (i < toBeSortedRes.length) {
                resBySyncBo.addElement(toBeSortedRes[i]);
                ++i;
            }
        }
        Vector res = new Vector();
        while (order.hasNext()) {
            SyncBoDescriptor des = order.next();
            Vector resBySyncBo = (Vector)ht.get(des.getSyncBoName());
            if (resBySyncBo == null) continue;
            Enumeration enumeration2 = resBySyncBo.elements();
            while (enumeration2.hasMoreElements()) {
                Object d = enumeration2.nextElement();
                if (asc) {
                    res.addElement(d);
                    continue;
                }
                res.insertElementAt(d, 0);
            }
        }
        return new MeIteratorVectorImpl(res);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MeIterator getAllDelta() throws PersistenceException {
        MeIterator all;
        block7: {
            SmartSyncTransaction tx = null;
            all = null;
            try {
                tx = this.dataPersistenceAdapter.beginTransaction();
                ClassDescriptor cd = this.deltaPackagePersistenceMaster.getSyncBoDeltaClassDescriptor();
                all = this.dataPersistenceAdapter.getAll(cd, 2);
                this.dataPersistenceAdapter.commit(tx);
                tx = null;
                Object var5_4 = null;
                if (tx == null) break block7;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (tx != null) {
                    this.dataPersistenceAdapter.rollback(tx);
                }
                throw throwable;
            }
            this.dataPersistenceAdapter.rollback(tx);
        }
        Hashtable<SyncBoChangeActionType, Vector<SyncBoChange>> deltaByAction = new Hashtable<SyncBoChangeActionType, Vector<SyncBoChange>>();
        while (true) {
            if (!all.hasNext()) break;
            SyncBoChange change = (SyncBoChange)all.next();
            if (change.getAction() == SyncBoChangeActionType.NOOPER) continue;
            Vector<SyncBoChange> v = (Vector<SyncBoChange>)deltaByAction.get(change.getAction());
            if (v == null) {
                v = new Vector<SyncBoChange>();
                deltaByAction.put(change.getAction(), v);
            }
            v.addElement(change);
        }
        MeIterator[] deltaItrByAction = new MeIterator[deltaByAction.size()];
        int i = 0;
        Enumeration enumeration = deltaByAction.keys();
        while (enumeration.hasMoreElements()) {
            SyncBoChangeActionType type = (SyncBoChangeActionType)enumeration.nextElement();
            deltaItrByAction[i] = this.getAllDelta(new MeIteratorVectorImpl((Vector)deltaByAction.get(type)), this.interMetaPackageManager.getInternalSyncBoDescriptorFacade().getAllSyncBoDescriptors(), type != SyncBoChangeActionType.DELETE);
            ++i;
        }
        return new CompositeMeIteratorImpl(deltaItrByAction);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasDelta() throws SmartSyncException {
        SmartSyncTransaction tx = null;
        try {
            try {
                QueryRuntime queryRuntime = QueryRuntime.getInstance();
                ClassDescriptor syncBoClassDeltaClassDescriptor = this.deltaPackagePersistenceMaster.getSyncBoDeltaClassDescriptor();
                Query queryForHasDelta = queryRuntime.createQuery(syncBoClassDeltaClassDescriptor.getClasstype(), null);
                tx = this.dataPersistenceAdapter.beginTransaction();
                int numberOfDeltas = this.dataPersistenceAdapter.getCount(queryForHasDelta, 2);
                this.dataPersistenceAdapter.commit(tx);
                tx = null;
                boolean bl = numberOfDeltas > 0;
                Object var8_8 = null;
                if (tx == null) return bl;
                try {
                    this.dataPersistenceAdapter.rollback(tx);
                    return bl;
                }
                catch (PersistenceException e1) {
                    e1.printStackTrace();
                }
                return bl;
            }
            catch (PersistenceException e) {
                throw new SmartSyncException(e);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (tx == null) throw throwable;
            try {}
            catch (PersistenceException e1) {
                e1.printStackTrace();
                throw throwable;
            }
            this.dataPersistenceAdapter.rollback(tx);
            throw throwable;
        }
    }

    public void deleteAllDelta() throws PersistenceException {
        block3: {
            SmartSyncTransaction tx = null;
            try {
                tx = this.dataPersistenceAdapter.beginTransaction();
                this.dataPersistenceAdapter.deleteAll(this.deltaPackagePersistenceMaster.getSyncBoDeltaClassDescriptor(), TreeOptionType.DEPENDENT, 2);
                this.dataPersistenceAdapter.commit(tx);
                tx = null;
                Object var3_2 = null;
                if (tx == null) break block3;
                TRACE.log(50, "Error while delete all delta. Rollback transaction. ");
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (tx != null) {
                    TRACE.log(50, "Error while delete all delta. Rollback transaction. ");
                    this.dataPersistenceAdapter.rollback(tx);
                }
                throw throwable;
            }
            this.dataPersistenceAdapter.rollback(tx);
            {
            }
        }
    }

    public void deleteDelta(SyncBoOutDelta delta) throws PersistenceException {
        this.dataPersistenceAdapter.delete((PersistableEntity)((Object)delta), TreeOptionType.DEPENDENT, 2);
    }

    public void createDeltaForReplaceRow(SyncBo syncBo, Row row) throws PersistenceException {
        Row previousRow = syncBo.getRow(row.getRowDescriptor(), row.getKey());
        if (previousRow != null) {
            this.createDeltaForModifyField(syncBo, row);
        } else {
            this.createDeltaForInsertRow(syncBo, row);
        }
    }

    private void createDeltaForRow(SyncBo syncBo, Row row, RowChangeActionType action) throws PersistenceException {
        RowDelta rowDelta;
        SyncBoDelta syncBoDelta = this.readOrCreateSyncBoDelta(syncBo);
        syncBoDelta.setAction(SyncBoChangeActionType.MODIFY);
        if (!row.getRowDescriptor().isTop()) {
            rowDelta = this.readOrCreateRowDelta(syncBo.getTopRow(), syncBoDelta);
            rowDelta.setAction(RowChangeActionType.MODIFY);
        }
        rowDelta = this.readOrCreateRowDelta(row, syncBoDelta);
        rowDelta.setAction(action);
        this.dataPersistenceAdapter.update(syncBoDelta, TreeOptionType.COMPLETE, 2);
        this.dataPersistenceAdapter.update(rowDelta, TreeOptionType.SKELETON, 0);
    }

    public void createDeltaForModifyField(SyncBo syncBo, Row row) throws PersistenceException {
        this.createDeltaForRow(syncBo, row, RowChangeActionType.MODIFY);
    }

    public void createDeltaForDeleteRow(SyncBo syncBo, Row row) throws PersistenceException {
        if (StatusType.LOCAL.equals(row.getStatus())) {
            SyncBoDelta syncBoDelta = this.readSyncBoDelta(syncBo.getSyncKey());
            RowDelta rowDelta = syncBoDelta.getRowDeltaForRow(row);
            if (rowDelta != null) {
                syncBoDelta.deleteRowDelta(rowDelta);
                this.dataPersistenceAdapter.update(syncBoDelta, TreeOptionType.SKELETON, 2);
                this.dataPersistenceAdapter.delete(rowDelta, TreeOptionType.DEPENDENT, 0);
            }
        } else {
            this.createDeltaForRow(syncBo, row, RowChangeActionType.DELETE);
        }
    }

    public void createDeltaForInsertRow(SyncBo syncBo, Row row) throws PersistenceException {
        this.createDeltaForRow(syncBo, row, RowChangeActionType.INSERT);
    }

    private SyncBoDelta readOrCreateSyncBoDelta(SyncBo syncBo) throws PersistenceException {
        String syncKey = syncBo.getSyncKey();
        SyncBoDelta syncBoDelta = (SyncBoDelta)this.dataPersistenceAdapter.get(this.deltaPackagePersistenceMaster.getSyncBoDeltaClassDescriptor(), syncKey, 2);
        if (syncBoDelta != null) {
            return syncBoDelta;
        }
        PersistenceContainer o = this.dataPersistenceAdapter.getPersistedObjectFactory().createPersistedObject(this.deltaPackagePersistenceMaster.getSyncBoDeltaClassDescriptor(), syncKey);
        SyncBoDelta delta = new SyncBoDelta(this.interMetaPackageManager.getInternalSyncBoDescriptorFacade(), o);
        String timeStamp = syncBo.getTimeStamp();
        delta.setTimeStamp(timeStamp);
        SyncBoDescriptor descriptor = syncBo.getSyncBoDescriptor();
        delta.setSyncBoDescriptor(descriptor);
        delta.setStateId(syncBo.getStateId());
        return delta;
    }

    private RowDelta readOrCreateRowDelta(Row row, SyncBoDelta syncBoDelta) throws PersistenceException {
        RowDelta rowDelta = syncBoDelta.getRowDeltaForRow(row);
        if (rowDelta == null) {
            PersistenceContainer o = this.dataPersistenceAdapter.getPersistedObjectFactory().createPersistedObject(this.deltaPackagePersistenceMaster.getRowDeltaClassDescriptor(), row.getKey());
            RowDescriptor descriptor = row.getRowDescriptor();
            rowDelta = new RowDelta(o);
            rowDelta.setRowDescriptor(descriptor);
            syncBoDelta.addRowDelta(rowDelta);
        }
        return rowDelta;
    }

    public void createDeltaForReplaceSyncBo(SyncBo newSyncBo, SyncBo prevSyncBo) throws PersistenceException {
        SyncBoDelta syncBoDelta = this.readOrCreateSyncBoDelta(prevSyncBo);
        syncBoDelta.setAction(SyncBoChangeActionType.MODIFY);
        Row row = newSyncBo.getTopRow();
        RowDelta rowDelta = this.readOrCreateRowDelta(row, syncBoDelta);
        rowDelta.setAction(RowChangeActionType.MODIFY);
        Hashtable<String, Row> rowsOfPrevSyncBo = new Hashtable<String, Row>();
        RowCollection[] rows = prevSyncBo.getRows();
        int x = 0;
        while (x < rows.length) {
            MeIterator it = rows[x].iterator();
            while (it.hasNext()) {
                row = (Row)it.next();
                rowsOfPrevSyncBo.put(row.getKey(), row);
            }
            ++x;
        }
        rows = newSyncBo.getRows();
        int x2 = 0;
        while (x2 < rows.length) {
            MeIterator it = rows[x2].iterator();
            while (it.hasNext()) {
                row = (Row)it.next();
                rowDelta = this.readOrCreateRowDelta(row, syncBoDelta);
                if (rowsOfPrevSyncBo.remove(row.getKey()) != null) {
                    rowDelta.setAction(RowChangeActionType.MODIFY);
                    continue;
                }
                rowDelta.setAction(RowChangeActionType.INSERT);
            }
            ++x2;
        }
        Enumeration e = rowsOfPrevSyncBo.elements();
        while (e.hasMoreElements()) {
            row = (Row)e.nextElement();
            rowDelta = this.readOrCreateRowDelta(row, syncBoDelta);
            rowDelta.setAction(RowChangeActionType.DELETE);
        }
        this.dataPersistenceAdapter.update(syncBoDelta, TreeOptionType.DEPENDENT, 2);
    }

    public void createDeltaForInsertSyncBo(SyncBo syncBo) throws PersistenceException {
        SyncBoDelta syncBoDelta = this.readOrCreateSyncBoDelta(syncBo);
        syncBoDelta.setAction(SyncBoChangeActionType.INSERT);
        RowDelta rowDelta = this.readOrCreateRowDelta(syncBo.getTopRow(), syncBoDelta);
        rowDelta.setAction(RowChangeActionType.INSERT);
        RowCollection[] rows = syncBo.getRows();
        int x = 0;
        while (x < rows.length) {
            MeIterator it = rows[x].iterator();
            while (it.hasNext()) {
                rowDelta = this.readOrCreateRowDelta((Row)it.next(), syncBoDelta);
                rowDelta.setAction(RowChangeActionType.INSERT);
            }
            ++x;
        }
        this.dataPersistenceAdapter.update(syncBoDelta, TreeOptionType.DEPENDENT, 2);
    }

    public void createDeltaForDeleteSyncBo(SyncBo syncBo) throws PersistenceException {
        SyncBoDelta syncBoDelta = this.readOrCreateSyncBoDelta(syncBo);
        syncBoDelta.setAction(SyncBoChangeActionType.DELETE);
        RowDelta rowDelta = this.readOrCreateRowDelta(syncBo.getTopRow(), syncBoDelta);
        rowDelta.setAction(RowChangeActionType.DELETE);
        RowCollection[] rows = syncBo.getRows();
        int x = 0;
        while (x < rows.length) {
            MeIterator it = rows[x].iterator();
            while (it.hasNext()) {
                rowDelta = this.readOrCreateRowDelta((Row)it.next(), syncBoDelta);
                rowDelta.setAction(RowChangeActionType.DELETE);
            }
            ++x;
        }
        this.dataPersistenceAdapter.update(syncBoDelta, TreeOptionType.DEPENDENT, 0);
    }

    private SyncBoDelta readSyncBoDelta(String key) throws PersistenceException {
        return (SyncBoDelta)this.dataPersistenceAdapter.get(this.deltaPackagePersistenceMaster.getSyncBoDeltaClassDescriptor(), key, 2);
    }
}

