/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.delta;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.smartsync.GlobalResetProcessing;
import com.sap.ip.me.api.smartsync.SyncBoDeltaRequest;
import com.sap.ip.me.api.smartsync.SyncBoDeltaRequestFacade;
import com.sap.ip.me.api.smartsync.SyncBoDescriptor;
import com.sap.ip.me.api.smartsync.SyncBoDescriptorFacade;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.core.MeIteratorVectorImpl;
import com.sap.ip.me.smartsync.delta.DeltaRequestImpl;
import com.sap.ip.me.smartsync.ipi.InternalSyncBoDescriptor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

final class DeltaRequestFacadeImpl
implements SyncBoDeltaRequestFacade {
    private final Hashtable deltaRequests = new Hashtable(20);
    private final Vector deltaRequestsInSequence = new Vector(20);
    private GlobalResetProcessing globalResetProcessing = GlobalResetProcessing.DEFAULT;
    private static Trace trace = Trace.getInstance("MI/API/Smartsync");
    private boolean bInitialized = false;

    DeltaRequestFacadeImpl(SyncBoDescriptorFacade syncBoDescriptorFacade) {
        if (syncBoDescriptorFacade == null) {
            throw new NullPointerException("syncBoDescriptorFacade");
        }
        this.initializeDeltaRequests(syncBoDescriptorFacade);
    }

    boolean isInitialized() {
        return this.bInitialized;
    }

    /*
     * Unable to fully structure code
     */
    void initializeDeltaRequests(SyncBoDescriptorFacade syncBoDescriptorFacade) {
        if (DeltaRequestFacadeImpl.trace.isLogging(70)) {
            try {
                DeltaRequestFacadeImpl.trace.log(70, "Initializing Delta Requests for " + ConversationIdHandler.getInstance().getCurrentConversationId().getMsd().toString());
            }
            catch (Throwable e) {
                DeltaRequestFacadeImpl.trace.logException(70, "Exception during tracing", e, true);
            }
        }
        if (syncBoDescriptorFacade == null) {
            throw new IllegalArgumentException("descriptorFacade is NULL!");
        }
        descriptors = syncBoDescriptorFacade.getAllSyncBoDescriptors();
        if (descriptors != null) ** GOTO lbl25
        throw new IllegalStateException("No descriptors retrieved from descriptorFacade!");
lbl-1000:
        // 1 sources

        {
            descriptor = (InternalSyncBoDescriptor)descriptors.next();
            downloadOrder = descriptor.getDownloadOrder();
            if (downloadOrder == 0) continue;
            deltaRequest = new DeltaRequestImpl(descriptor);
            this.deltaRequests.put(descriptor, deltaRequest);
            if (downloadOrder < 0) {
                throw new RuntimeException("download order " + downloadOrder + " is not allowed.");
            }
            if (this.deltaRequestsInSequence.size() < downloadOrder) {
                this.deltaRequestsInSequence.setSize(downloadOrder);
            }
            if (this.deltaRequestsInSequence.elementAt(downloadOrder - 1) != null) {
                throw new RuntimeException("duplicated download order for syncbo descriptor " + descriptor);
            }
            this.deltaRequestsInSequence.setElementAt(deltaRequest, downloadOrder - 1);
lbl25:
            // 3 sources

            ** while (descriptors.hasNext())
        }
lbl26:
        // 1 sources

        i = 0;
        while (i < this.deltaRequestsInSequence.size()) {
            if (this.deltaRequestsInSequence.elementAt(i) == null) {
                throw new RuntimeException("download order " + (i + 1) + " is lost.");
            }
            ++i;
        }
        if (DeltaRequestFacadeImpl.trace.isLogging(70)) {
            DeltaRequestFacadeImpl.trace.log(70, "End of Initializing Delta Requests");
        }
        this.bInitialized = true;
    }

    public MeIterator getAllSyncBoDeltaRequests() {
        return new MeIteratorVectorImpl(this.deltaRequestsInSequence);
    }

    public void setGlobalResetProcessing(GlobalResetProcessing globalResetProcessing) {
        this.globalResetProcessing = globalResetProcessing;
    }

    public GlobalResetProcessing getGlobalResetProcessing() {
        return this.globalResetProcessing;
    }

    public SyncBoDeltaRequest getSyncBoDeltaRequest(SyncBoDescriptor syncBoDescriptor) {
        return (SyncBoDeltaRequest)this.deltaRequests.get(syncBoDescriptor);
    }

    public void resetAllSyncBoDeltaRequests() {
        this.globalResetProcessing = GlobalResetProcessing.DEFAULT;
        Enumeration deltaRequestEnum = this.deltaRequests.elements();
        while (deltaRequestEnum.hasMoreElements()) {
            ((DeltaRequestImpl)deltaRequestEnum.nextElement()).setDefaults();
        }
    }
}

